/*
 * Decompiled with CFR 0.152.
 */
package com.sas.framework.commons.actions;

import com.sas.framework.commons.actions.ActionGroup;
import com.sas.framework.commons.actions.ActionResourceLoader;
import com.sas.framework.commons.actions.DefaultAction;
import com.sas.swing.util.Action;
import com.sas.swing.visuals.util.Util;
import java.util.HashMap;
import javax.swing.KeyStroke;

class ActionImpl
extends DefaultAction {
    private static final long serialVersionUID = 1L;
    private final String _key;
    private Action _parent;
    private boolean _suppressEvents;
    protected ActionResourceLoader _map;

    public ActionImpl(String key, ActionResourceLoader map) {
        this._map = map;
        this._key = key;
        String s = this._map.getOptionalStringResource(key + "parent.notrans");
        if (null != s) {
            this._parent = this.getParentAction(s);
        }
        this.getValue("GroupName");
    }

    protected Action getParentAction(String key) {
        return this._map.getAction(key.substring("Action.".length()));
    }

    @Override
    public Object getValue(String key) {
        Object value = super.getValue(key);
        if (null == value) {
            String s = null;
            String resourceKey = ActionResourceLoader.getResourceKey(key);
            if (null != resourceKey) {
                resourceKey = this._key + resourceKey;
                s = this._map.getOptionalStringResource(resourceKey);
            }
            if (null == s) {
                if (key.equals("MnemonicKey") || key.equals("MnemonicIndex")) {
                    this.getValue("Name");
                    Object objValue = super.getValue(key);
                    if (null != objValue) {
                        return objValue;
                    }
                }
                if (null != this._parent) {
                    boolean checkParent = true;
                    if ("SmallIcon".equals(key)) {
                        String thisValue = (String)this.getValue("SmallIconName");
                        String parentValue = (String)this._parent.getValue("SmallIconName");
                        checkParent = null == thisValue || thisValue.equals(parentValue);
                    } else if ("LargeIcon".equals(key)) {
                        String thisValue = (String)this.getValue("LargeIconName");
                        String parentValue = (String)this._parent.getValue("LargeIconName");
                        checkParent = null == thisValue || thisValue.equals(parentValue);
                    } else if ("SmallDisabledIcon".equals(key)) {
                        String thisValue = (String)this.getValue("SmallDisabledIconName");
                        String parentValue = (String)this._parent.getValue("SmallDisabledIconName");
                        checkParent = null == thisValue || thisValue.equals(parentValue);
                    } else if ("LargeDisabledIcon".equals(key)) {
                        String thisValue = (String)this.getValue("LargeDisabledIconName");
                        String parentValue = (String)this._parent.getValue("LargeDisabledIconName");
                        boolean bl = checkParent = null == thisValue || thisValue.equals(parentValue);
                    }
                    if (checkParent) {
                        value = this._parent.getValue(key);
                    }
                }
            } else if (key.equals("Name")) {
                value = Util.getLabelWithoutMnemonic(s);
                if (!s.equals(value)) {
                    Integer val2 = Util.getDisplayedMnemonic((String)s);
                    this._putValue("MnemonicKey", val2);
                    val2 = Util.getDisplayedMnemonicIndex((String)s);
                    this._putValue("MnemonicIndex", val2);
                }
            } else if (key.equals("AcceleratorKey")) {
                value = KeyStroke.getKeyStroke(s);
                if (null == value) {
                    throw new IllegalArgumentException(resourceKey + "=" + s);
                }
            } else if (key.equals("CommandClass")) {
                try {
                    value = Class.forName(s, true, this._map._callerClassLoader);
                }
                catch (ClassNotFoundException cnfex) {
                    ActionResourceLoader.LOG.warn(cnfex.getMessage(), (Throwable)cnfex);
                }
            } else {
                value = s;
            }
            if (null != value) {
                this._putValue(key, value);
            }
            if (null != value && "GroupName".equals(key)) {
                ActionGroup group;
                if (null == this._map._actionGroups) {
                    this._map._actionGroups = new HashMap();
                }
                if (null == (group = (ActionGroup)this._map._actionGroups.get(value))) {
                    group = new ActionGroup();
                    this._map._actionGroups.put(value, group);
                }
                group.add(this);
            }
        }
        return value;
    }

    protected final void _putValue(String key, Object value) {
        try {
            this._suppressEvents = true;
            this.putValue(key, value);
        }
        finally {
            this._suppressEvents = false;
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (!this._suppressEvents) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

