/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.redaction;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.util.redaction.CombinedSensitiveDictionary;
import org.apache.geode.internal.util.redaction.RedactionDefaults;
import org.apache.geode.internal.util.redaction.RedactionStrategy;
import org.apache.geode.internal.util.redaction.RegexRedactionStrategy;
import org.apache.geode.internal.util.redaction.SensitiveDataDictionary;
import org.apache.geode.internal.util.redaction.SensitivePrefixDictionary;
import org.apache.geode.internal.util.redaction.SensitiveSubstringDictionary;

public class StringRedaction
implements SensitiveDataDictionary {
    private final String redacted;
    private final SensitiveDataDictionary sensitiveDataDictionary;
    private final RedactionStrategy redactionStrategy;

    public StringRedaction() {
        this("********", new CombinedSensitiveDictionary(new SensitivePrefixDictionary(RedactionDefaults.SENSITIVE_PREFIXES), new SensitiveSubstringDictionary(RedactionDefaults.SENSITIVE_SUBSTRINGS)));
    }

    private StringRedaction(String redacted, SensitiveDataDictionary sensitiveDataDictionary) {
        this(redacted, sensitiveDataDictionary, new RegexRedactionStrategy(sensitiveDataDictionary::isSensitive, redacted));
    }

    @VisibleForTesting
    StringRedaction(String redacted, SensitiveDataDictionary sensitiveDataDictionary, RedactionStrategy redactionStrategy) {
        this.redacted = redacted;
        this.sensitiveDataDictionary = sensitiveDataDictionary;
        this.redactionStrategy = redactionStrategy;
    }

    public String redact(String string) {
        return this.redactionStrategy.redact(string);
    }

    public String redact(Iterable<String> strings) {
        return this.redact(String.join((CharSequence)" ", strings));
    }

    public String redactArgumentIfNecessary(String key, String value) {
        if (this.isSensitive(key)) {
            return this.redacted;
        }
        return value;
    }

    public List<String> redactEachInList(Collection<String> strings) {
        return strings.stream().map(this::redact).collect(Collectors.toList());
    }

    @Override
    public boolean isSensitive(String key) {
        return this.sensitiveDataDictionary.isSensitive(key);
    }

    public String getRedacted() {
        return this.redacted;
    }
}

