/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.client.internal.TXSynchronizationOp;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.TXCommitMessage;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.MessageTooLargeException;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.CommitCommand;
import org.apache.geode.internal.security.SecurityService;
import org.jetbrains.annotations.NotNull;

public class TXSynchronizationCommand
extends BaseCommand {
    @Immutable
    private static final TXSynchronizationCommand singleton = new TXSynchronizationCommand();

    public static Command getCommand() {
        return singleton;
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException, ClassNotFoundException, InterruptedException {
        boolean isDebugEnabled;
        block30: {
            isDebugEnabled = logger.isDebugEnabled();
            serverConnection.setAsTrue(2);
            TXSynchronizationOp.CompletionType type = TXSynchronizationOp.CompletionType.values()[clientMessage.getPart(0).getInt()];
            clientMessage.getPart(1).getInt();
            Part statusPart = type == TXSynchronizationOp.CompletionType.AFTER_COMPLETION ? clientMessage.getPart(2) : null;
            TXManagerImpl txMgr = this.getTXManager(serverConnection);
            InternalDistributedMember member = this.getDistributedMember(serverConnection);
            TXStateProxy txProxy = txMgr.getTXState();
            assert (txProxy != null);
            TXId txId = txProxy.getTxId();
            TXCommitMessage commitMessage = txMgr.getRecentlyCompletedMessage(txId);
            if (commitMessage != null && commitMessage != TXCommitMessage.ROLLBACK_MSG) {
                block28: {
                    assert (type == TXSynchronizationOp.CompletionType.AFTER_COMPLETION);
                    try {
                        this.writeCommitResponse(clientMessage, serverConnection, commitMessage);
                    }
                    catch (IOException e) {
                        if (isDebugEnabled) {
                            logger.debug("Problem writing reply to client", (Throwable)e);
                        }
                    }
                    catch (RuntimeException e) {
                        try {
                            TXSynchronizationCommand.writeException(clientMessage, e, false, serverConnection);
                        }
                        catch (IOException ioe) {
                            if (!isDebugEnabled) break block28;
                            logger.debug("Problem writing reply to client", (Throwable)ioe);
                        }
                    }
                }
                serverConnection.setAsTrue(1);
                return;
            }
            try {
                if (type == TXSynchronizationOp.CompletionType.BEFORE_COMPLETION) {
                    block31: {
                        if (isDebugEnabled) {
                            logger.debug("Executing beforeCompletion() notification for transaction {}", (Object)clientMessage.getTransactionId());
                        }
                        Throwable failureException = null;
                        try {
                            block29: {
                                txProxy.setIsJTA(true);
                                txProxy.beforeCompletion();
                                try {
                                    this.writeReply(clientMessage, serverConnection);
                                }
                                catch (IOException e) {
                                    if (!isDebugEnabled) break block29;
                                    logger.debug("Problem writing reply to client", (Throwable)e);
                                }
                            }
                            serverConnection.setAsTrue(1);
                        }
                        catch (ReplyException e) {
                            failureException = e.getCause();
                        }
                        catch (Exception e) {
                            failureException = e;
                        }
                        if (failureException == null) break block30;
                        try {
                            TXSynchronizationCommand.writeException(clientMessage, failureException, false, serverConnection);
                        }
                        catch (IOException ioe) {
                            if (!isDebugEnabled) break block31;
                            logger.debug("Problem writing reply to client", (Throwable)ioe);
                        }
                    }
                    serverConnection.setAsTrue(1);
                    break block30;
                }
                try {
                    block32: {
                        int status = statusPart.getInt();
                        if (isDebugEnabled) {
                            logger.debug("Executing afterCompletion({}) notification for transaction {}", (Object)status, (Object)clientMessage.getTransactionId());
                        }
                        txProxy.setIsJTA(true);
                        txProxy.setCommitOnBehalfOfRemoteStub(true);
                        txProxy.afterCompletion(status);
                        TXCommitMessage cmsg = txProxy.getCommitMessage();
                        try {
                            this.writeCommitResponse(clientMessage, serverConnection, cmsg);
                            txMgr.removeHostedTXState(txProxy.getTxId());
                        }
                        catch (IOException e) {
                            if (!isDebugEnabled && !(e instanceof MessageTooLargeException)) break block32;
                            logger.warn("Problem writing reply to client", (Throwable)e);
                        }
                    }
                    serverConnection.setAsTrue(1);
                }
                catch (RuntimeException e) {
                    block33: {
                        try {
                            TXSynchronizationCommand.writeException(clientMessage, e, false, serverConnection);
                        }
                        catch (IOException ioe) {
                            if (!isDebugEnabled) break block33;
                            logger.debug("Problem writing reply to client", (Throwable)ioe);
                        }
                    }
                    serverConnection.setAsTrue(1);
                }
            }
            catch (Exception e) {
                TXSynchronizationCommand.writeException(clientMessage, 2, e, false, serverConnection);
                serverConnection.setAsTrue(1);
            }
        }
        if (isDebugEnabled) {
            logger.debug("Sent tx synchronization response");
        }
    }

    void writeCommitResponse(Message clientMessage, ServerConnection serverConnection, TXCommitMessage commitMessage) throws IOException {
        CommitCommand.writeCommitResponse(commitMessage, clientMessage, serverConnection);
    }

    InternalDistributedMember getDistributedMember(ServerConnection serverConnection) {
        return (InternalDistributedMember)serverConnection.getProxyID().getDistributedMember();
    }

    TXManagerImpl getTXManager(ServerConnection serverConnection) {
        return (TXManagerImpl)serverConnection.getCache().getCacheTransactionManager();
    }
}

