/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntry;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryHeapIntKey;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryHeapLongKey;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.entries.VMStatsLRURegionEntryHeapUUIDKey;
import org.apache.geode.internal.cache.entries.VersionedStatsLRURegionEntryHeap;

public abstract class VMStatsLRURegionEntryHeap
extends VMStatsLRURegionEntry {
    @Immutable
    private static final VMStatsLRURegionEntryHeapFactory factory = new VMStatsLRURegionEntryHeapFactory();

    public VMStatsLRURegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsLRURegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMStatsLRURegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsLRURegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsLRURegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsLRURegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsLRURegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsLRURegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsLRURegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VMStatsLRURegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsLRURegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

