/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AdminDistributedSystem;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.Alert;
import org.apache.geode.admin.AlertLevel;
import org.apache.geode.admin.AlertListener;
import org.apache.geode.admin.BackupStatus;
import org.apache.geode.admin.CacheServer;
import org.apache.geode.admin.CacheServerConfig;
import org.apache.geode.admin.CacheVm;
import org.apache.geode.admin.ConfigurationParameter;
import org.apache.geode.admin.DistributedSystemConfig;
import org.apache.geode.admin.DistributionLocator;
import org.apache.geode.admin.DistributionLocatorConfig;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.ManagedEntity;
import org.apache.geode.admin.ManagedEntityConfig;
import org.apache.geode.admin.OperationCancelledException;
import org.apache.geode.admin.RuntimeAdminException;
import org.apache.geode.admin.SystemMember;
import org.apache.geode.admin.SystemMemberCacheListener;
import org.apache.geode.admin.SystemMembershipListener;
import org.apache.geode.admin.internal.CacheServerConfigImpl;
import org.apache.geode.admin.internal.CacheServerImpl;
import org.apache.geode.admin.internal.ConfigurationParameterImpl;
import org.apache.geode.admin.internal.DistributedSystemConfigImpl;
import org.apache.geode.admin.internal.DistributionLocatorConfigImpl;
import org.apache.geode.admin.internal.DistributionLocatorImpl;
import org.apache.geode.admin.internal.GemFireHealthImpl;
import org.apache.geode.admin.internal.InetAddressUtilsWithLogging;
import org.apache.geode.admin.internal.LogCollator;
import org.apache.geode.admin.internal.ManagedEntityController;
import org.apache.geode.admin.internal.ManagedEntityControllerFactory;
import org.apache.geode.admin.internal.ManagedSystemMemberImpl;
import org.apache.geode.admin.internal.SystemMemberImpl;
import org.apache.geode.admin.internal.SystemMembershipEventImpl;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.FutureCancelledException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.admin.ApplicationVM;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.GfManagerAgent;
import org.apache.geode.internal.admin.GfManagerAgentConfig;
import org.apache.geode.internal.admin.GfManagerAgentFactory;
import org.apache.geode.internal.admin.JoinLeaveListener;
import org.apache.geode.internal.admin.remote.CompactRequest;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.admin.remote.MissingPersistentIDsRequest;
import org.apache.geode.internal.admin.remote.PrepareRevokePersistentIDRequest;
import org.apache.geode.internal.admin.remote.RemoteApplicationVM;
import org.apache.geode.internal.admin.remote.RemoteTransportConfig;
import org.apache.geode.internal.admin.remote.RevokePersistentIDRequest;
import org.apache.geode.internal.admin.remote.ShutdownAllRequest;
import org.apache.geode.internal.cache.backup.BackupOperation;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.logging.Banner;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogWriterFactory;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.util.concurrent.FutureResult;
import org.apache.geode.logging.internal.LoggingSession;
import org.apache.geode.logging.internal.NullLoggingSession;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

@Deprecated
public class AdminDistributedSystemImpl
implements AdminDistributedSystem,
JoinLeaveListener,
org.apache.geode.internal.admin.AlertListener,
InternalDistributedSystem.DisconnectListener {
    private static final Logger logger = LogService.getLogger();
    private String id;
    private Alert latestAlert;
    private volatile GfManagerAgent gfManagerAgent;
    private GemFireHealth health;
    private final Set applicationSet = new HashSet();
    private final Set locatorSet = new HashSet();
    private final Set cacheServerSet = new HashSet();
    private final DistributedSystemConfigImpl config;
    private final ManagedEntityController controller;
    private final LogCollator logCollator = new LogCollator();
    private AlertLevel alertLevel = AlertLevel.WARNING;
    private volatile Set<AlertListener> alertListeners = Collections.emptySet();
    private final Object alertLock = new Object();
    private final InternalLogWriter logWriter;
    private volatile Set membershipListeners = Collections.EMPTY_SET;
    private final Object membershipLock = new Object();
    private volatile List cacheListeners = Collections.EMPTY_LIST;
    private final Object cacheListLock = new Object();
    private final LoggingSession loggingSession;
    @MakeNotStatic
    private static volatile AdminDistributedSystemImpl thisAdminDS;
    private static final Object CONNECTION_SYNC;
    private static final String TIMEOUT_MS_NAME = "AdminDistributedSystemImpl.TIMEOUT_MS";
    private static final int TIMEOUT_MS_DEFAULT = 60000;
    private static final int TIMEOUT_MS;
    private final Object membershipListenerLock = new Object();

    private static LoggingSession createLoggingSession() {
        return NullLoggingSession.create();
    }

    public AdminDistributedSystemImpl(DistributedSystemConfigImpl config) {
        this.loggingSession = AdminDistributedSystemImpl.createLoggingSession();
        this.config = config;
        String systemId = this.config.getSystemId();
        if (systemId != null && systemId.length() > 0) {
            this.id = systemId;
        }
        this.id = this.getLocators() != null && this.getLocators().length() > 0 ? this.getLocators() : this.getMcastAddress() + "[" + this.getMcastPort() + "]";
        this.loggingSession.startSession();
        InternalLogWriter existingLogWriter = this.config.getInternalLogWriter();
        if (existingLogWriter != null) {
            this.logWriter = existingLogWriter;
        } else {
            this.logWriter = LogWriterFactory.createLogWriterLogger(this.config.createLogConfig(), false);
            if (!Boolean.getBoolean("Locator.inhibitDMBanner")) {
                this.logWriter.info(new Banner().getString());
            } else {
                logger.debug("skipping banner - Locator.inhibitDMBanner is set to true");
            }
            this.config.setInternalLogWriter(this.logWriter);
        }
        this.controller = ManagedEntityControllerFactory.createManagedEntityController(this);
        this.initializeDistributionLocators();
        this.initializeCacheServers();
    }

    private void initializeDistributionLocators() {
        DistributionLocatorConfig[] configs = this.config.getDistributionLocatorConfigs();
        if (configs.length == 0) {
            return;
        }
        for (DistributionLocatorConfig conf : configs) {
            DistributionLocatorImpl locator = this.createDistributionLocatorImpl(conf);
            this.locatorSet.add(new FutureResult<DistributionLocatorImpl>(locator));
        }
        this.setLocators(this.parseLocatorSet());
    }

    private void initializeCacheServers() {
        CacheServerConfig[] cacheServerConfigs;
        for (CacheServerConfig cacheServerConfig : cacheServerConfigs = this.config.getCacheServerConfigs()) {
            try {
                CacheServerConfigImpl copy = new CacheServerConfigImpl(cacheServerConfig);
                this.cacheServerSet.add(new FutureResult<CacheServer>(this.createCacheServer(copy)));
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void checkConnectCalled() {
        if (this.gfManagerAgent == null) {
            throw new IllegalStateException("connect() has not been invoked on this AdminDistributedSystem.");
        }
    }

    public GfManagerAgent getGfManagerAgent() {
        return this.gfManagerAgent;
    }

    @Override
    public boolean isConnected() {
        return this.gfManagerAgent != null && this.gfManagerAgent.isConnected();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        String name = this.config.getSystemName();
        if (name != null && name.length() > 0) {
            return name;
        }
        return this.getId();
    }

    public String getSystemName() {
        return this.config.getSystemName();
    }

    @Override
    public String getRemoteCommand() {
        return this.config.getRemoteCommand();
    }

    @Override
    public void setRemoteCommand(String remoteCommand) {
        this.config.setRemoteCommand(remoteCommand);
    }

    @Override
    public void setAlertLevel(AlertLevel level) {
        if (this.isConnected()) {
            this.gfManagerAgent.setAlertLevel(level.getSeverity());
        }
        this.alertLevel = level;
    }

    @Override
    public AlertLevel getAlertLevel() {
        return this.alertLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAlertListener(AlertListener listener) {
        Object object = this.alertLock;
        synchronized (object) {
            Set<AlertListener> oldListeners = this.alertListeners;
            if (!oldListeners.contains(listener)) {
                HashSet<AlertListener> newListeners = new HashSet<AlertListener>(oldListeners);
                newListeners.add(listener);
                this.alertListeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAlertListenerCount() {
        Object object = this.alertLock;
        synchronized (object) {
            return this.alertListeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAlertListener(AlertListener listener) {
        Object object = this.alertLock;
        synchronized (object) {
            HashSet<AlertListener> newListeners;
            Set<AlertListener> oldListeners = this.alertListeners;
            if (oldListeners.contains(listener) && (newListeners = new HashSet<AlertListener>(oldListeners)).remove(listener)) {
                this.alertListeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMembershipListener(SystemMembershipListener listener) {
        Object object = this.membershipLock;
        synchronized (object) {
            Set oldListeners = this.membershipListeners;
            if (!oldListeners.contains(listener)) {
                HashSet<SystemMembershipListener> newListeners = new HashSet<SystemMembershipListener>(oldListeners);
                newListeners.add(listener);
                this.membershipListeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMembershipListener(SystemMembershipListener listener) {
        Object object = this.membershipLock;
        synchronized (object) {
            HashSet newListeners;
            Set oldListeners = this.membershipListeners;
            if (oldListeners.contains(listener) && (newListeners = new HashSet(oldListeners)).remove(listener)) {
                this.membershipListeners = newListeners;
            }
        }
    }

    @Override
    public String getMcastAddress() {
        return this.config.getMcastAddress();
    }

    @Override
    public int getMcastPort() {
        return this.config.getMcastPort();
    }

    public boolean getDisableTcp() {
        return this.config.getDisableTcp();
    }

    public boolean getDisableAutoReconnect() {
        return this.config.getDisableAutoReconnect();
    }

    @Override
    public String getLocators() {
        return this.config.getLocators();
    }

    protected void setLocators(String locators) {
        this.config.setLocators(locators);
    }

    public String getMembershipPortRange() {
        return this.getConfig().getMembershipPortRange();
    }

    public int getTcpPort() {
        return this.getConfig().getTcpPort();
    }

    public void setTcpPort(int port) {
        this.getConfig().setTcpPort(port);
    }

    public void setMembershipPortRange(String membershipPortRange) {
        this.getConfig().setMembershipPortRange(membershipPortRange);
    }

    @Override
    public DistributedSystemConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isRunning() {
        if (this.gfManagerAgent == null) {
            return false;
        }
        return this.isAnyMemberRunning();
    }

    @Override
    public boolean isMcastEnabled() {
        return this.getMcastPort() > 0;
    }

    ManagedEntityController getEntityController() {
        return this.controller;
    }

    @Override
    public void start() throws AdminException {
        CacheServer[] servers;
        DistributionLocator[] locs;
        for (DistributionLocator distributionLocator : locs = this.getDistributionLocators()) {
            distributionLocator.start();
        }
        for (DistributionLocator loc : locs) {
            try {
                if (loc.waitToStart(TIMEOUT_MS)) continue;
                throw new AdminException(String.format("%s did not start after %s ms", loc, TIMEOUT_MS));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new AdminException(String.format("Interrupted while waiting for %s to start.", loc), ex);
            }
        }
        for (CacheServer cacheServer : servers = this.getCacheServers()) {
            cacheServer.start();
        }
        for (CacheServer server : servers) {
            try {
                if (server.waitToStart(TIMEOUT_MS)) continue;
                throw new AdminException(String.format("%s did not start after %s ms", server, TIMEOUT_MS));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new AdminException(String.format("Interrupted while waiting for %s to start.", server), ex);
            }
        }
    }

    @Override
    public void stop() throws AdminException {
        DistributionLocator[] locs;
        CacheServer[] servers;
        long timeout = 30L;
        for (CacheServer cacheServer : servers = this.getCacheServers()) {
            cacheServer.stop();
        }
        for (CacheServer server : servers) {
            try {
                if (server.waitToStop(timeout * 1000L)) continue;
                throw new AdminException(String.format("%s did not stop after %s seconds.", server, timeout));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new AdminException(String.format("Interrupted while waiting for %s to stop.", server), ex);
            }
        }
        for (DistributionLocator distributionLocator : locs = this.getDistributionLocators()) {
            distributionLocator.stop();
        }
        for (DistributionLocator loc : locs) {
            try {
                if (loc.waitToStop(timeout * 1000L)) continue;
                throw new AdminException(String.format("%s did not stop after %s seconds.", loc, timeout));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new AdminException(String.format("Interrupted while waiting for %s to stop.", loc), ex);
            }
        }
    }

    @Override
    public String displayMergedLogs() {
        return this.logCollator.collateLogs(this.gfManagerAgent);
    }

    @Override
    public Properties getLicense() {
        SystemMember member = this.findFirstRunningMember();
        if (member != null) {
            return new Properties();
        }
        return null;
    }

    private void setDistributionParameters(SystemMember member) throws AdminException {
        Assert.assertTrue(member instanceof ManagedSystemMemberImpl);
        ConfigurationParameter[] configParms = new ConfigurationParameter[]{new ConfigurationParameterImpl("mcast-port", this.config.getMcastPort()), new ConfigurationParameterImpl("locators", this.config.getLocators()), new ConfigurationParameterImpl("mcast-address", InetAddressUtilsWithLogging.toInetAddress(this.config.getMcastAddress())), new ConfigurationParameterImpl("disable-tcp", this.config.getDisableTcp())};
        member.setConfiguration(configParms);
    }

    private static void handle(ExecutionException ex) {
        Throwable cause = ex.getCause();
        if (cause instanceof OperationCancelledException) {
            return;
        }
        if (cause instanceof CancelException) {
            throw new FutureCancelledException("Future cancelled due to shutdown", ex);
        }
        throw new RuntimeAdminException("While waiting for Future", ex);
    }

    protected void checkCancellation() {
        DistributionManager dm = this.getDistributionManager();
        if (dm != null) {
            dm.getCancelCriterion().checkCancelInProgress(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SystemMember[] getSystemMemberApplications() throws AdminException {
        Set set = this.applicationSet;
        synchronized (set) {
            ArrayList coll = new ArrayList(this.applicationSet.size());
            Iterator iterator = this.applicationSet.iterator();
            block11: while (true) {
                if (!iterator.hasNext()) {
                    SystemMember[] array = new SystemMember[coll.size()];
                    coll.toArray(array);
                    return array;
                }
                Object o = iterator.next();
                Future future = (Future)o;
                while (true) {
                    this.checkCancellation();
                    boolean interrupted = Thread.interrupted();
                    try {
                        coll.add(future.get());
                        continue block11;
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        continue;
                    }
                    catch (CancellationException ex) {
                        continue block11;
                    }
                    catch (ExecutionException ex) {
                        AdminDistributedSystemImpl.handle(ex);
                        continue block11;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                break;
            }
        }
    }

    @Override
    public String getLatestAlert() {
        if (this.latestAlert == null) {
            return "";
        }
        return this.latestAlert.toString();
    }

    @Override
    public void connect() {
        this.connect(this.logWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(InternalLogWriter logWriter) {
        Object object = CONNECTION_SYNC;
        synchronized (object) {
            if (this.gfManagerAgent != null) {
                if (this.gfManagerAgent.isListening()) {
                    if (!logger.isDebugEnabled()) return;
                    logger.debug("The RemoteGfManagerAgent is already listening for this AdminDistributedSystem.");
                    return;
                }
                this.disconnect();
            }
            if (thisAdminDS != null) {
                throw new IllegalStateException("Only one AdminDistributedSystem connection can be made at once.");
            }
            thisAdminDS = this;
            this.id = this.getLocators().length() == 0 ? this.getMcastAddress() + "[" + this.getMcastPort() + "]" : this.getLocators();
            if (this.config instanceof DistributedSystemConfigImpl) {
                this.config.validate();
                this.config.setDistributedSystem(this);
            }
            this.gfManagerAgent = GfManagerAgentFactory.getManagerAgent(this.buildAgentConfig(logWriter));
            Object object2 = this.membershipListenerLock;
            synchronized (object2) {
                ApplicationVM[] apps;
                for (ApplicationVM app : apps = this.gfManagerAgent.listApplications()) {
                    try {
                        this.nodeJoined(null, app);
                    }
                    catch (RuntimeAdminException e) {
                        this.logWriter.warning("encountered a problem processing member " + app);
                    }
                }
            }
            String locators = this.getLocators();
            StringTokenizer st = new StringTokenizer(locators, ",");
            block20: while (st.hasMoreTokens()) {
                DistributionLocatorConfig conf;
                String locator = st.nextToken();
                int first = locator.indexOf("[");
                int last = locator.indexOf("]");
                String host = locator.substring(0, first);
                int colidx = host.lastIndexOf(64);
                if (colidx < 0) {
                    colidx = host.lastIndexOf(58);
                }
                String bindAddr = null;
                if (colidx > 0 && colidx < host.length() - 1) {
                    String orig = host;
                    bindAddr = host.substring(colidx + 1);
                    if ((host = host.substring(0, colidx)).indexOf(58) >= 0) {
                        int bindidx = orig.lastIndexOf(64);
                        if (bindidx >= 0) {
                            host = orig.substring(0, bindidx);
                            bindAddr = orig.substring(bindidx + 1);
                        } else {
                            host = orig;
                            bindAddr = null;
                        }
                    }
                }
                int port = Integer.parseInt(locator.substring(first + 1, last));
                Set bindidx = this.locatorSet;
                synchronized (bindidx) {
                    block21: for (Object o : this.locatorSet) {
                        Future future = (Future)o;
                        DistributionLocatorImpl impl = null;
                        while (true) {
                            this.checkCancellation();
                            boolean interrupted = Thread.interrupted();
                            try {
                                impl = (DistributionLocatorImpl)future.get();
                            }
                            catch (InterruptedException ex) {
                                interrupted = true;
                                continue;
                            }
                            catch (CancellationException ex) {
                                continue block21;
                            }
                            catch (ExecutionException ex) {
                                AdminDistributedSystemImpl.handle(ex);
                                continue block21;
                            }
                            finally {
                                if (!interrupted) continue;
                                Thread.currentThread().interrupt();
                                continue;
                            }
                            break;
                        }
                        DistributionLocatorConfig conf2 = impl.getConfig();
                        InetAddress host1 = InetAddressUtilsWithLogging.toInetAddress(host);
                        InetAddress host2 = InetAddressUtilsWithLogging.toInetAddress(conf2.getHost());
                        if (port != conf2.getPort() || !host1.equals(host2)) continue;
                        continue block20;
                    }
                }
                InetAddress bindAddress = null;
                if (bindAddr != null) {
                    bindAddress = InetAddressUtilsWithLogging.toInetAddress(bindAddr);
                }
                if ((conf = DistributionLocatorConfigImpl.createConfigFor(host, port, bindAddress)) == null) continue;
                DistributionLocatorImpl impl = this.createDistributionLocatorImpl(conf);
                Set set = this.locatorSet;
                synchronized (set) {
                    this.locatorSet.add(new FutureResult<DistributionLocatorImpl>(impl));
                }
            }
            return;
        }
    }

    @Override
    public boolean waitToBeConnected(long timeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.checkConnectCalled();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            if (this.gfManagerAgent.isInitialized()) {
                return true;
            }
            Thread.sleep(100L);
        }
        return this.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = CONNECTION_SYNC;
        synchronized (object) {
            this.loggingSession.stopSession();
            try {
                if (thisAdminDS == this) {
                    thisAdminDS = null;
                }
                if (this.gfManagerAgent != null && this.gfManagerAgent.isListening()) {
                    AdminDistributedSystemImpl adminDistributedSystemImpl = this;
                    synchronized (adminDistributedSystemImpl) {
                        if (this.health != null) {
                            this.health.close();
                        }
                    }
                    this.gfManagerAgent.removeJoinLeaveListener(this);
                    this.gfManagerAgent.disconnect();
                }
                this.gfManagerAgent = null;
                if (this.config instanceof DistributedSystemConfigImpl) {
                    this.config.setDistributedSystem(null);
                }
            }
            finally {
                this.loggingSession.shutdown();
            }
        }
    }

    public DistributionManager getDistributionManager() {
        GfManagerAgent agent = this.gfManagerAgent;
        if (agent == null) {
            return null;
        }
        return agent.getDM();
    }

    public GfManagerAgent getAdminAgent() {
        return this.gfManagerAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DistributionLocator addDistributionLocator() {
        DistributionLocatorConfigImpl conf = new DistributionLocatorConfigImpl();
        DistributionLocatorImpl locator = this.createDistributionLocatorImpl(conf);
        Set set = this.locatorSet;
        synchronized (set) {
            this.locatorSet.add(new FutureResult<DistributionLocatorImpl>(locator));
        }
        this.setLocators(this.parseLocatorSet());
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DistributionLocator[] getDistributionLocators() {
        Set set = this.locatorSet;
        synchronized (set) {
            ArrayList coll = new ArrayList(this.locatorSet.size());
            Iterator iterator = this.locatorSet.iterator();
            block11: while (true) {
                if (!iterator.hasNext()) {
                    DistributionLocator[] array = new DistributionLocator[coll.size()];
                    coll.toArray(array);
                    return array;
                }
                Object o = iterator.next();
                Future future = (Future)o;
                while (true) {
                    this.checkCancellation();
                    boolean interrupted = Thread.interrupted();
                    try {
                        coll.add(future.get());
                        continue block11;
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        continue;
                    }
                    catch (CancellationException ex) {
                        continue block11;
                    }
                    catch (ExecutionException ex) {
                        AdminDistributedSystemImpl.handle(ex);
                        continue block11;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                break;
            }
        }
    }

    void updateLocatorsString() {
        this.setLocators(this.parseLocatorSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String parseLocatorSet() {
        StringBuilder sb = new StringBuilder();
        Iterator iter = this.locatorSet.iterator();
        block9: while (iter.hasNext()) {
            Future future = (Future)iter.next();
            DistributionLocator locator = null;
            while (true) {
                this.checkCancellation();
                boolean interrupted = Thread.interrupted();
                try {
                    locator = (DistributionLocator)future.get();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                catch (CancellationException ex) {
                    continue block9;
                }
                catch (ExecutionException ex) {
                    AdminDistributedSystemImpl.handle(ex);
                    continue block9;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            sb.append(locator.getConfig().getHost());
            sb.append("[").append(locator.getConfig().getPort()).append("]");
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeJoined(GfManagerAgent source, GemFireVM vm) {
        Object object = this.membershipListenerLock;
        synchronized (object) {
            SystemMember member = this.findSystemMember(vm);
            if (member == null) {
                FutureTask future = null;
                if (vm instanceof ApplicationVM) {
                    Object object2;
                    ApplicationVM app = (ApplicationVM)vm;
                    if (app.isDedicatedCacheServer()) {
                        object2 = this.cacheServerSet;
                        synchronized (object2) {
                            future = new AdminFutureTask(vm.getId(), () -> {
                                logger.info(LogMarker.DM_MARKER, "Adding new CacheServer for {}", (Object)vm);
                                return this.createCacheServer(app);
                            });
                            this.cacheServerSet.add(future);
                        }
                    } else {
                        object2 = this.applicationSet;
                        synchronized (object2) {
                            future = new AdminFutureTask(vm.getId(), () -> {
                                logger.info(LogMarker.DM_MARKER, "Adding new Application for {}", (Object)vm);
                                return this.createSystemMember(app);
                            });
                            this.applicationSet.add(future);
                        }
                    }
                } else {
                    Assert.assertTrue(false, "Unknown GemFireVM type: " + vm.getClass().getName());
                }
                future.run();
                while (true) {
                    this.checkCancellation();
                    boolean interrupted = Thread.interrupted();
                    try {
                        member = (SystemMember)future.get();
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        continue;
                    }
                    catch (CancellationException ex) {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                        return;
                    }
                    catch (ExecutionException ex) {
                        AdminDistributedSystemImpl.handle(ex);
                        return;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                Assert.assertTrue(member != null);
                SystemMembershipEventImpl event = new SystemMembershipEventImpl(member.getDistributedMember());
                for (Object membershipListener : this.membershipListeners) {
                    SystemMembershipListener listener = (SystemMembershipListener)membershipListener;
                    listener.memberJoined(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeLeft(GfManagerAgent source, GemFireVM vm) {
        Object object = this.membershipListenerLock;
        synchronized (object) {
            SystemMember member = this.removeSystemMember(vm.getId());
            if (member == null) {
                return;
            }
            SystemMembershipEventImpl event = new SystemMembershipEventImpl(vm.getId());
            for (Object membershipListener : this.membershipListeners) {
                SystemMembershipListener listener = (SystemMembershipListener)membershipListener;
                listener.memberLeft(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeCrashed(GfManagerAgent source, GemFireVM vm) {
        Object object = this.membershipListenerLock;
        synchronized (object) {
            SystemMember member = this.removeSystemMember(vm.getId());
            if (member == null) {
                return;
            }
            SystemMembershipEventImpl event = new SystemMembershipEventImpl(vm.getId());
            for (Object membershipListener : this.membershipListeners) {
                SystemMembershipListener listener = (SystemMembershipListener)membershipListener;
                listener.memberCrashed(event);
            }
        }
    }

    @Override
    public void alert(org.apache.geode.internal.admin.Alert alert) {
        if (AlertLevel.forSeverity((int)alert.getLevel()).ordinal < this.alertLevel.ordinal) {
            return;
        }
        AlertImpl alert2 = new AlertImpl(alert);
        this.latestAlert = alert2;
        for (AlertListener listener : this.alertListeners) {
            listener.alert(alert2);
        }
    }

    @Override
    public void onDisconnect(InternalDistributedSystem sys) {
        logger.debug("Calling AdminDistributedSystemImpl#onDisconnect");
        this.disconnect();
        logger.debug("Completed AdminDistributedSystemImpl#onDisconnect");
    }

    protected CacheServer createCacheServer(ApplicationVM member) throws AdminException {
        return new CacheServerImpl(this, (GemFireVM)member);
    }

    protected CacheServer createCacheServer(CacheServerConfigImpl conf) throws AdminException {
        return new CacheServerImpl(this, conf);
    }

    protected SystemMember createSystemMember(ApplicationVM app) throws AdminException {
        return new SystemMemberImpl((AdminDistributedSystem)this, app);
    }

    protected SystemMember createSystemMember(InternalDistributedMember member) throws AdminException {
        return new SystemMemberImpl((AdminDistributedSystem)this, member);
    }

    protected DistributionLocatorImpl createDistributionLocatorImpl(DistributionLocatorConfig conf) {
        return new DistributionLocatorImpl(conf, this);
    }

    protected List parseLocators() {
        ArrayList<DistributionLocatorId> locatorIds = new ArrayList<DistributionLocatorId>();
        if (this.isMcastEnabled()) {
            String mcastId = this.getMcastAddress() + "[" + this.getMcastPort() + "]";
            locatorIds.add(DistributionLocatorId.unmarshal(mcastId));
        }
        StringTokenizer st = new StringTokenizer(this.getLocators(), ",");
        while (st.hasMoreTokens()) {
            locatorIds.add(DistributionLocatorId.unmarshal(st.nextToken()));
        }
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Locator set is: ");
            for (Object e : locatorIds) {
                sb.append(e);
                sb.append(" ");
            }
            logger.debug((CharSequence)sb);
        }
        return locatorIds;
    }

    private boolean isSame(SystemMemberImpl member, GemFireVM vm, boolean examineConfig) {
        if (vm.equals(member.getGemFireVM())) {
            return true;
        }
        InternalDistributedMember memberId = member.getInternalId();
        InternalDistributedMember vmId = vm.getId();
        if (vmId.equals(memberId)) {
            return true;
        }
        if (member instanceof ManagedSystemMemberImpl && examineConfig) {
            ManagedSystemMemberImpl entity = (ManagedSystemMemberImpl)member;
            if (entity instanceof CacheServer) {
                if (!(vm instanceof ApplicationVM)) {
                    return false;
                }
                ApplicationVM app = (ApplicationVM)vm;
                if (!app.isDedicatedCacheServer()) {
                    return false;
                }
            }
            ManagedEntityConfig conf = entity.getEntityConfig();
            InetAddress managedHost = InetAddressUtilsWithLogging.toInetAddress(conf.getHost());
            File managedWorkingDir = new File(conf.getWorkingDirectory());
            File managedProdDir = new File(conf.getProductDirectory());
            InetAddress vmHost = vm.getHost();
            File vmWorkingDir = vm.getWorkingDirectory();
            File vmProdDir = vm.getGeodeHomeDir();
            return vmHost.equals(managedHost) && this.isSameFile(vmWorkingDir, managedWorkingDir) && this.isSameFile(vmProdDir, managedProdDir);
        }
        return false;
    }

    private boolean isSameFile(File file1, File file2) {
        if (file1.equals(file2)) {
            return true;
        }
        if (file1.getAbsoluteFile().equals(file2.getAbsoluteFile())) {
            return true;
        }
        try {
            if (file1.getCanonicalFile().equals(file2.getCanonicalFile())) {
                return true;
            }
        }
        catch (IOException ex) {
            logger.info("While getting canonical file", (Throwable)ex);
        }
        return false;
    }

    protected SystemMember findSystemMember(GemFireVM vm) {
        return this.findSystemMember(vm, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected SystemMember findSystemMember(GemFireVM vm, boolean compareConfig) {
        boolean interrupted;
        Future future;
        SystemMemberImpl member = null;
        Set set = this.cacheServerSet;
        synchronized (set) {
            block26: for (Object o : this.cacheServerSet) {
                future = (Future)o;
                CacheServerImpl cacheServer = null;
                while (true) {
                    this.checkCancellation();
                    interrupted = Thread.interrupted();
                    try {
                        cacheServer = (CacheServerImpl)future.get();
                        break;
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        continue;
                    }
                    catch (CancellationException ex) {}
                    continue block26;
                    catch (ExecutionException ex) {
                        AdminDistributedSystemImpl.handle(ex);
                        continue block26;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                if (!this.isSame(cacheServer, vm, compareConfig)) continue;
                member = cacheServer;
                break;
            }
        }
        if (member == null) {
            set = this.applicationSet;
            synchronized (set) {
                block28: for (Object o : this.applicationSet) {
                    future = (Future)o;
                    SystemMemberImpl application = null;
                    while (true) {
                        this.checkCancellation();
                        interrupted = Thread.interrupted();
                        try {
                            application = (SystemMemberImpl)future.get();
                            break;
                        }
                        catch (InterruptedException ex) {
                            interrupted = true;
                            continue;
                        }
                        catch (CancellationException ex) {}
                        continue block28;
                        catch (ExecutionException ex) {
                            AdminDistributedSystemImpl.handle(ex);
                            continue block28;
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        break;
                    }
                    if (!this.isSame(application, vm, compareConfig)) continue;
                    member = application;
                    break;
                }
            }
        }
        if (member != null && compareConfig) {
            try {
                member.setGemFireVM(vm);
            }
            catch (AdminException ex) {
                logger.warn("Could not set the GemFire VM.", (Throwable)ex);
            }
        }
        return member;
    }

    protected SystemMember removeSystemMember(SystemMember systemMember) {
        return this.removeSystemMember(((SystemMemberImpl)systemMember).getInternalId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected SystemMember removeSystemMember(InternalDistributedMember internalId) {
        AdminFutureTask task;
        Future future;
        Iterator iter;
        if (internalId == null) {
            return null;
        }
        boolean found = false;
        SystemMemberImpl member = null;
        Set set = this.cacheServerSet;
        synchronized (set) {
            iter = this.cacheServerSet.iterator();
            block21: while (iter.hasNext() && !found) {
                future = (Future)iter.next();
                if (future instanceof AdminFutureTask) {
                    task = (AdminFutureTask)future;
                    if (!task.getMemberId().equals(internalId)) continue;
                    future.cancel(true);
                }
                while (true) {
                    this.checkCancellation();
                    boolean interrupted = Thread.interrupted();
                    try {
                        member = (SystemMemberImpl)future.get();
                        break;
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        continue;
                    }
                    catch (CancellationException ex) {}
                    continue block21;
                    catch (ExecutionException ex) {
                        AdminDistributedSystemImpl.handle(ex);
                        SystemMember systemMember = null;
                        return systemMember;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                InternalDistributedMember cacheServerId = member.getInternalId();
                if (!internalId.equals(cacheServerId)) continue;
                iter.remove();
                found = true;
            }
        }
        set = this.applicationSet;
        synchronized (set) {
            iter = this.applicationSet.iterator();
            while (iter.hasNext() && !found) {
                InternalDistributedMember applicationId;
                future = (Future)iter.next();
                try {
                    if (future instanceof AdminFutureTask) {
                        task = (AdminFutureTask)future;
                        if (!task.getMemberId().equals(internalId)) continue;
                        iter.remove();
                        found = true;
                        if (!future.isDone()) break;
                        member = (SystemMemberImpl)future.get();
                        break;
                    }
                    if (future.isDone()) {
                        member = (SystemMemberImpl)future.get();
                    } else {
                        future.cancel(true);
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    this.checkCancellation();
                    throw new RuntimeException("Interrupted", ex);
                }
                catch (CancellationException ex) {
                    continue;
                }
                catch (ExecutionException ex) {
                    AdminDistributedSystemImpl.handle(ex);
                    return null;
                }
                if (!internalId.equals(applicationId = member.getInternalId())) continue;
                iter.remove();
                found = true;
            }
        }
        if (found) {
            try {
                if (member != null) {
                    member.setGemFireVM(null);
                }
            }
            catch (AdminException ex) {
                logger.fatal("Unexpected AdminException", (Throwable)ex);
            }
            return member;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Couldn't remove member {}", (Object)internalId);
        }
        return null;
    }

    private GfManagerAgentConfig buildAgentConfig(InternalLogWriter logWriter) {
        RemoteTransportConfig conf = new RemoteTransportConfig(this.isMcastEnabled(), this.getDisableTcp(), this.getDisableAutoReconnect(), this.getBindAddress(), this.buildSSLConfig(), this.parseLocators(), this.getMembershipPortRange(), this.getTcpPort(), 12);
        return new GfManagerAgentConfig(this.getSystemName(), conf, logWriter, this.alertLevel.getSeverity(), this, this);
    }

    protected SSLConfig buildSSLConfig() {
        SSLConfig.Builder sslConfigBuilder = new SSLConfig.Builder();
        if (this.getConfig() != null) {
            sslConfigBuilder.setEnabled(this.getConfig().isSSLEnabled());
            sslConfigBuilder.setProtocols(this.getConfig().getSSLProtocols());
            sslConfigBuilder.setCiphers(this.getConfig().getSSLCiphers());
            sslConfigBuilder.setRequireAuth(this.getConfig().isSSLAuthenticationRequired());
            sslConfigBuilder.setProperties(this.getConfig().getSSLProperties());
        }
        return sslConfigBuilder.build();
    }

    private String getBindAddress() {
        return this.config.getBindAddress();
    }

    private boolean isRunning(SystemMember member) {
        if (member instanceof ManagedEntity) {
            return ((ManagedEntity)((Object)member)).isRunning();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SystemMember findFirstRunningMember() {
        boolean interrupted;
        SystemMember member;
        Future future;
        Set set = this.cacheServerSet;
        synchronized (set) {
            block22: for (Object o : this.cacheServerSet) {
                future = (Future)o;
                member = null;
                while (true) {
                    this.checkCancellation();
                    interrupted = Thread.interrupted();
                    try {
                        member = (SystemMember)future.get();
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        continue;
                    }
                    catch (CancellationException ex) {
                        continue block22;
                    }
                    catch (ExecutionException ex) {
                        AdminDistributedSystemImpl.handle(ex);
                        SystemMember systemMember = null;
                        return systemMember;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                if (!this.isRunning(member)) continue;
                return member;
            }
        }
        set = this.applicationSet;
        synchronized (set) {
            block27: {
                Iterator iterator = this.applicationSet.iterator();
                block24: while (iterator.hasNext()) {
                    Object o;
                    o = iterator.next();
                    future = (Future)o;
                    member = null;
                    while (true) {
                        this.checkCancellation();
                        interrupted = Thread.interrupted();
                        try {
                            member = (SystemMember)future.get();
                        }
                        catch (InterruptedException ex) {
                            interrupted = true;
                            continue;
                        }
                        catch (CancellationException ex) {
                            continue block24;
                        }
                        catch (ExecutionException ex) {
                            AdminDistributedSystemImpl.handle(ex);
                            SystemMember systemMember = null;
                            return systemMember;
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                            continue;
                        }
                        break;
                    }
                    if (!this.isRunning(member)) {
                        continue;
                    }
                    break block27;
                }
                return null;
            }
            return member;
        }
    }

    protected SystemMember findCacheOrAppVmById(String memberId) {
        SystemMember found;
        block6: {
            found = null;
            if (memberId != null) {
                try {
                    SystemMember[] appVms;
                    boolean foundSender = false;
                    CacheVm[] cacheVms = this.getCacheVms();
                    if (cacheVms != null) {
                        for (CacheVm cacheVm : cacheVms) {
                            if (!cacheVm.getId().equals(memberId) || !(cacheVm instanceof CacheVm)) continue;
                            found = cacheVm;
                            foundSender = true;
                            break;
                        }
                    }
                    if (foundSender) break block6;
                    for (SystemMember appVm : appVms = this.getSystemMemberApplications()) {
                        if (!appVm.getId().equals(memberId) || !(appVm instanceof SystemMember)) continue;
                        found = appVm;
                        foundSender = true;
                        break;
                    }
                }
                catch (AdminException e) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug("Could not find System Member for member id: {}", (Object)memberId, (Object)e);
                }
            }
        }
        return found;
    }

    protected boolean isAnyMemberRunning() {
        return this.findFirstRunningMember() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GemFireHealth getGemFireHealth() {
        AdminDistributedSystemImpl adminDistributedSystemImpl = this;
        synchronized (adminDistributedSystemImpl) {
            if (this.health == null || this.health.isClosed()) {
                try {
                    this.health = this.createGemFireHealth(this.gfManagerAgent);
                }
                catch (AdminException ex) {
                    throw new RuntimeAdminException("An AdminException was thrown while getting the GemFire health.", ex);
                }
            }
            return this.health;
        }
    }

    protected GemFireHealth createGemFireHealth(GfManagerAgent agent) throws AdminException {
        if (agent == null) {
            throw new IllegalStateException("GfManagerAgent must not be null");
        }
        return new GemFireHealthImpl(agent, this);
    }

    @Override
    public CacheVm addCacheVm() throws AdminException {
        return (CacheVm)((Object)this.addCacheServer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheServer addCacheServer() throws AdminException {
        CacheServerConfigImpl conf = new CacheServerConfigImpl();
        CacheServer server = this.createCacheServer(conf);
        this.setDistributionParameters(server);
        Set set = this.cacheServerSet;
        synchronized (set) {
            this.cacheServerSet.add(new FutureResult<CacheServer>(server));
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection getCacheVmsCollection() throws AdminException {
        Set set = this.cacheServerSet;
        synchronized (set) {
            ArrayList<Object> coll = new ArrayList<Object>(this.cacheServerSet.size());
            Iterator iterator = this.cacheServerSet.iterator();
            block11: while (iterator.hasNext()) {
                Object o = iterator.next();
                Future future = (Future)o;
                Object get = null;
                while (true) {
                    this.checkCancellation();
                    boolean interrupted = Thread.interrupted();
                    try {
                        get = future.get();
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        continue;
                    }
                    catch (CancellationException ex) {
                        continue block11;
                    }
                    catch (ExecutionException ex) {
                        AdminDistributedSystemImpl.handle(ex);
                        Collection collection = null;
                        return collection;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                coll.add(get);
            }
            return coll;
        }
    }

    @Override
    public CacheServer[] getCacheServers(String durableClientId) throws AdminException {
        CacheServer[] servers;
        ArrayList<CacheServer> serversForDurableClient = new ArrayList<CacheServer>();
        for (CacheServer server : servers = this.getCacheServers()) {
            RemoteApplicationVM vm = (RemoteApplicationVM)((CacheServerImpl)server).getGemFireVM();
            if (vm == null || !vm.hasDurableClient(durableClientId)) continue;
            serversForDurableClient.add(server);
        }
        CacheServer[] array = new CacheServer[serversForDurableClient.size()];
        serversForDurableClient.toArray(array);
        return array;
    }

    @Override
    public CacheVm[] getCacheVms() throws AdminException {
        Collection coll = this.getCacheVmsCollection();
        if (coll == null) {
            return null;
        }
        CacheVm[] array = new CacheVm[coll.size()];
        coll.toArray(array);
        return array;
    }

    @Override
    public CacheServer[] getCacheServers() throws AdminException {
        Collection coll = this.getCacheVmsCollection();
        if (coll == null) {
            return null;
        }
        CacheServer[] array = new CacheServer[coll.size()];
        coll.toArray(array);
        return array;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdminDistributedSystemImpl getConnectedInstance() {
        Object object = CONNECTION_SYNC;
        synchronized (object) {
            return thisAdminDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCacheListener(SystemMemberCacheListener listener) {
        Object object = this.cacheListLock;
        synchronized (object) {
            List oldListeners = this.cacheListeners;
            if (!oldListeners.contains(listener)) {
                ArrayList<SystemMemberCacheListener> newListeners = new ArrayList<SystemMemberCacheListener>(oldListeners);
                newListeners.add(listener);
                this.cacheListeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCacheListener(SystemMemberCacheListener listener) {
        Object object = this.cacheListLock;
        synchronized (object) {
            List newListeners;
            List oldListeners = this.cacheListeners;
            if (oldListeners.contains(listener) && (newListeners = new ArrayList(oldListeners)).remove(listener)) {
                if (newListeners.isEmpty()) {
                    newListeners = Collections.EMPTY_LIST;
                }
                this.cacheListeners = newListeners;
            }
        }
    }

    public List getCacheListeners() {
        return this.cacheListeners;
    }

    @Override
    public SystemMember lookupSystemMember(DistributedMember distributedMember) throws AdminException {
        SystemMember[] members;
        if (distributedMember == null) {
            return null;
        }
        for (SystemMember member : members = this.getSystemMemberApplications()) {
            if (!distributedMember.equals(member.getDistributedMember())) continue;
            return member;
        }
        return null;
    }

    public DistributedMember getDistributedMember() {
        return this.getDistributionManager().getId();
    }

    private void connectAdminDS() {
        this.connect(this.logWriter);
        try {
            thisAdminDS.waitToBeConnected(3000L);
        }
        catch (InterruptedException ie) {
            logger.warn("Interrupted while waiting to connect", (Throwable)ie);
        }
    }

    @Override
    public Set<PersistentID> getMissingPersistentMembers() throws AdminException {
        this.connectAdminDS();
        DistributionManager dm = this.getDistributionManager();
        if (dm == null) {
            throw new IllegalStateException("connect() has not been invoked on this AdminDistributedSystem.");
        }
        return AdminDistributedSystemImpl.getMissingPersistentMembers(dm);
    }

    public static Set<PersistentID> getMissingPersistentMembers(DistributionManager dm) {
        return MissingPersistentIDsRequest.send(dm);
    }

    @Override
    public void revokePersistentMember(InetAddress host, String directory) throws AdminException {
        this.connectAdminDS();
        DistributionManager dm = this.getDistributionManager();
        if (dm == null) {
            throw new IllegalStateException("connect() has not been invoked on this AdminDistributedSystem.");
        }
        AdminDistributedSystemImpl.revokePersistentMember(dm, host, directory);
    }

    @Override
    public void revokePersistentMember(UUID diskStoreID) throws AdminException {
        this.connectAdminDS();
        DistributionManager dm = this.getDistributionManager();
        if (dm == null) {
            throw new IllegalStateException("connect() has not been invoked on this AdminDistributedSystem.");
        }
        AdminDistributedSystemImpl.revokePersistentMember(dm, diskStoreID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void revokePersistentMember(DistributionManager dm, UUID diskStoreID) {
        PersistentMemberPattern pattern = new PersistentMemberPattern(diskStoreID);
        boolean success = false;
        try {
            boolean found = false;
            Set<PersistentID> details = AdminDistributedSystemImpl.getMissingPersistentMembers(dm);
            if (details != null) {
                for (PersistentID id : details) {
                    if (!id.getUUID().equals(diskStoreID)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return;
            }
            PrepareRevokePersistentIDRequest.send(dm, pattern);
            success = true;
        }
        finally {
            if (success) {
                RevokePersistentIDRequest.send(dm, pattern);
            } else {
                PrepareRevokePersistentIDRequest.cancel(dm, pattern);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void revokePersistentMember(DistributionManager dm, InetAddress host, String directory) {
        PersistentMemberPattern pattern = new PersistentMemberPattern(host, directory, System.currentTimeMillis());
        boolean success = false;
        try {
            PrepareRevokePersistentIDRequest.send(dm, pattern);
            success = true;
        }
        finally {
            if (success) {
                RevokePersistentIDRequest.send(dm, pattern);
            } else {
                PrepareRevokePersistentIDRequest.cancel(dm, pattern);
            }
        }
    }

    public Set shutDownAllMembers() throws AdminException {
        return this.shutDownAllMembers(0L);
    }

    public Set shutDownAllMembers(long timeout) throws AdminException {
        this.connectAdminDS();
        DistributionManager dm = this.getDistributionManager();
        if (dm == null) {
            throw new IllegalStateException("connect() has not been invoked on this AdminDistributedSystem.");
        }
        return AdminDistributedSystemImpl.shutDownAllMembers(dm, timeout);
    }

    public static Set shutDownAllMembers(DistributionManager dm, long timeout) {
        return ShutdownAllRequest.send(dm, timeout);
    }

    @Override
    public BackupStatus backupAllMembers(File targetDir) throws AdminException {
        return this.backupAllMembers(targetDir, null);
    }

    @Override
    public BackupStatus backupAllMembers(File targetDir, File baselineDir) throws AdminException {
        this.connectAdminDS();
        DistributionManager dm = this.getDistributionManager();
        if (dm == null) {
            throw new IllegalStateException("connect() has not been invoked on this AdminDistributedSystem.");
        }
        return AdminDistributedSystemImpl.backupAllMembers(dm, targetDir, baselineDir);
    }

    public static BackupStatus backupAllMembers(DistributionManager dm, File targetDir, File baselineDir) throws AdminException {
        String baselineDirectory = baselineDir == null ? null : baselineDir.toString();
        return new BackupOperation(dm, dm.getCache()).backupAllMembers(targetDir.toString(), baselineDirectory);
    }

    @Override
    public Map<DistributedMember, Set<PersistentID>> compactAllDiskStores() throws AdminException {
        this.connectAdminDS();
        DistributionManager dm = this.getDistributionManager();
        if (dm == null) {
            throw new IllegalStateException("connect() has not been invoked on this AdminDistributedSystem.");
        }
        return AdminDistributedSystemImpl.compactAllDiskStores(dm);
    }

    public static Map<DistributedMember, Set<PersistentID>> compactAllDiskStores(DistributionManager dm) throws AdminException {
        return CompactRequest.send(dm);
    }

    public void processClientMembership(String senderId, String clientId, String clientHost, int eventType) {
    }

    @Override
    public void setAlertLevelAsString(String level) {
        AlertLevel newAlertLevel = AlertLevel.forName(level);
        if (newAlertLevel == null) {
            System.out.println("ERROR:: " + level + " is invalid. Allowed alert levels are: WARNING, ERROR, SEVERE, OFF");
            throw new IllegalArgumentException(String.format("%s", level + " is invalid. Allowed alert levels are: WARNING, ERROR, SEVERE, OFF"));
        }
        this.setAlertLevel(newAlertLevel);
    }

    @Override
    public String getAlertLevelAsString() {
        return this.getAlertLevel().getName();
    }

    static {
        CONNECTION_SYNC = new Object();
        TIMEOUT_MS = Integer.getInteger(TIMEOUT_MS_NAME, 60000);
    }

    static class AdminFutureTask
    extends FutureTask {
        private final InternalDistributedMember memberId;

        public AdminFutureTask(InternalDistributedMember memberId, Callable callable) {
            super(callable);
            this.memberId = memberId;
        }

        public InternalDistributedMember getMemberId() {
            return this.memberId;
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                return super.get();
            }
            catch (ExecutionException ex) {
                for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof InterruptedException)) continue;
                    CancellationException ex2 = new CancellationException("by interrupt");
                    ex2.setStackTrace(cause.getStackTrace());
                    throw ex2;
                }
                throw ex;
            }
        }
    }

    public class AlertImpl
    implements Alert {
        private final org.apache.geode.internal.admin.Alert alert;
        private SystemMember systemMember;

        AlertImpl(org.apache.geode.internal.admin.Alert alert) {
            InternalDistributedMember sender;
            this.alert = alert;
            GemFireVM vm = alert.getGemFireVM();
            SystemMember systemMember = this.systemMember = vm == null ? null : AdminDistributedSystemImpl.this.findSystemMember(vm, false);
            if (this.systemMember == null && (sender = alert.getSender()) != null) {
                try {
                    this.systemMember = AdminDistributedSystemImpl.this.createSystemMember(sender);
                }
                catch (AdminException e) {
                    this.systemMember = null;
                }
            }
        }

        @Override
        public AlertLevel getLevel() {
            return AlertLevel.forSeverity(this.alert.getLevel());
        }

        @Override
        public SystemMember getSystemMember() {
            return this.systemMember;
        }

        @Override
        public String getConnectionName() {
            return this.alert.getConnectionName();
        }

        @Override
        public String getSourceId() {
            return this.alert.getSourceId();
        }

        @Override
        public String getMessage() {
            return this.alert.getMessage();
        }

        @Override
        public Date getDate() {
            return this.alert.getDate();
        }

        public String toString() {
            return this.alert.toString();
        }
    }
}

