/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.labeling;

import com.sas.graphics.util.labeling.Node;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public final class Candidate {
    int position;
    Node node;
    ArrayList conflictPartners;
    Rectangle bbox;
    Stack otherCandidates = new Stack();

    public Candidate(Node n, int p) {
        this.node = n;
        this.position = p;
        this.conflictPartners = new ArrayList();
        this.calcBBox();
    }

    public Node getNode() {
        return this.node;
    }

    public int getPosition() {
        return this.position;
    }

    public void removeConflictPartner(Candidate c) {
        this.conflictPartners.remove(c);
    }

    public void addConflictPartner(Candidate cc) {
        this.conflictPartners.add(cc);
    }

    public int getNumConflictPartners() {
        return this.conflictPartners.size();
    }

    public Iterator getConflictPartners() {
        return this.conflictPartners.listIterator();
    }

    public Candidate getConflictPartner(int i) {
        return (Candidate)this.conflictPartners.get(i);
    }

    public void calcBBox() {
        int nx = this.node.x + this.node.dx;
        int ny = this.node.y + this.node.dy;
        int nw = this.node.textWidth;
        int nh = this.node.textHeight;
        int hms = this.node.markerSize / 2;
        switch (this.position) {
            case -1: {
                this.bbox = new Rectangle(nx - hms, ny - hms, 2 * hms, 2 * hms);
                break;
            }
            case 0: {
                this.bbox = new Rectangle(nx, ny - nh, nw + hms, nh);
                break;
            }
            case 1: {
                this.bbox = new Rectangle(nx - nw - hms, ny - nh, nw + hms, nh);
                break;
            }
            case 2: {
                this.bbox = new Rectangle(nx, ny, nw + hms, nh);
                break;
            }
            case 3: {
                this.bbox = new Rectangle(nx - nw - hms, ny, nw + hms, nh);
                break;
            }
            case 4: {
                this.bbox = new Rectangle(nx, ny - nh / 2, nw + hms, nh);
                break;
            }
            case 5: {
                this.bbox = new Rectangle(nx - nw / 2, ny - nh - hms, nw, nh + hms);
                break;
            }
            case 6: {
                this.bbox = new Rectangle(nx - nw - hms, ny - nh / 2, nw + hms, nh);
                break;
            }
            case 7: {
                this.bbox = new Rectangle(nx - nw / 2, ny, nw, nh + hms);
            }
        }
    }

    public void resolved(int rule) {
        this.node.setResolved(true);
        if (this.node.getNumCandidates() == 1) {
            return;
        }
        this.otherCandidates.removeAllElements();
        Iterator i = this.node.getCandidates();
        while (i.hasNext()) {
            Candidate c = (Candidate)i.next();
            if (c == this) continue;
            this.otherCandidates.push(c);
        }
        while (!this.otherCandidates.empty()) {
            Candidate c = (Candidate)this.otherCandidates.pop();
            this.node.removeCandidate(c);
            c.removeFromConflictPartners();
            c.applyRule(rule);
        }
    }

    public void removeFromConflictPartners() {
        Iterator i = this.getConflictPartners();
        while (i.hasNext()) {
            Candidate c = (Candidate)i.next();
            c.removeConflictPartner(this);
        }
    }

    public void applyRule(int rule) {
        if (this.node.isResolved()) {
            return;
        }
        this.node.doPhaseI(rule);
        Iterator i = this.getConflictPartners();
        while (i.hasNext()) {
            Candidate c = (Candidate)i.next();
            c.getNode().doPhaseI(rule);
        }
    }

    public void dump() {
        System.out.println("    Position: " + this.position);
        System.out.println("    Partners: " + this.getNumConflictPartners());
    }
}

