/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.categorization;

import com.sas.graphics.util.categorization.DataComparator;
import com.sas.graphics.util.categorization.DataInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class JenksNaturalBreaks {
    private static int NUMBER_OF_PARTITIONS = 16;
    private static int accuracyLevel = 1;
    private static HashMap bestSDBC = new HashMap();
    private static HashMap svc = new HashMap();
    private static HashMap value2Index = new HashMap();

    public static Double[] getRanges(Double[] values, int numLevels) {
        values = JenksNaturalBreaks.removeMissings(values);
        Arrays.sort((Object[])values);
        if (numLevels > 6) {
            HashSet<Double> uniqueValues = new HashSet<Double>(Arrays.asList(values));
            uniqueValues.remove(new Double(Double.NaN));
            int uniqValueCount = uniqueValues.size();
            if (numLevels + 1 >= uniqValueCount) {
                Double[] breaks;
                int arrlen;
                Object[] sortedUniqueValues = uniqueValues.toArray();
                Arrays.sort(sortedUniqueValues);
                boolean diff = false;
                if (numLevels == uniqValueCount - 1) {
                    diff = true;
                }
                if ((arrlen = sortedUniqueValues.length) == 0) {
                    return new Double[0];
                }
                if (diff) {
                    breaks = new Double[arrlen];
                    for (int i = 0; i < arrlen; ++i) {
                        breaks[i] = (Double)sortedUniqueValues[i];
                    }
                } else {
                    breaks = new Double[arrlen + 1];
                    for (int i = 0; i < arrlen; ++i) {
                        breaks[i + 1] = (Double)sortedUniqueValues[i];
                    }
                    breaks[0] = breaks[1];
                }
                return breaks;
            }
            int dataLength = values.length;
            int firstPartition = numLevels / 2;
            int secondPartition = numLevels - firstPartition;
            Double[] allRanges = new Double[numLevels + 1];
            double bestValue = Double.MAX_VALUE;
            Double[] midvalue = JenksNaturalBreaks._getRangesFromSortedValues(values, 6);
            for (int i = 1; i <= 6; ++i) {
                int midIndex = Arrays.binarySearch((Object[])values, midvalue[i]);
                int firstPartitionSize = midIndex < 0 ? -midIndex : midIndex + 1;
                int secondPartitionSize = values.length - firstPartitionSize + 1;
                if (firstPartitionSize < dataLength / 5 || firstPartitionSize <= firstPartition) continue;
                if (secondPartitionSize < dataLength / 5 || secondPartitionSize <= secondPartition) {
                    if (allRanges[0] != null) break;
                    int midIndex1 = Arrays.binarySearch((Object[])values, midvalue[i - 1]);
                    int midIndex2 = Arrays.binarySearch((Object[])values, midvalue[i]);
                    int startIndex = midIndex1 < 0 ? -midIndex1 : midIndex1;
                    int endIndex = midIndex2 < 0 ? -midIndex2 : midIndex2;
                    Double[] midValues = new Double[endIndex - startIndex + 1];
                    System.arraycopy(values, startIndex, midValues, 0, midValues.length);
                    Double[] range = JenksNaturalBreaks._getRangesFromSortedValues(midValues, numLevels - 5);
                    if (i > 1) {
                        System.arraycopy(midvalue, 0, allRanges, 0, i - 1);
                    }
                    System.arraycopy(range, 0, allRanges, i - 1, range.length);
                    if (i >= 6) break;
                    System.arraycopy(midvalue, i + 1, allRanges, i - 1 + range.length, 6 - i);
                    break;
                }
                Double[] firstValues = new Double[firstPartitionSize];
                System.arraycopy(values, 0, firstValues, 0, firstPartitionSize);
                Double[] range1 = JenksNaturalBreaks._getRangesFromSortedValues(firstValues, firstPartition);
                double sdbc1 = (Double)bestSDBC.get(firstValues);
                Double[] secondValues = new Double[secondPartitionSize];
                System.arraycopy(values, firstPartitionSize - 1, secondValues, 0, secondPartitionSize);
                Double[] range2 = JenksNaturalBreaks._getRangesFromSortedValues(secondValues, secondPartition);
                double sdbc2 = (Double)bestSDBC.get(secondValues);
                if (!(sdbc1 + sdbc2 < bestValue)) continue;
                System.arraycopy(range1, 0, allRanges, 0, firstPartition + 1);
                System.arraycopy(range2, 1, allRanges, firstPartition + 1, secondPartition);
                bestValue = sdbc1 + sdbc2;
            }
            return allRanges;
        }
        return JenksNaturalBreaks._getRangesFromSortedValues(values, numLevels);
    }

    private static Double[] removeMissings(Double[] d) {
        HashSet<Double> newValues = new HashSet<Double>(Arrays.asList(d));
        newValues.remove(new Double(Double.NaN));
        Double[] nonMissingValues = newValues.toArray(new Double[0]);
        return nonMissingValues;
    }

    private static Double[] _getRangesFromSortedValues(Double[] values, int numLevels) {
        HashSet<Double> uniqueValues = new HashSet<Double>(Arrays.asList(values));
        uniqueValues.remove(new Double(Double.NaN));
        Object[] sortedUniqueValues = uniqueValues.toArray();
        Arrays.sort(sortedUniqueValues);
        int uniqValueCount = uniqueValues.size();
        if (uniqValueCount == 0) {
            return new Double[0];
        }
        if (numLevels == 1) {
            Double[] breaks = new Double[]{(Double)sortedUniqueValues[0], (Double)sortedUniqueValues[sortedUniqueValues.length - 1]};
            return breaks;
        }
        if (numLevels + 1 >= uniqValueCount) {
            Double[] breaks;
            int arrlen;
            boolean diff = false;
            if (numLevels == uniqValueCount - 1) {
                diff = true;
            }
            if ((arrlen = sortedUniqueValues.length) == 0) {
                return new Double[0];
            }
            if (diff) {
                breaks = new Double[arrlen];
                for (int i = 0; i < arrlen; ++i) {
                    breaks[i] = (Double)sortedUniqueValues[i];
                }
            } else {
                breaks = new Double[arrlen + 1];
                for (int i = 0; i < arrlen; ++i) {
                    breaks[i + 1] = (Double)sortedUniqueValues[i];
                }
                breaks[0] = breaks[1];
            }
            bestSDBC.put(values, new Double(0.0));
            return breaks;
        }
        bestSDBC.put(values, new Double(Double.MAX_VALUE));
        ArrayList<DataInfo> gaps = new ArrayList<DataInfo>();
        for (int i = 1; i < uniqValueCount - 1; ++i) {
            gaps.add(new DataInfo((Double)sortedUniqueValues[i], (Double)sortedUniqueValues[i + 1] - (Double)sortedUniqueValues[i], i));
        }
        DataComparator dc = new DataComparator();
        int stepSize = uniqValueCount < 1000 ? Math.min(33, Math.max(1, uniqValueCount / (numLevels + 1))) : (uniqValueCount < 5000 ? Math.min(66, Math.max(1, uniqValueCount / (numLevels + 1))) : (uniqValueCount < 10000 ? Math.min(132, Math.max(1, uniqValueCount / (numLevels + 1))) : (uniqValueCount < 50000 ? Math.min(314, Math.max(1, uniqValueCount / (numLevels + 1))) : Math.min(500, Math.max(1, uniqValueCount / (numLevels + 1))))));
        HashSet<Object> candidates = new HashSet<Object>();
        Object[] garray = gaps.toArray();
        for (int i = 1; i < uniqValueCount - (stepSize + 2); i += stepSize) {
            Arrays.sort(garray, i, i + stepSize + 1, dc);
            candidates.add(sortedUniqueValues[i + stepSize]);
        }
        Arrays.sort(garray, dc);
        int startIndex = Math.max(uniqValueCount - 5 * numLevels, 0);
        for (startIndex = accuracyLevel < 2 ? (uniqValueCount < 10000 ? Math.max(uniqValueCount - 50, startIndex) : uniqValueCount - 100) : (uniqValueCount < 1000 ? Math.min(uniqValueCount * 3 / 4, startIndex) : (uniqValueCount < 5000 ? Math.min(uniqValueCount * 11 / 12, startIndex) : (uniqValueCount < 10000 ? Math.min(uniqValueCount * 31 / 32, startIndex) : (uniqValueCount < 25000 ? Math.min(uniqValueCount * 127 / 128, startIndex) : Math.min(uniqValueCount * 999 / 1000, startIndex))))); startIndex > 0 && ((DataInfo)garray[startIndex]).gapsize == ((DataInfo)garray[startIndex - 1]).gapsize; --startIndex) {
        }
        int max = uniqValueCount - startIndex - 2;
        DataInfo[] choppedArray = new DataInfo[max];
        System.arraycopy(garray, startIndex, choppedArray, 0, max);
        dc.setSortByIndex(true);
        Arrays.sort(choppedArray, dc);
        dc.setSortByIndex(false);
        candidates.add(choppedArray[max - 1].dataValue);
        for (int i = max - 2; i > 1; --i) {
            if (choppedArray[i].index - choppedArray[i - 2].index == 2) {
                Arrays.sort(choppedArray, i - 2, i + 1, dc);
                candidates.add(choppedArray[i].dataValue);
                i -= 2;
                continue;
            }
            if (choppedArray[i].index == choppedArray[i - 1].index + 1) {
                Arrays.sort(choppedArray, i - 1, i + 1, dc);
                candidates.add(choppedArray[i].dataValue);
                --i;
                continue;
            }
            candidates.add(choppedArray[i].dataValue);
        }
        candidates.add(choppedArray[1].dataValue);
        candidates.add(choppedArray[0].dataValue);
        Object[] carray = candidates.toArray();
        Arrays.sort(carray);
        ArrayList<Object> clist = new ArrayList<Object>(Arrays.asList(carray));
        Double[] breaks = new Double[numLevels + 1];
        Double[] result = new Double[numLevels + 1];
        breaks[0] = (Double)sortedUniqueValues[0];
        result[0] = breaks[0];
        breaks[1] = (Double)sortedUniqueValues[uniqValueCount - 1];
        result[1] = breaks[0];
        svc.clear();
        value2Index.clear();
        JenksNaturalBreaks.findBreaks(values, breaks, clist, numLevels - 1, result);
        return result;
    }

    private static double findBreaks(Double[] values, Double[] breakValues, ArrayList common, int numNeeded, Double[] bestBreaks) {
        int end;
        HashMap<String, Double> value2SDBC = new HashMap<String, Double>();
        double sdbc = Double.MAX_VALUE;
        int length = breakValues.length;
        int start = 0;
        int stepSize = end = common.size() - numNeeded;
        if (numNeeded > 0) {
            int index = length - numNeeded;
            ArrayList removeList = new ArrayList();
            int bestBreakIndex = -1;
            int prevBreakIndex = -1;
            double secondBestSDBC = Double.MAX_VALUE;
            while (bestBreakIndex == -1 || stepSize != 1) {
                int i;
                sdbc = Double.MAX_VALUE;
                stepSize = Math.max(1, stepSize / NUMBER_OF_PARTITIONS);
                removeList.clear();
                for (i = 0; i < start; ++i) {
                    removeList.add(common.get(i));
                }
                for (i = start; i <= end; i += stepSize) {
                    double newSDBC;
                    Double newBreak = (Double)common.get(i);
                    removeList.add(newBreak);
                    common.removeAll(removeList);
                    breakValues[index] = newBreak;
                    Double savedSDBC = (Double)value2SDBC.get(newBreak.toString());
                    if (savedSDBC == null) {
                        newSDBC = JenksNaturalBreaks.findBreaks(values, breakValues, common, numNeeded - 1, bestBreaks);
                        value2SDBC.put(newBreak.toString(), new Double(newSDBC));
                    } else {
                        newSDBC = savedSDBC;
                    }
                    common.addAll(0, removeList);
                    if (newSDBC < sdbc) {
                        prevBreakIndex = bestBreakIndex;
                        secondBestSDBC = sdbc;
                        bestBreakIndex = i;
                        sdbc = newSDBC;
                    } else {
                        if (!(newSDBC < secondBestSDBC)) break;
                        secondBestSDBC = newSDBC;
                        prevBreakIndex = i;
                    }
                    if (i + stepSize > end) continue;
                    for (int j = 1; j < stepSize; ++j) {
                        removeList.add(common.get(i + j));
                    }
                }
                if (prevBreakIndex < bestBreakIndex) {
                    start = prevBreakIndex;
                    end = bestBreakIndex;
                    continue;
                }
                start = Math.max(0, bestBreakIndex - stepSize / 2);
                end = prevBreakIndex;
            }
        } else {
            Object[] tickValues = new Double[length];
            for (int i = 0; i < length; ++i) {
                tickValues[i] = breakValues[i];
            }
            Arrays.sort(tickValues);
            sdbc = JenksNaturalBreaks.sumOfSquaredDeviationBetweenClasses(values, (Double[])tickValues);
            double savedSDBC = (Double)bestSDBC.get(values);
            if (sdbc < savedSDBC) {
                for (int k = 0; k < length; ++k) {
                    bestBreaks[k] = tickValues[k];
                }
                bestSDBC.put(values, new Double(sdbc));
            }
        }
        return sdbc;
    }

    public static double sumOfSquaredDeviationBetweenClasses(Double[] values, Double[] tickValues) {
        if (values.length < 2) {
            return 0.0;
        }
        if (tickValues == null || tickValues.length < 3) {
            return JenksNaturalBreaks.squaredDeviation(values);
        }
        int prevIndex = 0;
        double sdbc = 0.0;
        int max = values.length - 1;
        for (int i = 1; i < tickValues.length; ++i) {
            double cv;
            int nextIndex;
            Integer savedIndex = (Integer)value2Index.get(tickValues[i]);
            if (savedIndex != null) {
                nextIndex = savedIndex;
            } else {
                for (nextIndex = prevIndex; nextIndex < max && values[nextIndex + 1] <= tickValues[i]; ++nextIndex) {
                }
                value2Index.put(tickValues[i], new Integer(nextIndex));
            }
            Double savedSV = (Double)svc.get(prevIndex + "," + nextIndex);
            if (savedSV != null) {
                cv = savedSV;
            } else {
                double[] classValues = new double[nextIndex - prevIndex + 1];
                int j = prevIndex;
                int k = 0;
                while (j <= nextIndex) {
                    classValues[k] = values[j];
                    ++j;
                    ++k;
                }
                cv = JenksNaturalBreaks.squaredDeviation(classValues);
                svc.put(prevIndex + "," + nextIndex, new Double(cv));
            }
            sdbc += cv;
            prevIndex = nextIndex + 1;
        }
        return sdbc;
    }

    public static double squaredDeviation(double[] values) {
        int length = values.length;
        if (length < 2) {
            return 0.0;
        }
        double sum = values[0];
        for (int i = 1; i < length; ++i) {
            sum += values[i];
        }
        double mean = sum / (double)length;
        double sumSquaredDistance = 0.0;
        for (int i = 0; i < length; ++i) {
            double dist = values[i] - mean;
            sumSquaredDistance += dist * dist;
        }
        return sumSquaredDistance;
    }

    public static double squaredDeviation(Double[] values) {
        int length = values.length;
        if (length < 2) {
            return 0.0;
        }
        double sum = values[0];
        for (int i = 1; i < length; ++i) {
            sum += values[i].doubleValue();
        }
        double mean = sum / (double)length;
        double sumSquaredDistance = 0.0;
        for (int i = 0; i < length; ++i) {
            double dist = values[i] - mean;
            sumSquaredDistance += dist * dist;
        }
        return sumSquaredDistance / (double)(length - 1);
    }

    public static void setAccuracyLevel(int newValue) {
        if (newValue >= 0 && newValue < 4) {
            accuracyLevel = newValue;
        }
    }
}

