/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.categorization;

import com.sas.graphics.util.categorization.Bucket;
import com.sas.graphics.util.categorization.JenksNaturalBreaks;
import com.sas.graphics.util.categorization.RB;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;

public class Categorizor {
    private static final String RB_KEY = "Categorizor.";

    public static int getNumberOfBreaks(int sampleSize) {
        return (int)Math.floor(1.0 + 3.3 * (Math.log(sampleSize) / Math.log(10.0)));
    }

    public static int getNumberOfBreaks(double[] values) {
        return Categorizor.getNumberOfBreaks(values.length);
    }

    public static int getNumberOfBreaks(Double[] values) {
        return Categorizor.getNumberOfBreaks(values.length);
    }

    public static Double[] getNaturalBreaksRanges(Double[] values, int numLevels) {
        return JenksNaturalBreaks.getRanges(values, numLevels);
    }

    public static double[] getNaturalBreaksRanges(double[] values, int numLevels) {
        if (numLevels == 0) {
            numLevels = Categorizor.getNumberOfBreaks(values);
        }
        Double[] in = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            in[i] = new Double(values[i]);
        }
        Double[] dValues = JenksNaturalBreaks.getRanges(in, numLevels);
        double[] out = new double[dValues.length];
        for (int i = 0; i < dValues.length; ++i) {
            out[i] = dValues[i];
        }
        return out;
    }

    public static Double[] getEqualIntervalRanges(Double[] values, int numLevels) {
        double[] inValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            inValues[i] = values[i];
        }
        double[] outValues = Categorizor.getEqualIntervalRanges(inValues, numLevels);
        Double[] out = new Double[outValues.length];
        for (int i = 0; i < outValues.length; ++i) {
            out[i] = new Double(outValues[i]);
        }
        return out;
    }

    public static double[] getEqualIntervalRanges(double[] values, int numLevels) {
        double minValue = Double.MAX_VALUE;
        double maxValue = -1.7976931348623157E308;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            if (values[i] < minValue) {
                minValue = values[i];
            }
            if (!(values[i] > maxValue)) continue;
            maxValue = values[i];
        }
        if (minValue == Double.MAX_VALUE || maxValue == -1.7976931348623157E308) {
            return new double[0];
        }
        if (minValue == maxValue) {
            double[] temp = new double[]{minValue, minValue};
            return temp;
        }
        if (numLevels == 0) {
            numLevels = Categorizor.getNumberOfBreaks(values);
        }
        double[] bucketInfo = Bucket.calcMidpoints(numLevels, minValue, maxValue);
        double start = bucketInfo[0];
        double size = bucketInfo[1];
        double[] ranges = new double[numLevels + 1];
        for (int i = 0; i < numLevels - 1; ++i) {
            ranges[i + 1] = start + (double)i * size + size / 2.0;
        }
        ranges[0] = minValue;
        ranges[numLevels] = maxValue;
        return ranges;
    }

    public static double[] getStandardDeviationRanges(double[] values, Vector labels, int stddev, Locale locale) {
        int numBelowRanges;
        int totalRanges;
        int numValues = 0;
        double mean = 0.0;
        double minValue = Double.MAX_VALUE;
        double maxValue = -1.7976931348623157E308;
        if (stddev == 0) {
            stddev = 1;
        }
        if (values.length == 1) {
            double[] ranges = new double[]{values[0], values[0]};
            labels.add("0 " + RB.getStringResource(RB_KEY, "STD.txt", locale));
            return ranges;
        }
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            mean += values[i];
            ++numValues;
            if (values[i] < minValue) {
                minValue = values[i];
            }
            if (!(values[i] > maxValue)) continue;
            maxValue = values[i];
        }
        mean /= (double)numValues;
        double sum = 0.0;
        for (int i = 0; i < values.length; ++i) {
            if (Double.isNaN(values[i])) continue;
            sum += (values[i] - mean) * (values[i] - mean);
        }
        double standardDeviation = Math.sqrt(sum /= (double)numValues);
        int numAboveRanges = (int)Math.ceil((maxValue - mean) / (standardDeviation /= (double)stddev));
        if ((totalRanges = numAboveRanges + (numBelowRanges = (int)Math.ceil((mean - minValue) / standardDeviation))) == 0) {
            double[] ranges = new double[]{values[0], values[0]};
            labels.add("0 " + RB.getStringResource(RB_KEY, "STD.txt", locale));
            return ranges;
        }
        double[] ranges = new double[totalRanges + 1];
        int index = 0;
        for (int i = 0 - numBelowRanges; i <= numAboveRanges; ++i) {
            if (i != 0) {
                String s = "";
                if (i > 0) {
                    s = s + "+";
                }
                labels.add(s + Integer.toString(i) + " " + RB.getStringResource(RB_KEY, "STD.txt", locale));
            }
            ranges[index++] = mean + (double)i * standardDeviation;
        }
        return ranges;
    }

    public static Double[] getQuantileRanges(Double[] values, int numLevels) {
        double[] inValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            inValues[i] = values[i];
        }
        double[] outValues = Categorizor.getQuantileRanges(inValues, numLevels);
        Double[] out = new Double[outValues.length];
        for (int i = 0; i < outValues.length; ++i) {
            out[i] = new Double(outValues[i]);
        }
        return out;
    }

    public static double[] getQuantileRanges(double[] inValues, int numLevels) {
        if (numLevels == 0) {
            numLevels = Categorizor.getNumberOfBreaks(inValues);
        }
        if (inValues.length == 0) {
            return new double[0];
        }
        double[] values = new double[numLevels + 1];
        double[] sortedUniqueValues = Categorizor.getSortedUniqueValues(inValues);
        double[] sortedValues = Categorizor.getSortedValues(inValues);
        int iNumUniqueValues = sortedUniqueValues.length;
        if (iNumUniqueValues == 0) {
            return new double[0];
        }
        if (numLevels >= iNumUniqueValues) {
            double[] foo = new double[iNumUniqueValues + 1];
            for (int i = 0; i < iNumUniqueValues; ++i) {
                foo[i + 1] = sortedUniqueValues[i];
            }
            foo[0] = foo[1];
            return foo;
        }
        Quantile[] asQuantiles = new Quantile[numLevels];
        for (int g = 0; g < numLevels; ++g) {
            asQuantiles[g] = new Quantile();
        }
        int iNumNonMissingValues = sortedValues.length;
        double dPercentileStep = (double)iNumNonMissingValues / (double)numLevels;
        for (int iLevel = 0; iLevel < numLevels; ++iLevel) {
            asQuantiles[iLevel].iStart = (int)Math.floor(dPercentileStep * (double)iLevel);
            asQuantiles[iLevel].dVal = sortedValues[asQuantiles[iLevel].iStart];
        }
        Categorizor.Balance(asQuantiles, sortedValues, 0);
        for (int i = 0; i < asQuantiles.length; ++i) {
            values[i] = sortedValues[asQuantiles[i].iStart];
        }
        values[0] = sortedValues[0];
        values[values.length - 1] = sortedValues[iNumNonMissingValues - 1];
        return values;
    }

    protected static int Balance(Quantile[] asQuantiles, double[] adValues, int iCurrentPos) {
        int j;
        int nVals = adValues.length;
        int nQtiles = asQuantiles.length;
        if (iCurrentPos == 0) {
            int j2;
            Quantile q;
            int i;
            block0: for (i = 1; i < nQtiles; ++i) {
                q = asQuantiles[i];
                Quantile qPrev = asQuantiles[i - 1];
                if (q.dVal != qPrev.dVal) {
                    while (q.iStart != 0 && q.dVal == adValues[q.iStart - 1]) {
                        --q.iStart;
                    }
                }
                int iStart = q.iStart;
                while (q.dVal <= qPrev.dVal) {
                    if (q.iStart >= nVals - 1) {
                        q.iStart = iStart;
                        q.dVal = adValues[iStart];
                        i = nQtiles;
                        continue block0;
                    }
                    if (q.iStart < qPrev.iStart) {
                        q.iStart = qPrev.iStart;
                    }
                    if (++q.iStart == adValues.length) {
                        q.dVal = Double.MAX_VALUE;
                        continue;
                    }
                    q.dVal = adValues[q.iStart];
                }
            }
            if (asQuantiles[nQtiles - 1].dVal == adValues[nVals - 1]) {
                while (adValues[nVals - 1] == adValues[asQuantiles[nQtiles - 1].iStart - 1]) {
                    asQuantiles[nQtiles - 1].dVal = adValues[--asQuantiles[nQtiles - 1].iStart];
                }
            }
            i = nQtiles;
            while (--i >= 0) {
                q = asQuantiles[i];
                if (i == nQtiles - 1) {
                    q.nVals = nVals - q.iStart;
                } else {
                    Quantile qNext = asQuantiles[i + 1];
                    while (q.dVal >= qNext.dVal && q.iStart != 0) {
                        if (qNext.iStart < q.iStart) {
                            q.iStart = qNext.iStart;
                        }
                        if (--q.iStart < 0) {
                            q.iStart = 0;
                            q.dVal = -1.7976931348623157E308;
                            continue;
                        }
                        q.dVal = adValues[q.iStart];
                    }
                    double curVal = q.dVal;
                    while (q.dVal == curVal && q.iStart >= 0) {
                        --q.iStart;
                        if (q.iStart < 0) continue;
                        q.dVal = adValues[q.iStart];
                    }
                    q.dVal = adValues[++q.iStart];
                    q.nVals = qNext.iStart - q.iStart;
                }
                if (q.iStart + q.nVals < 1) continue;
                q.bLock = q.dVal == adValues[q.iStart + q.nVals - 1] && q.nVals > (int)((double)nVals / (double)nQtiles);
            }
            i = nQtiles;
            while (--i > 0) {
                boolean bFound = false;
                while (!bFound) {
                    j2 = i;
                    while (--j2 >= 0) {
                        if (asQuantiles[j2].bLock) {
                            j2 = -1;
                            break;
                        }
                        if (asQuantiles[i].nVals - 1 <= asQuantiles[j2].nVals && asQuantiles[j2].nVals != 0) continue;
                        if (Categorizor.Balance(asQuantiles, adValues, i) != 0) {
                            i = nQtiles;
                        }
                        j2 = -1;
                        break;
                    }
                    bFound = j2 == -1;
                }
            }
            for (i = 0; i < nQtiles - 1; ++i) {
                boolean bFound = false;
                while (!bFound) {
                    for (j2 = i + 1; j2 < nQtiles; ++j2) {
                        if (asQuantiles[j2].bLock) {
                            j2 = nQtiles;
                            break;
                        }
                        if (asQuantiles[i].nVals - 1 <= asQuantiles[j2].nVals && asQuantiles[j2].nVals != 0) continue;
                        if (Categorizor.Balance(asQuantiles, adValues, -(i + 1)) != 0) {
                            i = -1;
                        }
                        j2 = nQtiles;
                        break;
                    }
                    bFound = j2 == nQtiles;
                }
            }
            return 0;
        }
        if (iCurrentPos < 0) {
            int i;
            iCurrentPos = -(iCurrentPos + 1);
            int j3 = 0;
            Quantile q = asQuantiles[iCurrentPos];
            Quantile qNext = asQuantiles[iCurrentPos + 1];
            if (!qNext.bLock) {
                int iMost = q.nVals - qNext.nVals - 1;
                int iLeast = Math.max(1, iMost / 2);
                if (iMost < 0) {
                    return 0;
                }
                if (iMost == 0) {
                    iMost = 1;
                }
                i = q.iStart + q.nVals - 1;
                for (j3 = iLeast - 1; j3 < iMost && !(adValues[i - j3] > adValues[i - j3 - 1]); ++j3) {
                }
                if (j3 == iMost) {
                    if (qNext.nVals == 0) {
                        qNext.bLock = q.bLock;
                        q.bLock = false;
                        j3 = q.nVals - 1;
                    } else {
                        return 0;
                    }
                }
                q.nVals -= ++j3;
                qNext.iStart -= j3;
                qNext.nVals += j3;
                qNext.dVal = adValues[qNext.iStart];
            }
            for (i = iCurrentPos; i < nQtiles - 1; ++i) {
                if ((asQuantiles[i].nVals - 1 <= asQuantiles[i + 1].nVals || asQuantiles[i].bLock || asQuantiles[i + 1].bLock) && asQuantiles[i + 1].nVals != 0) continue;
                j3 += Categorizor.Balance(asQuantiles, adValues, -(i + 1));
                break;
            }
            return j3;
        }
        Quantile q = asQuantiles[iCurrentPos];
        Quantile qPrev = asQuantiles[iCurrentPos - 1];
        if (q.bLock || qPrev.bLock || q.dVal == adValues[nVals - 1] && qPrev.nVals != 0) {
            return 0;
        }
        int iMost = q.nVals - qPrev.nVals - 1;
        int iLeast = Math.max(1, iMost / 2);
        if (iMost < 0) {
            return 0;
        }
        if (iMost == 0) {
            iMost = 1;
        }
        int i = q.iStart;
        for (j = iLeast - 1; j < iMost && !(adValues[i + j] < adValues[i + j + 1]); ++j) {
        }
        if (j == iMost) {
            if (qPrev.nVals == 0) {
                qPrev.bLock = q.bLock;
                q.bLock = false;
                j = q.nVals - 1;
            } else {
                return 0;
            }
        }
        qPrev.nVals += ++j;
        q.iStart += j;
        q.dVal = adValues[q.iStart];
        q.nVals -= j;
        int ii = --iCurrentPos;
        while (--ii >= 0) {
            if (asQuantiles[iCurrentPos].nVals - 1 <= asQuantiles[ii].nVals) continue;
            if ((asQuantiles[iCurrentPos].bLock || asQuantiles[ii].bLock) && asQuantiles[ii].nVals != 0) break;
            j += Categorizor.Balance(asQuantiles, adValues, iCurrentPos);
            break;
        }
        return j;
    }

    private static double[] getSortedUniqueValues(double[] data) {
        HashMap<Double, Double> hash = new HashMap<Double, Double>();
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            hash.put(new Double(data[i]), new Double(i));
        }
        double[] numericValues = new double[hash.size()];
        Double[] values = hash.keySet().toArray(new Double[0]);
        for (int i = 0; i < numericValues.length; ++i) {
            numericValues[i] = values[i];
        }
        Arrays.sort(numericValues);
        return numericValues;
    }

    private static double[] getSortedValues(double[] data) {
        int missingCount = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!Double.isNaN(data[i])) continue;
            ++missingCount;
        }
        double[] numericValues = new double[data.length - missingCount];
        int index = 0;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            numericValues[index++] = data[i];
        }
        Arrays.sort(numericValues);
        return numericValues;
    }

    private static class Quantile {
        double dVal;
        int iStart;
        int nVals;
        boolean bLock;

        private Quantile() {
        }
    }
}

