/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.ZxAxis;
import com.sas.text.SASFormat;
import java.util.ArrayList;

public class ZxAxisExt
extends ZxAxis {
    public static final byte BEGINNING = 0;
    public static final byte END = 1;
    public static final byte MIDDLE = 2;
    public static final byte SAME = 3;

    public static double[] getWeekends(double start, double end, SASFormat format) {
        int size;
        double d;
        int mod7;
        if (format == null) {
            return null;
        }
        if (!(format.isDateFormat() || format.isTimeFormat() || format.isDateTimeFormat())) {
            return null;
        }
        boolean day = format.isDateFormat();
        double startDay = day ? start : Math.floor(start / 86400.0);
        int shift = 0;
        boolean firstSun = false;
        boolean firstSat = false;
        if (startDay >= 0.0) {
            mod7 = (int)(startDay % 7.0);
            switch (mod7) {
                case 0: {
                    shift = 5;
                    break;
                }
                case 1: {
                    shift = 0;
                    firstSat = true;
                    break;
                }
                case 2: {
                    shift = 0;
                    firstSun = true;
                    break;
                }
                case 3: {
                    shift = 1;
                    break;
                }
                case 4: {
                    shift = 2;
                    break;
                }
                case 5: {
                    shift = 3;
                    break;
                }
                case 6: {
                    shift = 4;
                }
            }
        } else {
            mod7 = (int)(-startDay % 7.0);
            switch (mod7) {
                case 0: {
                    shift = 5;
                    break;
                }
                case 1: {
                    shift = 4;
                    break;
                }
                case 2: {
                    shift = 3;
                    break;
                }
                case 3: {
                    shift = 2;
                    break;
                }
                case 4: {
                    shift = 1;
                    break;
                }
                case 5: {
                    shift = 0;
                    firstSun = true;
                    break;
                }
                case 6: {
                    shift = 0;
                    firstSat = true;
                }
            }
        }
        double incr = day ? 1.0 : 86400.0;
        ArrayList<Double> list = new ArrayList<Double>();
        if (!firstSat && !firstSun) {
            start += (double)(6 - shift) * incr;
            firstSat = true;
        }
        if (firstSat) {
            for (d = start; d <= end; d += 6.0 * incr) {
                list.add(new Double(d));
                if (!((d += incr) > end)) {
                    list.add(new Double(d));
                    continue;
                }
                break;
            }
        } else if (firstSun) {
            list.add(null);
            for (d = start; d <= end; d += incr) {
                list.add(new Double(d));
                if (!((d += 6.0 * incr) > end)) {
                    list.add(new Double(d));
                    continue;
                }
                break;
            }
        }
        if ((size = list.size()) == 0) {
            return null;
        }
        double[] weekends = new double[size];
        Object first = list.get(0);
        weekends[0] = first == null ? Double.NaN : (Double)list.get(0);
        for (int i = 1; i < size; ++i) {
            weekends[i] = (Double)list.get(i);
        }
        return weekends;
    }

    public static double zintnx3(ZxAxis.Interval istr, double inptDate, double n, byte align, ZxAxis.Interval sub_intrvl) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        double result = ZxAxisExt.zintnx2(istr, inptDate, n);
        if (Double.isNaN(result)) {
            return result;
        }
        switch (align) {
            case 0: {
                break;
            }
            case 2: {
                result = Math.floor((result + ZxAxisExt.zintnx2(istr, result, 1.0) - 1.0) / 2.0);
                break;
            }
            case 1: {
                result = ZxAxisExt.zintnx2(istr, inptDate, n += 1.0);
                if (Double.isNaN(result)) {
                    return result;
                }
                result -= 1.0;
                break;
            }
            case 3: {
                if (istr.intcode == 28 || istr.intcode == 29 || istr.intcode == 38 || istr.intcode == 43 || istr.intcode == 49 || istr.intcode == 54 || istr.intcode == 58) break;
                double inptIntrvlBegin = ZxAxisExt.zintnx2(istr, inptDate, 0.0);
                if (sub_intrvl == null || sub_intrvl.intcode == 0) {
                    ZxAxis.Interval shft_intrvl;
                    sub_intrvl = shft_intrvl = ZxAxisExt.zintshft(istr);
                }
                double dp = ZxAxisExt.zintck2(sub_intrvl, inptIntrvlBegin, inptDate);
                double du = inptDate - ZxAxisExt.zintnx2(sub_intrvl, inptIntrvlBegin, dp);
                double next_interval = ZxAxisExt.zintnx2(istr, inptDate, n + 1.0);
                double next_subintrvl = ZxAxisExt.zintnx2(sub_intrvl, result, dp + 1.0);
                double next = Math.min(next_interval, next_subintrvl);
                result = ZxAxisExt.zintnx2(sub_intrvl, result, dp);
                if (!((result += du) >= next)) break;
                if (sub_intrvl.intcode >= 25) {
                    ZxAxis.Interval tmp_intrvl = new ZxAxis.Interval();
                    if (sub_intrvl.intcode == 27) {
                        ZxAxisExt.zintstr(istr.units == 's' ? "DTWEEKDAY" : "WEEKDAY", tmp_intrvl);
                    } else {
                        ZxAxisExt.zintstr(istr.units == 's' ? "DTDAY" : "DAY", tmp_intrvl);
                    }
                    result = ZxAxisExt.zintnx2(tmp_intrvl, next, -1.0);
                    if (istr.units != 's') break;
                    result += ZxAxisExt.ztimprt(inptDate);
                    break;
                }
                result = next - 1.0;
                break;
            }
        }
        return result;
    }

    public static ZxAxis.Interval zintshft(ZxAxis.Interval istr) {
        ZxAxis.Interval sistr = new ZxAxis.Interval();
        switch (istr.intcode) {
            case 45: 
            case 50: 
            case 55: 
            case 60: {
                ZxAxisExt.zintstr(istr.units == 's' ? "DTMONTH" : "MONTH", sistr);
                break;
            }
            case 40: {
                ZxAxisExt.zintstr(istr.units == 's' ? "DTSEMIMONTH" : "SEMIMONTH", sistr);
                break;
            }
            case 35: {
                ZxAxisExt.zintstr(istr.units == 's' ? "DTTENDAY" : "TENDAY", sistr);
                break;
            }
            case 25: 
            case 30: {
                ZxAxisExt.zintstr(istr.units == 's' ? "DTDAY" : "DAY", sistr);
                break;
            }
            case 27: {
                String intname = istr.units == 's' ? new String("DTWEEKDAY") : new String("WEEKDAY");
                if (istr.nweekday != '\u0005' || !istr.weekend[0] || !istr.weekend[6]) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 1; i <= 7; ++i) {
                        if (istr.weekend[i - 1]) {
                            sb.append(String.valueOf(i));
                            continue;
                        }
                        sb.append(" ");
                    }
                    sb.append("W");
                    intname = new String(sb);
                }
                ZxAxisExt.zintstr(intname, sistr);
                break;
            }
            case 20: {
                ZxAxisExt.zintstr(istr.units == 's' ? "DTHOUR" : "HOUR", sistr);
                break;
            }
            case 15: {
                ZxAxisExt.zintstr(istr.units == 's' ? "DTMINUTE" : "MINUTE", sistr);
                break;
            }
            case 10: {
                ZxAxisExt.zintstr(istr.units == 's' ? "DTSECOND" : "SECOND", sistr);
                break;
            }
            case 1: {
                ZxAxisExt.zintstr("OBS", sistr);
                break;
            }
            case 0: {
                ZxAxisExt.zintstr("NONE", sistr);
                break;
            }
            default: {
                return null;
            }
        }
        return sistr;
    }
}

