/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.visuals.image.encoder.GifEncoder;
import com.sas.visuals.image.encoder.ImageAdaptor;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WriteImage {
    protected final int BITMAPFILEHEADERSIZE = 14;
    protected final int BITMAPINFOHEADERSIZE = 40;
    protected final int PelsPerMeter = 2952;
    protected final int BufferSize = 4096;
    public boolean oldsave = false;
    public static final int IMAGE_TYPE_GIF = 0;
    public static final int IMAGE_TYPE_BMP = 1;

    public boolean SaveImage(String filename, Image img, int type) {
        FileOutputStream fs = null;
        boolean rc = true;
        try {
            fs = new FileOutputStream(filename);
        }
        catch (IOException e) {
            return false;
        }
        if (type == 0) {
            rc = this.SaveGIF(fs, img);
        } else if (type == 1) {
            rc = this.SaveBMP(fs, img);
        }
        try {
            fs.close();
        }
        catch (IOException e) {
            return false;
        }
        return rc;
    }

    protected boolean SaveGIF(FileOutputStream fs, Image img) {
        ImageAdaptor adaptor = new ImageAdaptor(img);
        try {
            adaptor.setup();
        }
        catch (Exception e) {
            return false;
        }
        GifEncoder ge = new GifEncoder(adaptor, (OutputStream)fs);
        try {
            ge.encode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    protected boolean SaveBMP(FileOutputStream fs, Image img) {
        int size = 0;
        int width = 0;
        int height = 0;
        PixelGrabber pg = new PixelGrabber(img, 0, 0, -1, -1, !this.oldsave);
        byte[] buffer = new byte[4096];
        if (buffer == null) {
            return false;
        }
        try {
            if (!pg.grabPixels()) {
                return false;
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        try {
            width = img.getWidth(null);
            int scanlineWidth = width + 3 & 0xFFFFFFFC;
            height = img.getHeight(null);
            size = 54 + scanlineWidth * height;
            buffer[0] = 66;
            buffer[1] = 77;
            buffer[2] = (byte)size;
            buffer[3] = (byte)(size >> 8);
            buffer[4] = (byte)(size >> 16);
            buffer[5] = (byte)(size >> 24);
            buffer[6] = 0;
            buffer[7] = 0;
            buffer[8] = 0;
            buffer[9] = 0;
            buffer[10] = 54;
            buffer[11] = 0;
            buffer[12] = 0;
            buffer[13] = 0;
            fs.write(buffer, 0, 14);
            buffer[0] = 40;
            buffer[1] = 0;
            buffer[2] = 0;
            buffer[3] = 0;
            buffer[4] = (byte)width;
            buffer[5] = (byte)(width >> 8);
            buffer[6] = (byte)(width >> 16);
            buffer[7] = (byte)(width >> 24);
            buffer[8] = (byte)height;
            buffer[9] = (byte)(height >> 8);
            buffer[10] = (byte)(height >> 16);
            buffer[11] = (byte)(height >> 24);
            buffer[12] = 1;
            buffer[13] = 0;
            buffer[14] = 24;
            buffer[15] = 0;
            buffer[16] = 0;
            buffer[17] = 0;
            buffer[18] = 0;
            buffer[19] = 0;
            size = width * height * 3;
            buffer[20] = (byte)size;
            buffer[21] = (byte)(size >> 8);
            buffer[22] = (byte)(size >> 16);
            buffer[23] = (byte)(size >> 24);
            buffer[24] = -120;
            buffer[25] = 11;
            buffer[26] = 0;
            buffer[27] = 0;
            buffer[28] = -120;
            buffer[29] = 11;
            buffer[30] = 0;
            buffer[31] = 0;
            buffer[32] = 0;
            buffer[33] = 0;
            buffer[34] = 0;
            buffer[35] = 0;
            buffer[36] = 0;
            buffer[37] = 0;
            buffer[38] = 0;
            buffer[39] = 0;
            fs.write(buffer, 0, 40);
            Object obj = pg.getPixels();
            if (!(obj instanceof int[])) {
                return false;
            }
            int[] pixels = (int[])obj;
            if (pixels.length != width * height) {
                return false;
            }
            ColorModel cm = pg.getColorModel();
            int np = cm.getPixelSize();
            for (int iy = height - 1; iy >= 0; --iy) {
                for (int ix = 0; ix < width; ++ix) {
                    byte r;
                    byte g;
                    byte b;
                    if (np == 16 && this.oldsave) {
                        b = (byte)((pixels[iy * width + ix] & 0x1F) << 3);
                        g = (byte)((pixels[iy * width + ix] >> 5 & 0x3F) << 2);
                        r = (byte)((pixels[iy * width + ix] >> 11 & 0x1F) << 3);
                    } else if (this.oldsave) {
                        b = (byte)(pixels[iy * width + ix] >> 24);
                        g = (byte)(pixels[iy * width + ix] >> 16);
                        r = (byte)(pixels[iy * width + ix] >> 8);
                    } else {
                        b = (byte)cm.getBlue(pixels[iy * width + ix]);
                        g = (byte)cm.getGreen(pixels[iy * width + ix]);
                        r = (byte)cm.getRed(pixels[iy * width + ix]);
                    }
                    fs.write(b);
                    fs.write(g);
                    fs.write(r);
                }
                for (int j = 0; j < scanlineWidth - width; ++j) {
                    fs.write(0);
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

