/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.styles.Size;
import com.sas.graphics.util.UserDefinedMarkerInterface;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;

public class UserDefinedCharacterMarker
implements UserDefinedMarkerInterface {
    private String text;
    private Font font;
    private double dpi = 1.0;
    private double xScale = 1.0;
    private double yScale = 1.0;
    private double rotation = 0.0;
    private double xOffset = 0.0;
    private double yOffset = 0.0;

    public UserDefinedCharacterMarker(String text, Font font, double dpi) {
        this.text = text;
        this.font = font;
        this.dpi = dpi;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public double getMarkerOffsetX() {
        return this.xOffset;
    }

    @Override
    public void setMarkerOffsetX(double offset) {
        this.xOffset = offset;
    }

    @Override
    public double getMarkerOffsetY() {
        return this.yOffset;
    }

    @Override
    public void setMarkerOffsetY(double offset) {
        this.yOffset = offset;
    }

    @Override
    public double getMarkerScaleX() {
        return this.xScale;
    }

    @Override
    public void setMarkerScaleX(double scale) {
        this.xScale = scale;
    }

    @Override
    public double getMarkerScaleY() {
        return this.yScale;
    }

    @Override
    public void setMarkerScaleY(double scale) {
        this.yScale = scale;
    }

    @Override
    public double getMarkerRotation() {
        return this.rotation;
    }

    @Override
    public void setMarkerRotation(double angle) {
        this.rotation = angle;
    }

    @Override
    public void paint(Graphics2D g2d, Color color, Color edgeColor, int x, int y, int w, int h) {
        Graphics2D gc = (Graphics2D)g2d.create();
        gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.rotation != 0.0) {
            gc.rotate(-this.rotation, x, y);
        }
        Size size = new Size((double)h * this.yScale, 1);
        int pt = size.toPoints((int)(100.0 * this.dpi), 0);
        gc.setFont(new Font(this.font.getFamily(), this.font.getStyle(), pt));
        FontMetrics fm = gc.getFontMetrics();
        int x1 = x - fm.stringWidth(this.text) / 2;
        int y1 = y + fm.getAscent() - (fm.getAscent() + fm.getDescent()) / 2;
        gc.setColor(color);
        int origX = x - (int)(this.xOffset * (double)w + 0.5);
        int origY = y + (int)(this.yOffset * (double)h + 0.5);
        gc.clip(new Rectangle(origX - w / 2, origY - h / 2, w, h));
        gc.drawString(this.text, x1, y1);
        gc.dispose();
    }

    @Override
    public void paint(Graphics2D g2d, Color color, Color edgeColor, double x, double y, int w, int h) {
        Graphics2D gc = (Graphics2D)g2d.create();
        gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.rotation != 0.0) {
            gc.rotate(-this.rotation, x, y);
        }
        Size size = new Size((double)h * this.yScale, 1);
        int pt = size.toPoints((int)(100.0 * this.dpi), 0);
        gc.setFont(new Font(this.font.getFamily(), this.font.getStyle(), pt));
        FontMetrics fm = gc.getFontMetrics();
        float x1 = (float)(x - (double)((float)fm.stringWidth(this.text) / 2.0f));
        float y1 = (float)(y + (double)fm.getAscent() - (double)((float)(fm.getAscent() + fm.getDescent()) / 2.0f));
        gc.setColor(color);
        double origX = x - (this.xOffset * (double)w + 0.5);
        double origY = y + (this.yOffset * (double)h + 0.5);
        gc.clip(new Rectangle2D.Double(origX - (double)w / 2.0, origY - (double)h / 2.0, w, h));
        gc.drawString(this.text, x1, y1);
        gc.dispose();
    }
}

