/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.ColorRampDialog;
import com.sas.graphics.util.ColorVertex;
import com.sas.graphics.util.InteractivePalettePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class RepresentationPanel
extends InteractivePalettePanel {
    public RepresentationPanel() {
        PanelMouseAdapter panelMouseAdapter = new PanelMouseAdapter();
        PanelMouseMotionAdapter panelMouseMotionAdapter = new PanelMouseMotionAdapter();
        this.addMouseListener(panelMouseAdapter);
        this.addMouseMotionListener(panelMouseMotionAdapter);
    }

    public RepresentationPanel(ColorRampDialog foo) {
        this();
        this.colorRampDialog = foo;
    }

    @Override
    public void paint(Graphics g) {
        if (this.palette == null) {
            return;
        }
        if (this.continuous) {
            this.drawContinuousRamp(g);
        } else {
            this.drawDiscreteRamp(g);
        }
    }

    protected void drawContinuousRamp(Graphics g) {
        for (int i = this.palette.size() - 1; i > 0; --i) {
            ColorVertex tempEntry = this.palette.getEntry(i);
            ColorVertex tempEntry2 = this.palette.getEntry(i - 1);
            int foo = (int)((1.0 - tempEntry.value) * (double)this.getSize().height);
            int foo2 = (int)((1.0 - tempEntry2.value) * (double)this.getSize().height);
            this.drawShadedRect(g, 0, foo, this.getSize().width, foo2 - foo, tempEntry.color, tempEntry2.color);
        }
    }

    protected void drawShadedRect(Graphics g, int x, int y, int width, int height, Color color1, Color color2) {
        int red1 = color1.getRed();
        int red2 = color2.getRed();
        int green1 = color1.getGreen();
        int green2 = color2.getGreen();
        int blue1 = color1.getBlue();
        int blue2 = color2.getBlue();
        double redInc = (double)(red1 - red2) / (double)height;
        double greenInc = (double)(green1 - green2) / (double)height;
        double blueInc = (double)(blue1 - blue2) / (double)height;
        for (int i = y; i <= y + height; ++i) {
            g.setColor(new Color((int)((double)red1 - redInc * (double)(i - y)), (int)((double)green1 - greenInc * (double)(i - y)), (int)((double)blue1 - blueInc * (double)(i - y))));
            g.drawLine(0, i, width, i);
        }
    }

    protected void drawDiscreteRamp(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        for (int i = 0; i < this.palette.size() - 1; ++i) {
            ColorVertex tempEntry1 = this.palette.getEntry(i + 1);
            ColorVertex tempEntry2 = this.palette.getEntry(i);
            int val1 = (int)((1.0 - tempEntry1.value) * (double)h);
            int val2 = (int)((1.0 - tempEntry2.value) * (double)h);
            g.setColor(tempEntry2.color);
            g.fillRect(0, val1, w, val2 - val1);
        }
    }

    class PanelMouseMotionAdapter
    extends MouseMotionAdapter {
        PanelMouseMotionAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int mod = e.getModifiers();
            RepresentationPanel.this.colorRampDialog.movePoint(RepresentationPanel.this.selectedPoint, RepresentationPanel.this.getNormalizedValue(new Point(x, y)), RepresentationPanel.this.mask);
            RepresentationPanel.this.colorRampDialog.repaintPanels();
        }
    }

    class PanelMouseAdapter
    extends MouseAdapter {
        PanelMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int mod = e.getModifiers();
            if ((mod & 4) == 0) {
                RepresentationPanel.this.selectedPoint = RepresentationPanel.this.getClosestPoint(RepresentationPanel.this.getNormalizedValue(new Point(x, y)));
                if (e.getClickCount() == 2) {
                    RepresentationPanel.this.colorRampDialog.editPoint(RepresentationPanel.this.selectedPoint, RepresentationPanel.this.mask);
                } else {
                    RepresentationPanel.this.colorRampDialog.selectPoint(RepresentationPanel.this.selectedPoint, RepresentationPanel.this.mask);
                }
                RepresentationPanel.this.colorRampDialog.repaintPanels();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

