/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.AlternateRangeSliderUI;
import com.sas.graphics.util.BasicRangeSliderUI;
import com.sas.graphics.util.MultipleBoundedRangeModel;
import com.sas.graphics.util.RangeSliderUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.UIManager;

public class RangeSlider
extends JSlider {
    private static final long serialVersionUID = 5163110846381966440L;
    public static final int RANGE_MIN = -1;
    public static final int RANGE_MID = 0;
    public static final int RANGE_MAX = 1;
    protected JPopupMenu _popupMenu = null;
    protected boolean _isCursorFeedback = false;
    protected boolean _isClickCreate = false;
    protected boolean _isALAF = false;
    private AbstractAction _newRange = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ((BasicRangeSliderUI)RangeSlider.this.getUI()).newRange();
        }
    };
    private AbstractAction _newValue = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ((BasicRangeSliderUI)RangeSlider.this.getUI()).newValue();
        }
    };
    private AbstractAction _rangeValue = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ((BasicRangeSliderUI)RangeSlider.this.getUI()).rangeValue();
        }
    };
    private AbstractAction _includeExclude = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ((BasicRangeSliderUI)RangeSlider.this.getUI()).includeExclude();
        }
    };
    private AbstractAction _delete = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ((BasicRangeSliderUI)RangeSlider.this.getUI()).delete();
        }
    };
    private static final String _UI_CLASS_ID = "RangeSliderUI";

    @Override
    public String getUIClassID() {
        return _UI_CLASS_ID;
    }

    @Override
    public void updateUI() {
        super.updateLabelUIs();
        if (UIManager.getLookAndFeel().getID().equals("Windows")) {
            UIManager.put(_UI_CLASS_ID, "com.sas.graphics.util.WindowsRangeSliderUI");
        } else {
            UIManager.put(_UI_CLASS_ID, "com.sas.graphics.util.MetalRangeSliderUI");
        }
        if (this._isALAF) {
            this.setUI(new AlternateRangeSliderUI(this));
        } else {
            this.setUI((RangeSliderUI)UIManager.getUI(this));
        }
    }

    public boolean isALAF() {
        return this._isALAF;
    }

    public void setALAF(boolean isALAF) {
        this._isALAF = isALAF;
        this.updateUI();
    }

    public RangeSlider() {
        this(0);
    }

    public RangeSlider(int orientation) {
        super(orientation, 0, 10000, 0);
        this.setModel(new MultipleBoundedRangeModel(0, 10000));
        this.updateUI();
    }

    public RangeSlider(int min, int max) {
        this(new MultipleBoundedRangeModel(min, max));
    }

    public RangeSlider(int min, int max, int value) {
        this(0, min, max, value);
    }

    public RangeSlider(int orientation, int min, int max, int value) {
        this(orientation, min, max, value, 0);
    }

    public RangeSlider(BoundedRangeModel brm) {
        super(0);
        this.setModel(brm);
        this.updateUI();
    }

    public RangeSlider(int orientation, int min, int max, int value, int extent) {
        super(orientation, min, max, value);
        this.setModel(new MultipleBoundedRangeModel(value, extent, min, max));
        this.updateUI();
    }

    public Dimension getThumbSize() {
        return ((BasicRangeSliderUI)this.getUI()).getThumbSize();
    }

    public void setThumbSize(int size) {
        ((BasicRangeSliderUI)this.getUI()).setThumbSize(size);
    }

    public int getTrackBuffer() {
        return ((BasicRangeSliderUI)this.getUI()).getTrackBuffer();
    }

    public void setColorScheme(Color background) {
        ((BasicRangeSliderUI)this.getUI()).setColorScheme(background);
    }

    public int getValue(int i) {
        return ((MultipleBoundedRangeModel)this.getModel()).getValue(i);
    }

    public void setValue(int i, int newValue) {
        ((MultipleBoundedRangeModel)this.getModel()).setValue(i, newValue);
    }

    public boolean getValueInclusive(int i) {
        return ((MultipleBoundedRangeModel)this.getModel()).getValueInclusive(i);
    }

    public void setValueInclusive(int i, boolean inclusive) {
        ((MultipleBoundedRangeModel)this.getModel()).setValueInclusive(i, inclusive);
    }

    public int getExtent(int i) {
        return ((MultipleBoundedRangeModel)this.getModel()).getExtent(i);
    }

    public void setExtent(int i, int newExtent) {
        ((MultipleBoundedRangeModel)this.getModel()).setExtent(i, newExtent);
    }

    public boolean getExtentInclusive(int i) {
        return ((MultipleBoundedRangeModel)this.getModel()).getExtentInclusive(i);
    }

    public void setExtentInclusive(int i, boolean inclusive) {
        ((MultipleBoundedRangeModel)this.getModel()).setExtentInclusive(i, inclusive);
    }

    public void setRange(int i, int newValue, int newExtent) {
        ((MultipleBoundedRangeModel)this.getModel()).setRange(i, newValue, newExtent);
    }

    public void setRange(int i, int newValue, boolean valueInclusive, int newExtent, boolean extentInclusive) {
        ((MultipleBoundedRangeModel)this.getModel()).setRange(i, newValue, valueInclusive, newExtent, extentInclusive);
    }

    public int getVisibleMinimum() {
        int min = 0;
        if (this.getModel() instanceof MultipleBoundedRangeModel) {
            min = ((MultipleBoundedRangeModel)this.getModel()).getVisibleMinimum();
        }
        return min;
    }

    public void setVisibleMinimum(int min) {
        if (this.getModel() instanceof MultipleBoundedRangeModel) {
            ((MultipleBoundedRangeModel)this.getModel()).setVisibleMinimum(min);
        }
    }

    public int getVisibleMaximum() {
        int max = 10000;
        if (this.getModel() instanceof MultipleBoundedRangeModel) {
            max = ((MultipleBoundedRangeModel)this.getModel()).getVisibleMaximum();
        }
        return max;
    }

    public void setVisibleMaximum(int max) {
        if (this.getModel() instanceof MultipleBoundedRangeModel) {
            ((MultipleBoundedRangeModel)this.getModel()).setVisibleMaximum(max);
        }
    }

    public void add(int newValue, boolean valueInclusive, int newExtent, boolean extentInclusive) {
        MultipleBoundedRangeModel model = (MultipleBoundedRangeModel)this.getModel();
        model.add(newValue, valueInclusive, newExtent, extentInclusive);
    }

    @Override
    public void remove(int i) {
        ((MultipleBoundedRangeModel)this.getModel()).remove(i);
    }

    public int ranges() {
        int n = 0;
        if (this.getModel() instanceof MultipleBoundedRangeModel) {
            n = ((MultipleBoundedRangeModel)this.getModel()).ranges();
        }
        return n;
    }

    public boolean isOverlap() {
        return ((MultipleBoundedRangeModel)this.getModel()).isOverlap();
    }

    public void setOverlap(boolean overlap) {
        ((MultipleBoundedRangeModel)this.getModel()).setOverlap(overlap);
    }

    public boolean isBounded() {
        return ((MultipleBoundedRangeModel)this.getModel()).isBounded();
    }

    public void setBounded(boolean bounded) {
        ((MultipleBoundedRangeModel)this.getModel()).setBounded(bounded);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.ui != null) {
            this.ui.installUI(this);
        }
    }

    @Override
    protected String paramString() {
        String modelString = "";
        if (this.getModel() instanceof MultipleBoundedRangeModel) {
            for (int i = 0; i < this.ranges(); ++i) {
                modelString = modelString + "\n  " + i + "  " + this.getValue(i) + "  " + this.getExtent(i) + "  " + this.getValueInclusive(i) + "  " + this.getExtentInclusive(i);
            }
        }
        return super.paramString() + ", model=" + modelString;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleRangeSlider();
        }
        return this.accessibleContext;
    }

    public Action getNewRangeAction() {
        return this._newRange;
    }

    public Action getNewValueAction() {
        return this._newValue;
    }

    public Action getRangeValueAction() {
        return this._rangeValue;
    }

    public Action getIncludeExcludeAction() {
        return this._includeExclude;
    }

    public Action getDeleteAction() {
        return this._delete;
    }

    public Insets getFocusInsets() {
        return ((BasicRangeSliderUI)this.getUI()).getFocusInsets();
    }

    public JPopupMenu getPopupMenu() {
        return this._popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this._popupMenu = popupMenu;
    }

    public boolean isCursorFeedback() {
        return this._isCursorFeedback;
    }

    public void setCursorFeedback(boolean isCursorFeedback) {
        this._isCursorFeedback = isCursorFeedback;
    }

    public boolean isExclusive() {
        if (this.getModel() instanceof MultipleBoundedRangeModel) {
            return ((MultipleBoundedRangeModel)this.getModel()).isExclusive();
        }
        return false;
    }

    public void setExclusive(boolean isExclusive) {
        ((MultipleBoundedRangeModel)this.getModel()).setExclusive(isExclusive);
        this.getIncludeExcludeAction().setEnabled(isExclusive);
    }

    public boolean isClickCreate() {
        return this._isClickCreate;
    }

    public void setClickCreate(boolean isClickCreate) {
        this._isClickCreate = isClickCreate;
    }

    public int getTickSpacing() {
        int tickSpacing = 0;
        int majorTickSpacing = this.getMajorTickSpacing();
        int minorTickSpacing = this.getMinorTickSpacing();
        if (minorTickSpacing > 0) {
            tickSpacing = minorTickSpacing;
        } else if (majorTickSpacing > 0) {
            tickSpacing = majorTickSpacing;
        }
        return tickSpacing;
    }

    @Override
    public void setMajorTickSpacing(int s) {
        super.setMajorTickSpacing(s);
        ((MultipleBoundedRangeModel)this.getModel()).setSpacing(this.getSnapToTicks() ? this.getTickSpacing() : 0);
    }

    @Override
    public void setMinorTickSpacing(int s) {
        super.setMinorTickSpacing(s);
        ((MultipleBoundedRangeModel)this.getModel()).setSpacing(this.getSnapToTicks() ? this.getTickSpacing() : 0);
    }

    @Override
    public void setSnapToTicks(boolean b) {
        super.setSnapToTicks(b);
        ((MultipleBoundedRangeModel)this.getModel()).setSpacing(this.getSnapToTicks() ? this.getTickSpacing() : 0);
    }

    public int getRangeIndex() {
        return ((BasicRangeSliderUI)this.getUI()).getRangeIndex();
    }

    public int getRangePart() {
        return ((BasicRangeSliderUI)this.getUI()).getRangePart();
    }

    public void setCalculation(int originPixel, double originValue, double pixelsPerValue) {
        ((BasicRangeSliderUI)this.getUI()).setCalculation(originPixel, originValue, pixelsPerValue);
    }

    protected class AccessibleRangeSlider
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = 1L;

        protected AccessibleRangeSlider() {
            super(RangeSlider.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (RangeSlider.this.getValueIsAdjusting()) {
                states.add(AccessibleState.BUSY);
            }
            if (RangeSlider.this.getOrientation() == 1) {
                states.add(AccessibleState.VERTICAL);
            } else {
                states.add(AccessibleState.HORIZONTAL);
            }
            return states;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SLIDER;
        }
    }
}

