/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.Vec3d;

public class Plane {
    public Vec3d normal;
    public double distance;
    public static final Plane YZ = new Plane(1.0, 0.0, 0.0, 0.0);
    public static final Plane ZY = new Plane(1.0, 0.0, 0.0, 0.0);
    public static final Plane ZX = new Plane(0.0, 1.0, 0.0, 0.0);
    public static final Plane XZ = new Plane(0.0, 1.0, 0.0, 0.0);
    public static final Plane XY = new Plane(0.0, 0.0, 1.0, 0.0);
    public static final Plane YX = new Plane(0.0, 0.0, 1.0, 0.0);

    public Plane() {
        this.normal = new Vec3d(0.0, 0.0, 1.0);
        this.distance = 0.0;
    }

    public Plane(double a, double b, double c, double d) {
        this.normal = new Vec3d(a, b, c);
        this.distance = d;
    }

    public Plane(Vec3d point1, Vec3d point2, Vec3d point3) {
        Vec3d v1 = new Vec3d(point1.x - point2.x, point1.y - point2.y, point1.z - point2.z);
        Vec3d v2 = new Vec3d(point3.x - point2.x, point3.y - point2.y, point3.z - point2.z);
        Vec3d normal = v1.cross(v2);
        this.makePlane(normal, point2);
    }

    public Plane(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        Vec3d v1 = new Vec3d(x1 - x2, y1 - y2, z1 - z2);
        Vec3d v2 = new Vec3d(x3 - x2, y3 - y2, z3 - z2);
        Vec3d normal = v1.cross(v2);
        this.makePlane(normal, new Vec3d(x2, y2, z2));
    }

    public Plane(Vec3d normal, Vec3d point) {
        this.makePlane(normal, point);
    }

    private Plane makePlane(Vec3d normal, Vec3d point) {
        normal.normalize();
        this.normal = normal;
        this.distance = normal.x * point.x + normal.y * point.y + normal.z * point.z;
        return this;
    }

    public Plane(Plane plane) {
        this.normal = new Vec3d(plane.normal);
        this.distance = plane.distance;
    }

    public boolean isOnPositiveSide(Vec3d point) {
        boolean isPositive = true;
        double sum = this.normal.x * point.x + this.normal.y * point.y + this.normal.z * point.z - this.distance;
        if (sum > 0.0) {
            isPositive = true;
        } else if (sum <= 0.0) {
            isPositive = false;
        }
        return isPositive;
    }

    public boolean isParallelTo(Plane plane) {
        boolean planeIsParallel = false;
        double angle = this.normal.angle(plane.normal);
        if (angle == 0.0 || angle == Math.PI) {
            planeIsParallel = true;
        }
        return planeIsParallel;
    }

    public Vec3d getPointOfIntersection(Vec3d beginLine, Vec3d endLine) {
        Vec3d point = new Vec3d();
        Vec3d lineDirection = new Vec3d(endLine.x - beginLine.x, endLine.y - beginLine.y, endLine.z - beginLine.z);
        lineDirection.normalize();
        double denom = this.normal.x * lineDirection.x + this.normal.y * lineDirection.y + this.normal.z * lineDirection.z;
        if (denom == 0.0) {
            point = null;
        } else {
            double t = -(this.normal.x * beginLine.x + this.normal.y * beginLine.y + this.normal.z * beginLine.z - this.distance) / denom;
            point.x = beginLine.x + lineDirection.x * t;
            point.y = beginLine.y + lineDirection.y * t;
            point.z = beginLine.z + lineDirection.z * t;
        }
        return point;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setNormal(Vec3d normal) {
        this.normal = new Vec3d(normal);
    }

    public Vec3d getNormal() {
        return new Vec3d(this.normal);
    }
}

