/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.ColorVertex;
import com.sas.graphics.util.Palette;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class PaletteRepresentationPanel
extends Component {
    protected Palette palette;
    Image offscreen;
    Image tempOffscreen;

    @Override
    public void addNotify() {
        super.addNotify();
        Dimension size = this.getSize();
        if (size.width > 0 && size.height > 0) {
            this.offscreen = this.createImage(size.width, size.height);
            if (this.offscreen != null) {
                this.drawSelf(this.offscreen.getGraphics());
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width != 0 && height != 0) {
            if (this.offscreen != null) {
                this.offscreen.flush();
            }
            this.offscreen = this.createImage(width, height);
        }
        super.setBounds(x, y, width, height);
        if (this.offscreen != null) {
            this.drawSelf(this.offscreen.getGraphics());
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.offscreen != null) {
            g.drawImage(this.offscreen, 0, 0, this);
        }
    }

    public void setPalette(Palette newPalette) {
        this.palette = newPalette;
        if (this.offscreen != null) {
            this.drawSelf(this.offscreen.getGraphics());
        }
        this.repaint();
    }

    public void drawSelf(Graphics g) {
        if (this.palette == null) {
            return;
        }
        Rectangle bounds = this.getBounds();
        if (this.palette.getContinuous()) {
            this.drawContinuousRamp(g, bounds);
        } else {
            this.drawDiscreteRamp(g, bounds);
        }
    }

    protected void drawContinuousRamp(Graphics g, Rectangle bounds) {
        for (int i = 0; i < this.palette.size() - 1; ++i) {
            ColorVertex tempEntry = this.palette.getEntry(i);
            ColorVertex tempEntry2 = this.palette.getEntry(i + 1);
            int x1 = (int)(tempEntry.value * (double)bounds.width);
            int x2 = (int)(tempEntry2.value * (double)bounds.width);
            this.drawShadedRect(g, bounds.x + x1, bounds.y, x2 - x1, bounds.height, tempEntry.color, tempEntry2.color);
        }
    }

    protected void drawShadedRect(Graphics g, int x, int y, int width, int height, Color color1, Color color2) {
        int red1 = color1.getRed();
        int red2 = color2.getRed();
        int green1 = color1.getGreen();
        int green2 = color2.getGreen();
        int blue1 = color1.getBlue();
        int blue2 = color2.getBlue();
        double redInc = (double)(red1 - red2) / (double)width;
        double greenInc = (double)(green1 - green2) / (double)width;
        double blueInc = (double)(blue1 - blue2) / (double)width;
        for (int i = x; i <= x + width; ++i) {
            g.setColor(new Color((int)((double)red1 - redInc * (double)(i - x)), (int)((double)green1 - greenInc * (double)(i - x)), (int)((double)blue1 - blueInc * (double)(i - x))));
            g.drawLine(i, y, i, y + height);
        }
    }

    protected void drawDiscreteRamp(Graphics g, Rectangle bounds) {
        for (int i = 0; i < this.palette.size() - 1; ++i) {
            ColorVertex tempEntry = this.palette.getEntry(i);
            ColorVertex tempEntry2 = this.palette.getEntry(i + 1);
            int x1 = (int)(tempEntry.value * (double)bounds.width);
            int x2 = (int)(tempEntry2.value * (double)bounds.width);
            g.setColor(tempEntry.color);
            g.fillRect(bounds.x + x1, bounds.y, x2 - x1, bounds.height);
        }
    }
}

