/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.ColorRampDialog;
import com.sas.graphics.util.ColorVertex;
import com.sas.graphics.util.DoublePoint;
import com.sas.graphics.util.Palette;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;

public class InteractivePalettePanel
extends Panel {
    protected Palette palette;
    protected boolean continuous = true;
    protected int mask;
    protected ColorRampDialog colorRampDialog;
    protected int selectedPoint = -1;

    public InteractivePalettePanel() {
    }

    public InteractivePalettePanel(ColorRampDialog foo, int newmask) {
        this();
        this.colorRampDialog = foo;
        this.mask = newmask;
    }

    public void setPalette(Palette newPalette) {
        this.palette = newPalette;
    }

    public void setContinuous(boolean temp) {
        this.continuous = temp;
    }

    public void setSelectedPoint(int point) {
        this.selectedPoint = point;
    }

    public DoublePoint getNormalizedValue(Point point) {
        Dimension size = this.getSize();
        return new DoublePoint((double)point.x / (double)size.width, 1.0 - (double)point.y / (double)size.height);
    }

    public Point getNonNormalizedValue(DoublePoint point) {
        Dimension size = this.getSize();
        return new Point((int)(point.x * (double)size.width), (int)((1.0 - point.y) * (double)size.height));
    }

    public int getClosestPoint(DoublePoint newPoint) {
        int curClosest = 0;
        if (this.continuous) {
            double curDistance = 1.5;
            for (int i = 0; i < this.palette.size(); ++i) {
                ColorVertex tempEntry = this.palette.getEntry(i);
                double dist = Math.abs(newPoint.y - tempEntry.value);
                if (!(dist < curDistance)) continue;
                curDistance = dist;
                curClosest = i;
            }
        } else {
            for (int i = 0; i < this.palette.size() - 1; ++i) {
                ColorVertex tempEntry = this.palette.getEntry(i);
                ColorVertex tempEntry2 = this.palette.getEntry(i + 1);
                if (!(newPoint.y >= tempEntry.value) || !(newPoint.y < tempEntry2.value)) continue;
                curClosest = i;
            }
        }
        return curClosest;
    }
}

