/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;

public abstract class Icon {
    protected Image img = null;
    protected int width = -1;
    protected int height = -1;

    public abstract boolean Initialize(Component var1, Color var2, int var3);

    protected boolean MakeImage(Component c, Color bgColor, int oldValue, int[] counts, int[] imageData) {
        int x = 0;
        int y = 0;
        Graphics g = null;
        if (c == null || counts == null || imageData == null) {
            return false;
        }
        this.img = c.createImage(this.width, this.height);
        if (this.img == null) {
            return false;
        }
        g = this.img.getGraphics();
        if (g == null) {
            return false;
        }
        for (int irec = 0; irec < imageData.length; ++irec) {
            if (bgColor != null && oldValue == imageData[irec]) {
                g.setColor(bgColor);
            } else {
                g.setColor(new Color(imageData[irec]));
            }
            for (int i = 0; i < counts[irec]; ++i) {
                if (x > this.width - 1) {
                    x = 0;
                    ++y;
                }
                g.drawLine(x, y, x, y);
                ++x;
            }
        }
        return true;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void DrawIcon(ImageObserver io, Graphics g, int xoff, int yoff) {
        if (io == null || g == null) {
            return;
        }
        g.drawImage(this.img, xoff, yoff, io);
    }
}

