/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.DateFormatNameConversion;
import com.sas.graphics.util.TickSpacer;
import com.sas.graphics.util.TidyDateTimeTickSpacingInfo;
import com.sas.graphics.util.ZxAxis;
import com.sas.text.SASFormat;

public class DateTimeTickSpacer
extends TickSpacer {
    protected TidyDateTimeTickSpacingInfo tickSpacingInfo = new TidyDateTimeTickSpacingInfo();
    protected ZxAxis.Interval interval;
    protected String format1;
    protected String format2;
    protected ZxAxis.Interval minorInterval;
    protected double[] minorValues;
    private double min;
    private double max;
    private DateFormatNameConversion nameConvertor = null;
    private String englishName = null;
    private boolean converting = false;
    private boolean invalidUserMinorInterval = false;

    public TidyDateTimeTickSpacingInfo getTickSpacingInfo() {
        return this.tickSpacingInfo;
    }

    public void setTickSpacingInfo(TidyDateTimeTickSpacingInfo info) {
        this.tickSpacingInfo = info;
    }

    public ZxAxis.Interval getInterval() {
        return this.interval;
    }

    public String getFormatName(boolean wider) {
        String fmtname = wider ? this.format1 : this.format2;
        return fmtname;
    }

    public SASFormat getFormat(boolean wider) {
        String fmtname = wider ? this.format1 : this.format2;
        return SASFormat.getInstance((String)fmtname);
    }

    public double[] getMinorTickValues() {
        return this.minorValues;
    }

    public ZxAxis.Interval getMinorInterval() {
        return this.minorInterval;
    }

    @Override
    public void doTickSpacing() {
        double[] values;
        Object[] val;
        ZxAxis.Interval intvl;
        this.min = this.preference.getMinCalc() == 1 ? this.userMin : this.dataMin;
        this.max = this.preference.getMaxCalc() == 1 ? this.userMax : this.dataMax;
        if (Double.isNaN(this.min) || Double.isNaN(this.max)) {
            throw new RuntimeException("Minimum value or maximum value is not provided.");
        }
        if (!ZxAxis.isValidDateTime(new double[]{this.min, this.max}, this.tickSpacingInfo.getFormat())) {
            throw new RuntimeException("Minimum value or maximum value is out of range.");
        }
        this.max = Math.max(this.max, this.min);
        try {
            String fmtname = this.extractFormatName(this.tickSpacingInfo.getFormat().getName());
            this.nameConvertor = DateFormatNameConversion.newDataFormatNameConversion(fmtname.toUpperCase());
            this.englishName = this.nameConvertor.getEnglishFormatName();
            if (!this.englishName.equalsIgnoreCase(fmtname)) {
                this.converting = true;
            }
        }
        catch (IllegalArgumentException e) {
            this.englishName = this.tickSpacingInfo.getFormat().getName();
            this.converting = false;
        }
        ZxAxis.Interval dataIntvl = this.tickSpacingInfo.getDataInterval();
        if (dataIntvl == null) {
            dataIntvl = this.getDefaultInterval();
        }
        if (this.preference.isAutoInterval()) {
            intvl = dataIntvl;
        } else {
            int ticks;
            intvl = this.tickSpacingInfo.getInterval();
            if (intvl.units == 'u') {
                intvl.units = this.tickSpacingInfo.getFormat().isDateFormat() ? (char)100 : (char)115;
            }
            if ((ticks = this.getTickCount(intvl)) < 2 && this.min != this.max) {
                intvl = this.getDefaultInterval();
            } else {
                this.tickSpacingInfo.setMaxTicks(ticks);
            }
        }
        if (this.min == this.max) {
            if (this.preference.isAutoInterval()) {
                val = ZxAxis.getClosestDates(this.min, this.tickSpacingInfo.getFormat());
                this.min = ((Number)val[0]).doubleValue();
                this.max = ((Number)val[1]).doubleValue();
                this.interval = (ZxAxis.Interval)val[2];
            } else {
                this.min = ZxAxis.zintnx2(intvl, this.min, -1.0);
                this.max = ZxAxis.zintnx2(intvl, this.max, 1.0);
                this.interval = intvl;
            }
            values = new double[]{this.min, ZxAxis.zintnx2(this.interval, this.min, 1.0), this.max};
        } else {
            val = ZxAxis.ztaxis(intvl, this.min, this.max, this.getMaximumTicks(), this.tickSpacingInfo.getMinCover(), this.tickSpacingInfo.getFormat());
            this.interval = (ZxAxis.Interval)val[0];
            if (this.interval == null) {
                values = new double[6];
                double delta = (this.max - this.min) / 5.0;
                for (int i = 0; i < 6; ++i) {
                    values[i] = this.min + (double)i * delta;
                }
            } else {
                int ticks = (Integer)val[2];
                values = new double[ticks];
                values[0] = (Double)val[1];
                for (int i = 1; i < ticks; ++i) {
                    values[i] = ZxAxis.zintnx2(this.interval, values[i - 1], 1.0);
                }
            }
        }
        this.minorInterval = null;
        this.invalidUserMinorInterval = false;
        if (this.interval != null && this.tickSpacingInfo.getMaxMinorTicks() > 0) {
            int maxMinorTicks = this.tickSpacingInfo.getMaxMinorTicks();
            if (this.tickSpacingInfo.getAxisLength() > 0 && this.tickSpacingInfo.getMinorTickGap() > 0) {
                int allowed = (int)((double)this.tickSpacingInfo.getAxisLength() / (double)values.length / (double)this.tickSpacingInfo.getMinorTickGap());
                maxMinorTicks = Math.min(allowed, maxMinorTicks);
            }
            if (this.tickSpacingInfo.getMinorIntervalCode() != 0) {
                this.minorInterval = this.getMinorInterval(this.tickSpacingInfo.getMinorIntervalCode(), this.interval);
                if (this.minorInterval == null) {
                    this.invalidUserMinorInterval = true;
                }
            }
            if (this.minorInterval == null) {
                this.minorInterval = ZxAxis.ztaxis2(dataIntvl, this.interval, maxMinorTicks);
            }
            this.processingMinorTicks(values, this.minorInterval);
        }
        this.postProcessing(values);
        ZxAxis.Interval I = this.minorInterval != null && this.tickSpacingInfo.isHonorMinorTickFormat() ? this.minorInterval : this.interval;
        this.format1 = this.interval == null ? this.tickSpacingInfo.getFormat().getName() : ZxAxis.zintfmm(I, this.tickValues[0], true, this.tickSpacingInfo.getFormat());
        String string = this.format2 = this.interval == null ? this.tickSpacingInfo.getFormat().getName() : ZxAxis.zintfmm(I, this.tickValues[0], false, this.tickSpacingInfo.getFormat());
        if (this.converting) {
            try {
                this.format1 = this.nameConvertor.convertEnglishFormatName(this.extractFormatName(this.format1).toUpperCase());
                this.format2 = this.nameConvertor.convertEnglishFormatName(this.extractFormatName(this.format2).toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void autoSpacing() {
        ZxAxis.Interval intvl = new ZxAxis.Interval(this.tickSpacingInfo.getInterval());
        Object[] val = ZxAxis.ztaxis(intvl, this.min, this.max, this.tickSpacingInfo.getMaxTicks(), this.tickSpacingInfo.getMinCover(), this.tickSpacingInfo.getFormat());
        this.interval = (ZxAxis.Interval)val[0];
        int ticks = (Integer)val[2];
        double[] values = new double[ticks];
        values[0] = (Double)val[1];
        for (int i = 1; i < ticks; ++i) {
            values[i] = ZxAxis.zintnx2(this.interval, values[i - 1], 1.0);
        }
        this.postProcessing(values);
    }

    private void spacingByInterval() {
        this.interval = this.tickSpacingInfo.getInterval();
        double ticknd = ZxAxis.zintck2(this.interval, this.min, this.max);
        if (Double.isNaN(ticknd)) {
            throw new RuntimeException("Invalid interval");
        }
        int ticks = (int)ticknd + 1;
        double xmin = ZxAxis.zintnx2(this.interval, this.min, 0.0);
        double xmax = ZxAxis.zintnx2(this.interval, this.max, 0.0);
        if (xmax < this.max) {
            ++ticks;
        }
        double[] values = new double[ticks];
        values[0] = this.min;
        for (int i = 1; i < ticks; ++i) {
            values[i] = ZxAxis.zintnx2(this.interval, values[i - 1], 1.0);
        }
        this.postProcessing(values);
    }

    private void postProcessing(double[] values) {
        int ticks = values.length;
        if (this.preference.getMinCalc() == 1) {
            values[0] = this.userMin;
        }
        if (this.preference.getMinCalc() == 2) {
            values[0] = this.dataMin;
        }
        if (this.preference.getMaxCalc() == 1) {
            values[ticks - 1] = this.userMax;
        }
        if (this.preference.getMaxCalc() == 2) {
            values[ticks - 1] = this.dataMax;
        }
        this.tickMin = values[0];
        this.tickMax = values[ticks - 1];
        if (!this.preference.isFullCoverage()) {
            boolean useTickMin = true;
            boolean useTickMax = true;
            int newTicks = ticks;
            if (this.preference.getMinCalc() == 0 && values[1] - this.dataMin < this.preference.getCoverageCoeff() * (values[1] - values[0])) {
                --newTicks;
                useTickMin = false;
            }
            if (this.preference.getMaxCalc() == 0 && this.dataMax - values[ticks - 2] < this.preference.getCoverageCoeff() * (values[ticks - 1] - values[ticks - 2])) {
                --newTicks;
                useTickMax = false;
            }
            if (newTicks != ticks) {
                this.tickValues = new double[newTicks];
                int start = useTickMin ? 0 : 1;
                int end = useTickMax ? ticks : ticks - 1;
                int idx = 0;
                for (int i = start; i < end; ++i) {
                    this.tickValues[idx] = values[i];
                    ++idx;
                }
                return;
            }
        }
        int start = 0;
        int end = ticks - 1;
        if (this.minorValues != null) {
            int i;
            int minorStart = 0;
            int minorEnd = this.minorValues.length - 1;
            if (this.tickMin < this.dataMin && this.minorValues[0] <= this.dataMin) {
                for (i = 1; i < this.minorValues.length; ++i) {
                    if (!(this.minorValues[i] > this.dataMin)) continue;
                    this.tickMin = this.minorValues[i - 1];
                    ++start;
                    --ticks;
                    minorStart = i - 1;
                    break;
                }
            }
            if (this.tickMax > this.dataMax && this.minorValues[this.minorValues.length - 1] >= this.dataMax) {
                for (i = this.minorValues.length - 2; i >= 0; --i) {
                    if (!(this.minorValues[i] < this.dataMax)) continue;
                    this.tickMax = this.minorValues[i + 1];
                    --end;
                    --ticks;
                    minorEnd = i + 1;
                    break;
                }
            }
            if (ticks == 0) {
                return;
            }
            if (minorStart != 0 || minorEnd != this.minorValues.length - 1) {
                double[] values2 = new double[minorEnd - minorStart + 1];
                int idx = 0;
                for (int i2 = minorStart; i2 <= minorEnd; ++i2) {
                    values2[idx++] = this.minorValues[i2];
                }
                this.minorValues = values2;
            }
        }
        this.tickValues = new double[ticks];
        int idx = 0;
        int i = start;
        while (i <= end) {
            this.tickValues[idx] = values[i];
            ++i;
            ++idx;
        }
    }

    private ZxAxis.Interval getMinorInterval(int minorIntervalCode, ZxAxis.Interval majorInterval) {
        ZxAxis.Interval interval = null;
        if (minorIntervalCode == majorInterval.intcode) {
            if (majorInterval.intper > 1) {
                interval = new ZxAxis.Interval(majorInterval);
                interval.intper = 1;
                interval.shiftper = 0;
            }
        } else if (minorIntervalCode < majorInterval.intcode) {
            if (minorIntervalCode < 25 && majorInterval.units == 'd') {
                return null;
            }
            interval = new ZxAxis.Interval();
            interval.units = majorInterval.units;
            interval.intcode = minorIntervalCode;
        }
        return interval;
    }

    private void processingMinorTicks(double[] major, ZxAxis.Interval minor) {
        if (minor == null) {
            this.minorValues = null;
            return;
        }
        int tickn = 0;
        for (int i = 0; i < major.length - 1; ++i) {
            tickn += (int)ZxAxis.zintck2(minor, major[i], major[i + 1]) + 2;
        }
        this.minorValues = new double[tickn];
        int j = 0;
        for (int i = 0; i < major.length - 1; ++i) {
            double v = major[i];
            while ((v = ZxAxis.zintnx2(minor, v, 1.0)) < major[i + 1]) {
                this.minorValues[j] = v;
                ++j;
            }
        }
        if (j < this.minorValues.length) {
            double[] nv = new double[j];
            for (int i = 0; i < j; ++i) {
                nv[i] = this.minorValues[i];
            }
            this.minorValues = nv;
        }
    }

    private ZxAxis.Interval getDefaultInterval() {
        ZxAxis.Interval intvl = new ZxAxis.Interval();
        SASFormat fmt = this.tickSpacingInfo.getFormat();
        if (fmt != null) {
            String fmtname = this.englishName;
            if (fmt.isDateFormat()) {
                intvl.intcode = 25;
                intvl.units = (char)100;
            } else if (fmt.isTimeFormat() || fmt.isDateTimeFormat()) {
                double dataTimeRange = this.max - this.min;
                double days = dataTimeRange / 86400.0;
                intvl.intcode = fmtname.startsWith("DTYEAR") && days > 365.0 ? 60 : (fmtname.startsWith("DTSEMIYEAR") && days > 365.0 ? 55 : (fmtname.startsWith("DTYYQC") && days > 365.0 ? 50 : (fmtname.startsWith("DTMONYY") && days > 31.0 ? 45 : (fmtname.startsWith("DT") && days > 1.0 ? 25 : 10))));
                intvl.units = (char)115;
            }
        }
        return intvl;
    }

    private int getMaximumTicks() {
        boolean date;
        int maxTicks = this.tickSpacingInfo.getMaxTicks();
        if (maxTicks > 0) {
            return maxTicks;
        }
        maxTicks = 13;
        SASFormat fmt = this.tickSpacingInfo.getFormat();
        if (fmt.isDateFormat()) {
            date = true;
        } else if (fmt.isTimeFormat() || fmt.isDateTimeFormat()) {
            date = this.englishName.startsWith("DT") || this.englishName.startsWith("DATETIME");
        } else {
            return maxTicks;
        }
        if (date) {
            return maxTicks;
        }
        ZxAxis.Interval intv = new ZxAxis.Interval();
        intv.units = (char)115;
        intv.intcode = 20;
        intv.intper = (short)12;
        int reqTicks = this.getTickCount(intv);
        maxTicks = Math.max(reqTicks + 2, maxTicks);
        return maxTicks;
    }

    private int getTickCount(ZxAxis.Interval intvl) {
        double ticknd = ZxAxis.zintck2(intvl, this.min, this.max);
        if (Double.isNaN(ticknd)) {
            return -1;
        }
        int ticks = (int)ticknd + 1;
        return ticks;
    }

    private String extractFormatName(String fmtname) {
        if (fmtname == null) {
            return null;
        }
        int i = -1;
        for (int c = 0; c < fmtname.length(); ++c) {
            if (Character.isLetter(fmtname.charAt(c))) continue;
            i = c;
            break;
        }
        if (i != -1) {
            fmtname = fmtname.substring(0, i);
        }
        return fmtname;
    }

    public boolean isInvalidUserMinorInterval() {
        return this.invalidUserMinorInterval;
    }
}

