/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.ImageSelection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import javax.swing.JComponent;

public class CopyToClipboard {
    public static boolean toClipboard(JComponent comp) {
        Image img = CopyToClipboard.getImage(comp);
        if (img == null) {
            return false;
        }
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        ImageSelection is = new ImageSelection();
        is.exportToClipboard(comp, cb, 1);
        return true;
    }

    public static Image getImage(Component comp) {
        Dimension d = null;
        int w = 0;
        int h = 0;
        Image img = null;
        Graphics g = null;
        if (comp == null) {
            return null;
        }
        d = comp.getSize();
        if (d == null) {
            return null;
        }
        w = d.width;
        h = d.height;
        if (w <= 0 || h <= 0) {
            return null;
        }
        img = comp.createImage(w, h);
        if (img == null) {
            return null;
        }
        g = img.getGraphics();
        if (g == null) {
            return null;
        }
        comp.paint(g);
        g.dispose();
        return img;
    }
}

