/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.NumericalTickSpacer;
import com.sas.graphics.util.ZxAxis;

public class ContinuousTickSpacer
extends NumericalTickSpacer {
    private double min;
    private double max;
    private double start;
    private double end;
    private double inc10;

    @Override
    public void doTickSpacing() {
        this.min = this.preference.getMinCalc() == 1 ? this.userMin : this.dataMin;
        this.max = this.preference.getMaxCalc() == 1 ? this.userMax : this.dataMax;
        if (Double.isNaN(this.min) || Double.isNaN(this.max)) {
            throw new RuntimeException("Minimum value or maximum value is not provided");
        }
        this.max = Math.max(this.max, this.min);
        if (this.min == this.max) {
            this.tickMin = this.min;
            this.tickMax = this.max;
            this.tickValues = new double[2];
            this.tickValues[0] = this.min;
            this.tickValues[1] = this.max;
            return;
        }
        if (this.preference.getMinCalc() != 0 && this.preference.getMaxCalc() != 0 && !this.preference.isAutoInterval() && !this.honorCount) {
            throw new RuntimeException("Conflicted preference");
        }
        if (this.preference.isAutoInterval()) {
            this.autoSpacing();
        } else if (!this.preference.isAutoInterval() && !this.honorCount) {
            this.spacingByInterval();
        } else if (!this.preference.isAutoInterval() && this.honorCount) {
            this.spacingByCount();
        }
    }

    private void autoSpacing() {
        double tickinc;
        double tickend;
        double tickstart;
        double[] val = this.tickSpacingInfo.isInteger() ? ZxAxis.ziaxis((long)this.min, (long)this.max, this.tickSpacingInfo.isZeroMark(), this.tickSpacingInfo.isHorizontal(), this.tickSpacingInfo.getMaxTicks(), this.tickSpacingInfo.getMinCover(), this.tickSpacingInfo.getTargetCover()) : ZxAxis.znaxis(this.min, this.max, this.tickSpacingInfo.isZeroMark(), this.tickSpacingInfo.isHorizontal(), this.tickSpacingInfo.getMaxTicks(), this.tickSpacingInfo.getMinCover(), this.tickSpacingInfo.getTargetCover());
        int ticks = (int)val[2];
        if (ticks > 0) {
            tickstart = val[0];
            tickend = tickstart + ((double)ticks - 1.0) * val[1];
            tickinc = val[1];
        } else {
            double inc10;
            int n;
            int tickn = 3;
            double inc = (this.max - this.min) / (double)(tickn - 1);
            if (inc > 1.0) {
                n = (int)(Math.log(inc) / Math.log(10.0));
                inc10 = Math.ceil(inc / Math.pow(10.0, n));
                inc10 *= Math.pow(10.0, n);
            } else {
                n = (int)(Math.log(1.0 / inc) / Math.log(10.0));
                inc10 = Math.ceil(inc * Math.pow(10.0, n));
                inc10 /= Math.pow(10.0, n);
            }
            tickinc = inc10;
            tickstart = Math.floor(this.min / tickinc + 1.0E-6) * tickinc;
            tickend = Math.ceil(this.max / tickinc - 1.0E-6) * tickinc;
            double arange = tickend - tickstart;
            ticks = (int)Math.floor(arange / tickinc + 1.0E-6) + 1;
        }
        if (ticks > 1) {
            if (tickstart + tickinc <= this.min) {
                --ticks;
                tickstart += tickinc;
            }
            if (tickend - tickinc >= this.max) {
                --ticks;
                tickend -= tickinc;
            }
        }
        double[] values = new double[ticks];
        values[0] = tickstart;
        for (int i = 1; i < ticks; ++i) {
            values[i] = values[i - 1] + tickinc;
        }
        this.postProcessing(values);
    }

    private void spacingByInterval() {
        double tickVal;
        int ticks;
        if (Double.isNaN(this.interval)) {
            throw new RuntimeException("Interval value is not provided");
        }
        if (this.preference.getMinCalc() == 0 && this.preference.getMaxCalc() == 0) {
            ticks = this.getNumTicks(this.interval);
        } else if (this.preference.getMinCalc() != 0) {
            ticks = 1;
            tickVal = this.start = this.min;
            while (tickVal < this.max) {
                tickVal += this.interval;
                ++ticks;
            }
            this.end = tickVal;
        } else {
            ticks = 1;
            tickVal = this.end = this.max;
            while (tickVal > this.min) {
                tickVal -= this.interval;
                ++ticks;
            }
            this.start = tickVal;
        }
        double[] values = new double[ticks];
        values[0] = this.start;
        for (int i = 1; i < ticks; ++i) {
            values[i] = values[i - 1] + this.interval;
        }
        this.postProcessing(values);
    }

    private void spacingByCount() {
        if (this.tickCount < 1) {
            throw new RuntimeException("Invalid tick count");
        }
        if (this.preference.getMinCalc() != 0 && this.preference.getMaxCalc() != 0) {
            this.start = this.min;
            this.end = this.max;
            this.inc10 = (this.end - this.start) / (double)(this.tickCount - 1);
        } else {
            int n;
            double inc = (this.max - this.min) / (double)(this.tickCount - 1);
            if (inc > 1.0) {
                n = (int)(Math.log(inc) / Math.log(10.0));
                this.inc10 = Math.ceil(inc / Math.pow(10.0, n));
                this.inc10 *= Math.pow(10.0, n);
            } else {
                n = (int)(Math.log(1.0 / inc) / Math.log(10.0));
                this.inc10 = Math.ceil(inc * Math.pow(10.0, n));
                this.inc10 /= Math.pow(10.0, n);
            }
            if (this.inc10 == inc) {
                this.start = this.min;
                this.end = this.max;
            } else if (this.preference.getMinCalc() == 0 && this.preference.getMaxCalc() == 0) {
                if (this.start == this.min) {
                    this.end = this.start + (double)(this.tickCount - 1) * this.inc10;
                    this.adjustTickMax(inc);
                } else {
                    int ticks = this.getNumTicks(this.inc10);
                    this.adjustTicks(inc, ticks);
                }
            } else if (this.preference.getMinCalc() != 0) {
                this.start = this.min;
                this.end = this.start + (double)(this.tickCount - 1) * this.inc10;
                this.adjustTickMax(inc);
            } else {
                this.end = this.max;
                this.start = this.end - (double)(this.tickCount - 1) * this.inc10;
                this.adjustTickMin(inc);
            }
        }
        this.tickValues = new double[this.tickCount];
        this.tickValues[0] = this.start;
        for (int i = 1; i < this.tickCount; ++i) {
            this.tickValues[i] = this.start + this.inc10 * (double)i;
        }
        this.end = this.tickValues[this.tickCount - 1];
        this.tickMin = this.start > this.min ? this.start - this.inc10 : this.start;
        this.tickMax = this.end < this.max ? this.end + this.inc10 : this.end;
    }

    private int getNumTicks(double incr) {
        this.start = Math.floor(this.min / incr + 1.0E-6) * incr;
        this.end = Math.ceil(this.max / incr - 1.0E-6) * incr;
        double arange = this.end - this.start;
        int ticks = (int)Math.floor(arange / incr + 1.0E-6) + 1;
        return ticks;
    }

    private void adjustTicks(double inc, int ticks) {
        if (!this.preference.isFullCoverage() && ticks > this.tickCount) {
            if (ticks - this.tickCount == 1) {
                if (this.min - this.start > (1.0 - this.preference.getCoverageCoeff()) * this.inc10) {
                    this.start += this.inc10;
                    return;
                }
                if (this.end - this.max > (1.0 - this.preference.getCoverageCoeff()) * this.inc10) {
                    this.end -= this.inc10;
                    return;
                }
            } else if (ticks - this.tickCount == 2 && this.min - this.start > (1.0 - this.preference.getCoverageCoeff()) * this.inc10 && this.end - this.max > (1.0 - this.preference.getCoverageCoeff()) * this.inc10) {
                this.start += this.inc10;
                this.end -= this.inc10;
                return;
            }
        }
        if (ticks > this.tickCount) {
            double d;
            double bestAdj;
            int n;
            if (inc > 1.0) {
                n = (int)(Math.log(this.inc10) / Math.log(10.0));
                bestAdj = Math.pow(10.0, n);
            } else {
                n = (int)(Math.log(1.0 / this.inc10) / Math.log(10.0));
                bestAdj = 1.0 / Math.pow(10.0, n + 1);
            }
            double startSav = this.start;
            double endSav = this.end;
            while (this.start + bestAdj <= this.min) {
                this.start += bestAdj;
                this.end = this.start + this.inc10 * (double)(this.tickCount - 1);
                if (!(this.end >= this.max)) continue;
                return;
            }
            this.start = startSav;
            this.end = endSav;
            double addition = (double)(ticks - this.tickCount) / (double)(this.tickCount - 1) * this.inc10;
            double d2 = d = addition >= bestAdj ? bestAdj : 0.0;
            while (d < addition) {
                d += bestAdj * 0.25;
            }
            this.inc10 += d;
        } else if (ticks < this.tickCount) {
            double d;
            double bestAdj;
            int n;
            if (inc > 1.0) {
                n = (int)(Math.log(this.inc10) / Math.log(10.0));
                bestAdj = Math.pow(10.0, n);
            } else {
                n = (int)(Math.log(1.0 / this.inc10) / Math.log(10.0));
                bestAdj = 1.0 / Math.pow(10.0, n + 1);
            }
            double startSav = this.start;
            double endSav = this.end;
            while (this.min - (this.start - bestAdj) <= this.inc10) {
                this.start -= bestAdj;
                this.end = this.start + this.inc10 * (double)(this.tickCount - 1);
                if (!(this.end - this.max <= this.inc10)) continue;
                return;
            }
            this.start = startSav;
            this.end = endSav;
            double addition = (double)(this.tickCount - ticks) / (double)(this.tickCount - 1) * this.inc10;
            double d3 = d = addition >= bestAdj ? bestAdj : 0.0;
            while (d + bestAdj * 0.25 <= addition) {
                d += bestAdj * 0.25;
            }
            this.inc10 -= d;
        }
    }

    private void adjustTickMax(double inc) {
        double left = (this.end - this.max) / this.inc10;
        while (left > 1.0) {
            double adj;
            int n;
            double diff = this.inc10 - inc;
            if (inc > 1.0) {
                n = (int)(Math.log(diff) / Math.log(10.0));
                adj = Math.pow(10.0, n);
            } else {
                n = (int)(Math.log(1.0 / diff) / Math.log(10.0));
                adj = 5.0 / Math.pow(10.0, n + 1);
                if (this.inc10 - adj < inc) {
                    adj /= 5.0;
                }
            }
            this.inc10 -= adj;
            this.end = this.start + (double)(this.tickCount - 1) * this.inc10;
            if (this.end < this.max) {
                this.inc10 += adj;
                this.end = this.start + (double)(this.tickCount - 1) * this.inc10;
                break;
            }
            left = (this.end - this.max) / this.inc10;
        }
    }

    private void adjustTickMin(double inc) {
        double left = (this.min - this.start) / this.inc10;
        while (left > 1.0) {
            double adj;
            int n;
            double diff = this.inc10 - inc;
            if (inc > 1.0) {
                n = (int)(Math.log(diff) / Math.log(10.0));
                adj = Math.pow(10.0, n);
            } else {
                n = (int)(Math.log(1.0 / diff) / Math.log(10.0));
                adj = 5.0 / Math.pow(10.0, n + 1);
                if (this.inc10 - adj < inc) {
                    adj /= 5.0;
                }
            }
            this.inc10 -= adj;
            this.start = this.end - (double)(this.tickCount - 1) * this.inc10;
            if (this.start > this.min) {
                this.inc10 += adj;
                this.start = this.end - (double)(this.tickCount - 1) * this.inc10;
                break;
            }
            left = (this.min - this.start) / this.inc10;
        }
    }

    private void postProcessing(double[] values) {
        int ticks = values.length;
        if (this.preference.getMinCalc() == 1) {
            values[0] = this.userMin;
        }
        if (this.preference.getMinCalc() == 2) {
            values[0] = this.dataMin;
        }
        if (this.preference.getMaxCalc() == 1) {
            values[ticks - 1] = this.userMax;
        }
        if (this.preference.getMaxCalc() == 2) {
            values[ticks - 1] = this.dataMax;
        }
        this.tickMin = values[0];
        this.tickMax = values[ticks - 1];
        if (!this.preference.isFullCoverage()) {
            boolean useTickMin = true;
            boolean useTickMax = true;
            int newTicks = ticks;
            if (this.preference.getMinCalc() == 0 && values[1] - this.dataMin < this.preference.getCoverageCoeff() * (values[1] - values[0])) {
                --newTicks;
                useTickMin = false;
            }
            if (this.preference.getMaxCalc() == 0 && this.dataMax - values[ticks - 2] < this.preference.getCoverageCoeff() * (values[ticks - 1] - values[ticks - 2])) {
                --newTicks;
                useTickMax = false;
            }
            if (newTicks != ticks) {
                this.tickValues = new double[newTicks];
                int start = useTickMin ? 0 : 1;
                int end = useTickMax ? ticks : ticks - 1;
                int idx = 0;
                for (int i = start; i < end; ++i) {
                    this.tickValues[idx] = values[i];
                    ++idx;
                }
                return;
            }
        }
        this.tickValues = new double[ticks];
        for (int i = 0; i < ticks; ++i) {
            this.tickValues[i] = values[i];
        }
    }
}

