/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.ColorRampDialog;
import com.sas.graphics.util.ColorVertex;
import com.sas.graphics.util.InteractivePalettePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class ColorPanel
extends InteractivePalettePanel {
    public ColorPanel() {
        PanelMouseAdapter panelMouseAdapter = new PanelMouseAdapter();
        PanelMouseMotionAdapter panelMouseMotionAdapter = new PanelMouseMotionAdapter();
        PanelKeyAdapter panelKeyAdapter = new PanelKeyAdapter();
        this.addKeyListener(panelKeyAdapter);
        this.addMouseListener(panelMouseAdapter);
        this.addMouseMotionListener(panelMouseMotionAdapter);
    }

    public ColorPanel(ColorRampDialog foo, int newmask) {
        this();
        this.colorRampDialog = foo;
        this.mask = newmask;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension((int)((double)this.getParent().getSize().width / 3.0), this.getParent().getSize().height);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.gray);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.continuous) {
            this.drawContinuous(g);
        } else {
            this.drawDiscrete(g);
        }
    }

    protected void drawContinuous(Graphics g) {
        ColorVertex tempEntry;
        int i;
        g.setColor(Color.white);
        for (i = this.palette.size() - 1; i > 0; --i) {
            tempEntry = this.palette.getEntry(i);
            ColorVertex tempEntry2 = this.palette.getEntry(i - 1);
            int y1 = (int)((1.0 - tempEntry.value) * (double)this.getSize().height);
            int y2 = (int)((1.0 - tempEntry2.value) * (double)this.getSize().height);
            int x1 = (int)(this.getColorValue(tempEntry.color) * (double)this.getSize().width);
            int x2 = (int)(this.getColorValue(tempEntry2.color) * (double)this.getSize().width);
            g.drawLine(x1, y1, x2, y2);
        }
        g.setColor(Color.red);
        for (i = this.palette.size() - 1; i >= 0; --i) {
            if (i == this.selectedPoint) {
                g.setColor(Color.blue);
            }
            tempEntry = this.palette.getEntry(i);
            g.fillOval((int)(this.getColorValue(tempEntry.color) * (double)this.getSize().width) - 5, (int)((1.0 - tempEntry.value) * (double)this.getSize().height) - 5, 10, 10);
            if (i != this.selectedPoint) continue;
            g.setColor(Color.red);
        }
    }

    protected double getColorValue(Color color) {
        if (this.mask == 1) {
            return (double)color.getRed() / 255.0;
        }
        if (this.mask == 2) {
            return (double)color.getGreen() / 255.0;
        }
        if (this.mask == 4) {
            return (double)color.getBlue() / 255.0;
        }
        return 0.0;
    }

    protected void drawDiscrete(Graphics g) {
        for (int i = 0; i < this.palette.size() - 1; ++i) {
            ColorVertex tempEntry = this.palette.getEntry(i);
            ColorVertex tempEntry2 = this.palette.getEntry(i + 1);
            int y1 = (int)((1.0 - tempEntry.value) * (double)this.getSize().height);
            int y2 = (int)((1.0 - tempEntry2.value) * (double)this.getSize().height);
            int x1 = (int)(this.getColorValue(tempEntry.color) * (double)this.getSize().width);
            if (i == this.selectedPoint) {
                g.setColor(Color.blue);
            } else {
                g.setColor(Color.white);
            }
            g.drawLine(x1, y1, x1, y2);
        }
    }

    void ColorPanel_KeyPressed(KeyEvent event) {
        if (event.getKeyCode() == 127) {
            this.colorRampDialog.deleteSelectedPoint(this.selectedPoint);
            this.colorRampDialog.repaintPanels();
            this.colorRampDialog.deselectPoint(this.selectedPoint);
            this.selectedPoint = -1;
        }
    }

    class PanelKeyAdapter
    extends KeyAdapter {
        PanelKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            Object object = event.getSource();
            if (object == ColorPanel.this) {
                ColorPanel.this.ColorPanel_KeyPressed(event);
            }
        }
    }

    class PanelMouseMotionAdapter
    extends MouseMotionAdapter {
        PanelMouseMotionAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int mod = e.getModifiers();
            ColorPanel.this.colorRampDialog.movePoint(ColorPanel.this.selectedPoint, ColorPanel.this.getNormalizedValue(new Point(x, y)), ColorPanel.this.mask);
            ColorPanel.this.colorRampDialog.repaintPanels();
        }
    }

    class PanelMouseAdapter
    extends MouseAdapter {
        PanelMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int mod = e.getModifiers();
            if ((mod & 4) != 0) {
                ColorPanel.this.colorRampDialog.addPoint(ColorPanel.this.getNormalizedValue(new Point(x, y)), ColorPanel.this.mask);
                ColorPanel.this.colorRampDialog.repaintPanels();
            } else {
                ColorPanel.this.selectedPoint = ColorPanel.this.getClosestPoint(ColorPanel.this.getNormalizedValue(new Point(x, y)));
                if (e.getClickCount() == 2) {
                    ColorPanel.this.colorRampDialog.editPoint(ColorPanel.this.selectedPoint, ColorPanel.this.mask);
                } else {
                    ColorPanel.this.colorRampDialog.selectPoint(ColorPanel.this.selectedPoint, ColorPanel.this.mask);
                }
                ColorPanel.this.colorRampDialog.repaintPanels();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

