/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.Debug;
import java.awt.Color;
import java.util.Enumeration;

public abstract class ColorNameTable {
    private static final String HEX_PREFIX = "0x";
    private static final String HEX2_PREFIX = "#";
    private static final String OCT_PREFIX = "0";

    public Color getColor(String name) {
        Color color = null;
        if (name != null && name.length() > 0) {
            try {
                color = new Color(this.decode(name));
            }
            catch (NumberFormatException e) {
                Debug.println(e.toString());
            }
        }
        return color;
    }

    private int decode(String nm) throws NumberFormatException {
        int result = nm.startsWith(HEX_PREFIX, 0) ? Integer.parseInt(nm.substring(2), 16) : (nm.startsWith(HEX2_PREFIX, 0) ? Integer.parseInt(nm.substring(1), 16) : (nm.startsWith(OCT_PREFIX, 0) && nm.length() > 1 ? Integer.parseInt(nm.substring(1), 8) : Integer.parseInt(nm)));
        return result;
    }

    public abstract Enumeration getColorName();

    public abstract Enumeration getColor();

    public abstract boolean isNamedColor(String var1);

    public abstract int size();
}

