/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.ColorEditDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class BrightnessPanel
extends Panel
implements MouseMotionListener,
MouseListener {
    protected Image backgroundImage = null;
    protected Image offscreen = null;
    protected float currentHue = 0.5f;
    protected float currentSat = 0.5f;
    protected float currentBrightness = 0.5f;
    protected ColorEditDialog dialog;

    public BrightnessPanel() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public BrightnessPanel(ColorEditDialog d) {
        this.dialog = d;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Dimension size = this.getSize();
        if (size.width > 0 && size.height > 0) {
            this.backgroundImage = this.createImage(size.width, size.height);
            this.offscreen = this.createImage(size.width, size.height);
            this.recalcImage(this.backgroundImage.getGraphics());
        }
    }

    protected void recalcImage(Graphics g) {
        Rectangle bounds = this.getBounds();
        for (int i = 0; i < bounds.height; ++i) {
            float b = 1.0f - (float)i / (float)bounds.height;
            g.setColor(Color.getHSBColor(this.currentHue, this.currentSat, b));
            g.drawLine(0, i, (int)((double)bounds.width * 0.8), i);
        }
        g.setColor(this.getBackground());
        g.fillRect((int)((double)bounds.width * 0.8), 0, bounds.width - (int)((double)bounds.width * 0.8), bounds.height);
    }

    @Override
    public void paint(Graphics g) {
        this.mypaint();
    }

    public void setHueSat(float h, float s) {
        this.currentHue = h;
        this.currentSat = s;
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
            this.recalcImage(this.backgroundImage.getGraphics());
        }
        this.repaint();
    }

    public void setBrightness(float b) {
        this.currentBrightness = b;
        this.repaint();
    }

    public void setHueSatBrightness(float h, float s, float b) {
        this.currentHue = h;
        this.currentSat = s;
        this.currentBrightness = b;
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
            this.recalcImage(this.backgroundImage.getGraphics());
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point point = e.getPoint();
        this.currentBrightness = 1.0f - (float)point.y / (float)this.getBounds().height;
        this.currentBrightness = Math.max(Math.min(this.currentBrightness, 1.0f), 0.0f);
        this.dialog.setBrightness(this.currentBrightness);
        this.mypaint();
    }

    @Override
    public void update(Graphics g) {
        this.mypaint();
    }

    protected void mypaint() {
        Graphics g = this.getGraphics();
        Graphics gr = this.offscreen.getGraphics();
        int[] x = new int[3];
        int[] y = new int[3];
        x[0] = (int)((double)this.getBounds().width * 0.8);
        y[0] = (int)((1.0f - this.currentBrightness) * (float)this.getBounds().height);
        x[1] = this.getBounds().width;
        y[1] = (int)((1.0f - this.currentBrightness) * (float)this.getBounds().height) - 5;
        x[2] = this.getBounds().width;
        y[2] = (int)((1.0f - this.currentBrightness) * (float)this.getBounds().height) + 5;
        gr.drawImage(this.backgroundImage, 0, 0, this);
        gr.setColor(Color.black);
        gr.fillPolygon(x, y, 3);
        g.drawImage(this.offscreen, 0, 0, this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point point = e.getPoint();
        this.currentBrightness = 1.0f - (float)point.y / (float)this.getBounds().height;
        this.currentBrightness = Math.max(Math.min(this.currentBrightness, 1.0f), 0.0f);
        this.dialog.setBrightness(this.currentBrightness);
        this.mypaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

