/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.Vec3d;

public class BoundingBox {
    private boolean empty;
    private Vec3d minimum;
    private Vec3d maximum;
    double minX;
    double minY;
    double minZ;
    double maxX;
    double maxY;
    double maxZ;

    public BoundingBox() {
        this.empty = true;
        this.minimum = new Vec3d(0.0, 0.0, 0.0);
        this.maximum = new Vec3d(0.0, 0.0, 0.0);
    }

    public BoundingBox(BoundingBox box) {
        this.minimum = new Vec3d(box.minimum.x, box.minimum.y, box.minimum.z);
        this.maximum = new Vec3d(box.maximum.x, box.maximum.y, box.maximum.z);
        this.empty = box.empty;
    }

    public void setCenter(Vec3d center) {
        this.setCenter(center.x, center.y, center.z);
    }

    public void setCenter(double x, double y, double z) {
        double dx = (this.maximum.x - this.minimum.x) / 2.0;
        double dy = (this.maximum.y - this.minimum.y) / 2.0;
        double dz = (this.maximum.z - this.minimum.z) / 2.0;
        this.minimum.set(x - dx, y - dy, z - dz);
        this.maximum.set(x + dx, y + dy, z + dz);
        this.empty = false;
    }

    public Vec3d getCenter() {
        return new Vec3d((this.maximum.x + this.minimum.x) / 2.0, (this.maximum.y + this.minimum.y) / 2.0, (this.maximum.z + this.minimum.z) / 2.0);
    }

    public void setSize(Vec3d size) {
        this.setSize(size.x, size.y, size.z);
    }

    public void setSize(double x, double y, double z) {
        this.minimum.set((this.maximum.x + this.minimum.x - x) / 2.0, (this.maximum.y + this.minimum.y - y) / 2.0, (this.maximum.z + this.minimum.z - z) / 2.0);
        this.maximum.set(this.minimum.x + x, this.minimum.y + y, this.minimum.z + z);
        this.empty = false;
    }

    public Vec3d getSize() {
        return new Vec3d(this.maximum.x - this.minimum.x, this.maximum.y - this.minimum.y, this.maximum.z - this.minimum.z);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void makeEmpty() {
        this.empty = true;
        this.minimum.z = 0.0;
        this.minimum.y = 0.0;
        this.minimum.x = 0.0;
        this.maximum.z = 0.0;
        this.maximum.y = 0.0;
        this.maximum.x = 0.0;
    }

    public void intersection(BoundingBox box) {
        if (this.empty) {
            return;
        }
        if (box.empty) {
            this.makeEmpty();
        } else {
            if (box.minimum.x > this.maximum.x || box.maximum.x < this.minimum.x || box.minimum.y > this.maximum.y || box.maximum.y < this.minimum.y || box.minimum.z > this.maximum.z || box.maximum.z < this.minimum.z) {
                this.makeEmpty();
                return;
            }
            if (box.minimum.x > this.minimum.x) {
                this.minimum.x = box.minimum.x;
            }
            if (box.minimum.y > this.minimum.y) {
                this.minimum.y = box.minimum.y;
            }
            if (box.minimum.z > this.minimum.z) {
                this.minimum.z = box.minimum.z;
            }
            if (box.maximum.x < this.maximum.x) {
                this.maximum.x = box.maximum.x;
            }
            if (box.maximum.y < this.maximum.y) {
                this.maximum.y = box.maximum.y;
            }
            if (box.maximum.z < this.maximum.z) {
                this.maximum.z = box.maximum.z;
            }
        }
    }

    public void union(Vec3d center, Vec3d size) {
        double dx = size.x / 2.0;
        double dy = size.y / 2.0;
        double dz = size.z / 2.0;
        if (center.x - dx < this.minimum.x) {
            this.minimum.x = center.x - dx;
        }
        if (center.y - dy < this.minimum.y) {
            this.minimum.y = center.y - dy;
        }
        if (center.z - dz < this.minimum.z) {
            this.minimum.z = center.z - dz;
        }
        if (center.x + dx > this.maximum.x) {
            this.maximum.x = center.x + dx;
        }
        if (center.y + dy > this.maximum.y) {
            this.maximum.y = center.y + dy;
        }
        if (center.z + dz > this.maximum.z) {
            this.maximum.z = center.z + dz;
        }
        this.empty = false;
    }

    public void union(BoundingBox box) {
        if (box.empty) {
            return;
        }
        if (this.empty) {
            this.minimum.set(box.minimum.x, box.minimum.y, box.minimum.z);
            this.maximum.set(box.maximum.x, box.maximum.y, box.maximum.z);
            this.empty = false;
        } else {
            if (box.minimum.x < this.minimum.x) {
                this.minimum.x = box.minimum.x;
            }
            if (box.minimum.y < this.minimum.y) {
                this.minimum.y = box.minimum.y;
            }
            if (box.minimum.z < this.minimum.z) {
                this.minimum.z = box.minimum.z;
            }
            if (box.maximum.x > this.maximum.x) {
                this.maximum.x = box.maximum.x;
            }
            if (box.maximum.y > this.maximum.y) {
                this.maximum.y = box.maximum.y;
            }
            if (box.maximum.z > this.maximum.z) {
                this.maximum.z = box.maximum.z;
            }
        }
    }

    public void union(Vec3d point) {
        if (this.empty) {
            this.empty = false;
            this.minimum.set(point.x, point.y, point.z);
            this.maximum.set(point.x, point.y, point.z);
        } else {
            if (point.x < this.minimum.x) {
                this.minimum.x = point.x;
            }
            if (point.y < this.minimum.y) {
                this.minimum.y = point.y;
            }
            if (point.z < this.minimum.z) {
                this.minimum.z = point.z;
            }
            if (point.x > this.maximum.x) {
                this.maximum.x = point.x;
            }
            if (point.y > this.maximum.y) {
                this.maximum.y = point.y;
            }
            if (point.z > this.maximum.z) {
                this.maximum.z = point.z;
            }
        }
    }

    private void set(Vec3d min, Vec3d max) {
        this.minimum.set(min.x, min.y, min.z);
        this.maximum.set(max.x, max.y, max.z);
        this.empty = false;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof BoundingBox) {
            BoundingBox box = (BoundingBox)obj;
            result = this.minimum.equals(box.minimum) && this.maximum.equals(box.maximum) && this.empty == box.empty;
        }
        return result;
    }

    public void transform(double[] matrix) {
        if (this.empty) {
            return;
        }
        Vec3d aPoint = new Vec3d();
        this.minX = this.minimum.x;
        this.minY = this.minimum.y;
        this.minZ = this.minimum.z;
        this.maxX = this.maximum.x;
        this.maxY = this.maximum.y;
        this.maxZ = this.maximum.z;
        this.makeEmpty();
        this.preMultiply(matrix, this.minX, this.minY, this.minZ, aPoint);
        this.union(aPoint);
        this.preMultiply(matrix, this.minX, this.minY, this.maxZ, aPoint);
        this.union(aPoint);
        this.preMultiply(matrix, this.minX, this.maxY, this.minZ, aPoint);
        this.union(aPoint);
        this.preMultiply(matrix, this.minX, this.maxY, this.maxZ, aPoint);
        this.union(aPoint);
        this.preMultiply(matrix, this.maxX, this.minY, this.minZ, aPoint);
        this.union(aPoint);
        this.preMultiply(matrix, this.maxX, this.minY, this.maxZ, aPoint);
        this.union(aPoint);
        this.preMultiply(matrix, this.maxX, this.maxY, this.minZ, aPoint);
        this.union(aPoint);
        this.preMultiply(matrix, this.maxX, this.maxY, this.maxZ, aPoint);
        this.union(aPoint);
    }

    private void preMultiply(double[] matrix, double srcX, double srcY, double srcZ, Vec3d result) {
        result.x = srcX * matrix[0] + srcY * matrix[1] + srcZ * matrix[2] + matrix[3];
        result.y = srcX * matrix[4] + srcY * matrix[5] + srcZ * matrix[6] + matrix[7];
        result.z = srcX * matrix[8] + srcY * matrix[9] + srcZ * matrix[10] + matrix[11];
    }

    public boolean isPointContained(Vec3d point) {
        return !(point.x < this.minimum.x || point.x > this.maximum.x || point.y < this.minimum.y || point.y > this.maximum.y || point.z < this.minimum.z) && !(point.z > this.maximum.z);
    }

    public Vec3d getMinimum() {
        return this.minimum;
    }

    public Vec3d getMaximum() {
        return this.maximum;
    }
}

