/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.MultipleBoundedRangeModel;
import com.sas.graphics.util.RangeSlider;
import com.sas.graphics.util.RangeSliderUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class BasicRangeSliderUI
extends RangeSliderUI {
    protected ArrayList _thumbRects = new ArrayList();
    protected ArrayList _zOrder = new ArrayList();
    protected int _valueFocus = -1;
    protected int _extentFocus = -1;
    protected transient boolean _isDragging = false;
    protected transient boolean _isClicking = false;
    protected int _thumbSmall = 11;
    protected int _thumbLarge = 12;
    protected Color _thumbColor;
    protected Color _highlightColor;
    protected Color _shadowColor;
    protected Color _focusColor;
    protected boolean _isPopup = false;
    protected boolean _endpoint = false;
    private int _originPixel = 0;
    private double _originValue = 0.0;
    private double _pixelsPerValue = -1.0;

    public BasicRangeSliderUI(JSlider slider) {
        super(slider);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicRangeSliderUI((RangeSlider)c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this._isDragging = false;
    }

    public RangeSlider getSlider() {
        return (RangeSlider)this.slider;
    }

    @Override
    public Dimension getThumbSize() {
        Dimension size = new Dimension();
        if (this.slider.getOrientation() == 1) {
            size.width = this._thumbLarge;
            size.height = this._thumbSmall;
        } else {
            size.width = this._thumbSmall;
            size.height = this._thumbLarge;
        }
        return size;
    }

    public void setThumbSize(int size) {
        this._thumbLarge = size;
        if (this._thumbLarge % 2 == 1) {
            --this._thumbLarge;
        }
        this._thumbSmall = this._thumbLarge - 1;
        this.calculateThumbLocation();
    }

    public int getTrackBuffer() {
        return this.trackBuffer;
    }

    public Color getThumbColor() {
        return this._thumbColor != null ? this._thumbColor : this.slider.getBackground();
    }

    @Override
    public Color getHighlightColor() {
        return this._highlightColor != null ? this._highlightColor : super.getHighlightColor();
    }

    @Override
    public Color getShadowColor() {
        return this._shadowColor != null ? this._shadowColor : super.getShadowColor();
    }

    @Override
    public Color getFocusColor() {
        return this._focusColor != null ? this._focusColor : super.getFocusColor();
    }

    public void setColorScheme(Color background) {
        this.slider.setBackground(background);
        float[] hsb = Color.RGBtoHSB(background.getRed(), background.getGreen(), background.getBlue(), null);
        float fac = (double)hsb[2] > 0.5 ? 0.75f : 1.25f;
        this._thumbColor = Color.getHSBColor(hsb[0], hsb[1], Math.min(1.0f, hsb[2] * fac));
        this._highlightColor = this._thumbColor.brighter();
        this._shadowColor = this._thumbColor.darker();
    }

    public void setCalculation(int originPixel, double originValue, double pixelsPerValue) {
        this._originPixel = originPixel;
        this._originValue = originValue;
        this._pixelsPerValue = pixelsPerValue;
        this.calculateGeometry();
        this.slider.repaint();
    }

    protected int getIntForDouble(double value) {
        if (value > 2.147483647E9) {
            return 0x3FFFFFFF;
        }
        if (value < -2.147483648E9) {
            return -1073741824;
        }
        return (int)value;
    }

    @Override
    protected int xPositionForValue(int value) {
        int trackLength = this.trackRect.width;
        int trackLeft = this.trackRect.x;
        int trackRight = this.trackRect.x + (this.trackRect.width - 1);
        int off = this.getSlider().isExclusive() ? 0 : this.getSlider().getTickSpacing();
        int min = this.slider.getMinimum() - off / 2;
        int max = this.slider.getMaximum() + off / 2;
        double valueRange = max - min;
        double pixelsPerValue = (double)trackLength / valueRange;
        int xPosition = 0;
        xPosition = !this.drawInverted() ? (this._pixelsPerValue <= 0.0 ? trackLeft + this.getIntForDouble(Math.round(pixelsPerValue * (double)(value - min))) : this._originPixel + this.getIntForDouble(Math.round(this._pixelsPerValue * ((double)value - this._originValue)))) : (this._pixelsPerValue <= 0.0 ? trackRight - this.getIntForDouble(Math.round(pixelsPerValue * (double)(value - min))) : this._originPixel - this.getIntForDouble(Math.round(this._pixelsPerValue * ((double)value - this._originValue))));
        if (this.getSlider().isBounded()) {
            xPosition = Math.max(trackLeft, xPosition);
            xPosition = Math.min(trackRight, xPosition);
        }
        return xPosition;
    }

    @Override
    protected int yPositionForValue(int value) {
        int trackLength = this.trackRect.height;
        int trackTop = this.trackRect.y;
        int trackBottom = this.trackRect.y + (this.trackRect.height - 1);
        int off = this.getSlider().isExclusive() ? 0 : this.getSlider().getTickSpacing();
        int min = this.slider.getMinimum() - off / 2;
        int max = this.slider.getMaximum() + off / 2;
        double valueRange = max - min;
        double pixelsPerValue = (double)trackLength / valueRange;
        int yPosition = 0;
        yPosition = !this.drawInverted() ? (this._pixelsPerValue <= 0.0 ? trackTop + this.getIntForDouble(Math.round(pixelsPerValue * (double)(max - value))) : this._originPixel + this.getIntForDouble(Math.round(this._pixelsPerValue * ((double)value - this._originValue)))) : (this._pixelsPerValue <= 0.0 ? trackTop + this.getIntForDouble(Math.round(pixelsPerValue * (double)(value - min))) : this._originPixel - this.getIntForDouble(Math.round(this._pixelsPerValue * (this._originValue - (double)value))));
        if (this.getSlider().isBounded()) {
            yPosition = Math.max(trackTop, yPosition);
            yPosition = Math.min(trackBottom, yPosition);
        }
        return yPosition;
    }

    @Override
    public int valueForXPosition(int xPos) {
        int off = this.getSlider().isExclusive() ? 0 : this.getSlider().getTickSpacing();
        int min = this.slider.getMinimum() - off / 2;
        int max = this.slider.getMaximum() + off / 2;
        int trackLength = this.trackRect.width;
        int trackLeft = this.trackRect.x;
        int value = 0;
        if (this._pixelsPerValue <= 0.0) {
            double valueRange = max - min;
            double valuePerPixel = valueRange / (double)trackLength;
            int valueFromLeft = (int)Math.round((double)(xPos - trackLeft) * valuePerPixel);
            value = this.drawInverted() ? max - valueFromLeft : min + valueFromLeft;
        } else {
            value = !this.drawInverted() ? (int)Math.round(this._originValue + (double)(xPos - this._originPixel) / this._pixelsPerValue) : (int)Math.round(this._originValue - (double)(this._originPixel - xPos) / this._pixelsPerValue);
        }
        if (this.getSlider().isBounded()) {
            value = Math.max(value, min);
            value = Math.min(value, max);
        }
        return value;
    }

    @Override
    public int valueForYPosition(int yPos) {
        int off = this.getSlider().isExclusive() ? 0 : this.getSlider().getTickSpacing();
        int min = this.slider.getMinimum() - off / 2;
        int max = this.slider.getMaximum() + off / 2;
        int trackLength = this.trackRect.height - 1;
        int trackTop = this.trackRect.y;
        int value = 0;
        if (this._pixelsPerValue <= 0.0) {
            double valueRange = max - min;
            double valuePerPixel = valueRange / (double)trackLength;
            int valueFromLeft = (int)Math.round((double)(yPos - trackTop) * valuePerPixel);
            value = this.drawInverted() ? min + valueFromLeft : max - valueFromLeft;
        } else {
            value = !this.drawInverted() ? (int)Math.round(this._originValue - (double)(this._originPixel - yPos) / this._pixelsPerValue) : (int)Math.round(this._originValue + (double)(yPos - this._originPixel) / this._pixelsPerValue);
        }
        if (this.getSlider().isBounded()) {
            value = Math.max(value, min);
            value = Math.min(value, max);
        }
        return value;
    }

    @Override
    protected void calculateTrackRect() {
        super.calculateTrackRect();
        int off = this.getSlider().isExclusive() ? 0 : this.getSlider().getTickSpacing();
        int min = this.slider.getMinimum() - off / 2;
        int max = this.slider.getMaximum() + off / 2;
        int vmin = ((RangeSlider)this.slider).getVisibleMinimum();
        int vmax = ((RangeSlider)this.slider).getVisibleMaximum();
        if (vmax > vmin) {
            if (this.slider.getOrientation() == 0) {
                this.trackRect.x -= this.trackBuffer;
                this.trackRect.width += 2 * this.trackBuffer;
                this.trackRect.x = (int)Math.round((double)this.trackRect.x + (double)this.trackRect.width * (double)(this.drawInverted() ? vmax - max : min - vmin) / (double)(vmax - vmin));
                this.trackRect.width = (int)Math.round((double)this.trackRect.width * (double)(max - min) / (double)(vmax - vmin));
                this.trackRect.x += this.trackBuffer;
                this.trackRect.width -= 2 * this.trackBuffer;
            } else {
                this.trackRect.y -= this.trackBuffer;
                this.trackRect.height += 2 * this.trackBuffer;
                this.trackRect.y = (int)Math.round((double)this.trackRect.y + (double)this.trackRect.height * (double)(this.drawInverted() ? min - vmin : vmax - max) / (double)(vmax - vmin));
                this.trackRect.height = (int)Math.round((double)this.trackRect.height * (double)(max - min) / (double)(vmax - vmin));
                this.trackRect.y += this.trackBuffer;
                this.trackRect.height -= 2 * this.trackBuffer;
            }
        }
    }

    @Override
    protected void calculateThumbLocation() {
        int nRects = 2 * ((RangeSlider)this.slider).ranges();
        if (this._thumbRects.size() != nRects || this._zOrder.size() != nRects) {
            this._thumbRects = new ArrayList(nRects);
            this._zOrder = new ArrayList(nRects);
            for (int i = 0; i < nRects; ++i) {
                this._thumbRects.add(new Rectangle(0, 0, this.getThumbSize().width, this.getThumbSize().height));
                this._zOrder.add(new Integer(i));
            }
            this.focusTop(this.getValueFocus(), this.getExtentFocus());
        }
        int tickSpacing = this.getSlider().getTickSpacing();
        int min = this.slider.getMinimum();
        for (int i = 0; i < nRects; ++i) {
            int sliderValue = ((RangeSlider)this.slider).getValue(i / 2);
            if (i % 2 == 1) {
                sliderValue += Math.max(0, ((RangeSlider)this.slider).getExtent(i / 2));
            }
            if (this.slider.getSnapToTicks() && tickSpacing != 0) {
                int snappedValue = sliderValue;
                if ((sliderValue - min) % tickSpacing != 0) {
                    float temp = (float)(sliderValue - min) / (float)tickSpacing;
                    float fuzz = 1.0E-5f * (float)tickSpacing;
                    int whichTick = Math.round(temp + (i % 2 == 0 ? fuzz : -fuzz));
                    snappedValue = min + whichTick * tickSpacing;
                }
                if (sliderValue != snappedValue) {
                    int ext = ((RangeSlider)this.slider).getExtent(i / 2);
                    if (i % 2 == 0) {
                        if (ext >= 0 && ext != tickSpacing * (ext / tickSpacing)) {
                            ((RangeSlider)this.slider).setRange(i / 2, snappedValue, ext + sliderValue - snappedValue);
                        } else {
                            ((RangeSlider)this.slider).setValue(i / 2, snappedValue);
                        }
                    } else if (ext >= 0) {
                        ((RangeSlider)this.slider).setExtent(i / 2, snappedValue - ((RangeSlider)this.slider).getValue(i / 2));
                    }
                    sliderValue = snappedValue;
                }
            }
            if (!this.getSlider().isExclusive()) {
                sliderValue = i % 2 == 0 ? (sliderValue -= tickSpacing / 2) : (sliderValue += tickSpacing / 2);
            }
            Rectangle r = (Rectangle)this._thumbRects.get(i);
            if (this.slider.getOrientation() == 0) {
                r.y = this.trackRect.y;
                r.x = this.xPositionForValue(sliderValue) - r.width / 2;
            } else {
                r.x = this.trackRect.x;
                r.y = this.yPositionForValue(sliderValue) - r.height / 2;
            }
            r.width = this.getThumbSize().width;
            r.height = this.getThumbSize().height;
        }
    }

    protected void top(int i) {
        int found = -1;
        for (int j = 0; j < this._zOrder.size() && found < 0; ++j) {
            if (i != (Integer)this._zOrder.get(j)) continue;
            found = j;
        }
        if (this._zOrder.size() > 0) {
            this._zOrder.remove(found);
            this._zOrder.add(new Integer(i));
        }
    }

    protected boolean onThumb(int x, int y, int i) {
        Rectangle r = (Rectangle)this._thumbRects.get(i);
        return r.x <= x && x < r.x + r.width && r.y <= y && y < r.y + r.height;
    }

    protected boolean onRange(int x, int y, int i) {
        Rectangle r = this.getRangeRectangle(i);
        return r.x <= x && x < r.x + r.width && r.y <= y && y < r.y + r.height;
    }

    protected Rectangle getRangeRectangle(int i) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        Rectangle r0 = (Rectangle)this._thumbRects.get(2 * i);
        Rectangle r1 = (Rectangle)this._thumbRects.get(2 * i + 1);
        r.x = Math.min(r0.x, r1.x);
        r.y = Math.min(r0.y, r1.y);
        if (this.slider.getOrientation() == 0) {
            int d = this.getThumbSize().height / 4;
            r.y += d;
            r.height = this.getThumbSize().height - 2 * d;
            r.x += this.getThumbSize().width / 2;
            r.width = Math.abs(r1.x - r0.x);
        } else {
            int d = this.getThumbSize().width / 4;
            r.x += d;
            r.width = this.getThumbSize().width - 2 * d;
            r.y += this.getThumbSize().height / 2;
            r.height = Math.abs(r1.y - r0.y);
        }
        return r;
    }

    @Override
    public void paintThumb(Graphics g) {
        int nRects = this._thumbRects.size();
        boolean[] rangePainted = new boolean[nRects / 2];
        for (int i = 0; i < nRects; ++i) {
            int j = (Integer)this._zOrder.get(i);
            if (!rangePainted[j / 2]) {
                rangePainted[j / 2] = true;
                this.paintRange(g, j / 2);
            }
            this.paintThumb(g, j);
        }
    }

    public void paintThumb(Graphics g, int i) {
        boolean focused = i == this.getValueFocus() || i == this.getExtentFocus();
        Rectangle r = (Rectangle)this._thumbRects.get(i);
        g.translate(r.x, r.y);
        if (i % 2 == 0) {
            if (this.getSlider().getExtent(i / 2) >= 0) {
                if (this.getSlider().getValueInclusive(i / 2)) {
                    this.paintThumbValueInclusive(g, i, r.width, r.height, focused, this.drawInverted());
                } else {
                    this.paintThumbValueExclusive(g, i, r.width, r.height, focused, this.drawInverted());
                }
            } else {
                this.paintThumbValue(g, i, r.width, r.height, focused, this.drawInverted());
            }
        } else if (this.getSlider().getExtent(i / 2) >= 0) {
            if (this.getSlider().getExtentInclusive(i / 2)) {
                this.paintThumbExtentInclusive(g, i, r.width, r.height, focused, this.drawInverted());
            } else {
                this.paintThumbExtentExclusive(g, i, r.width, r.height, focused, this.drawInverted());
            }
        }
        g.translate(-r.x, -r.y);
    }

    public void paintRange(Graphics g, int i) {
        boolean focused;
        if (((RangeSlider)this.slider).getExtent(i) < 0) {
            return;
        }
        Rectangle r = this.getRangeRectangle(i);
        int x = r.x;
        int y = r.y;
        int w = r.width;
        int h = r.height;
        g.translate(x, y);
        boolean bl = focused = 2 * i == this.getValueFocus() && 2 * i + 1 == this.getExtentFocus();
        if (this.slider.isEnabled()) {
            if (focused) {
                g.setColor(this.getFocusColor());
            } else {
                g.setColor(this.getThumbColor());
            }
        } else {
            g.setColor(this.getThumbColor().darker());
        }
        g.fillRect(0, 0, w - 1, h - 1);
        g.setColor(this.getHighlightColor());
        g.drawLine(0, 0, w - 1, 0);
        g.drawLine(0, 0, 0, h - 1);
        if (!focused) {
            g.setColor(this.getShadowColor());
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.drawLine(w - 2, 1, w - 2, h - 2);
        }
        g.setColor(Color.black);
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 0, w - 1, h - 1);
        g.translate(-x, -y);
    }

    public void paintThumbValue(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        if (this.slider.isEnabled()) {
            g.setColor(focused ? this.getFocusColor() : this.getThumbColor());
        } else {
            g.setColor(this.getThumbColor().darker());
        }
        g.fillRect(0, 0, w - 1, h - 1);
        g.setColor(this.getHighlightColor());
        g.drawLine(0, 0, w - 1, 0);
        g.drawLine(0, 0, 0, h - 1);
        if (!focused) {
            g.setColor(this.getShadowColor());
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.drawLine(w - 2, 1, w - 2, h - 2);
        }
        g.setColor(Color.black);
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.drawLine(w - 1, 0, w - 1, h - 1);
    }

    public void paintThumbValueInclusive(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        this.paintThumbValue(g, i, w, h, focused, inverted);
    }

    public void paintThumbValueExclusive(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        this.paintThumbValue(g, i, w, h, focused, inverted);
    }

    public void paintThumbExtentInclusive(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        this.paintThumbValue(g, i, w, h, focused, inverted);
    }

    public void paintThumbExtentExclusive(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        this.paintThumbValue(g, i, w, h, focused, inverted);
    }

    @Override
    protected FocusListener createFocusListener(JSlider slider) {
        return new RangeFocusHandler();
    }

    private void focusTop(int valueFocus, int extentFocus) {
        this.setValueFocus(valueFocus);
        this.setExtentFocus(extentFocus);
        if (valueFocus >= 0) {
            if (extentFocus < 0) {
                this.top(valueFocus + 1);
            }
            this.top(valueFocus);
        }
        if (extentFocus >= 0) {
            if (valueFocus < 0) {
                this.top(extentFocus - 1);
            }
            this.top(extentFocus);
        }
    }

    @Override
    protected void installKeyboardActions(JSlider slider) {
        super.installKeyboardActions(slider);
        slider.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "Tab");
        slider.getActionMap().put("Tab", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int valueFocus = BasicRangeSliderUI.this.getValueFocus();
                int extentFocus = BasicRangeSliderUI.this.getExtentFocus();
                if (valueFocus < 0 && extentFocus < 0) {
                    valueFocus = 0;
                    extentFocus = -1;
                } else if (BasicRangeSliderUI.this.getSlider().getExtent(Math.max(valueFocus, extentFocus) / 2) < 0) {
                    valueFocus = valueFocus >= 0 ? (valueFocus += 2) : extentFocus + 1;
                    if (valueFocus >= 2 * BasicRangeSliderUI.this.getSlider().ranges()) {
                        valueFocus = 0;
                    }
                    extentFocus = -1;
                } else if (valueFocus >= 0 && extentFocus >= 0) {
                    valueFocus = -1;
                } else if (extentFocus < 0) {
                    extentFocus = valueFocus + 1;
                } else {
                    valueFocus = extentFocus + 1;
                    if (valueFocus >= 2 * BasicRangeSliderUI.this.getSlider().ranges()) {
                        valueFocus = 0;
                    }
                    extentFocus = -1;
                }
                if (BasicRangeSliderUI.this.getSlider().getExtent(extentFocus / 2) < 0) {
                    valueFocus = extentFocus - 1;
                    extentFocus = -1;
                }
                BasicRangeSliderUI.this.focusTop(valueFocus, extentFocus);
                BasicRangeSliderUI.this.getSlider().repaint();
            }
        });
        slider.getInputMap().put(KeyStroke.getKeyStroke(9, 1), "ShiftTab");
        slider.getActionMap().put("ShiftTab", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int valueFocus = BasicRangeSliderUI.this.getValueFocus();
                int extentFocus = BasicRangeSliderUI.this.getExtentFocus();
                if (valueFocus < 0 && extentFocus < 0) {
                    valueFocus = 0;
                    extentFocus = -1;
                } else if (BasicRangeSliderUI.this.getSlider().getExtent(Math.max(valueFocus, extentFocus) / 2) < 0) {
                    extentFocus = extentFocus >= 0 ? (extentFocus -= 2) : valueFocus - 1;
                    if (extentFocus < 0) {
                        extentFocus = 2 * BasicRangeSliderUI.this.getSlider().ranges() - 1;
                    }
                    valueFocus = -1;
                } else if (valueFocus >= 0 && extentFocus >= 0) {
                    extentFocus = -1;
                } else if (valueFocus < 0) {
                    valueFocus = extentFocus - 1;
                } else {
                    extentFocus = valueFocus - 1;
                    if (extentFocus < 0) {
                        extentFocus = 2 * BasicRangeSliderUI.this.getSlider().ranges() - 1;
                    }
                    valueFocus = -1;
                }
                if (BasicRangeSliderUI.this.getSlider().getExtent(extentFocus / 2) < 0) {
                    valueFocus = extentFocus - 1;
                    extentFocus = -1;
                }
                BasicRangeSliderUI.this.focusTop(valueFocus, extentFocus);
                BasicRangeSliderUI.this.getSlider().repaint();
            }
        });
        slider.getInputMap().put(KeyStroke.getKeyStroke(9, 2), "CtrlTab");
        slider.getActionMap().put("CtrlTab", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicRangeSliderUI.this.getSlider().transferFocusUpCycle();
                BasicRangeSliderUI.this.getSlider().transferFocus();
            }
        });
        slider.getInputMap().put(KeyStroke.getKeyStroke(9, 3), "CtrlShiftTab");
        slider.getActionMap().put("CtrlShiftTab", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicRangeSliderUI.this.getSlider().transferFocusUpCycle();
                BasicRangeSliderUI.this.getSlider().transferFocusBackward();
            }
        });
        slider.setFocusTraversalKeysEnabled(false);
        slider.setFocusCycleRoot(true);
    }

    @Override
    protected ChangeListener createChangeListener(JSlider slider) {
        return new RangeChangeHandler();
    }

    public void newRange() {
        int value = this.slider.getOrientation() == 1 ? this.valueForYPosition(((RangeTrackListener)this.trackListener).getPreviousMouseY()) : this.valueForXPosition(((RangeTrackListener)this.trackListener).getPreviousMouseX());
        int limit = this.slider.getOrientation() == 1 ? this.valueForYPosition(((RangeTrackListener)this.trackListener).getMouseY()) : this.valueForXPosition(((RangeTrackListener)this.trackListener).getMouseX());
        int extent = 0;
        if (this.getSlider().isExclusive()) {
            extent = Math.abs(limit - value);
            value = Math.min(value, limit);
            extent = this.getSlider().getSnapToTicks() ? Math.max(extent, this.getSlider().getTickSpacing()) : Math.max(extent, (this.getSlider().getMaximum() - this.getSlider().getMinimum()) / 10);
        }
        MultipleBoundedRangeModel model = (MultipleBoundedRangeModel)this.slider.getModel();
        int[] newRange = model.correctAdd(value, extent);
        model.add(newRange[0], true, newRange[1], true);
    }

    public void newValue() {
        int value = this.slider.getOrientation() == 1 ? this.valueForYPosition(((RangeTrackListener)this.trackListener).getPreviousMouseY()) : this.valueForXPosition(((RangeTrackListener)this.trackListener).getPreviousMouseX());
        int extent = -1;
        MultipleBoundedRangeModel model = (MultipleBoundedRangeModel)this.slider.getModel();
        int[] newRange = model.correctAdd(value, extent);
        model.add(newRange[0], true, newRange[1], false);
    }

    public void rangeValue() {
        int valueFocus = this.getValueFocus();
        int extentFocus = this.getExtentFocus();
        MultipleBoundedRangeModel model = (MultipleBoundedRangeModel)this.slider.getModel();
        int i = Math.max(valueFocus >= 0 ? valueFocus / 2 : extentFocus / 2, 0);
        int extent = (this.getSlider().getMaximum() - this.getSlider().getMinimum()) / 10;
        model.setExtent(i, model.getExtent(i) < 0 ? extent : -1);
    }

    public void includeExclude() {
        int valueFocus = this.getValueFocus();
        int extentFocus = this.getExtentFocus();
        MultipleBoundedRangeModel model = (MultipleBoundedRangeModel)this.slider.getModel();
        if (valueFocus >= 0 && valueFocus < model.ranges() * 2 - 1) {
            model.setValueInclusive(valueFocus / 2, !model.getValueInclusive(valueFocus / 2));
        }
        if (extentFocus >= 0 && extentFocus < model.ranges() * 2) {
            model.setExtentInclusive(extentFocus / 2, !model.getExtentInclusive(extentFocus / 2));
        }
    }

    public void delete() {
        int valueFocus = this.getValueFocus();
        int extentFocus = this.getExtentFocus();
        this.setValueFocus(0);
        this.setExtentFocus(-1);
        MultipleBoundedRangeModel model = (MultipleBoundedRangeModel)this.slider.getModel();
        if (valueFocus >= 0 && (extentFocus >= 0 || model.getExtent(valueFocus / 2) < 0)) {
            model.remove(valueFocus / 2);
        } else if (valueFocus >= 0) {
            model.setRange(valueFocus / 2, model.getValue(valueFocus / 2) + model.getExtent(valueFocus / 2), -1);
        } else if (extentFocus >= 0) {
            model.setExtent(extentFocus / 2, -1);
        }
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new RangeTrackListener();
    }

    protected boolean isAddEnabled() {
        boolean isEnabled = false;
        MultipleBoundedRangeModel model = (MultipleBoundedRangeModel)this.slider.getModel();
        if (model.isBounded() && model.ranges() > 0) {
            int[] gap = model.correctAdd(model.getMinimum(), model.getMaximum() - model.getMinimum());
            isEnabled = this.getSlider().isExclusive() ? gap[1] > 0 : gap[1] >= 0;
        } else {
            isEnabled = true;
        }
        return isEnabled;
    }

    @Override
    public void scrollByBlock(int direction) {
        this.scrollByUnit(direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int i = 0;
            if (this.getValueFocus() >= 0) {
                i = this.getValueFocus() / 2;
            } else if (this.getExtentFocus() >= 0) {
                i = this.getExtentFocus() / 2;
            }
            int oldValue = ((RangeSlider)this.slider).getValue(i);
            int oldExtent = ((RangeSlider)this.slider).getExtent(i);
            int delta = 1 * (direction > 0 ? 1 : -1);
            if (this.slider.getSnapToTicks()) {
                delta *= this.slider.getMinorTickSpacing();
            }
            if (this.getValueFocus() >= 0 && this.getExtentFocus() >= 0) {
                ((RangeSlider)this.slider).setValue(i, oldValue + delta);
            } else if (this.getValueFocus() >= 0) {
                if (delta > oldExtent) {
                    delta = oldExtent;
                }
                ((RangeSlider)this.slider).setRange(i, oldValue + delta, oldExtent - delta);
            } else if (this.getExtentFocus() >= 0) {
                if (delta < -oldExtent) {
                    delta = -oldExtent;
                }
                ((RangeSlider)this.slider).setExtent(i, oldExtent + delta);
            }
        }
    }

    public int getValueFocus() {
        return this._valueFocus;
    }

    public void setValueFocus(int i) {
        this._valueFocus = i;
    }

    public int getExtentFocus() {
        return this._extentFocus;
    }

    public void setExtentFocus(int i) {
        this._extentFocus = i;
    }

    public Insets getFocusInsets() {
        return this.focusInsets;
    }

    public int getRangeIndex() {
        int i = -1;
        int[] focus = ((RangeTrackListener)this.trackListener).findValueAndExtent();
        if (focus[0] >= 0) {
            i = focus[0] / 2;
        } else if (focus[1] >= 0) {
            i = focus[1] / 2;
        }
        return i;
    }

    public int getRangePart() {
        int i = 0;
        int[] focus = ((RangeTrackListener)this.trackListener).findValueAndExtent();
        if (focus[0] >= 0 && focus[1] < 0) {
            i = -1;
        } else if (focus[0] < 0 && focus[1] >= 0) {
            i = 1;
        }
        return i;
    }

    public class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        protected transient int previousMouseX;
        protected transient int previousMouseY;

        public RangeTrackListener() {
            super(BasicRangeSliderUI.this);
        }

        public int getPreviousMouseX() {
            return this.previousMouseX;
        }

        public int getPreviousMouseY() {
            return this.previousMouseY;
        }

        public int getMouseX() {
            return this.currentMouseX;
        }

        public int getMouseY() {
            return this.currentMouseY;
        }

        public void showPopup(MouseEvent e) {
            if (BasicRangeSliderUI.this.getSlider().getPopupMenu() != null) {
                MultipleBoundedRangeModel model = (MultipleBoundedRangeModel)BasicRangeSliderUI.this.slider.getModel();
                if (!(BasicRangeSliderUI.this.getValueFocus() >= 0 && BasicRangeSliderUI.this.getValueFocus() < model.ranges() * 2 - 1 || BasicRangeSliderUI.this.getExtentFocus() >= 0 && BasicRangeSliderUI.this.getExtentFocus() < model.ranges() * 2)) {
                    BasicRangeSliderUI.this.getSlider().getIncludeExcludeAction().setEnabled(false);
                } else {
                    BasicRangeSliderUI.this.getSlider().getIncludeExcludeAction().setEnabled(true);
                }
                BasicRangeSliderUI.this.getSlider().getDeleteAction().setEnabled(model.ranges() > 0);
                BasicRangeSliderUI.this.getSlider().getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                BasicRangeSliderUI.this._isPopup = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            MultipleBoundedRangeModel model = (MultipleBoundedRangeModel)BasicRangeSliderUI.this.slider.getModel();
            int i = 0;
            if (BasicRangeSliderUI.this.getValueFocus() >= 0) {
                i = BasicRangeSliderUI.this.getValueFocus() / 2;
            } else if (BasicRangeSliderUI.this.getExtentFocus() >= 0) {
                i = BasicRangeSliderUI.this.getExtentFocus() / 2;
            }
            if (BasicRangeSliderUI.this._endpoint) {
                model.setEndpoint(BasicRangeSliderUI.this._endpoint);
                if (BasicRangeSliderUI.this.getSlider().ranges() > 0) {
                    model.correctInclusive(i);
                    BasicRangeSliderUI.this.slider.repaint();
                }
            }
            this.offset = 0;
            BasicRangeSliderUI.this.scrollTimer.stop();
            BasicRangeSliderUI.this._isDragging = false;
            BasicRangeSliderUI.this.slider.setValueIsAdjusting(false);
            if (e.isPopupTrigger() && BasicRangeSliderUI.this.getSlider().getPopupMenu() != null) {
                this.showPopup(e);
                BasicRangeSliderUI.this._isClicking = false;
                return;
            }
            if (BasicRangeSliderUI.this._isClicking) {
                BasicRangeSliderUI.this._isClicking = false;
                int[] focus = this.findValueAndExtent();
                if (focus[0] < 0 && focus[1] < 0 && BasicRangeSliderUI.this.isAddEnabled()) {
                    BasicRangeSliderUI.this.newRange();
                }
            }
        }

        public int[] findValueAndExtent() {
            int j;
            int i;
            int[] focus = new int[]{-1, -1};
            int nRects = BasicRangeSliderUI.this._thumbRects.size();
            for (i = nRects - 1; i >= 0 && focus[0] < 0 && focus[1] < 0; --i) {
                j = (Integer)BasicRangeSliderUI.this._zOrder.get(i);
                if (!BasicRangeSliderUI.this.onThumb(this.currentMouseX, this.currentMouseY, j)) continue;
                if (j % 2 == 0) {
                    focus[0] = j;
                    continue;
                }
                focus[1] = j;
            }
            for (i = nRects - 1; i >= 0 && focus[0] < 0 && focus[1] < 0; --i) {
                j = (Integer)BasicRangeSliderUI.this._zOrder.get(i);
                if (!BasicRangeSliderUI.this.onRange(this.currentMouseX, this.currentMouseY, j / 2)) continue;
                focus[0] = 2 * (j / 2);
                focus[1] = 2 * (j / 2) + 1;
            }
            if (focus[0] < 0 && focus[1] >= 0 && ((RangeSlider)BasicRangeSliderUI.this.slider).getExtent(focus[1] / 2) < 0) {
                focus[0] = focus[1] - 1;
            }
            if (focus[0] >= 0 && focus[1] < 0 && ((RangeSlider)BasicRangeSliderUI.this.slider).getExtent(focus[0] / 2) < 0) {
                focus[1] = focus[0] + 1;
            }
            return focus;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (BasicRangeSliderUI.this.slider.isRequestFocusEnabled()) {
                BasicRangeSliderUI.this.slider.requestFocus();
            }
            this.previousMouseX = e.getX();
            this.previousMouseY = e.getY();
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            BasicRangeSliderUI.this._isDragging = false;
            BasicRangeSliderUI.this.slider.setValueIsAdjusting(true);
            if (BasicRangeSliderUI.this.getSlider().ranges() <= 0) {
                if (BasicRangeSliderUI.this.getSlider().isClickCreate()) {
                    BasicRangeSliderUI.this._isClicking = true;
                }
                return;
            }
            int[] focus = this.findValueAndExtent();
            int valueFocus = focus[0];
            int extentFocus = focus[1];
            MultipleBoundedRangeModel model = (MultipleBoundedRangeModel)BasicRangeSliderUI.this.slider.getModel();
            BasicRangeSliderUI.this._endpoint = model.isEndpoint();
            model.setEndpoint(false);
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (valueFocus >= 0 || extentFocus >= 0) {
                BasicRangeSliderUI.this.focusTop(valueFocus, extentFocus);
                rect = valueFocus >= 0 ? (Rectangle)BasicRangeSliderUI.this._thumbRects.get(valueFocus) : (Rectangle)BasicRangeSliderUI.this._thumbRects.get(extentFocus);
                this.offset = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? this.currentMouseY - rect.y : this.currentMouseX - rect.x;
            }
            if (e.isPopupTrigger() && BasicRangeSliderUI.this.getSlider().getPopupMenu() != null) {
                this.showPopup(e);
                return;
            }
            if (valueFocus >= 0 || extentFocus >= 0) {
                BasicRangeSliderUI.this._isDragging = true;
                return;
            }
            if (BasicRangeSliderUI.this.getSlider().isClickCreate()) {
                BasicRangeSliderUI.this._isClicking = true;
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            rect = new Rectangle(0, 0, 0, 0);
            if (BasicRangeSliderUI.this.getValueFocus() >= 0) {
                rect = (Rectangle)BasicRangeSliderUI.this._thumbRects.get(BasicRangeSliderUI.this.getValueFocus());
            } else if (BasicRangeSliderUI.this.getExtentFocus() >= 0) {
                rect = (Rectangle)BasicRangeSliderUI.this._thumbRects.get(BasicRangeSliderUI.this.getExtentFocus());
            }
            if (rect.isEmpty()) {
                return;
            }
            int direction = 1;
            direction = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? (!BasicRangeSliderUI.this.drawInverted() ? (this.currentMouseY < rect.y ? 1 : -1) : (this.currentMouseY < rect.y ? -1 : 1)) : (!BasicRangeSliderUI.this.drawInverted() ? (this.currentMouseX < rect.x ? -1 : 1) : (this.currentMouseX < rect.x ? 1 : -1));
            BasicRangeSliderUI.this.scrollByUnit(direction);
            if (!rect.contains(this.currentMouseX, this.currentMouseY) && this.shouldScroll(direction)) {
                BasicRangeSliderUI.this.scrollTimer.stop();
                BasicRangeSliderUI.this.scrollListener.setDirection(direction);
                BasicRangeSliderUI.this.scrollTimer.start();
            }
        }

        @Override
        public boolean shouldScroll(int direction) {
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (BasicRangeSliderUI.this.getValueFocus() >= 0) {
                rect = (Rectangle)BasicRangeSliderUI.this._thumbRects.get(BasicRangeSliderUI.this.getValueFocus());
            } else if (BasicRangeSliderUI.this.getExtentFocus() >= 0) {
                rect = (Rectangle)BasicRangeSliderUI.this._thumbRects.get(BasicRangeSliderUI.this.getExtentFocus());
            }
            if (rect.isEmpty()) {
                return false;
            }
            if (BasicRangeSliderUI.this.slider.getOrientation() == 1 ? ((BasicRangeSliderUI.this.drawInverted() ? direction < 0 : direction > 0) ? rect.y + rect.height <= this.currentMouseY : rect.y >= this.currentMouseY) : ((BasicRangeSliderUI.this.drawInverted() ? direction < 0 : direction > 0) ? rect.x + rect.width >= this.currentMouseX : rect.x <= this.currentMouseX)) {
                return false;
            }
            if (BasicRangeSliderUI.this.getSlider().isBounded()) {
                int i = 0;
                if (BasicRangeSliderUI.this.getValueFocus() >= 0) {
                    i = BasicRangeSliderUI.this.getValueFocus() / 2;
                } else if (BasicRangeSliderUI.this.getExtentFocus() >= 0) {
                    i = BasicRangeSliderUI.this.getExtentFocus() / 2;
                }
                if (direction > 0 ? ((RangeSlider)BasicRangeSliderUI.this.slider).getValue(i) + ((RangeSlider)BasicRangeSliderUI.this.slider).getExtent(i) >= BasicRangeSliderUI.this.slider.getMaximum() : direction < 0 && ((RangeSlider)BasicRangeSliderUI.this.slider).getValue(i) <= BasicRangeSliderUI.this.slider.getMinimum()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int off;
            if (!BasicRangeSliderUI.this.slider.isEnabled() || !BasicRangeSliderUI.this._isDragging || ((RangeSlider)BasicRangeSliderUI.this.slider).ranges() <= 0) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            int i = 0;
            if (BasicRangeSliderUI.this.getValueFocus() >= 0) {
                i = BasicRangeSliderUI.this.getValueFocus() / 2;
            } else if (BasicRangeSliderUI.this.getExtentFocus() >= 0) {
                i = BasicRangeSliderUI.this.getExtentFocus() / 2;
            }
            int delta = 0;
            int oldValue = ((RangeSlider)BasicRangeSliderUI.this.slider).getValue(i);
            int oldExtent = ((RangeSlider)BasicRangeSliderUI.this.slider).getExtent(i);
            int n = off = BasicRangeSliderUI.this.getSlider().isExclusive() ? 0 : BasicRangeSliderUI.this.getSlider().getTickSpacing();
            if (BasicRangeSliderUI.this.slider.getOrientation() == 1) {
                int thumbTop = e.getY() - this.offset;
                int halfThumbHeight = ((BasicRangeSliderUI)BasicRangeSliderUI.this).thumbRect.height / 2;
                if (BasicRangeSliderUI.this.getSlider().isBounded()) {
                    int yMin = BasicRangeSliderUI.this.yPositionForValue(BasicRangeSliderUI.this.slider.getMinimum() - off / 2);
                    int yMax = BasicRangeSliderUI.this.yPositionForValue(BasicRangeSliderUI.this.slider.getMaximum() + off / 2);
                    thumbTop = Math.min(thumbTop, Math.max(yMin, yMax) - halfThumbHeight);
                    thumbTop = Math.max(thumbTop, Math.min(yMin, yMax) - halfThumbHeight);
                }
                delta = BasicRangeSliderUI.this.valueForYPosition(thumbTop + halfThumbHeight) - oldValue;
            } else {
                int thumbLeft = e.getX() - this.offset;
                int halfThumbWidth = ((BasicRangeSliderUI)BasicRangeSliderUI.this).thumbRect.width / 2;
                if (BasicRangeSliderUI.this.getSlider().isBounded()) {
                    int xMin = BasicRangeSliderUI.this.xPositionForValue(BasicRangeSliderUI.this.slider.getMinimum() - off / 2);
                    int xMax = BasicRangeSliderUI.this.xPositionForValue(BasicRangeSliderUI.this.slider.getMaximum() + off / 2);
                    thumbLeft = Math.min(thumbLeft, Math.max(xMin, xMax) - halfThumbWidth);
                    thumbLeft = Math.max(thumbLeft, Math.min(xMin, xMax) - halfThumbWidth);
                }
                delta = BasicRangeSliderUI.this.valueForXPosition(thumbLeft + halfThumbWidth) - oldValue;
            }
            delta = BasicRangeSliderUI.this.getValueFocus() >= 0 ? (delta += off / 2) : (delta -= off / 2);
            BasicRangeSliderUI.this.slider.setValueIsAdjusting(true);
            if (BasicRangeSliderUI.this.getValueFocus() >= 0 && BasicRangeSliderUI.this.getExtentFocus() >= 0) {
                ((RangeSlider)BasicRangeSliderUI.this.slider).setValue(i, oldValue + delta);
            } else if (BasicRangeSliderUI.this.getValueFocus() >= 0) {
                if (delta > oldExtent) {
                    delta = oldExtent;
                }
                ((RangeSlider)BasicRangeSliderUI.this.slider).setRange(i, oldValue + delta, oldExtent - delta);
            } else if (BasicRangeSliderUI.this.getExtentFocus() >= 0) {
                if ((delta -= oldExtent) < -oldExtent) {
                    delta = -oldExtent;
                }
                ((RangeSlider)BasicRangeSliderUI.this.slider).setExtent(i, oldExtent + delta);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!BasicRangeSliderUI.this.getSlider().isCursorFeedback()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            int[] focus = this.findValueAndExtent();
            int valueFocus = focus[0];
            int extentFocus = focus[1];
            int cursor = 0;
            if (valueFocus >= 0 && extentFocus >= 0) {
                cursor = 12;
            } else if (valueFocus >= 0 || extentFocus >= 0) {
                cursor = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? (valueFocus >= 0 == BasicRangeSliderUI.this.drawInverted() ? 8 : 9) : (valueFocus >= 0 == BasicRangeSliderUI.this.drawInverted() ? 11 : 10);
            }
            BasicRangeSliderUI.this.slider.setCursor(new Cursor(cursor));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    public class RangeChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            BasicRangeSliderUI.this.calculateGeometry();
            BasicRangeSliderUI.this.slider.repaint();
            MultipleBoundedRangeModel model = (MultipleBoundedRangeModel)BasicRangeSliderUI.this.slider.getModel();
            if (!model.getValueIsAdjusting()) {
                BasicRangeSliderUI.this.getSlider().getDeleteAction().setEnabled(model.ranges() > 0);
                BasicRangeSliderUI.this.getSlider().getNewRangeAction().setEnabled(BasicRangeSliderUI.this.isAddEnabled());
            }
        }
    }

    public class RangeFocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            if (BasicRangeSliderUI.this.getValueFocus() < 0 && BasicRangeSliderUI.this.getExtentFocus() < 0) {
                BasicRangeSliderUI.this.focusTop(0, -1);
            }
            if (!BasicRangeSliderUI.this._isPopup) {
                BasicRangeSliderUI.this.slider.repaint();
            }
            BasicRangeSliderUI.this._isPopup = false;
        }

        @Override
        public void focusLost(FocusEvent e) {
            BasicRangeSliderUI.this._isDragging = false;
            if (!BasicRangeSliderUI.this._isPopup) {
                BasicRangeSliderUI.this.focusTop(-1, -1);
                BasicRangeSliderUI.this.slider.repaint();
            }
        }
    }
}

