/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public final class BMPWriter {
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private byte[] bitmapFileHeader = new byte[14];
    private byte[] bfType = new byte[]{66, 77};
    private int bfSize = 0;
    private int bfReserved1 = 0;
    private int bfReserved2 = 0;
    private int bfOffBits = 54;
    private byte[] bitmapInfoHeader = new byte[40];
    private int biSize = 40;
    private int biWidth = 0;
    private int biHeight = 0;
    private int biPlanes = 1;
    private int biBitCount = 24;
    private int biCompression = 0;
    private int biSizeImage = 196608;
    private int biXPelsPerMeter = 0;
    private int biYPelsPerMeter = 0;
    private int biClrUsed = 0;
    private int biClrImportant = 0;
    private int[] bitmap;
    private BufferedOutputStream fo;
    private byte[] w = new byte[2];
    private byte[] dw = new byte[4];

    public void saveBitmap(File file, Image image, int width, int height) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            this.fo = new BufferedOutputStream(fos);
            this.save(image, width, height);
            this.fo.close();
            fos.close();
        }
        catch (Exception saveEx) {
            saveEx.printStackTrace();
        }
    }

    public void saveBitmap(String filename, Image image, int width, int height) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            this.fo = new BufferedOutputStream(fos);
            this.save(image, width, height);
            this.fo.close();
            fos.close();
        }
        catch (Exception saveEx) {
            saveEx.printStackTrace();
        }
    }

    public void saveBitmap(BufferedOutputStream bos, Image image, int width, int height) {
        try {
            this.fo = bos;
            this.save(image, width, height);
        }
        catch (Exception saveEx) {
            saveEx.printStackTrace();
        }
    }

    private void save(Image parImage, int parWidth, int parHeight) {
        try {
            this.convertImage(parImage, parWidth, parHeight);
            this.writeBitmapFileHeader();
            this.writeBitmapInfoHeader();
            this.writeBitmap();
        }
        catch (Exception saveEx) {
            saveEx.printStackTrace();
        }
    }

    private boolean convertImage(Image parImage, int parWidth, int parHeight) {
        this.bitmap = new int[parWidth * parHeight];
        PixelGrabber pg = new PixelGrabber(parImage, 0, 0, parWidth, parHeight, this.bitmap, 0, parWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        int pad = (4 - parWidth * 3 % 4) * parHeight;
        this.biSizeImage = parWidth * parHeight * 3 + pad;
        this.bfSize = this.biSizeImage + 14 + 40;
        this.biWidth = parWidth;
        this.biHeight = parHeight;
        return true;
    }

    private void writeBitmap() {
        int rowIndex;
        byte[] rgb = new byte[3 * this.biWidth];
        int size = this.biWidth * this.biHeight - 1;
        int pad = 4 - this.biWidth * 3 % 4;
        if (pad == 4) {
            pad = 0;
        }
        byte[] padded = null;
        if (pad > 0) {
            padded = new byte[pad];
        }
        int rowCount = 1;
        int padCount = 0;
        int lastRowIndex = rowIndex = size - this.biWidth;
        try {
            for (int j = 0; j < size; ++j) {
                int value = this.bitmap[rowIndex];
                rgb[3 * rowCount - 3] = (byte)(value & 0xFF);
                rgb[3 * rowCount - 2] = (byte)(value >> 8 & 0xFF);
                rgb[3 * rowCount - 1] = (byte)(value >> 16 & 0xFF);
                if (rowCount == this.biWidth || j == size - 1) {
                    this.fo.write(rgb);
                    padCount += pad;
                    if (pad > 0) {
                        this.fo.write(padded);
                    }
                    rowCount = 1;
                    lastRowIndex = rowIndex = lastRowIndex - this.biWidth;
                } else {
                    ++rowCount;
                }
                ++rowIndex;
            }
            this.bfSize += padCount - pad;
            this.biSizeImage += padCount - pad;
        }
        catch (Exception wb) {
            wb.printStackTrace();
        }
        rgb = null;
        this.bitmap = null;
    }

    private void writeBitmapFileHeader() {
        try {
            this.fo.write(this.bfType);
            this.fo.write(this.intToDWord(this.bfSize, this.dw));
            this.fo.write(this.intToWord(this.bfReserved1, this.w));
            this.fo.write(this.intToWord(this.bfReserved2, this.w));
            this.fo.write(this.intToDWord(this.bfOffBits, this.dw));
        }
        catch (Exception wbfh) {
            wbfh.printStackTrace();
        }
    }

    private void writeBitmapInfoHeader() {
        try {
            this.fo.write(this.intToDWord(this.biSize, this.dw));
            this.fo.write(this.intToDWord(this.biWidth, this.dw));
            this.fo.write(this.intToDWord(this.biHeight, this.dw));
            this.fo.write(this.intToWord(this.biPlanes, this.w));
            this.fo.write(this.intToWord(this.biBitCount, this.w));
            this.fo.write(this.intToDWord(this.biCompression, this.dw));
            this.fo.write(this.intToDWord(this.biSizeImage, this.dw));
            this.fo.write(this.intToDWord(this.biXPelsPerMeter, this.dw));
            this.fo.write(this.intToDWord(this.biYPelsPerMeter, this.dw));
            this.fo.write(this.intToDWord(this.biClrUsed, this.dw));
            this.fo.write(this.intToDWord(this.biClrImportant, this.dw));
        }
        catch (Exception wbih) {
            wbih.printStackTrace();
        }
    }

    private byte[] intToWord(int parValue, byte[] value) {
        value[0] = (byte)(parValue & 0xFF);
        value[1] = (byte)(parValue >> 8 & 0xFF);
        return value;
    }

    private byte[] intToDWord(int parValue, byte[] value) {
        value[0] = (byte)(parValue & 0xFF);
        value[1] = (byte)(parValue >> 8 & 0xFF);
        value[2] = (byte)(parValue >> 16 & 0xFF);
        value[3] = (byte)(parValue >> 24 & 0xFF);
        return value;
    }
}

