/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.tools.wizard;

import java.awt.Component;
import java.awt.Image;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class WizardEntry {
    protected Component graph = null;
    protected boolean graphQueried = false;
    protected String[] pageList = null;
    protected Image image = null;
    protected Object source = null;
    protected Element chartElement = null;
    protected ResourceBundle rb = null;

    public void init(Element entryDescription, Object data, ResourceBundle resource) {
        if (data != null) {
            this.source = data;
        }
        if (resource != null) {
            this.rb = resource;
        }
        if (entryDescription != null) {
            this.chartElement = entryDescription;
        }
        NodeList children = this.chartElement.getChildNodes();
        int num = children.getLength();
        Element pagelist = null;
        for (int i = 0; i < num; ++i) {
            Element e;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(e = (Element)child).getTagName().equalsIgnoreCase("Pages")) continue;
            pagelist = e;
        }
        if (pagelist != null) {
            StringTokenizer st = new StringTokenizer(pagelist.getAttribute("list"), ",");
            this.pageList = new String[st.countTokens()];
            for (int i = 0; i < this.pageList.length; ++i) {
                this.pageList[i] = st.nextToken();
            }
        }
        if (this.pageList != null && this.pageList.length == 0) {
            this.pageList = null;
        }
    }

    public void reset() {
        this.graph = null;
        this.graphQueried = false;
    }

    public boolean canLoad() {
        if (this.chartElement == null) {
            return false;
        }
        String classname = this.chartElement.getAttribute("component");
        if (classname == null) {
            return false;
        }
        try {
            Class.forName(classname);
            return true;
        }
        catch (NoClassDefFoundError ce) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract void loadGraph();

    public String getNextPage(String current) {
        if (current == null || this.pageList == null) {
            return null;
        }
        if (current.equalsIgnoreCase("CHART_TYPE_PAGE")) {
            return this.pageList[0];
        }
        for (int i = 0; i < this.pageList.length - 1; ++i) {
            if (!this.pageList[i].equalsIgnoreCase(current)) continue;
            return this.pageList[i + 1];
        }
        return null;
    }

    public String getDescription() {
        String rc = "None";
        try {
            if (this.rb != null) {
                rc = this.rb.getString(this.chartElement.getAttribute("displayNameKey"));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return rc;
    }

    public String getName() {
        return this.chartElement.getAttribute("name");
    }

    public String getIconPath() {
        return this.chartElement.getAttribute("icon");
    }

    public Icon getIcon() {
        return null;
    }

    public String getIconText() {
        String rc = null;
        if (this.chartElement.hasAttribute("iconTextKey")) {
            try {
                if (this.rb != null) {
                    rc = this.rb.getString(this.chartElement.getAttribute("iconTextKey"));
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return rc;
    }

    public JComponent getGraph() {
        if (this.graph == null) {
            this.loadGraph();
        }
        if (this.graph instanceof JComponent) {
            this.graphQueried = true;
            return (JComponent)this.graph;
        }
        return null;
    }

    public void setImage(Image i) {
        this.image = i;
    }

    public Image getImage() {
        return this.image;
    }

    public String getImagePath() {
        return this.chartElement.getAttribute("image");
    }

    public void finish() {
    }

    public Element getChartElement() {
        return this.chartElement;
    }

    public void dispose() {
    }

    public ResourceBundle getRb() {
        return this.rb;
    }

    public Object getDataSource() {
        return this.source;
    }
}

