/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.tools.wizard;

import com.sas.graphics.tools.wizard.ChartCategory;
import com.sas.graphics.tools.wizard.ChartTypePage;
import com.sas.graphics.tools.wizard.WizardEntry;
import com.sas.graphics.tools.wizard.WizardPage;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GraphWizard
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4010977095200349711L;
    protected Object data = null;
    protected Object metaData = null;
    protected Vector actionListeners = null;
    protected JPanel buttonPanel = null;
    protected JButton m_cancel = null;
    protected JButton m_prev = null;
    protected JButton m_next = null;
    protected JButton m_finish = null;
    protected JPanel m_pagePanel = null;
    protected CardLayout m_pageLayout = null;
    protected WizardEntry m_entry = null;
    protected Vector m_stack = new Vector();
    protected String m_currentKey = null;
    protected Map m_pages = new HashMap();
    protected WizardPage m_currentPage;
    protected ResourceBundle localRB = null;
    protected ResourceBundle rb = null;
    protected WizardPage startPage = null;
    protected Hashtable avaliblePages = null;
    protected InputStream configXML = null;
    protected Element chartList = null;
    public static final String CHART_TYPE_PAGE_ID = "CHART_TYPE_PAGE";
    public static final String WIZARD_FINISH = "FINISH";
    public static final String WIZARD_CANCEL = "CANCEL";

    public GraphWizard(JFrame owner, Object data, InputStream xml) {
        super(owner);
        this.setModal(true);
        if (xml != null) {
            this.configXML = xml;
        }
        this.avaliblePages = new Hashtable();
        this.data = data;
        try {
            this.localRB = ResourceBundle.getBundle("com.sas.graphics.tools.wizard.graphwizard_NLS");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.init();
        this.actionListeners = new Vector();
    }

    Element getChartListRoot() {
        return this.chartList;
    }

    public static Element getChildWithTagName(String name, Element parent, int which) {
        NodeList children = parent.getChildNodes();
        int num = children.getLength();
        int numSeen = 0;
        for (int i = 0; i < num; ++i) {
            Element e;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(e = (Element)child).getTagName().equalsIgnoreCase(name) || ++numSeen != which) continue;
            return e;
        }
        return null;
    }

    protected void loadFromXML() {
        if (this.configXML == null) {
            return;
        }
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(this.configXML);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (document == null) {
            return;
        }
        Element root = document.getDocumentElement();
        String resourceBundle = root.getAttribute("resourceBundle");
        if (resourceBundle != null && resourceBundle.length() > 0) {
            try {
                this.rb = ResourceBundle.getBundle(resourceBundle);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.chartList = GraphWizard.getChildWithTagName("ChartList", root, 1);
        Element pageList = GraphWizard.getChildWithTagName("PageList", root, 1);
        if (pageList == null) {
            return;
        }
        int index = 1;
        Element page = null;
        while ((page = GraphWizard.getChildWithTagName("Page", pageList, index++)) != null) {
            String pageName = page.getAttribute("name");
            String className = page.getAttribute("class");
            if (pageName == null || pageName.length() == 0 || className == null || className.length() == 0) continue;
            try {
                Class<?> c = Class.forName(className);
                Object o = c.newInstance();
                Class<WizardPage> sc = WizardPage.class;
                if (sc.isInstance(o)) {
                    ((WizardPage)o).setWizard(this);
                    ((WizardPage)o).setId(pageName);
                    ((WizardPage)o).setResourceBundle(this.rb);
                    this.avaliblePages.put(pageName, o);
                }
            }
            catch (Exception e) {
                System.out.println("Failed to load Wizard Page" + className);
                e.printStackTrace();
            }
            this.startPage = (WizardPage)this.avaliblePages.get(pageList.getAttribute("startPage"));
        }
    }

    public static String GRS(ResourceBundle res, String key, String def) {
        String rc = def;
        try {
            if (res != null) {
                rc = res.getString(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return rc;
    }

    private void init() {
        this.loadFromXML();
        this.setSize(550, 360);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.m_cancel = new JButton(GraphWizard.GRS(this.localRB, "GraphWizard.Cancel.txt", "Cancel"));
        this.m_cancel.setMnemonic('C');
        this.m_cancel.addActionListener(this);
        gbc.gridy = 0;
        gbc.gridx = -1;
        this.buttonPanel.add((Component)this.m_cancel, gbc);
        this.m_prev = new JButton(GraphWizard.GRS(this.localRB, "GraphWizard.Back.txt", "< Back"));
        this.m_prev.setMnemonic('B');
        this.m_prev.addActionListener(this);
        gbc.gridy = 0;
        gbc.gridx = -1;
        this.buttonPanel.add((Component)this.m_prev, gbc);
        this.m_next = new JButton(GraphWizard.GRS(this.localRB, "GraphWizard.Next.txt", "Next >"));
        this.m_next.setMnemonic('N');
        this.m_next.addActionListener(this);
        gbc.gridy = 0;
        gbc.gridx = -1;
        this.buttonPanel.add((Component)this.m_next, gbc);
        this.m_finish = new JButton(GraphWizard.GRS(this.localRB, "GraphWizard.Finish.txt", "Finish"));
        this.m_finish.setMnemonic('F');
        this.m_finish.addActionListener(this);
        gbc.gridy = 0;
        gbc.gridx = -1;
        this.buttonPanel.add((Component)this.m_finish, gbc);
        this.m_pagePanel = new JPanel();
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 11));
        this.m_pageLayout = new CardLayout();
        this.m_pagePanel.setLayout(this.m_pageLayout);
        this.getContentPane().add((Component)this.m_pagePanel, "Center");
        JPanel rightAlignedPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        rightAlignedPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)rightAlignedPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                GraphWizard.this.onCancel();
            }
        });
        Object p = null;
        Object fsize = null;
        Dimension wsize = this.getSize();
        int w = -1;
        int h = -1;
        if (p != null && fsize != null) {
            w = p.x + fsize.width / 2 - wsize.width / 2;
            h = p.y + fsize.height / 2 - wsize.height / 2;
        }
        if (w < 0 || h < 0) {
            Dimension ssize = Toolkit.getDefaultToolkit().getScreenSize();
            w = ssize.width / 2 - wsize.width / 2;
            h = ssize.height / 2 - wsize.height / 2;
        }
        this.setLocation(w, h);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.m_cancel) {
            this.onCancel();
        } else if (source == this.m_prev) {
            this.onPrevious();
        } else if (source == this.m_next) {
            this.onNext();
        } else if (source == this.m_finish) {
            this.onFinish();
        }
    }

    public void setEntry(WizardEntry entry) {
        if (this.m_entry != null) {
            this.m_entry.dispose();
        }
        this.m_entry = entry;
        this.updateButtons();
    }

    private void start(WizardPage page) {
        this.removeAllPages();
        this.addPage(page, page.getID());
        this.setCurrentPage(page.getID());
        super.setVisible(true);
        this.setTitle(page.getTitle());
    }

    private void removeAllPages() {
        this.m_pages = new HashMap();
        this.m_pagePanel.removeAll();
        this.m_currentPage = null;
        this.m_currentKey = null;
    }

    private void addPage(WizardPage page, String key) {
        if (this.m_pages.containsKey(key)) {
            return;
        }
        this.m_pages.put(key, page);
        this.m_pagePanel.add((Component)page, key);
        page.init();
    }

    private void onCancel() {
        if (this.m_currentPage != null) {
            this.m_currentPage.cancel();
        }
        if (this.m_entry != null) {
            this.m_entry.dispose();
        }
        this.close();
    }

    private void onPrevious() {
        if (!this.m_currentPage.back()) {
            return;
        }
        this.setCurrentPage((String)this.m_stack.remove(this.m_stack.size() - 1));
    }

    private void onNext() {
        if (!this.m_currentPage.forward()) {
            return;
        }
        String nextPage = this.m_entry.getNextPage(this.m_currentPage.getID());
        if (nextPage == null || nextPage.trim().equals("")) {
            return;
        }
        this.m_stack.addElement(this.m_currentKey);
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setCurrentPage(nextPage);
        this.setCursor(oldCursor);
    }

    private void onFinish() {
        if (this.m_currentPage != null) {
            this.m_currentPage.finish();
        }
        if (this.m_entry != null) {
            this.m_entry.finish();
        }
        ActionEvent ae = new ActionEvent(this, -1, WIZARD_FINISH);
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            Object al = this.actionListeners.elementAt(i);
            ((ActionListener)al).actionPerformed(ae);
        }
        this.close();
    }

    private void close() {
        this.setVisible(false);
        WizardPage[] pages = this.m_pages.values().toArray(new WizardPage[0]);
        for (int i = 0; i < pages.length; ++i) {
            pages[i].cleanup();
        }
        this.dispose();
    }

    private boolean loadPage(String key) {
        if (key == null) {
            return false;
        }
        WizardPage page = (WizardPage)this.avaliblePages.get(key);
        if (page == null) {
            return false;
        }
        page.setWizard(this);
        this.addPage(page, page.getID());
        return true;
    }

    private void setCurrentPage(String key) {
        if (!this.m_pages.containsKey(key) && !this.loadPage(key)) {
            return;
        }
        this.m_currentPage = (WizardPage)this.m_pages.get(key);
        this.m_currentKey = key;
        this.m_currentPage.display();
        this.m_pageLayout.show(this.m_pagePanel, key);
        this.updateButtons();
        this.setTitle(this.m_currentPage.getTitle());
    }

    public void updateButtons() {
        if (this.m_currentPage == null) {
            return;
        }
        if (this.m_entry == null) {
            this.m_prev.setEnabled(false);
            this.m_prev.setEnabled(this.m_stack.size() > 0);
            this.m_next.setEnabled(false);
            this.m_next.setEnabled(false);
            this.m_finish.setEnabled(false);
            this.m_finish.setEnabled(false);
        } else {
            this.m_prev.setEnabled(this.m_currentPage.canBackward());
            this.m_next.setEnabled(this.m_currentPage.hasNext() && this.m_currentPage.canProceed() && this.m_entry.getNextPage(this.m_currentPage.getID()) != null);
            this.m_finish.setEnabled(this.m_currentPage.canFinish());
        }
    }

    public void addActionListener(ActionListener al) {
        if (al != null && !this.actionListeners.contains(al)) {
            this.actionListeners.addElement(al);
        }
    }

    public void removeActionListener(ActionListener al) {
        if (al != null && !this.actionListeners.contains(al)) {
            this.actionListeners.removeElement(al);
        }
    }

    public JComponent getGraph() {
        if (this.m_entry == null) {
            return null;
        }
        JComponent rc = this.m_entry.getGraph();
        return rc;
    }

    public void setData(Object data) {
        this.data = data;
        if (this.m_entry != null) {
            this.m_entry.source = data;
            this.m_entry.reset();
        }
        Enumeration e = this.avaliblePages.elements();
        while (e.hasMoreElements()) {
            ((WizardPage)e.nextElement()).reset();
        }
    }

    public void reset() {
        if (this.m_entry != null) {
            this.m_entry.reset();
        }
    }

    public void setData(Object data, Object metaData) {
        this.metaData = metaData;
        this.setData(data);
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            if (this.startPage == null) {
                return;
            }
            if (this.m_entry != null) {
                this.m_entry.reset();
            }
            this.startPage.init();
            this.start(this.startPage);
        } else {
            super.setVisible(false);
        }
    }

    public void setVisible(boolean vis, WizardEntry entry) {
        if (vis) {
            String nextPage;
            if (this.startPage == null) {
                return;
            }
            this.m_entry = entry;
            if (this.m_entry != null) {
                this.m_entry.reset();
            }
            if (!this.m_pages.containsKey(nextPage = this.m_entry.getNextPage(this.startPage.getID())) && !this.loadPage(nextPage)) {
                this.onFinish();
                return;
            }
            WizardPage page = (WizardPage)this.m_pages.get(nextPage);
            this.start(page);
        } else {
            super.setVisible(false);
        }
    }

    public Object getData() {
        return this.data;
    }

    public WizardEntry getCurrentEntry() {
        return this.m_entry;
    }

    public Image getImage() {
        return this.m_entry.getImage();
    }

    @Override
    public String getName() {
        return this.m_entry.getName();
    }

    public ChartCategory[] getChartList() {
        if (this.startPage == null || !(this.startPage instanceof ChartTypePage)) {
            return null;
        }
        return ((ChartTypePage)this.startPage).getChartList();
    }

    public ChartCategory getCategoryByName(String name) {
        ChartCategory[] list = this.getChartList();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!name.equalsIgnoreCase(list[i].getName())) continue;
            return list[i];
        }
        return null;
    }

    public WizardEntry getEntryByName(String name) {
        ChartCategory[] list = this.getChartList();
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            ChartCategory cc = list[i];
            WizardEntry[] arr = cc.getEntries();
            if (arr == null) continue;
            for (int j = 0; j < arr.length; ++j) {
                if (!name.equalsIgnoreCase(arr[j].getName())) continue;
                return arr[j];
            }
        }
        return null;
    }
}

