/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.tools.wizard;

import com.sas.graphics.tools.wizard.ChartCategory;
import com.sas.graphics.tools.wizard.GraphWizard;
import com.sas.graphics.tools.wizard.WizardEntry;
import com.sas.graphics.tools.wizard.WizardPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Element;

public class ChartTypePage
extends WizardPage
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = -3166017048801495127L;
    JList chartList = null;
    JTextArea textArea = null;
    JPanel chartButtonsPanel = null;
    NameAndPictureListModel model = null;
    WizardEntry selectedEntry = null;
    ResourceBundle localRB = null;
    ChartCategory[] cats = null;
    int defaultCategory = 0;

    public ChartTypePage() {
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        try {
            this.localRB = ResourceBundle.getBundle("com.sas.graphics.tools.wizard.graphwizard_NLS");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.chartList = new JList();
        this.chartList.addListSelectionListener(this);
        JScrollPane pane = new JScrollPane(this.chartList);
        pane.setViewportBorder(BorderFactory.createEmptyBorder());
        pane.setPreferredSize(new Dimension(150, 30));
        this.add("West", pane);
        JPanel p = new JPanel(new BorderLayout());
        this.chartButtonsPanel = new JPanel(new FlowLayout());
        this.chartButtonsPanel.setPreferredSize(new Dimension(300, 70));
        p.add("North", this.chartButtonsPanel);
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        this.textArea.setBackground(p.getBackground());
        JScrollPane sp = new JScrollPane(this.textArea);
        sp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0), sp.getBorder()));
        sp.setViewportBorder(BorderFactory.createEmptyBorder());
        p.add("Center", sp);
        this.add("Center", p);
    }

    public ChartCategory[] getChartList() {
        return this.cats;
    }

    @Override
    public void setWizard(GraphWizard wiz) {
        super.setWizard(wiz);
        this.reset();
    }

    @Override
    public void setResourceBundle(ResourceBundle rb) {
        super.setResourceBundle(rb);
        this.reset();
    }

    @Override
    public void reset() {
        this.model = this.loadChartList();
        this.chartList.setModel(this.model);
        NameAndPictureListCellRenderer renderer = new NameAndPictureListCellRenderer();
        this.chartList.setCellRenderer(renderer);
    }

    @Override
    public void init() {
        if (this.chartList.getModel().getSize() > this.defaultCategory) {
            this.chartList.setSelectedIndex(this.defaultCategory);
        } else {
            this.chartList.setSelectedIndex(0);
        }
    }

    @Override
    public void display() {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String name = ae.getActionCommand();
        WizardEntry[] charts = this.model.getEntrys(this.chartList.getSelectedIndex());
        for (int i = 0; i < charts.length; ++i) {
            if (!name.equals(charts[i].getName())) continue;
            this.selectedEntry = charts[i];
        }
        this.wizard.setEntry(this.selectedEntry);
        if (this.selectedEntry != null) {
            this.textArea.setText(this.selectedEntry.getDescription());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        this.setupCharts();
        WizardEntry[] charts = this.model.getEntrys(this.chartList.getSelectedIndex());
        if (charts != null && charts.length > 0) {
            this.selectedEntry = charts[0];
        }
        if (this.selectedEntry != null) {
            this.wizard.setEntry(this.selectedEntry);
            this.textArea.setText(this.selectedEntry.getDescription());
        }
    }

    private void setupCharts() {
        this.chartButtonsPanel.removeAll();
        this.chartButtonsPanel.setLayout(new FlowLayout(0));
        WizardEntry[] charts = this.model.getEntrys(this.chartList.getSelectedIndex());
        ButtonGroup grp = new ButtonGroup();
        if (charts == null) {
            return;
        }
        for (int i = 0; i < charts.length; ++i) {
            if (charts[i] == null) continue;
            Image img = charts[i].getImage();
            ImageIcon imgIcon = null;
            if (img != null) {
                imgIcon = new ImageIcon(img);
            }
            JToggleButton j = null;
            j = imgIcon != null ? new JToggleButton(imgIcon) : new JToggleButton(this.GRS(this.localRB, "ChartTypePage.Image_not_found.txt", "Image not found"));
            j.setRolloverEnabled(true);
            if (charts[i].getIconText() != null) {
                j.setText(charts[i].getIconText());
                j.setHorizontalTextPosition(4);
                j.setVerticalTextPosition(1);
                j.setIconTextGap(0);
            }
            this.chartButtonsPanel.add(j);
            grp.add(j);
            j.setActionCommand(charts[i].getName());
            j.addActionListener(this);
            if (i != 0) continue;
            j.setSelected(true);
            this.textArea.setText(charts[i].getDescription());
        }
        this.chartButtonsPanel.validate();
        this.repaint();
    }

    private String GRS(ResourceBundle res, String key, String def) {
        String rc = def;
        try {
            if (res != null) {
                rc = res.getString(key);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return rc;
    }

    @Override
    public String getTitle() {
        return this.GRS(this.localRB, "ChartTypePage.Select_a_Chart_Type.txt", "Select a Chart Type");
    }

    @Override
    public boolean hasNext() {
        return this.wizard.getCurrentEntry().getNextPage(this.getID()) != null;
    }

    private NameAndPictureListModel loadChartList() {
        Element e = this.wizard.getChartListRoot();
        Vector<ChartCategory> v = new Vector<ChartCategory>();
        int index = 1;
        Element cat = null;
        String defaultCat = e.getAttribute("defaultCategory");
        while ((cat = GraphWizard.getChildWithTagName("Category", e, index++)) != null) {
            ChartCategory cc = new ChartCategory(cat, this.rb, this.wizard);
            if (cc.getEntries().length <= 0) continue;
            v.addElement(cc);
        }
        this.cats = new ChartCategory[v.size()];
        v.copyInto(this.cats);
        for (int i = 0; i < this.cats.length; ++i) {
            if (!defaultCat.equalsIgnoreCase(this.cats[i].getName())) continue;
            this.defaultCategory = i;
        }
        return new NameAndPictureListModel(this.cats);
    }

    @Override
    public boolean canBackward() {
        return false;
    }

    @Override
    public boolean canFinish() {
        if (this.wizard.getCurrentEntry().getNextPage(this.getID()) == null) {
            return true;
        }
        WizardPage page = (WizardPage)this.wizard.avaliblePages.get(this.wizard.getCurrentEntry().getNextPage(this.getID()));
        if (page == null) {
            return true;
        }
        return page.canFinish();
    }

    class NameAndPictureListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 8274598398436334854L;
        private Border lineBorder = BorderFactory.createLineBorder(Color.black, 2);
        private Border emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);

        public NameAndPictureListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setPreferredSize(null);
            NameAndPictureListModel model = (NameAndPictureListModel)list.getModel();
            this.setText(model.getDisplayName(value));
            this.setIcon(model.getIcon(value));
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            if (cellHasFocus) {
                this.setBorder(this.lineBorder);
            } else {
                this.setBorder(this.emptyBorder);
            }
            int x = 125;
            int y = 30;
            Dimension d = new Dimension(Math.max(x, this.getPreferredSize().width), Math.max(y, this.getPreferredSize().height));
            this.setPreferredSize(d);
            return this;
        }
    }

    class NameAndPictureListModel
    extends DefaultListModel {
        private static final long serialVersionUID = -7954479998452494449L;

        public NameAndPictureListModel(ChartCategory[] cats) {
            for (int i = 0; i < cats.length; ++i) {
                this.addElement(cats[i]);
            }
        }

        public String getName(Object o) {
            if (!(o instanceof ChartCategory)) {
                return null;
            }
            return ((ChartCategory)o).getName();
        }

        public Icon getIcon(Object o) {
            if (!(o instanceof ChartCategory)) {
                return null;
            }
            return ((ChartCategory)o).getIcon();
        }

        public String getDisplayName(Object o) {
            if (!(o instanceof ChartCategory)) {
                return null;
            }
            return ((ChartCategory)o).getDisplayName();
        }

        public WizardEntry[] getEntrys(int i) {
            if (i < 0 || i >= this.getSize()) {
                return null;
            }
            Object o = this.get(i);
            if (!(o instanceof ChartCategory)) {
                return null;
            }
            return ((ChartCategory)o).getEntries();
        }
    }
}

