/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.AttributeNames;
import com.sas.graphics.styles.ContextNames;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.ShadowStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.FontManager;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

public class StyleUtils {
    private static Boolean isWindows = null;
    public static String[][] templateToContextMap = new String[][]{{"GraphData1", "GraphDataStyle1"}, {"GraphData2", "GraphDataStyle2"}, {"GraphData3", "GraphDataStyle3"}, {"GraphData4", "GraphDataStyle4"}, {"GraphData5", "GraphDataStyle5"}, {"GraphData6", "GraphDataStyle6"}, {"GraphData7", "GraphDataStyle7"}, {"GraphData8", "GraphDataStyle8"}, {"GraphData9", "GraphDataStyle9"}, {"GraphData10", "GraphDataStyle10"}, {"GraphData11", "GraphDataStyle11"}, {"GraphData12", "GraphDataStyle12"}, {"GraphDataDefault", "GraphDataStyleDefault"}, {"GraphOutlier", "Outlier"}, {"GraphBoxMedian", "BoxMedian"}, {"GraphBoxMean", "BoxMean"}, {"GraphBoxWhisker", "BoxWhisker"}, {"GraphAnnoShape", "AnnoShape"}, {"GraphSelection", "Selection"}, {"GraphMissing", "Missing"}, {"GraphControlLimits", "ControlLimits"}, {"GraphRunTest", "RunTest"}, {"GraphStars", "Stars"}, {"GraphClipping", "Clipping"}, {"GraphBox", "Box"}, {"GraphHistogram", "Histogram"}, {"GraphBand", "Band"}, {"GraphEllipse", "Ellipse"}, {"GraphConfidence", "Confidence"}, {"GraphConfidence2", "Confidence2"}, {"GraphPredictionLimits", "PredictionLimits"}, {"GraphError", "Error"}, {"ThreeColorRamp", "ThreeColorRamp"}, {"ThreeColorAltRamp", "ThreeColorAltRamp"}, {"TwoColorRamp", "TwoColorRamp"}, {"TwoColorAltRamp", "TwoColorAltRamp"}, {"GraphAxisLines", "AxisLines"}, {"GraphReference", "Reference"}, {"GraphGridLines", "GridLines"}, {"GraphMinorGridLines", "MinorGridLines"}, {"GraphOutlines", "Outlines"}, {"GraphBorderLines", "BorderLines"}, {"GraphFit", "Fit"}, {"GraphFit2", "Fit2"}, {"GraphPrediction", "Prediction"}, {"GraphAnnoLine", "AnnoLine"}, {"GraphConnectLine", "ConnectLine"}, {"GraphTitleText", "TitleText"}, {"GraphFootnoteText", "FootnoteText"}, {"GraphDataText", "DataText"}, {"GraphLabelText", "LabelText"}, {"GraphLabel2Text", "Label2Text"}, {"GraphValueText", "ValueText"}, {"GraphAnnoText", "AnnoText"}, {"GraphBackground", "Backfill"}, {"GraphWalls", "WallFill"}, {"GraphFloor", "FloorFill"}, {"GraphLegendBackground", "LegendFill"}, {"GraphHeaderBackground", "HeaderFill"}, {"GraphRangeFill", "RangeFill"}, {"DropShadowStyle", "DropShadow"}, {"GraphBlock", "Block"}, {"GraphAltBlock", "AltBlock"}, {"TableGridLines", "TableGridLines"}, {"TableHeaderFill", "TableHeaderFill"}, {"TableHeaderText", "TableHeaderText"}, {"TableDataFill", "TableDataFill"}, {"TableDataText", "TableDataText"}, {"GraphBar", "Bar"}, {"GraphOther", "Other"}, {"GraphInitial", "Initial"}, {"GraphFinal", "Final"}, {"GraphUnderflow", "Underflow"}, {"GraphOverflow", "Overflow"}, {"GraphCutLine", "CutLine"}, {"GraphSkins", "Skins"}, {"KPIRangeText", "KPIRangeText"}, {"KPIValueText", "KPIValueText"}, {"KPIUnderflow", "KPIUnderflow"}, {"KPIOverflow", "KPIOverflow"}, {"KPIRangeDefault", "KPIRangeDefault"}, {"KPIRange1", "KPIRange1"}, {"KPIRange2", "KPIRange2"}, {"KPIRange3", "KPIRange3"}, {"KPIRange4", "KPIRange4"}, {"KPIRange5", "KPIRange5"}, {"ZoneA", "ZoneA"}, {"ZoneB", "ZoneB"}, {"ZoneC", "ZoneC"}, {"PhaseBox", "PhaseBox"}, {"BlockHeader", "BlockHeader"}, {"GraphDataNode1", "GraphDataNode1"}, {"GraphDataNode2", "GraphDataNode2"}, {"GraphDataNode3", "GraphDataNode3"}, {"GraphDataNode4", "GraphDataNode4"}, {"GraphDataNode5", "GraphDataNode5"}, {"GraphDataNode6", "GraphDataNode6"}, {"GraphDataNode7", "GraphDataNode7"}, {"GraphDataNode8", "GraphDataNode8"}, {"GraphDataNode9", "GraphDataNode9"}, {"GraphDataNode10", "GraphDataNode10"}, {"GraphDataNode11", "GraphDataNode11"}, {"GraphDataNode12", "GraphDataNode12"}, {"GraphDataNodeDefault", "GraphDataNodeDefault"}, {"NodeDetails", "NodeDetails"}, {"NodeLink", "NodeLink"}, {"OverviewBorderLines", "OverviewBorderLines"}, {"OverviewViewportBorderLines", "OverviewViewportBorderLines"}, {"NodeTitle", "NodeTitle"}, {"NodeLabel", "NodeLabel"}, {"NodeInputLabel", "NodeInputLabel"}, {"NodeLinkLabel", "NodeLinkLabel"}, {"OverviewFill", "OverviewFill"}, {"OverviewFilterFill", "OverviewFilterFill"}};

    public static Color getColorAttribute(Style style, String elementName, String fallbackElementName, String attribute) {
        Color defaultColor = Color.black;
        if (attribute == null) {
            return defaultColor;
        }
        if (style != null) {
            StyleElement se = style.getStyleElement(elementName);
            if (se == null) {
                se = style.getStyleElement(fallbackElementName);
            }
            if (se == null) {
                se = StyleUtils.getDefaultElement(style, elementName, fallbackElementName);
            }
            if (se == null) {
                return defaultColor;
            }
            return se.getColorAttribute(attribute, se.getDefaultColor());
        }
        StyleElement se = StyleUtils.getDefaultElement(null, elementName, fallbackElementName);
        if (se == null) {
            return defaultColor;
        }
        return se.getColorAttribute(attribute, se.getDefaultColor());
    }

    private static StyleElement getDefaultElement(Style style, String elementName, String fallbackElement) {
        StyleElement rc = null;
        if (style != null && (rc = style.getStyleElement(elementName)) == null) {
            rc = style.getStyleElement(fallbackElement);
        }
        if (rc == null) {
            rc = StyleUtils.getDefaultElementFromContextName(elementName, fallbackElement);
        }
        return rc;
    }

    private static StyleElement getDefaultElementFromContextName(String elementName, String fallbackElementName) {
        String name = null;
        if (elementName != null && StyleUtils.isPredefinedContextName(elementName)) {
            name = elementName;
        }
        if (fallbackElementName != null && StyleUtils.isPredefinedContextName(fallbackElementName)) {
            name = fallbackElementName;
        }
        if (name == null || StyleUtils.isDataContextName(name)) {
            return new DataStyleElement(null);
        }
        if (StyleUtils.isFillContextName(name)) {
            return new FillStyleElement(null);
        }
        if (StyleUtils.isLineContextName(name)) {
            return new LineStyleElement(null);
        }
        if (StyleUtils.isRampContextName(name)) {
            return new RampStyleElement(null);
        }
        if (StyleUtils.isShadowContextName(name)) {
            return new ShadowStyleElement(null);
        }
        if (StyleUtils.isTextContextName(name)) {
            return new TextStyleElement(null);
        }
        return new DataStyleElement(null);
    }

    public static String getAttributeDisplayName(String attributeName) {
        if (attributeName == null) {
            return null;
        }
        if (!StyleUtils.isStandardAttributeName(attributeName)) {
            return attributeName;
        }
        ResourceBundle rb = ResourceBundle.getBundle("com.sas.graphics.styles.styles");
        try {
            return rb.getString(attributeName + ".txt");
        }
        catch (MissingResourceException missingResourceException) {
            return attributeName;
        }
    }

    public static boolean isStandardAttributeName(String name) {
        for (int i = 0; i < AttributeNames.standardAttributeNames.length; ++i) {
            if (!AttributeNames.standardAttributeNames[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPredefinedContextName(String name) {
        if (name == null) {
            return false;
        }
        if (StyleUtils.isDataContextName(name)) {
            return true;
        }
        if (StyleUtils.isDataNodeContextName(name)) {
            return true;
        }
        if (StyleUtils.isFillContextName(name)) {
            return true;
        }
        if (StyleUtils.isLineContextName(name)) {
            return true;
        }
        if (StyleUtils.isRampContextName(name)) {
            return true;
        }
        if (StyleUtils.isTextContextName(name)) {
            return true;
        }
        if (StyleUtils.isShadowContextName(name)) {
            return true;
        }
        for (int i = 0; i < ContextNames.allContexts.length; ++i) {
            if (!ContextNames.allContexts[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return name.startsWith("KPIRange");
    }

    public static boolean isDataContextName(String name) {
        for (int i = 0; i < ContextNames.dataContexts.length; ++i) {
            if (!ContextNames.dataContexts[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return name != null && name.startsWith("GraphDataStyle");
    }

    public static boolean isDataNodeContextName(String name) {
        for (int i = 0; i < ContextNames.dataContexts.length; ++i) {
            if (!ContextNames.dataContexts[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return name != null && name.startsWith("GraphDataNode");
    }

    public static boolean isFillContextName(String name) {
        for (int i = 0; i < ContextNames.fillContexts.length; ++i) {
            if (!ContextNames.fillContexts[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLineContextName(String name) {
        for (int i = 0; i < ContextNames.lineContexts.length; ++i) {
            if (!ContextNames.lineContexts[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRampContextName(String name) {
        for (int i = 0; i < ContextNames.rampContexts.length; ++i) {
            if (!ContextNames.rampContexts[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTextContextName(String name) {
        for (int i = 0; i < ContextNames.textContexts.length; ++i) {
            if (!ContextNames.textContexts[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isShadowContextName(String name) {
        for (int i = 0; i < ContextNames.shadowContexts.length; ++i) {
            if (!ContextNames.shadowContexts[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static Color darker(Color c, double percentage) {
        if (c == null) {
            return null;
        }
        int factor = (int)(255.0 * percentage);
        int red = Math.max(c.getRed() - factor, 0);
        int green = Math.max(c.getGreen() - factor, 0);
        int blue = Math.max(c.getBlue() - factor, 0);
        Color color = new Color(red, green, blue);
        return color;
    }

    public static Color brighter(Color c, double percentage) {
        if (c == null) {
            return null;
        }
        int factor = (int)(255.0 * percentage);
        int red = Math.min(c.getRed() + factor, 255);
        int green = Math.min(c.getGreen() + factor, 255);
        int blue = Math.min(c.getBlue() + factor, 255);
        Color color = new Color(red, green, blue);
        return color;
    }

    protected static Color applyTransparencyToColor(Color c, double transparency) {
        Color rc = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (1.0 - transparency)));
        return rc;
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static boolean isWindowsOS() {
        if (isWindows == null) {
            String os = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("os.name");
                }
            });
            isWindows = os == null ? Boolean.FALSE : (os.indexOf("Windows") >= 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        return isWindows;
    }

    public static StyleCollection loadStyles(File dir, StyleCollection collection) {
        File[] files;
        StyleCollection rc = collection;
        if (rc == null) {
            rc = new StyleCollection();
        }
        if (dir != null && dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getAbsolutePath().endsWith(".sty")) continue;
                Style s = null;
                try {
                    s = Style.getStyle(new FileInputStream(files[i]));
                    rc.addStyle(s, files[i]);
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.out.println("Failed to load style from " + files[i]);
                }
            }
        }
        return rc;
    }

    public static String getTemplateNameForContextName(String contextName) {
        if (contextName == null) {
            return null;
        }
        for (int i = 0; i < templateToContextMap.length; ++i) {
            if (!templateToContextMap[i][1].equalsIgnoreCase(contextName)) continue;
            return templateToContextMap[i][0];
        }
        return contextName;
    }

    public static String getContextNameForTemplateName(String templateName) {
        if (templateName == null) {
            return null;
        }
        for (int i = 0; i < templateToContextMap.length; ++i) {
            if (!templateToContextMap[i][0].equalsIgnoreCase(templateName)) continue;
            return templateToContextMap[i][1];
        }
        return templateName;
    }

    public static StringBuffer getStyleAsSASCode(Style styleIn, StringBuffer buffer) {
        StyleElement[] elements;
        StringBuffer sb = buffer;
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (styleIn == null) {
            return sb;
        }
        sb.append("\nproc template; \n");
        sb.append("\n   define style styles." + styleIn.getName() + ";");
        if (styleIn.getParent() != null) {
            sb.append("\n   parent=styles." + styleIn.getParent() + ";");
        }
        if ((elements = styleIn.getAllStyleElements()) != null) {
            for (int i = 0; i < elements.length; ++i) {
                if (!elements[i].hasAttribute("_modified") || !elements[i].getAttribute("_modified").equalsIgnoreCase("true")) continue;
                sb.append("\n\n   class " + elements[i].getTemplateClassname() + " / ");
                NamedNodeMap map = elements[i].getAttributes();
                String fontFamily = null;
                String fontWeight = null;
                String fontStyle = null;
                String fontSize = null;
                String color = null;
                String contrastColor = null;
                for (int k = 0; k < map.getLength(); ++k) {
                    Attr attr = (Attr)map.item(k);
                    if ("context".equalsIgnoreCase(attr.getName()) || "fillType".equalsIgnoreCase(attr.getName()) || "_modified".equalsIgnoreCase(attr.getName())) continue;
                    if ("fontFamily".equalsIgnoreCase(attr.getName())) {
                        fontFamily = attr.getValue();
                        continue;
                    }
                    if ("fontWeight".equalsIgnoreCase(attr.getName())) {
                        fontWeight = attr.getValue();
                        continue;
                    }
                    if ("fontStyle".equalsIgnoreCase(attr.getName())) {
                        fontStyle = attr.getValue();
                        continue;
                    }
                    if ("fontSize".equalsIgnoreCase(attr.getName())) {
                        fontSize = attr.getValue();
                        continue;
                    }
                    if ("color".equalsIgnoreCase(attr.getName()) || "textColor".equalsIgnoreCase(attr.getName()) || "fillColor".equalsIgnoreCase(attr.getName())) {
                        color = attr.getValue().replaceAll("#", "CX");
                        continue;
                    }
                    if ("altColor".equalsIgnoreCase(attr.getName()) || "lineColor".equalsIgnoreCase(attr.getName())) {
                        contrastColor = attr.getValue().replaceAll("#", "CX");
                        continue;
                    }
                    if ("fillGradientEndColor".equalsIgnoreCase(attr.getName())) {
                        sb.append("\n   endColor = " + attr.getValue().replaceAll("#", "CX"));
                        continue;
                    }
                    if ("fillGradientStartColor".equalsIgnoreCase(attr.getName())) {
                        sb.append("\n   startColor = " + attr.getValue().replaceAll("#", "CX"));
                        continue;
                    }
                    if ("fillGradientNeutralColor".equalsIgnoreCase(attr.getName())) {
                        sb.append("\n   neutralColor = " + attr.getValue().replaceAll("#", "CX"));
                        continue;
                    }
                    if ("markersymbol".equalsIgnoreCase(attr.getName()) || "displayOpts".equalsIgnoreCase(attr.getName()) || "capStyle".equalsIgnoreCase(attr.getName()) || "connect".equalsIgnoreCase(attr.getName())) {
                        sb.append("\n     " + attr.getName() + " = \"" + attr.getValue() + "\"");
                        continue;
                    }
                    sb.append("\n     " + attr.getName() + " = " + attr.getValue());
                }
                if (fontFamily != null || fontWeight != null || fontStyle != null || fontSize != null) {
                    String[] fonts = TextStyleElement.parseStringArray(fontFamily);
                    String family = "\"";
                    for (int j = 0; j < fonts.length; ++j) {
                        family = family + FontManager.getFont(fonts[j], 0, 12).getFamily();
                        if (j >= fonts.length - 1) continue;
                        family = family + ",";
                    }
                    family = family + "\"";
                    String size = fontSize;
                    if (size == null || size.length() == 0) {
                        size = "12pt";
                    }
                    String style = "";
                    if (fontStyle != null) {
                        style = style + " " + fontStyle;
                    }
                    if (fontWeight != null) {
                        style = style + " " + fontWeight;
                    }
                    if (style != null && style.length() > 0) {
                        sb.append("\n   font = ( " + family + "," + size + "," + style + ")");
                    } else {
                        sb.append("\n   font = ( " + family + "," + size + ")");
                    }
                }
                if (color != null) {
                    sb.append("\n   color = " + color);
                }
                if (contrastColor != null) {
                    sb.append("\n   contrastColor = " + contrastColor);
                }
                sb.append(";");
            }
        }
        sb.append("\nend;");
        return sb;
    }
}

