/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.measures.BaseLength;

public class Size {
    public static final int NONE = -1;
    public static final int POINT = 0;
    public static final int PIXEL = 1;
    public static final int PERCENT = 2;
    public static final int CM = 3;
    public static final int EM = 4;
    public static final int EX = 5;
    public static final int IN = 6;
    public static final int MM = 7;
    public static final int PICA = 8;
    public static final int WT = 9;
    public static final int SPX = 10;
    private static final String[] sizeTypeStrings = new String[]{"pt", "px", "%", "cm", "em", "ex", "in", "mm", "pc", "wt", "spx"};
    private double sizeValue = 0.0;
    private int sizeType = -1;

    public Size() {
        this(0, -1);
    }

    public Size(int sizeValue, int sizeType) {
        this.sizeValue = sizeValue;
        this.sizeType = sizeType;
    }

    public Size(double sizeValue, int sizeType) {
        this.sizeValue = sizeValue;
        this.sizeType = sizeType;
    }

    public Size(String size) {
        this(Size.getDoubleFromSize(size), Size.sizeTypeForString(Size.getTypeFromSize(size)));
    }

    public int getSizeType() {
        return this.sizeType;
    }

    public boolean setSizeType(int sizeType) {
        if (sizeType == 0 || sizeType == 1 || sizeType == 2) {
            this.sizeType = sizeType;
            return true;
        }
        return false;
    }

    public int getSizeValue() {
        return (int)this.sizeValue;
    }

    public void setSizeValue(int sizeValue) {
        this.sizeValue = sizeValue;
    }

    public double getSizeValueDouble() {
        return this.sizeValue;
    }

    public void setSizeValue(double sizeValue) {
        this.sizeValue = sizeValue;
    }

    public static String sizeTypeAsString(int sizeType) {
        if (sizeType == -1) {
            return "";
        }
        if (sizeType < 0 || sizeType >= sizeTypeStrings.length) {
            return null;
        }
        return sizeTypeStrings[sizeType];
    }

    public static int sizeTypeForString(String sizeType) {
        if (sizeType == null) {
            return 0;
        }
        for (int i = 0; i < sizeTypeStrings.length; ++i) {
            if (!sizeType.equalsIgnoreCase(sizeTypeStrings[i])) continue;
            return i;
        }
        return -1;
    }

    private static double getDoubleFromSize(String size) {
        double rc = -1.0;
        if (size.length() == 0) {
            return rc;
        }
        String dStr = "";
        Character decimal = new Character('.');
        for (int index = 0; index < size.length() && (Character.isDigit(size.charAt(index)) || decimal.equals(Character.valueOf(size.charAt(index)))); ++index) {
            dStr = dStr + size.charAt(index);
        }
        rc = Double.parseDouble(dStr);
        return rc;
    }

    private static String getTypeFromSize(String size) {
        int index;
        String rc = "";
        if (size.length() == 0) {
            return "pt";
        }
        Character decimal = new Character('.');
        for (index = 0; index < size.length() && (Character.isDigit(size.charAt(index)) || decimal.equals(Character.valueOf(size.charAt(index)))); ++index) {
        }
        rc = size.substring(index);
        return rc;
    }

    public String toString() {
        return this.sizeValue + Size.sizeTypeAsString(this.sizeType);
    }

    public int toPixels(int dpi, int containerWidth) {
        dpi = dpi <= 0 ? 100 : dpi;
        containerWidth = containerWidth <= 0 ? 700 : containerWidth;
        double rc = this.sizeValue;
        switch (this.sizeType) {
            case 0: {
                rc *= (double)dpi / 72.27;
                break;
            }
            case 8: {
                rc *= (double)dpi * 12.0 / 72.27;
                break;
            }
            case 5: {
                rc *= 6.0;
                break;
            }
            case 4: {
                rc *= 12.0;
                break;
            }
            case 6: {
                rc *= (double)dpi;
                break;
            }
            case 3: {
                rc *= (double)dpi / 2.54;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                rc *= (double)containerWidth / 100.0;
                break;
            }
            case 7: {
                rc *= (double)dpi / 25.4;
                break;
            }
            case 9: {
                rc *= -1.0;
                break;
            }
            case 10: {
                rc *= (double)(dpi / 150);
            }
        }
        return (int)rc;
    }

    public int toPoints(int dpi, int containerWidth) {
        int rc = (int)this.sizeValue;
        if (this.sizeType != 0 && this.sizeType != -1) {
            rc = (int)((double)this.toPixels(dpi, containerWidth) * 72.27 / (double)dpi);
        }
        return rc;
    }

    public BaseLength asBaseLength() {
        return new BaseLength(this.sizeValue, Size.sizeTypeAsString(this.sizeType));
    }
}

