/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.Style;
import java.io.IOException;
import java.io.InputStream;

public class PredefinedStyles {
    public static final String ANALYSIS = "Analysis";
    public static final String ASTRONOMY = "Astronomy";
    public static final String BANKER = "Banker";
    public static final String BLOCKPRINT = "Blockprint";
    public static final String BROWN = "Brown";
    public static final String CONVENTION = "Convention";
    public static final String CURVE = "Curve";
    public static final String DEFAULT = "Default";
    public static final String DOVE = "Dove";
    public static final String EDUCATION = "Education";
    public static final String EGDEFAULT = "EGDefault";
    public static final String ELECTRONICS = "Electronics";
    public static final String FESTIVAL = "Festival";
    public static final String GANTT = "Gantt";
    public static final String GEARS = "Gears";
    public static final String HTMLBLUE = "HtmlBlue";
    public static final String HTMLBLUECML = "HtmlBlueCML";
    public static final String JOURNAL = "Journal";
    public static final String LISTING = "Listing";
    public static final String MAGNIFY = "Magnify";
    public static final String MEADOW = "Meadow";
    public static final String MONEY = "Money";
    public static final String PEARL = "Pearl";
    public static final String PLATEAU = "Plateau";
    public static final String RAVEN = "Raven";
    public static final String RSVP = "RSVP";
    public static final String SASWEB = "SASWeb";
    public static final String SCIENCE = "Science";
    public static final String SEASIDE = "Seaside";
    public static final String SKETCH = "Sketch";
    public static final String SOLUTIONS = "Solutions";
    public static final String STATISTICAL = "Statistical";
    public static final String TORN = "Torn";
    public static final String WATERCOLOR = "Watercolor";
    public static final String SILKDEFAULT = "SILKDefault";
    public static final String[] predefinedStyles = new String[]{"Analysis", "Astronomy", "Banker", "Blockprint", "Convention", "Curve", "Default", "Dove", "Education", "EGDefault", "Electronics", "Festival", "Gantt", "Gears", "HtmlBlue", "HtmlBlueCML", "Journal", "Listing", "Magnify", "Meadow", "Money", "Plateau", "Pearl", "Raven", "RSVP", "SASWeb", "Science", "Seaside", "Sketch", "Solutions", "Statistical", "Torn", "Watercolor", "SILKDefault"};
    public static final String[] editorStyles = new String[]{"Analysis", "Astronomy", "Banker", "Blockprint", "Convention", "Curve", "Dove", "Default", "Education", "EGDefault", "Electronics", "Gantt", "Gears", "HtmlBlue", "HtmlBlueCML", "Journal", "Listing", "Magnify", "Money", "Pearl", "Raven", "RSVP", "SASWeb", "Science", "Sketch", "Statistical", "Torn", "Watercolor"};
    public static final String[] statisticalStyles = new String[]{"Analysis", "Dove", "Default", "HtmlBlue", "HtmlBlueCML", "Journal", "Listing", "Pearl", "Raven", "Statistical"};

    public static boolean isPredefinedStyle(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < predefinedStyles.length; ++i) {
            if (!name.equalsIgnoreCase(predefinedStyles[i])) continue;
            return true;
        }
        return false;
    }

    public static Style getPredefinedStyle(String style) {
        if (style == null) {
            return null;
        }
        String location = "/com/sas/graphics/styles/xml/" + style.toUpperCase() + ".xml";
        InputStream is = Style.class.getResourceAsStream(location);
        if (is == null) {
            return null;
        }
        Style rc = Style.getReadOnlyStyle(is);
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rc;
    }

    public static String getDisplayName(String styleName) {
        for (int i = 0; i < predefinedStyles.length; ++i) {
            if (!styleName.equalsIgnoreCase(predefinedStyles[i])) continue;
            return predefinedStyles[i];
        }
        return styleName;
    }
}

