/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.AttributeNames;
import com.sas.graphics.styles.Size;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.HTMLColors;
import com.sas.graphics.util.Markers;
import java.awt.Color;
import org.w3c.dom.Element;

public class MarkerStyleElement
extends StyleElement
implements AttributeNames {
    public static Color defaultMarkerColor = Color.BLACK;
    public static final Size defaultMarkerSize = new Size(7, 1);
    public static final int defaultMarkerSymbol = 0;

    public MarkerStyleElement(Element styleElement) {
        super(styleElement);
    }

    public Color getMarkerColor() {
        return this.getColorAttribute("markerColor", this.getColorAttribute("altColor", defaultMarkerColor));
    }

    public boolean setMarkerColor(Color c) {
        String s = HTMLColors.getColorString(c);
        if (s == null) {
            return false;
        }
        return this.setAttribute("markerColor", s);
    }

    public Size getMarkerSize() {
        return this.getSizeAttribute("markerSize", defaultMarkerSize);
    }

    public boolean setMarkerSize(Size markerSize) {
        return this.setAttribute("markerSize", markerSize.toString());
    }

    public int getMarkerSymbol() {
        if (!this.hasAttribute("markerSymbol")) {
            return 0;
        }
        int shape = Markers.getShape(this.getAttribute("markerSymbol"));
        if (shape == -1) {
            shape = 0;
        }
        return shape;
    }

    public boolean setMarkerSymbol(int symbol) {
        return this.setAttribute("markerSymbol", Markers.getShapeName(symbol));
    }
}

