/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles;

import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributesTable {
    public static final int VALUE_TYPE_ANY = 0;
    public static final int VALUE_TYPE_COLUMN_NAME = 1;
    public static final int VALUE_TYPE_DATA_VALUE = 2;
    private Vector entries = new Vector();
    private EventListenerList listeners = new EventListenerList();
    public static final String ENTRY_ADDED = "entryAdded";
    public static final String ENTRY_REMOVED = "entryRemoved";
    public static final String ENTRY_CHANGED = "entryChanged";
    private String name = "Default";

    public AttributesTable(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean newEntry(String value) {
        return this.newEntry(value, null);
    }

    public boolean newEntry(String value, String styleReference) {
        return this.newEntry(value, 0, styleReference);
    }

    public boolean newEntry(String value, int type, String styleReference) {
        if (value == null) {
            return false;
        }
        if (this.containsEntry(value = value.trim(), type)) {
            return false;
        }
        AttributesTableEntry entry = new AttributesTableEntry();
        if (styleReference != null) {
            entry.styleReference = styleReference;
        }
        entry.type = type;
        entry.value = value;
        this.entries.addElement(entry);
        this.firePropertyChange(ENTRY_ADDED, null, value);
        return true;
    }

    public boolean containsEntry(String value, int type) {
        if (this.entries.isEmpty()) {
            return false;
        }
        return this.getIndexOf(value, type) >= 0;
    }

    public int getIndexOf(String value, int type) {
        if (value == null) {
            return -1;
        }
        value = value.trim();
        for (int i = 0; i < this.getNumberEntries(); ++i) {
            AttributesTableEntry entry = (AttributesTableEntry)this.entries.elementAt(i);
            if (!entry.value.equalsIgnoreCase(value) || type != entry.type) continue;
            return i;
        }
        return -1;
    }

    public boolean removeEntry(String value, int type) {
        if (!this.containsEntry(value, type)) {
            return false;
        }
        this.entries.remove(this.getIndexOf(value, type));
        this.firePropertyChange(ENTRY_REMOVED, value, null);
        return true;
    }

    public int getNumberEntries() {
        return this.entries.size();
    }

    public String getValueAt(int i) {
        if (i < 0 || i >= this.entries.size()) {
            return null;
        }
        return ((AttributesTableEntry)this.entries.elementAt((int)i)).value;
    }

    public int getTypeAt(int i) {
        if (i < 0 || i >= this.entries.size()) {
            return 0;
        }
        return ((AttributesTableEntry)this.entries.elementAt((int)i)).type;
    }

    public String getStyleReference(String value, int type) {
        if (!this.containsEntry(value, type)) {
            return null;
        }
        return this.getEntry((String)value, (int)type).styleReference;
    }

    public boolean setStyleReference(String value, int type, String reference) {
        if (reference == null || !this.containsEntry(value, type)) {
            return false;
        }
        AttributesTableEntry entry = this.getEntry(value, type);
        String old = entry.styleReference;
        entry.styleReference = reference;
        this.firePropertyChange(ENTRY_CHANGED, old, reference);
        return true;
    }

    public boolean setAttributeOverride(String value, int type, String attributeName, String attributeValue) {
        if (!this.containsEntry(value, type) || attributeName == null) {
            return false;
        }
        AttributesTableEntry entry = this.getEntry(value, type);
        if (entry.overrides == null) {
            entry.overrides = new StyleElement();
        }
        entry.overrides.setAttribute(attributeName, attributeValue);
        this.firePropertyChange(ENTRY_CHANGED, null, attributeName);
        return true;
    }

    private AttributesTableEntry getEntry(String value, int type) {
        if (!this.containsEntry(value, type)) {
            return null;
        }
        return (AttributesTableEntry)this.entries.elementAt(this.getIndexOf(value, type));
    }

    public StyleElement getStyleElement(String value, int type, Style style) {
        StyleElement rc = null;
        AttributesTableEntry entry = this.getEntry(value, type);
        if (entry == null) {
            entry = this.getEntry(value, 0);
        }
        if (entry == null) {
            return null;
        }
        if (style == null) {
            return null;
        }
        rc = style.getStyleElement(entry.styleReference);
        if (entry.overrides != null) {
            rc = rc.mergeWith(entry.overrides);
        }
        return rc;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(PropertyChangeListener.class, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(PropertyChangeListener.class, listener);
    }

    private void firePropertyChange(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, property, oldValue, newValue);
        EventListener[] list = this.listeners.getListeners(PropertyChangeListener.class);
        for (int i = 0; i < list.length; ++i) {
            ((PropertyChangeListener)list[i]).propertyChange(evt);
        }
    }

    public static AttributesTable getAttributesTable(Element xmlElement) {
        if (xmlElement == null) {
            return null;
        }
        AttributesTable rc = new AttributesTable(xmlElement.getAttribute("name"));
        NodeList nodes = xmlElement.getChildNodes();
        int num = nodes.getLength();
        for (int i = 0; i < num; ++i) {
            Element e;
            Node n = nodes.item(i);
            if (n.getNodeType() != 1 || !(e = (Element)n).getTagName().equalsIgnoreCase("ValueStyle") || !e.hasAttribute("value")) continue;
            String value = e.getAttribute("value");
            int type = 0;
            if (e.hasAttribute("valueUsage")) {
                String ty = e.getAttribute("valueUsage");
                if (ty.equalsIgnoreCase("value")) {
                    type = 2;
                } else if (ty.equalsIgnoreCase("variable")) {
                    type = 1;
                }
            }
            String reference = "GraphDataStyleDefault";
            if (e.hasAttribute("styleElement")) {
                reference = e.getAttribute("styleElement");
            }
            rc.newEntry(value, type, reference);
            AttributesTableEntry entry = rc.getEntry(value, type);
            if (entry == null) continue;
            if (e.hasAttribute("isValueFormatted")) {
                entry.isValueFormatted = "true".equalsIgnoreCase(e.getAttribute("isValueFormatted"));
            }
            entry.overrides = new StyleElement(e);
        }
        return rc;
    }

    class AttributesTableEntry {
        int type = 0;
        String value = null;
        boolean isValueFormatted = true;
        String styleReference = "GraphDataStyleDefault";
        StyleElement overrides = null;

        AttributesTableEntry() {
        }
    }
}

