/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.image;

import com.sas.graphics.image.Filter;
import com.sas.graphics.image.GaussianFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;

public class DropShadowFilter
extends Filter {
    private boolean inner = true;
    private float distance = 5.0f;
    private float angle = 45.0f;
    private float blurX = 5.0f;
    private float blurY = 5.0f;
    private float strength = 1.0f;
    private int quality = 1;
    private Color color = Color.black;
    private float alpha = 0.5f;
    private boolean hideObject = false;
    private boolean knockout = false;
    private int height;
    private int width;
    private int offsetX;
    private int offsetY;

    public void setInner(boolean b) {
        this.inner = b;
    }

    public boolean isInner() {
        return this.inner;
    }

    public void setDistance(float d) {
        this.distance = d;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setAngle(float ang) {
        this.angle = ang;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public void setAlpha(float a) {
        this.alpha = a;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setBlurX(float blur) {
        this.blurX = blur;
    }

    public float getBlurX() {
        return this.blurX;
    }

    public void setBlurY(float blur) {
        this.blurY = blur;
    }

    public float getBlurY() {
        return this.blurY;
    }

    public void setHideObject(boolean b) {
        this.hideObject = b;
    }

    public boolean isHideObject() {
        return this.hideObject;
    }

    public void setStrength(float s) {
        this.strength = s;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setQuality(int q) {
        this.quality = q;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setKnockout(boolean b) {
        this.knockout = b;
    }

    public boolean isKnockout() {
        return this.knockout;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        this.width = src.getWidth();
        this.height = src.getHeight();
        this.computeOffsets();
        if (dst == null) {
            dst = new BufferedImage(this.width, this.height, 2);
        }
        int shadowColor = this.color.getRGB();
        float shadowR = (float)(shadowColor >> 16 & 0xFF) / 255.0f;
        float shadowG = (float)(shadowColor >> 8 & 0xFF) / 255.0f;
        float shadowB = (float)(shadowColor & 0xFF) / 255.0f;
        float[][] extractAlpha = new float[][]{{0.0f, 0.0f, 0.0f, shadowR}, {0.0f, 0.0f, 0.0f, shadowG}, {0.0f, 0.0f, 0.0f, shadowB}, {0.0f, 0.0f, 0.0f, this.alpha}};
        BufferedImage shadowSrc = this.inner ? this.createShadowSourceImage(src) : src;
        BufferedImage shadow = new BufferedImage(this.width, this.height, 2);
        new BandCombineOp(extractAlpha, null).filter(shadowSrc.getRaster(), shadow.getRaster());
        if ((this.blurX > 0.0f || this.blurY > 0.0f) && this.quality > 0) {
            double bx = 0.0;
            double by = 0.0;
            for (int i = 0; i < this.quality; ++i) {
                bx += (double)(this.blurX * this.blurX);
                by += (double)(this.blurY * this.blurY);
            }
            this.blurX = (float)Math.sqrt(bx);
            this.blurY = (float)Math.sqrt(by);
            GaussianFilter filter = new GaussianFilter(this.blurX, this.blurY);
            filter.filter(shadow, shadow);
        }
        if (this.strength > 1.0f) {
            this.applyStrength(shadow);
        }
        Graphics2D g = dst.createGraphics();
        if (this.inner) {
            this.clipInnerShadow(shadow, src);
            if (!this.hideObject) {
                g.drawRenderedImage(src, null);
            }
            g.setComposite(AlphaComposite.SrcOver);
            g.drawRenderedImage(shadow, null);
        } else {
            if (this.knockout) {
                this.clipOuterShadow(shadow, src);
            }
            g.drawRenderedImage(shadow, AffineTransform.getTranslateInstance(this.offsetX, this.offsetY));
            if (!this.hideObject) {
                g.setComposite(AlphaComposite.SrcOver);
                g.drawRenderedImage(src, null);
            }
        }
        g.dispose();
        return dst;
    }

    private void computeOffsets() {
        this.offsetX = (int)((double)this.distance * Math.cos((double)this.angle * Math.PI / 180.0) + 0.5);
        this.offsetY = (int)((double)this.distance * Math.sin((double)this.angle * Math.PI / 180.0) + 0.5);
    }

    private BufferedImage createShadowSourceImage(BufferedImage src) {
        BufferedImage dst = new BufferedImage(this.width, this.height, 2);
        BufferedImage tmp = new BufferedImage(this.width, this.height, 2);
        AffineTransformOp op = new AffineTransformOp(AffineTransform.getTranslateInstance(this.offsetX, this.offsetY), null);
        op.filter(src, tmp);
        int[] srcPixels = new int[this.width * this.height];
        int[] tmpPixels = new int[this.width * this.height];
        int[] dstPixels = new int[this.width * this.height];
        src.getRGB(0, 0, this.width, this.height, srcPixels, 0, this.width);
        tmp.getRGB(0, 0, this.width, this.height, tmpPixels, 0, this.width);
        dst.getRGB(0, 0, this.width, this.height, dstPixels, 0, this.width);
        for (int j = 0; j < this.height; ++j) {
            int offset = this.width * j;
            for (int i = 0; i < this.width; ++i) {
                int rgb = srcPixels[offset + i];
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                int rgb2 = tmpPixels[offset + i];
                int a2 = rgb2 >> 24 & 0xFF;
                a = 255 - a2;
                dstPixels[offset + i] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        dst.setRGB(0, 0, this.width, this.height, dstPixels, 0, this.width);
        return dst;
    }

    private void clipInnerShadow(BufferedImage shadow, BufferedImage src) {
        int[] srcPixels = new int[this.width * this.height];
        int[] shadowPixels = new int[this.width * this.height];
        shadow.getRGB(0, 0, this.width, this.height, shadowPixels, 0, this.width);
        src.getRGB(0, 0, this.width, this.height, srcPixels, 0, this.width);
        for (int j = 0; j < this.height; ++j) {
            int offset = this.width * j;
            for (int i = 0; i < this.width; ++i) {
                int rgb = shadowPixels[offset + i];
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                int rgb2 = srcPixels[offset + i];
                int a2 = rgb2 >> 24 & 0xFF;
                a = (int)((double)(a * a2) / 255.0);
                shadowPixels[offset + i] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        shadow.setRGB(0, 0, this.width, this.height, shadowPixels, 0, this.width);
    }

    private void clipOuterShadow(BufferedImage shadow, BufferedImage src) {
        BufferedImage tmp = new BufferedImage(this.width, this.height, 2);
        AffineTransformOp op = new AffineTransformOp(AffineTransform.getTranslateInstance(-this.offsetX, -this.offsetY), null);
        op.filter(src, tmp);
        int[] tmpPixels = new int[this.width * this.height];
        int[] shadowPixels = new int[this.width * this.height];
        shadow.getRGB(0, 0, this.width, this.height, shadowPixels, 0, this.width);
        tmp.getRGB(0, 0, this.width, this.height, tmpPixels, 0, this.width);
        for (int j = 0; j < this.height; ++j) {
            int offset = this.width * j;
            for (int i = 0; i < this.width; ++i) {
                int rgb = shadowPixels[offset + i];
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                int rgb2 = tmpPixels[offset + i];
                int a2 = rgb2 >> 24 & 0xFF;
                a = (int)((double)a * (255.0 - (double)a2) / 255.0);
                shadowPixels[offset + i] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        shadow.setRGB(0, 0, this.width, this.height, shadowPixels, 0, this.width);
    }

    private void applyStrength(BufferedImage shadow) {
        int[] shadowPixels = new int[this.width * this.height];
        shadow.getRGB(0, 0, this.width, this.height, shadowPixels, 0, this.width);
        int alphaCap = (int)((double)this.alpha * 255.0);
        for (int j = 0; j < this.height; ++j) {
            int offset = this.width * j;
            for (int i = 0; i < this.width; ++i) {
                int rgb = shadowPixels[offset + i];
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                a = (int)Math.min((float)alphaCap, (float)a * this.strength);
                shadowPixels[offset + i] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        shadow.setRGB(0, 0, this.width, this.height, shadowPixels, 0, this.width);
    }
}

