/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.image;

import com.sas.graphics.image.Filter;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class DilationFilter
extends Filter {
    private Color foreground = Color.black;
    private int iterations = 1;
    private int threshold = 1;
    private int radius = 1;

    public DilationFilter() {
    }

    public DilationFilter(int radius) {
        this.radius = radius;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setForeground(Color c) {
        this.foreground = c;
    }

    public Color getForeground() {
        return this.foreground;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = new BufferedImage(width, height, 2);
        }
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        src.getRGB(0, 0, width, height, inPixels, 0, width);
        this.filterPixels(width, height, inPixels, outPixels);
        dst.setRGB(0, 0, width, height, outPixels, 0, width);
        return dst;
    }

    private void filterPixels(int width, int height, int[] inPixels, int[] outPixels) {
        int newColor = this.foreground.getRGB();
        for (int i = 0; i < this.iterations; ++i) {
            int index = 0;
            if (i > 0) {
                int[] t = inPixels;
                inPixels = outPixels;
                outPixels = t;
            }
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = inPixels[y * width + x];
                    if (!this.isForeground(pixel)) {
                        int neighbours = 0;
                        for (int dy = -this.radius; dy <= this.radius; ++dy) {
                            int iy = y + dy;
                            if (0 > iy || iy >= height) continue;
                            int ioffset = iy * width;
                            for (int dx = -this.radius; dx <= this.radius; ++dx) {
                                int rgb;
                                int ix = x + dx;
                                if (dy == 0 && dx == 0 || 0 > ix || ix >= width || !this.isForeground(rgb = inPixels[ioffset + ix])) continue;
                                ++neighbours;
                            }
                        }
                        if (neighbours >= this.threshold) {
                            pixel = newColor;
                        }
                    }
                    outPixels[index++] = pixel;
                }
            }
        }
    }

    private boolean isForeground(int rgb) {
        return rgb == this.foreground.getRGB();
    }
}

