/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno.ui;

import com.sas.graphics.sg.interfaces.TextInterface;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.SimpleTextCustomizerPanel;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sganno.AnnotateElement;
import com.sas.graphics.sganno.LineElement;
import com.sas.graphics.sganno.TextElement;
import com.sas.graphics.sganno.ui.RB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class TextCustomizerPanel
extends JPanel
implements ActionListener {
    public static final String RB_KEY = "TextCustomizerPanel.";
    TextInterface textStyle;
    private static final int dlu2 = UIUtil.DLU * 2;
    private static final int dlu3 = UIUtil.DLU * 3;
    private static final int dlu4 = UIUtil.DLU * 4;
    private static final int dlu7 = UIUtil.DLU * 7;
    private static final Border empty = BorderFactory.createEmptyBorder(0, dlu7, dlu3, 0);
    private ColorGrabber colorGrabber;

    public TextCustomizerPanel(TextInterface textStyle, ColorGrabber cg) {
        this.textStyle = textStyle;
        this.colorGrabber = cg;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(UIUtil.emptyBorder);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(new LineBorder(Color.GRAY), " " + RB.getStringResource("font.txt")));
        panel.setLayout(new BorderLayout());
        SimpleTextCustomizerPanel textPanel = new SimpleTextCustomizerPanel(this.textStyle, this.colorGrabber);
        textPanel.setBorder(empty);
        panel.add(textPanel);
        this.add(panel);
        if (this.textStyle instanceof AnnotateElement && !(this.textStyle instanceof TextElement)) {
            this.add(Box.createRigidArea(new Dimension(0, dlu4)));
            JPanel posPanel = this.textStyle instanceof LineElement ? this.createLinePositionPanel((LineElement)this.textStyle) : this.createPositionPanel((AnnotateElement)this.textStyle);
            this.add(posPanel);
        }
        this.add(Box.createVerticalGlue());
    }

    private JPanel createPositionPanel(AnnotateElement ae) {
        JPanel posPanel = new JPanel();
        posPanel.setLayout(new BoxLayout(posPanel, 1));
        int pos = ae.getTextPosition();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(dlu2, 0)));
        ButtonGroup bg = new ButtonGroup();
        JRadioButton b = new JRadioButton(RB.getStringResource(RB_KEY, "inside.txt"));
        if (pos == 0) {
            b.setSelected(true);
        }
        b.addActionListener(this);
        b.setActionCommand("inside");
        bg.add(b);
        panel.add(b);
        panel.add(Box.createHorizontalGlue());
        posPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(dlu2, 0)));
        b = new JRadioButton(RB.getStringResource(RB_KEY, "above.txt"));
        if (pos == 1) {
            b.setSelected(true);
        }
        b.addActionListener(this);
        b.setActionCommand("above");
        bg.add(b);
        panel.add(b);
        panel.add(Box.createHorizontalGlue());
        posPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(dlu2, 0)));
        b = new JRadioButton(RB.getStringResource(RB_KEY, "below.txt"));
        if (pos == 3) {
            b.setSelected(true);
        }
        b.addActionListener(this);
        b.setActionCommand("below");
        bg.add(b);
        panel.add(b);
        panel.add(Box.createHorizontalGlue());
        posPanel.add(panel);
        posPanel.setBorder(BorderFactory.createTitledBorder(new LineBorder(Color.GRAY), " " + RB.getStringResource("position.txt")));
        return posPanel;
    }

    private JPanel createLinePositionPanel(LineElement le) {
        JPanel posPanel = new JPanel();
        posPanel.setLayout(new BoxLayout(posPanel, 1));
        int pos = le.getTextPosition();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(dlu2, 0)));
        ButtonGroup bg = new ButtonGroup();
        JRadioButton b = new JRadioButton(RB.getStringResource(RB_KEY, "through.txt"));
        if (pos == 0) {
            b.setSelected(true);
        }
        b.addActionListener(this);
        b.setActionCommand("inside");
        bg.add(b);
        panel.add(b);
        panel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        b = new JRadioButton(RB.getStringResource(RB_KEY, "above.txt"));
        if (pos == 1) {
            b.setSelected(true);
        }
        b.addActionListener(this);
        b.setActionCommand("above");
        bg.add(b);
        panel.add(b);
        panel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        b = new JRadioButton(RB.getStringResource(RB_KEY, "below.txt"));
        if (pos == 3) {
            b.setSelected(true);
        }
        b.addActionListener(this);
        b.setActionCommand("below");
        bg.add(b);
        panel.add(b);
        panel.add(Box.createHorizontalGlue());
        posPanel.add(panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(dlu2, 0)));
        b = new JRadioButton(RB.getStringResource("start.txt"));
        if (pos == 10) {
            b.setSelected(true);
        }
        b.addActionListener(this);
        b.setActionCommand("start");
        bg.add(b);
        panel.add(b);
        panel.add(Box.createRigidArea(new Dimension(4 * UIUtil.DLU, 0)));
        b = new JRadioButton(RB.getStringResource("end.txt"));
        if (pos == 11) {
            b.setSelected(true);
        }
        b.addActionListener(this);
        b.setActionCommand("end");
        bg.add(b);
        panel.add(b);
        panel.add(Box.createHorizontalGlue());
        posPanel.add(panel);
        Enumeration<AbstractButton> e = bg.getElements();
        Dimension ps = ((JRadioButton)e.nextElement()).getPreferredSize();
        while (e.hasMoreElements()) {
            Dimension ps2 = ((JRadioButton)e.nextElement()).getPreferredSize();
            if (ps2.width > ps.width) {
                ps.width = ps2.width;
            }
            if (ps2.height <= ps.height) continue;
            ps.height = ps2.height;
        }
        e = bg.getElements();
        while (e.hasMoreElements()) {
            JRadioButton rb = (JRadioButton)e.nextElement();
            rb.setMaximumSize(ps);
            rb.setPreferredSize(ps);
        }
        posPanel.setBorder(BorderFactory.createTitledBorder(new LineBorder(Color.GRAY), " " + RB.getStringResource("position.txt")));
        return posPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (this.textStyle instanceof AnnotateElement) {
            AnnotateElement ae = (AnnotateElement)this.textStyle;
            if (cmd.equals("inside")) {
                ae.setTextPosition(0);
            } else if (cmd.equals("above")) {
                ae.setTextPosition(1);
            } else if (cmd.equals("below")) {
                ae.setTextPosition(3);
            } else if (cmd.equals("start")) {
                ae.setTextPosition(10);
            } else if (cmd.equals("end")) {
                ae.setTextPosition(11);
            }
        }
    }
}

