/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno.ui;

import com.sas.graphics.sg.interfaces.AreaInterface;
import com.sas.graphics.sg.interfaces.DefaultAreaInterface;
import com.sas.graphics.sg.ui.ColorComboBoxEditor;
import com.sas.graphics.sg.ui.ColorGrabber;
import com.sas.graphics.sg.ui.CompTitledBorder;
import com.sas.graphics.sg.ui.LineCustomizerPanel;
import com.sas.graphics.sg.ui.SGDialog;
import com.sas.graphics.sg.ui.SwatchActionEvent;
import com.sas.graphics.sg.ui.SwatchComboBox;
import com.sas.graphics.sg.ui.SwatchLabel;
import com.sas.graphics.sg.ui.SwatchRenderer;
import com.sas.graphics.sg.ui.UIUtil;
import com.sas.graphics.sganno.AnnotateElement;
import com.sas.graphics.sganno.Group;
import com.sas.graphics.sganno.ImageElement;
import com.sas.graphics.sganno.ui.RB;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AppearanceCustomizerPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final int dlu2 = UIUtil.DLU * 2;
    private static final int dlu4 = UIUtil.DLU * 4;
    private static final int dlu7 = UIUtil.DLU * 7;
    private static final Border left = BorderFactory.createEmptyBorder(0, dlu7, 0, dlu7);
    public static final String RB_KEY = "AppearanceCustomizerPanel.";
    AreaInterface areaStyle;
    JCheckBox fill;
    JCheckBox outline;
    SwatchComboBox fillcolor;
    boolean enablefill = true;
    CompTitledBorder lineBorder;
    CompTitledBorder fillBorder;
    protected LineCustomizerPanel linePanel;
    protected JPanel fillPanel;
    private String defaultColorSource = "";
    private JPanel transparencyPanel;
    private JSlider transparency;
    private ColorGrabber colorGrabber;
    private JDialog dialog = null;

    public AppearanceCustomizerPanel(AreaInterface areaStyle, ColorGrabber cg) {
        this.areaStyle = areaStyle;
        this.colorGrabber = cg;
        if (areaStyle instanceof AnnotateElement) {
            this.enablefill = ((AnnotateElement)areaStyle).isAreaAttrsEnabled();
        } else if (areaStyle instanceof Group) {
            this.enablefill = ((Group)areaStyle).isAreaAttrsEnabled();
        }
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(UIUtil.emptyBorder);
        this.fillPanel = new JPanel();
        this.fillPanel.setBorder(left);
        this.fillPanel.setLayout(new BoxLayout(this.fillPanel, 1));
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 0));
        JLabel colorlabel = new JLabel(RB.getStringResource(RB_KEY, "fillColor.txt"));
        colorPanel.add(colorlabel);
        colorPanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        Color defaultColor = null;
        if (this.areaStyle instanceof DefaultAreaInterface) {
            DefaultAreaInterface dai = (DefaultAreaInterface)((Object)this.areaStyle);
            defaultColor = dai.getDefaultFillColor();
            this.defaultColorSource = dai.getDefaultFillColorSource();
            this.fillcolor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, this.defaultColorSource, defaultColor, RB.getStringResource("morecolorsdots.txt"));
            this.fillcolor.setEditor(new ColorComboBoxEditor(this.defaultColorSource, defaultColor));
            ColorComboBoxEditor editor = new ColorComboBoxEditor(this.defaultColorSource, defaultColor);
            this.fillcolor.setEditor(editor);
            editor.addMouseListener(this.fillcolor);
        } else {
            this.fillcolor = new SwatchComboBox(UIUtil.getColors(), 8, 4, this.colorGrabber, null, null, RB.getStringResource("morecolorsdots.txt"));
            SimpleEditor se = new SimpleEditor();
            this.fillcolor.setEditor(se);
            se.addMouseListener(this.fillcolor);
        }
        this.fillcolor.setEditable(true);
        Color c = this.areaStyle.getFillColor();
        if (c != null) {
            this.fillcolor.setSelectedItem(c);
        } else {
            this.fillcolor.setSelectedItem(this.defaultColorSource);
        }
        this.fillcolor.setRenderer(new SwatchRenderer());
        this.fillcolor.setActionCommand("fillcolor");
        this.fillcolor.addActionListener(this);
        colorPanel.add(this.fillcolor);
        colorPanel.add(Box.createHorizontalGlue());
        this.fillPanel.add(colorPanel);
        JLabel translabel = null;
        this.transparencyPanel = new JPanel();
        this.transparencyPanel.setLayout(new BoxLayout(this.transparencyPanel, 0));
        translabel = new JLabel(RB.getStringResource(RB_KEY, "transparency.txt"));
        this.transparencyPanel.add(translabel);
        this.transparencyPanel.add(Box.createRigidArea(new Dimension(3 * UIUtil.DLU, 0)));
        this.transparency = new JSlider(0, 0, 100, this.areaStyle.getFillTrans());
        this.transparency.addChangeListener(this);
        this.transparency.setMajorTickSpacing(25);
        this.transparency.setMinorTickSpacing(5);
        this.transparency.setPaintTicks(true);
        this.transparencyPanel.add(this.transparency);
        this.transparencyPanel.add(Box.createHorizontalGlue());
        this.fillPanel.add(Box.createRigidArea(new Dimension(0, 7 * UIUtil.DLU)));
        this.fillPanel.add(this.transparencyPanel);
        this.fill = new JCheckBox(RB.getStringResource(RB_KEY, "fill.txt"));
        this.fill.setBorder(BorderFactory.createEmptyBorder(0, dlu2, 0, dlu2));
        this.fill.addActionListener(this);
        this.fill.setActionCommand("fill");
        JPanel fillGroupPanel = new JPanel(){

            @Override
            public void doLayout() {
                Insets insets = this.getInsets();
                Rectangle rect = this.getBounds();
                rect.x = 0;
                rect.y = 0;
                if (AppearanceCustomizerPanel.this.fillBorder == null) {
                    return;
                }
                Rectangle compR = AppearanceCustomizerPanel.this.fillBorder.getComponentRect(rect, insets);
                AppearanceCustomizerPanel.this.fill.setBounds(compR);
                rect.x += insets.left;
                rect.y += insets.top;
                rect.width -= insets.left + insets.right;
                rect.height -= insets.top + insets.bottom;
                AppearanceCustomizerPanel.this.fillPanel.setBounds(rect);
            }

            @Override
            public Dimension getPreferredSize() {
                Insets insets = super.getInsets();
                Dimension ps2 = AppearanceCustomizerPanel.this.fillPanel.getPreferredSize();
                return new Dimension((int)(ps2.getWidth() + (double)insets.left + (double)insets.right), (int)ps2.getHeight() + insets.top + insets.bottom);
            }
        };
        fillGroupPanel.add(this.fill);
        fillGroupPanel.add(this.fillPanel);
        this.fillBorder = new CompTitledBorder((Border)new LineBorder(Color.GRAY), this.fill);
        fillGroupPanel.setBorder(this.fillBorder);
        this.add(fillGroupPanel);
        this.add(Box.createRigidArea(new Dimension(0, dlu4)));
        this.linePanel = new LineCustomizerPanel(this.areaStyle, this.colorGrabber);
        this.linePanel.setBorder(left);
        if (!this.enablefill) {
            if (this.areaStyle instanceof ImageElement || this.areaStyle instanceof Group && ((Group)this.areaStyle).isOutlineOnAttrsEnabled()) {
                this.outline = new JCheckBox(RB.getStringResource(RB_KEY, "outline.txt"));
                this.outline.setEnabled(true);
            } else {
                this.outline = new JCheckBox(RB.getStringResource(RB_KEY, "line.txt"));
                this.outline.setEnabled(false);
            }
            this.fill.setEnabled(this.enablefill);
            this.fillcolor.setEnabled(this.enablefill);
            this.transparency.setEnabled(this.enablefill);
            boolean lineOn = this.areaStyle.isLineOn();
            this.outline.setSelected(lineOn);
            this.linePanel.setEnabledAll(lineOn);
        } else {
            this.outline = new JCheckBox(RB.getStringResource(RB_KEY, "outline.txt"));
            this.fill.setSelected(this.areaStyle.isFillOn());
            boolean fillOn = this.areaStyle.isFillOn();
            boolean lineOn = this.areaStyle.isLineOn();
            this.fillcolor.setEnabled(fillOn);
            this.transparency.setEnabled(fillOn);
            this.outline.setEnabled(fillOn);
            this.fill.setEnabled(lineOn);
            this.outline.setSelected(lineOn);
            this.linePanel.setEnabledAll(lineOn);
        }
        this.outline.setActionCommand("lineon");
        this.outline.addActionListener(this);
        this.outline.addActionListener(this.linePanel);
        this.outline.setBorder(BorderFactory.createEmptyBorder(0, dlu2, 0, dlu2));
        JPanel outlinePanel = new JPanel(){

            @Override
            public void doLayout() {
                Insets insets = this.getInsets();
                Rectangle rect = this.getBounds();
                rect.x = 0;
                rect.y = 0;
                if (AppearanceCustomizerPanel.this.lineBorder == null) {
                    return;
                }
                Rectangle compR = AppearanceCustomizerPanel.this.lineBorder.getComponentRect(rect, insets);
                AppearanceCustomizerPanel.this.outline.setBounds(compR);
                rect.x += insets.left;
                rect.y += insets.top;
                rect.width -= insets.left + insets.right;
                rect.height -= insets.top + insets.bottom;
                AppearanceCustomizerPanel.this.linePanel.setBounds(rect);
            }

            @Override
            public Dimension getPreferredSize() {
                Insets insets = super.getInsets();
                Dimension ps2 = AppearanceCustomizerPanel.this.linePanel.getPreferredSize();
                return new Dimension((int)(ps2.getWidth() + (double)insets.left + (double)insets.right), (int)ps2.getHeight() + insets.top + insets.bottom);
            }
        };
        outlinePanel.add(this.outline);
        outlinePanel.add(this.linePanel);
        this.lineBorder = new CompTitledBorder((Border)new LineBorder(Color.GRAY), this.outline);
        outlinePanel.setBorder(this.lineBorder);
        this.add(outlinePanel);
        Dimension lps = this.linePanel.getLabelPreferredSize();
        Dimension wps = this.linePanel.getWidgetPreferredSize();
        Dimension ps1 = colorlabel.getPreferredSize();
        Dimension ps2 = this.fillcolor.getPreferredSize();
        lps.setSize(Math.max(lps.width, ps1.width), Math.max(lps.height, ps1.height));
        wps.setSize(Math.max(wps.width, ps2.width), Math.max(wps.height, ps2.height));
        ps1 = translabel.getPreferredSize();
        lps.setSize(Math.max(lps.width, ps1.width), Math.max(lps.height, ps1.height));
        translabel.setPreferredSize(lps);
        translabel.setMaximumSize(lps);
        this.transparency.setPreferredSize(wps);
        this.transparency.setMaximumSize(wps);
        this.fillcolor.setPreferredSize(wps);
        this.fillcolor.setMaximumSize(wps);
        colorlabel.setPreferredSize(lps);
        colorlabel.setMaximumSize(lps);
        this.linePanel.setLabelPreferredSize(lps);
        this.linePanel.setWidgetPreferredSize(wps);
        this.add(Box.createVerticalGlue());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Container parent;
        JPanel panel;
        JColorChooser cc;
        Color save;
        block25: {
            String cmd;
            block24: {
                cmd = e.getActionCommand();
                if (cmd.equals("fill")) {
                    boolean on = this.fill.isSelected();
                    this.areaStyle.setFillOn(on);
                    this.outline.setEnabled(on);
                    if (on) {
                        this.fillcolor.removeActionListener(this);
                        Color c = this.areaStyle.getFillColor();
                        if (c != null) {
                            this.fillcolor.setSelectedItem(c);
                        } else {
                            this.fillcolor.setSelectedItem(this.defaultColorSource);
                        }
                        this.fillcolor.addActionListener(this);
                    }
                    this.fillcolor.setEnabled(on);
                    this.transparency.setEnabled(on);
                    return;
                }
                if (!cmd.equals("fillcolor")) break block24;
                Object item = this.fillcolor.getSelectedItem();
                if (item == null) return;
                save = this.areaStyle.getFillColor();
                if (!(item instanceof String)) {
                    if (!(item instanceof Color)) return;
                    this.areaStyle.setFillColor((Color)item);
                    return;
                }
                if (((String)item).equals(RB.getStringResource("morecolorsdots.txt"))) {
                    cc = UIUtil.colorChooser;
                    if (save == null) {
                        if (this.areaStyle instanceof DefaultAreaInterface) {
                            cc.setColor(((DefaultAreaInterface)((Object)this.areaStyle)).getDefaultFillColor());
                        }
                    } else {
                        cc.setColor(save);
                    }
                    cc.setPreviewPanel(new JPanel());
                    panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    panel.add(cc);
                    break block25;
                } else {
                    if (((String)item).equals(this.defaultColorSource)) {
                        this.areaStyle.setFillColor(null);
                        return;
                    }
                    Container c = this.getTopLevelAncestor();
                    if (c instanceof SGDialog) {
                        SGDialog sgd = (SGDialog)c;
                        sgd.setValue(-1);
                        this.dialog = sgd.makeDisabledCopy(this.colorGrabber);
                        c.setVisible(false);
                        this.dialog.setVisible(true);
                    }
                    c = this.colorGrabber.getComponent().getTopLevelAncestor();
                    c.requestFocus();
                    if (this.dialog != null) {
                        this.dialog.toFront();
                    }
                    this.colorGrabber.setMouseEventListener();
                    this.colorGrabber.addActionListener(this);
                    if (save == null) {
                        this.colorGrabber.setStartColor(this.defaultColorSource);
                        return;
                    }
                    this.colorGrabber.setStartColor(save);
                    return;
                }
            }
            if (cmd.equals("colorpicker:done")) {
                Object color = ((SwatchActionEvent)e).getValue();
                this.fillcolor.setSelectedItem(color);
                this.fillcolor.setEnabled(true);
                this.colorGrabber.removeMouseEventListener();
                this.colorGrabber.removeActionListener(this);
                if (this.dialog == null) return;
                this.dialog.dispose();
                return;
            }
            if (cmd.equals("colorpicker:updating")) {
                int i;
                Color color = (Color)((SwatchActionEvent)e).getValue();
                if (color == null) return;
                ActionListener[] listener = this.fillcolor.getActionListeners();
                for (i = 0; i < listener.length; ++i) {
                    this.fillcolor.removeActionListener(listener[i]);
                }
                this.fillcolor.setSelectedItem(color);
                this.fillcolor.setEnabled(true);
                i = 0;
                while (i < listener.length) {
                    this.fillcolor.addActionListener(listener[i]);
                    ++i;
                }
                return;
            }
            if (!cmd.equals("lineon")) return;
            boolean on = this.outline.isSelected();
            this.areaStyle.setLineOn(on);
            this.linePanel.setEnabledAll(on);
            this.fill.setEnabled(on && this.enablefill);
            return;
        }
        for (parent = this.getParent(); parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
        }
        int result = SGDialog.showInputDialog((JFrame)parent, RB.getStringResource("morecolors.txt"), panel);
        if (result == 0) {
            Color newColor = cc.getColor();
            if (newColor == null) {
                if (save == null) {
                    this.fillcolor.setSelectedItem(this.defaultColorSource);
                    return;
                }
                this.fillcolor.setSelectedItem(save);
                return;
            }
            if (save != null) {
                if (save.getRGB() == newColor.getRGB()) return;
            }
            this.areaStyle.setFillColor(newColor);
            this.fillcolor.setSelectedItem(newColor);
            return;
        }
        if (save == null) {
            this.fillcolor.setSelectedItem(this.defaultColorSource);
            return;
        }
        this.fillcolor.setSelectedItem(save);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value1 = this.transparency.getModel().getValue();
        if (!this.transparency.getValueIsAdjusting()) {
            this.areaStyle.setFillTrans(value1);
        }
    }

    private class SimpleEditor
    extends SwatchLabel
    implements ComboBoxEditor {
        public SimpleEditor() {
            super((Object)"");
            this.setBorder(BorderFactory.createEmptyBorder(0, UIUtil.DLU * 12, 0, 0));
        }

        @Override
        public void selectAll() {
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public Object getItem() {
            return this;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject == null || anObject instanceof ComboBoxEditor) {
                return;
            }
            this.setValue(anObject);
        }
    }
}

