/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.AnnotateElement;
import com.sas.graphics.sganno.AnnotatePoint;
import com.sas.graphics.sganno.BaseAnnotatable;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.w3c.dom.Element;

abstract class TwoPointElement
extends AnnotateElement {
    protected double x;
    protected double y;
    protected double width;
    protected double height;
    static final double cos45 = Math.cos(0.7853981633974483);
    static final double sin45 = Math.sin(0.7853981633974483);
    private double modrotation = 0.0;

    TwoPointElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent) {
        super(annotate, graph, x, node, parent);
    }

    TwoPointElement(Annotate annotate, BaseAnnotatable graph, Point x1, Point x2, Element node, String parent) {
        super(annotate, graph, x1, node, parent);
        this.secondary = new AnnotatePoint(x2);
        this.finish();
    }

    TwoPointElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent) {
        super(annotate, graph, x, node, parent);
    }

    TwoPointElement(Annotate annotate, Annotatable graph, Object[] x1, Object[] x2, Element node, String parent) {
        super(annotate, graph, x1, node, parent);
        this.secondary.setPoint(graph, parent, x2);
    }

    protected void setPositionVariables() {
        double y2;
        double x2;
        double x1;
        boolean flipY;
        double y1;
        if (this.graph != null && this.annotate.isClipToScreenEnabled()) {
            double yo;
            double xo;
            double x12 = this.anchor.screen.getX();
            double x22 = this.secondary.screen.getX();
            y1 = this.anchor.screen.getY();
            double y22 = this.secondary.screen.getY();
            Dimension d = this.graph.getAnnotationSize();
            if (x12 < 0.0 || x12 > (double)d.width || y1 < 0.0 || y1 > (double)d.height) {
                xo = Math.max(0.0, Math.min((double)d.width, x12));
                yo = Math.max(0.0, Math.min((double)d.height, y1));
                this.anchor.screen.setLocation(xo, yo);
                if (this.moveType == 10) {
                    this.secondary.screen.setLocation(x22 += xo - x12, y22 += yo - y1);
                }
                x12 = xo;
                y1 = yo;
            }
            if (x22 < 0.0 || x22 > (double)d.width || y22 < 0.0 || y22 > (double)d.height) {
                xo = Math.max(0.0, Math.min((double)d.width, x22));
                yo = Math.max(0.0, Math.min((double)d.height, y22));
                this.secondary.screen.setLocation(xo, yo);
                if (this.moveType == 10) {
                    this.anchor.screen.setLocation(x12 += xo - x22, y1 += yo - y22);
                }
                x22 = xo;
                y22 = yo;
            }
        }
        boolean flipX = this.anchor.screen.getX() > this.secondary.screen.getX();
        boolean bl = flipY = this.anchor.screen.getY() > this.secondary.screen.getY();
        if (this.controlOn) {
            double centerX = this.x + this.width / 2.0;
            double centerY = this.y + this.height / 2.0;
            switch (this.moveType) {
                case 0: {
                    this.width = Math.round(2.0 * Math.abs(centerX - this.anchor.screen.getX()));
                    this.height = Math.round(2.0 * Math.abs(centerY - this.anchor.screen.getY()));
                    break;
                }
                case 6: {
                    this.width = Math.round(2.0 * Math.abs(this.secondary.screen.getX() - centerX));
                    this.height = Math.round(2.0 * Math.abs(centerY - this.anchor.screen.getY()));
                    break;
                }
                case 2: {
                    this.width = Math.round(2.0 * Math.abs(centerX - this.anchor.screen.getX()));
                    this.height = Math.round(2.0 * Math.abs(this.secondary.screen.getY() - centerY));
                    break;
                }
                case 4: {
                    this.width = Math.round(2.0 * Math.abs(this.secondary.screen.getX() - centerX));
                    this.height = Math.round(2.0 * Math.abs(this.secondary.screen.getY() - centerY));
                    break;
                }
                case 7: {
                    this.height = Math.round(2.0 * Math.abs(centerY - this.anchor.screen.getY()));
                    break;
                }
                case 5: {
                    this.width = Math.round(2.0 * Math.abs(this.secondary.screen.getX() - centerX));
                    break;
                }
                case 1: {
                    this.width = Math.round(2.0 * Math.abs(centerX - this.anchor.screen.getX()));
                    break;
                }
                case 3: {
                    this.height = Math.round(2.0 * Math.abs(this.secondary.screen.getY() - centerY));
                }
            }
            this.x = centerX - this.width / 2.0;
            this.y = centerY - this.height / 2.0;
            if (this.shiftOn) {
                switch (this.moveType) {
                    case 0: {
                        if (this.aspect * this.width > this.height) {
                            this.width = Math.round(this.height / this.aspect);
                            this.x = centerX - this.width / 2.0;
                            break;
                        }
                        this.height = Math.round(this.width * this.aspect);
                        this.y = Math.round(centerY - this.height / 2.0);
                        break;
                    }
                    case 6: {
                        if (this.aspect * this.width > this.height) {
                            this.width = Math.round(this.height / this.aspect);
                            this.x = Math.round(centerX - this.width / 2.0);
                            break;
                        }
                        this.height = Math.round(this.width * this.aspect);
                        this.y = Math.round(centerY - this.height / 2.0);
                        break;
                    }
                    case 2: {
                        if (this.aspect * this.width > this.height) {
                            this.width = Math.round(this.height / this.aspect);
                            this.x = Math.round(centerX - this.width / 2.0);
                            break;
                        }
                        this.height = Math.round(this.width * this.aspect);
                        this.y = Math.round(centerY - this.height / 2.0);
                        break;
                    }
                    case 4: {
                        if (this.aspect * this.width > this.height) {
                            this.width = Math.round(this.height / this.aspect);
                            this.x = Math.round(centerX - this.width / 2.0);
                            break;
                        }
                        this.height = Math.round(this.width * this.aspect);
                        this.y = Math.round(centerY - this.height / 2.0);
                    }
                }
            }
        } else {
            if (this.anchor.screen.getX() > this.secondary.screen.getX()) {
                this.x = Math.round(this.secondary.screen.getX());
                this.width = (double)Math.round(this.anchor.screen.getX()) - this.x;
                flipX = true;
            } else {
                this.x = Math.round(this.anchor.screen.getX());
                this.width = (double)Math.round(this.secondary.screen.getX()) - this.x;
            }
            if (this.anchor.screen.getY() > this.secondary.screen.getY()) {
                this.y = Math.round(this.secondary.screen.getY());
                this.height = (double)Math.round(this.anchor.screen.getY()) - this.y;
                flipY = true;
            } else {
                this.y = Math.round(this.anchor.screen.getY());
                this.height = (double)Math.round(this.secondary.screen.getY()) - this.y;
            }
            if (this.shiftOn) {
                switch (this.moveType) {
                    case 0: {
                        if (this.aspect * this.width > this.height) {
                            this.width = Math.round(this.height / this.aspect);
                            if (flipX) break;
                            this.x = (double)Math.round(this.secondary.screen.getX()) - this.width;
                            break;
                        }
                        this.height = Math.round(this.width * this.aspect);
                        if (flipY) break;
                        this.y = (double)Math.round(this.secondary.screen.getY()) - this.height;
                        break;
                    }
                    case 6: {
                        if (this.aspect * this.width > this.height) {
                            this.width = Math.round(this.height / this.aspect);
                            if (!flipX) break;
                            this.x = (double)Math.round(this.anchor.screen.getX()) - this.width;
                            break;
                        }
                        this.height = Math.round(this.width * this.aspect);
                        if (flipY) break;
                        this.y = (double)Math.round(this.secondary.screen.getY()) - this.height;
                        break;
                    }
                    case 2: {
                        if (this.aspect * this.width > this.height) {
                            this.width = Math.round(this.height / this.aspect);
                            if (flipX) break;
                            this.x = (double)Math.round(this.secondary.screen.getX()) - this.width;
                            break;
                        }
                        this.height = Math.round(this.width * this.aspect);
                        if (!flipY) break;
                        this.y = (double)Math.round(this.anchor.screen.getY()) - this.height;
                        break;
                    }
                    case 4: {
                        if (this.aspect * this.width > this.height) {
                            this.width = Math.round(this.height / this.aspect);
                            if (!flipX) break;
                            this.x = (double)Math.round(this.anchor.screen.getX()) - this.width;
                            break;
                        }
                        this.height = Math.round(this.width * this.aspect);
                        if (!flipY) break;
                        this.y = (double)Math.round(this.anchor.screen.getY()) - this.height;
                    }
                }
            }
        }
        if (this.anchor.screen.getX() > this.secondary.screen.getX()) {
            x1 = this.x + this.width;
            x2 = this.x;
        } else {
            x1 = this.x;
            x2 = this.x + this.width;
        }
        if (this.anchor.screen.getY() > this.secondary.screen.getY()) {
            y1 = this.y + this.height;
            y2 = this.y;
        } else {
            y1 = this.y;
            y2 = this.y + this.height;
        }
        this.anchor.screen.setLocation(x1, y1);
        this.secondary.screen.setLocation(x2, y2);
    }

    protected void setTextVariables() {
        if (this.text != null || this.caretOn) {
            this.wrappingWidth = !this.textwrapping ? 2.1474836E9f : (this.width > 8.0 ? (float)this.width - 6.0f : (float)this.minTextWidth);
            this.checkTextLayout();
            this.lbm.setPosition(0);
            TextLayout tl = this.lbm.nextLayout(this.wrappingWidth);
            this.bounds = tl.getBounds();
            double twidth = tl.getAdvance() + 6.0f;
            double theight = 12.0f + tl.getAscent() + tl.getDescent() + tl.getLeading();
            while ((tl = this.lbm.nextLayout(this.wrappingWidth)) != null) {
                theight += (double)(tl.getAscent() + tl.getDescent() + tl.getLeading());
                twidth = Math.max(twidth, (double)tl.getAdvance());
            }
            this.lbm.setPosition(0);
            tl = this.lbm.nextLayout(this.wrappingWidth);
            if (this.width < twidth) {
                this.x -= (twidth - this.width) / 2.0;
                this.width = twidth;
            }
            if (this.height < theight) {
                this.y -= (theight - this.height) / 2.0;
                this.height = theight;
            }
            if (this.text == null || twidth < (double)this.minTextWidth) {
                double tx = this.x + this.width / 2.0 - (double)(this.minTextWidth / 2) - 4.0;
                double ty = this.y + this.height / 2.0 - theight / 2.0;
                if (this.textPosition == 3) {
                    ty += (this.height + theight) / 2.0;
                } else if (this.textPosition == 1) {
                    ty -= (this.height + theight) / 2.0;
                }
                this.outside.setRect(tx, ty, this.minTextWidth + 6, theight);
                if (this.text == null) {
                    this.textAnchor.setLocation(this.x + this.width / 2.0 - 2.0, ty + (double)tl.getAscent() + 6.0);
                } else {
                    this.textAnchor.setLocation(this.x + this.width / 2.0 - twidth / 2.0 + 2.0, ty + (double)tl.getAscent() + 6.0);
                }
            } else {
                double tx = this.x + this.width / 2.0 - twidth / 2.0 - 4.0;
                double ty = this.y + this.height / 2.0 - theight / 2.0;
                if (this.textPosition == 3) {
                    ty += (this.height + theight) / 2.0;
                } else if (this.textPosition == 1) {
                    ty -= (this.height + theight) / 2.0;
                }
                this.outside.setRect(tx, ty, twidth + 6.0, theight);
                this.textAnchor.setLocation(tx - this.bounds.getX() + 6.0, ty + (double)tl.getAscent() + 6.0);
            }
        } else {
            this.outside.setRect(0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    void setInternalVariables() {
        if (this.annotate.isDataValuesDirty() && this.isAnchorAttachedToData()) {
            this.anchor.finish(this.graph, this.parentID);
            this.secondary.finish(this.graph, this.parentID);
        }
        this.setPositionVariables();
        this.setTextVariables();
        this.createHandles();
        this.setRotationVariables();
    }

    @Override
    protected void setRotationVariables() {
        this.at.setToIdentity();
        this.modrotation = 0.0;
        if (this.rotation != 0.0) {
            this.rotx = this.x + this.width / 2.0;
            this.roty = this.y + this.height / 2.0;
            this.modrotation = this.rotation;
            if (this.shiftOn) {
                this.modrotation = this.modrotation < 0.0 ? (this.modrotation *= -57.29577951308232) : (this.modrotation *= 57.29577951308232);
                double mod = this.modrotation % 15.0;
                this.modrotation = mod < 7.5 ? (this.modrotation -= mod) : (this.modrotation += 15.0 - mod);
                this.modrotation = this.rotation < 0.0 ? (this.modrotation *= -Math.PI / 180) : (this.modrotation *= Math.PI / 180);
            }
            this.at.rotate(this.modrotation, this.x + this.width / 2.0, this.y + this.height / 2.0);
        }
    }

    private void flipIfNeeded() {
        if (this.anchor.screen.getX() > this.secondary.screen.getX()) {
            this.anchor.screen.setLocation(this.x, this.anchor.screen.getY());
            this.secondary.screen.setLocation(this.x + this.width, this.secondary.screen.getY());
            Object left = this.anchor.data[0];
            this.anchor.data[0] = this.secondary.data[0];
            this.secondary.data[0] = left;
        }
        if (this.anchor.screen.getY() > this.secondary.screen.getY()) {
            this.anchor.screen.setLocation(this.anchor.screen.getX(), this.y);
            this.secondary.screen.setLocation(this.secondary.screen.getX(), this.y + this.height);
            Object bottom = this.anchor.data[1];
            this.anchor.data[1] = this.secondary.data[1];
            this.secondary.data[1] = bottom;
        }
    }

    @Override
    void update() {
        this.anchor.update(this.graph, this.parentID);
        this.secondary.update(this.graph, this.parentID);
        this.setInternalVariables();
        this.updateXMLNode();
        this.clip = this.anchor.type == 1 && this.clipOutside ? this.anGraph.getDataBoundingBox(this.parentID) : null;
    }

    @Override
    protected void updateXMLNode() {
        if (this.elem != null) {
            this.elem.setAttribute("SAnchorX", Integer.toString((int)Math.round(this.anchor.screen.getX())));
            this.elem.setAttribute("SAnchorY", Integer.toString((int)Math.round(this.anchor.screen.getY())));
            this.elem.setAttribute("SSecondaryX", Integer.toString((int)Math.round(this.secondary.screen.getX())));
            this.elem.setAttribute("SSecondaryY", Integer.toString((int)Math.round(this.secondary.screen.getY())));
            this.elem.setAttribute("AnchorX", this.anchor.data[0].toString());
            this.elem.setAttribute("AnchorY", this.anchor.data[1].toString());
            this.elem.setAttribute("SecondaryX", this.secondary.data[0].toString());
            this.elem.setAttribute("SecondaryY", this.secondary.data[1].toString());
            if (this.parentID != null) {
                this.elem.setAttribute("Parent", this.parentID);
            }
            if (this.rotation != 0.0) {
                this.elem.setAttribute("Rotation", Double.toString(this.rotation));
            } else {
                this.elem.removeAttribute("Rotation");
            }
        }
    }

    @Override
    void finish() {
        this.setInternalVariables();
        if (this.shiftOn) {
            this.rotation = this.modrotation;
        }
        this.anchor.finish(this.graph, this.parentID);
        this.secondary.finish(this.graph, this.parentID);
        this.flipIfNeeded();
        this.updateXMLNode();
        this.controlOn = false;
        this.shiftOn = false;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "move", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        this.clip = this.anchor.type == 1 && this.clipOutside ? this.anGraph.getDataBoundingBox(this.parentID) : null;
    }

    @Override
    void createHandles() {
        if (this.handles == null) {
            this.handles = new Shape[11];
            this.handles[9] = this.outside;
            this.handles[0] = new Ellipse2D.Double(this.x - 4.0, this.y - 4.0, 8.0, 8.0);
            this.handles[7] = new Ellipse2D.Double(this.x + this.width / 2.0, this.y, 1.0, 1.0);
            this.handles[6] = new Ellipse2D.Double(this.x + this.width - 4.0, this.y - 4.0, 8.0, 8.0);
            this.handles[1] = new Ellipse2D.Double(this.x - 4.0, this.y + this.height / 2.0 - 4.0, 8.0, 8.0);
            this.handles[5] = new Ellipse2D.Double(this.x + this.width - 4.0, this.y + this.height / 2.0 - 4.0, 8.0, 8.0);
            this.handles[2] = new Ellipse2D.Double(this.x - 4.0, this.y + this.height - 4.0, 8.0, 8.0);
            this.handles[3] = new Ellipse2D.Double(this.x + this.width / 2.0 - 4.0, this.y + this.height - 4.0, 8.0, 8.0);
            this.handles[4] = new Ellipse2D.Double(this.x + this.width - 4.0, this.y + this.height - 4.0, 8.0, 8.0);
            this.handles[8] = new Ellipse2D.Double(this.x + this.width / 2.0 - 4.0, this.y - 24.0, 8.0, 8.0);
            this.handles[10] = new Line2D.Double(this.x + this.width / 2.0, this.y - 16.0, this.x + this.width / 2.0, this.y + this.height / 2.0);
        } else {
            ((Ellipse2D)this.handles[0]).setFrame(this.x - 4.0, this.y - 4.0, 8.0, 8.0);
            ((Ellipse2D)this.handles[7]).setFrame(this.x + this.width / 2.0, this.y, 1.0, 1.0);
            ((Ellipse2D)this.handles[6]).setFrame(this.x + this.width - 4.0, this.y - 4.0, 8.0, 8.0);
            ((Ellipse2D)this.handles[1]).setFrame(this.x - 4.0, this.y + this.height / 2.0 - 4.0, 8.0, 8.0);
            ((Ellipse2D)this.handles[5]).setFrame(this.x + this.width - 4.0, this.y + this.height / 2.0 - 4.0, 8.0, 8.0);
            ((Ellipse2D)this.handles[2]).setFrame(this.x - 4.0, this.y + this.height - 4.0, 8.0, 8.0);
            ((Ellipse2D)this.handles[3]).setFrame(this.x + this.width / 2.0 - 4.0, this.y + this.height - 4.0, 8.0, 8.0);
            ((Ellipse2D)this.handles[4]).setFrame(this.x + this.width - 4.0, this.y + this.height - 4.0, 8.0, 8.0);
            ((Ellipse2D)this.handles[8]).setFrame(this.x + this.width / 2.0 - 4.0, this.y - 24.0, 8.0, 8.0);
            ((Line2D)this.handles[10]).setLine(this.x + this.width / 2.0, this.y - 16.0, this.x + this.width / 2.0, this.y + this.height / 2.0);
        }
    }

    @Override
    int getHandleAt(int locx, int locy) {
        if (this.handles == null) {
            this.createHandles();
        }
        Point2D p1 = new Point2D.Double(locx, locy);
        int offset = 0;
        if (this.rotation != 0.0) {
            try {
                p1 = this.at.inverseTransform(p1, p1);
            }
            catch (NoninvertibleTransformException e) {
                return -1;
            }
            double delta = 4.0 * this.rotation / Math.PI;
            offset = (int)Math.round(delta);
        }
        for (int i = 0; i < 8; ++i) {
            if (!this.handles[i].contains(p1)) continue;
            int modified = (i - offset) % 8;
            if (modified < 0) {
                modified += 8;
            }
            return modified;
        }
        if (this.handles[8].contains(p1)) {
            return 8;
        }
        if (this.handles[9].contains(p1)) {
            return 9;
        }
        if (this.shape.contains(p1)) {
            return 10;
        }
        Rectangle bounds = this.shape.getBounds();
        if (bounds.width == 0 || bounds.height == 0) {
            if (bounds.width == 0) {
                --bounds.x;
                bounds.width = 2;
            }
            if (bounds.height == 0) {
                --bounds.y;
                bounds.height = 2;
            }
            if (bounds.contains(p1)) {
                return 10;
            }
        }
        return -1;
    }

    private int undoRotation(int moveType) {
        int modified = moveType;
        if (this.rotation != 0.0 && moveType < 8) {
            double delta = 4.0 * this.rotation / Math.PI;
            int offset = (int)Math.round(delta);
            modified = (moveType + offset) % 8;
        }
        return modified;
    }

    @Override
    void move(int aMoveType, int locx, int locy) {
        if (this.rotation != 0.0 && aMoveType < 8) {
            aMoveType = this.undoRotation(aMoveType);
            try {
                Point2D p1 = new Point2D.Double(this.x + this.width / 2.0 + (double)locx, this.y + this.height / 2.0 + (double)locy);
                p1 = this.at.inverseTransform(p1, p1);
                locx = (int)(p1.getX() - (this.x + this.width / 2.0));
                locy = (int)(p1.getY() - (this.y + this.height / 2.0));
            }
            catch (NoninvertibleTransformException e) {
                locx = 0;
                locy = 0;
            }
        }
        this.moveType = aMoveType;
        switch (aMoveType) {
            default: {
                break;
            }
            case 0: {
                this.anchor.move(locx, locy);
                if (this.modrotation == 0.0) break;
                this.anchor.move((int)(Math.sin(-this.modrotation) * (double)locy) / 2, (int)((Math.cos(this.modrotation) - 1.0) * (double)locy / 2.0));
                this.secondary.move((int)(Math.sin(-this.modrotation) * (double)locy) / 2, (int)((Math.cos(this.modrotation) - 1.0) * (double)locy / 2.0));
                this.anchor.move((int)((Math.cos(this.modrotation) - 1.0) * (double)locx / 2.0), (int)(Math.sin(this.modrotation) * (double)locx) / 2);
                this.secondary.move((int)((Math.cos(this.modrotation) - 1.0) * (double)locx / 2.0), (int)(Math.sin(this.modrotation) * (double)locx) / 2);
                break;
            }
            case 7: {
                this.shiftOn = false;
                this.anchor.move(0, locy);
                if (this.modrotation == 0.0) break;
                this.anchor.move((int)(Math.sin(-this.modrotation) * (double)locy) / 2, (int)((Math.cos(this.modrotation) - 1.0) * (double)locy / 2.0));
                this.secondary.move((int)(Math.sin(-this.modrotation) * (double)locy) / 2, (int)((Math.cos(this.modrotation) - 1.0) * (double)locy / 2.0));
                break;
            }
            case 6: {
                this.anchor.move(0, locy);
                this.secondary.move(locx, 0);
                if (this.modrotation != 0.0) {
                    this.anchor.move((int)(Math.sin(-this.modrotation) * (double)locy) / 2, (int)((Math.cos(this.modrotation) - 1.0) * (double)locy / 2.0));
                    this.secondary.move((int)(Math.sin(-this.modrotation) * (double)locy) / 2, (int)((Math.cos(this.modrotation) - 1.0) * (double)locy / 2.0));
                }
                if (this.modrotation == 0.0) break;
                this.anchor.move((int)((Math.cos(this.modrotation) - 1.0) * (double)locx / 2.0), (int)(Math.sin(this.modrotation) * (double)locx) / 2);
                this.secondary.move((int)((Math.cos(this.modrotation) - 1.0) * (double)locx / 2.0), (int)(Math.sin(this.modrotation) * (double)locx) / 2);
                break;
            }
            case 8: {
                this.rotation += (double)(locx + locy) * Math.PI / 180.0;
                while (this.rotation < 0.0) {
                    this.rotation += Math.PI * 2;
                }
                while (this.rotation > Math.PI * 2) {
                    this.rotation -= Math.PI * 2;
                }
                break;
            }
            case 1: {
                this.shiftOn = false;
                this.anchor.move(locx, 0);
                if (this.modrotation == 0.0) break;
                this.anchor.move((int)((Math.cos(this.modrotation) - 1.0) * (double)locx / 2.0), (int)(Math.sin(this.modrotation) * (double)locx) / 2);
                this.secondary.move((int)((Math.cos(this.modrotation) - 1.0) * (double)locx / 2.0), (int)(Math.sin(this.modrotation) * (double)locx) / 2);
                break;
            }
            case 5: {
                this.shiftOn = false;
                this.secondary.move(locx, 0);
                if (this.modrotation == 0.0) break;
                this.anchor.move((int)((Math.cos(this.modrotation) - 1.0) * (double)locx / 2.0), (int)(Math.sin(this.modrotation) * (double)locx) / 2);
                this.secondary.move((int)((Math.cos(this.modrotation) - 1.0) * (double)locx / 2.0), (int)(Math.sin(this.modrotation) * (double)locx) / 2);
                break;
            }
            case 2: {
                this.anchor.move(locx, 0);
                this.secondary.move(0, locy);
                if (this.modrotation == 0.0) break;
                this.anchor.move((int)(Math.sin(-this.modrotation) * (double)locy) / 2, (int)((Math.cos(this.modrotation) - 1.0) * (double)locy / 2.0));
                this.secondary.move((int)(Math.sin(-this.modrotation) * (double)locy) / 2, (int)((Math.cos(this.modrotation) - 1.0) * (double)locy / 2.0));
                this.anchor.move((int)((Math.cos(this.modrotation) - 1.0) * (double)locx / 2.0), (int)(Math.sin(this.modrotation) * (double)locx) / 2);
                this.secondary.move((int)((Math.cos(this.modrotation) - 1.0) * (double)locx / 2.0), (int)(Math.sin(this.modrotation) * (double)locx) / 2);
                break;
            }
            case 3: {
                this.shiftOn = false;
                this.secondary.move(0, locy);
                if (this.modrotation == 0.0) break;
                this.anchor.move((int)(Math.sin(-this.modrotation) * (double)locy / 2.0), (int)((Math.cos(this.modrotation) - 1.0) * (double)locy / 2.0));
                this.secondary.move((int)(Math.sin(-this.modrotation) * (double)locy / 2.0), (int)((Math.cos(this.modrotation) - 1.0) * (double)locy / 2.0));
                break;
            }
            case 4: {
                if (this.modrotation != 0.0) {
                    this.anchor.move((int)(Math.sin(-this.modrotation) * (double)locy) / 2, (int)((Math.cos(this.modrotation) - 1.0) * (double)locy / 2.0));
                    this.secondary.move((int)(Math.sin(-this.modrotation) * (double)locy) / 2, (int)((Math.cos(this.modrotation) - 1.0) * (double)locy / 2.0));
                    this.anchor.move((int)((Math.cos(this.modrotation) - 1.0) * (double)locx / 2.0), (int)(Math.sin(this.modrotation) * (double)locx) / 2);
                    this.secondary.move((int)((Math.cos(this.modrotation) - 1.0) * (double)locx / 2.0), (int)(Math.sin(this.modrotation) * (double)locx) / 2);
                }
            }
            case 10: {
                this.secondary.move(locx, locy);
            }
        }
        super.move(aMoveType, locx, locy);
    }
}

