/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sganno.AAreaStyle;
import com.sas.graphics.sganno.AMarkerStyle;
import com.sas.graphics.sganno.ATextStyle;
import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.AnnotateElement;
import com.sas.graphics.sganno.BaseAnnotatable;
import com.sas.graphics.sganno.RectangleElement;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.w3c.dom.Element;

public class TextElement
extends RectangleElement {
    public static final int BASELINE = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    int align = 2;
    int valign = 0;
    AnnotateElement attachedTo = null;
    private Rectangle2D textBounds;

    TextElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent, String text) {
        this(annotate, graph, x, node, parent);
        this.finish();
        this.setText(text);
        this.areaAttrsEnabled = false;
        this.outlineAttrsEnabled = false;
    }

    TextElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent) {
        super(annotate, graph, x, null, parent);
        this.style.setLineOn(false);
        this.style.setFillOn(false);
        this.style.setLineColor(Color.LIGHT_GRAY);
        this.areaAttrsEnabled = false;
        this.outlineAttrsEnabled = false;
        this.curPosition = x;
        if (node != null) {
            this.elem = node.getOwnerDocument().createElement("TextElement");
            node.appendChild(this.elem);
            if (parent != null) {
                this.elem.setAttribute("Parent", parent);
            }
            this.elem.setAttribute("textAttrs", "GraphLabelText");
            this.elem.setAttribute("line", "false");
        }
    }

    TextElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent, String text) {
        this(annotate, graph, x, node, parent);
        this.finish();
        this.areaAttrsEnabled = false;
        this.outlineAttrsEnabled = false;
        this.setText(text);
    }

    TextElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent) {
        super(annotate, graph, x, null, parent);
        this.style.setLineOn(false);
        this.style.setFillOn(false);
        this.areaAttrsEnabled = false;
        this.outlineAttrsEnabled = false;
        Point2D pp = graph.convertDataToScreen(parent, x);
        this.curPosition = new Point((int)pp.getX(), (int)pp.getY());
        if (node != null) {
            this.elem = node.getOwnerDocument().createElement("TextElement");
            node.appendChild(this.elem);
            if (parent != null) {
                this.elem.setAttribute("Parent", parent);
            }
            this.elem.setAttribute("textAttrs", "GraphLabelText");
            this.elem.setAttribute("line", "false");
            this.elem.setAttribute("fill", "false");
        }
    }

    @Override
    void finish() {
        if (this.secondary.screen.getX() == this.anchor.screen.getX()) {
            double xx = this.anchor.screen.getX();
            double delta = Math.min(50.0, xx);
            this.anchor.screen.setLocation(xx - delta, this.anchor.screen.getY());
            this.secondary.screen.setLocation(xx + delta, this.secondary.screen.getY());
        }
        super.finish();
        this.style.setLineOn(false);
        this.style.setFillOn(false);
    }

    @Override
    void createHandles() {
        super.createHandles();
        ((Rectangle2D)this.handles[9]).setRect(this.x + 4.0, this.y + 4.0, this.width - 8.0, this.height - 8.0);
    }

    @Override
    void setCaretPosition(int x, int y) {
        float ty = (float)((double)y - (this.textBounds.getY() - this.bounds.getY() + 2.0));
        this._setCaret(x, ty);
    }

    @Override
    protected void setTextVariables() {
        super.setTextVariables();
        if (this.outside == null) {
            return;
        }
        if (this.textBounds == null) {
            this.textBounds = new Rectangle2D.Double(this.outside.getX(), this.outside.getY(), this.outside.getWidth(), this.outside.getHeight());
        } else {
            this.textBounds.setRect(this.outside.getX(), this.outside.getY(), this.outside.getWidth(), this.outside.getHeight());
        }
    }

    @Override
    void paint(Graphics2D gc) {
        if (this.text == null) {
            this.style.fillOn = false;
            this.style.lineOn = true;
            super.paint(gc);
            this.style.lineOn = false;
            return;
        }
        Shape prevClip = gc.getClip();
        if (this.parentID != null && this.clip != null) {
            if (prevClip == null) {
                gc.setClip(this.clip);
            } else {
                gc.setClip(this.clip.getBounds2D().createIntersection(prevClip.getBounds2D()));
            }
        }
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform save = gc.getTransform();
        if (this.rotation != 0.0) {
            gc.transform(this.at);
        }
        gc.setStroke(this.stroke);
        gc.setFont(this.getFont());
        if (this.frc == null) {
            this.frc = gc.getFontRenderContext();
            this.lbm = null;
        }
        Color cc = this.textStyle.getFontColor();
        if (this.text != null && this.text.length() > 0) {
            boolean extsel;
            if (this.lbm == null) {
                this.checkTextLayout();
            }
            boolean bl = extsel = this.caretPosition != this.selectAnchor && this.selectAnchor != -1;
            if (extsel) {
                this.as.addAttribute(TextAttribute.FOREGROUND, selectedTextColor);
                this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            } else if (this.rotation != 0.0) {
                this.lbm = new LineBreakMeasurer(this.as.getIterator(), this.frc);
            }
            if (this.caretOn) {
                this._drawBorderAndCaret(gc);
            }
            gc.setColor(cc);
            this.frc = gc.getFontRenderContext();
            float ty = (float)this.textAnchor.getY();
            int prevPosition = 0;
            this.lbm.setPosition(prevPosition);
            TextLayout tl = this.lbm.nextLayout(this.wrappingWidth);
            while (true) {
                float start = this._getTextAnchor(tl);
                tl.draw(gc, start, ty);
                ty += tl.getDescent() + tl.getLeading();
                tl = this.lbm.nextLayout(this.wrappingWidth);
                if (tl == null) break;
                ty += tl.getAscent();
            }
            if (extsel) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.textStyle.getFontColor());
                this.lbm = null;
            }
        } else if (this.caretOn) {
            this._drawBorderAndCaret(gc);
        }
        if (this.rotation != 0.0) {
            gc.setTransform(save);
        }
        gc.setClip(prevClip);
    }

    @Override
    public Rectangle getShapeBounds() {
        this.lbm.setPosition(0);
        TextLayout tl = this.lbm.nextLayout(this.wrappingWidth);
        Rectangle r = tl.getBounds().getBounds();
        int ascent = (int)tl.getAscent();
        int descent = (int)tl.getDescent();
        while ((tl = this.lbm.nextLayout(this.wrappingWidth)) != null) {
            r = r.union(tl.getBounds().getBounds());
        }
        r.setLocation((int)this.textAnchor.getX(), (int)(this.textAnchor.getY() - (double)ascent + (double)descent));
        return r;
    }

    @Override
    void drawHandles(Graphics2D gc) {
        this._drawHandles(gc);
    }

    @Override
    void drawHandles(Graphics2D gc, Color color) {
        this._drawHandles(gc, color);
    }

    @Override
    protected void fireUndoPropertyEvent(String oldText, String newText) {
        int lsize = this.listeners.size();
        String property = "undo";
        if (oldText == null) {
            property = "add";
        } else if (newText == null) {
            property = "delete";
        }
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, property, null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public void resetStyle(AAreaStyle areaStyle, ATextStyle textStyle, AMarkerStyle markerStyle) {
        super.resetStyle(areaStyle, textStyle, markerStyle);
        this.style.setLineOn(false);
        this.style.setFillOn(false);
    }
}

