/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.AnnotateElement;
import com.sas.graphics.sganno.AreaElement;
import com.sas.graphics.sganno.BaseAnnotatable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.w3c.dom.Element;

class RectangleElement
extends AreaElement {
    RectangleElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent) {
        super(annotate, graph, x, null, parent);
        this.init(node, parent);
    }

    RectangleElement(Annotate annotate, BaseAnnotatable graph, Point x1, Point x2, Element node, String parent) {
        super(annotate, graph, x1, x2, null, parent);
        this.init(node, parent);
    }

    private void init(Element node, String parent) {
        this.setInternalVariables();
        if (node != null) {
            this.elem = node.getOwnerDocument().createElement("RectangleElement");
            node.appendChild(this.elem);
            if (parent != null) {
                this.elem.setAttribute("Parent", parent);
            }
        }
    }

    RectangleElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent) {
        super(annotate, graph, x, null, parent);
        this.init(node, parent);
    }

    RectangleElement(Annotate annotate, Annotatable graph, Object[] x1, Object[] x2, Element node, String parent) {
        super(annotate, graph, x1, x2, null, parent);
        this.init(node, parent);
    }

    @Override
    void setInternalVariables() {
        super.setInternalVariables();
        this.shape = new RoundRectangle2D.Double(this.x, this.y, this.width, this.height, 5.0, 5.0);
    }

    @Override
    public boolean intersects(AnnotateElement ae) {
        Rectangle2D r1 = ae.outside;
        if (this.shape.intersects(r1) || this.outside.intersects(r1) || ae.shape.intersects(this.outside)) {
            return true;
        }
        return ae.shape.intersects(this.shape.getBounds2D());
    }

    RoundRectangle2D getRectangle() {
        return (RoundRectangle2D)this.shape;
    }

    @Override
    void drawHandles(Graphics2D gc) {
        int i;
        AffineTransform save = gc.getTransform();
        Stroke stroke = gc.getStroke();
        if (this.rotation != 0.0) {
            gc.transform(this.at);
        }
        gc.setColor(Color.white);
        gc.setStroke(elemBorder);
        for (i = 0; i < this.handles.length; ++i) {
            if (this.handles[i] == this.outside) continue;
            gc.fill(this.handles[i]);
        }
        gc.setColor(Color.lightGray);
        for (i = 0; i < this.handles.length; ++i) {
            if (this.handles[i] == this.outside) continue;
            gc.draw(this.handles[i]);
        }
        if (this.rotation != 0.0) {
            gc.setTransform(save);
        }
        gc.setStroke(stroke);
    }

    @Override
    void drawHandles(Graphics2D gc, Color color) {
        int i;
        AffineTransform save = gc.getTransform();
        if (this.rotation != 0.0) {
            gc.transform(this.at);
        }
        gc.setColor(Color.white);
        for (i = 0; i < this.handles.length; ++i) {
            if (this.handles[i] == this.outside) continue;
            gc.fill(this.handles[i]);
        }
        gc.setColor(color);
        for (i = 0; i < this.handles.length; ++i) {
            if (this.handles[i] == this.outside) continue;
            gc.draw(this.handles[i]);
        }
        if (this.rotation != 0.0) {
            gc.setTransform(save);
        }
    }
}

