/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.util.Util;
import com.sas.graphics.sganno.AAreaStyle;
import com.sas.graphics.sganno.AMarkerStyle;
import com.sas.graphics.sganno.ATextStyle;
import com.sas.graphics.sganno.MarkerElement;
import com.sas.graphics.util.Markers;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import javax.swing.JToggleButton;

class MyButton
extends JToggleButton {
    String _text = null;
    private AAreaStyle style;
    private ATextStyle textStyle;
    private AMarkerStyle markerStyle;
    BasicStroke stroke = new BasicStroke(1.0f);

    public MyButton(String text) {
        this._text = text;
    }

    public void setStyle(AAreaStyle aStyle) {
        this.style = aStyle;
    }

    public void setTextStyle(ATextStyle aTextStyle) {
        this.textStyle = aTextStyle;
    }

    public void setMarkerStyle(AMarkerStyle aMarkerStyle) {
        this.markerStyle = aMarkerStyle;
    }

    void setLineStroke(BasicStroke ls) {
        if (ls != null) {
            float[] array = ls.getDashArray();
            if (array != null) {
                int i = 0;
                while (i < array.length) {
                    int n = i++;
                    array[n] = array[n] / 0.5f;
                    this.stroke = new BasicStroke(ls.getLineWidth() / 2.0f, ls.getEndCap(), ls.getLineJoin(), ls.getMiterLimit(), array, ls.getDashPhase());
                }
            } else {
                this.stroke = new BasicStroke(ls.getLineWidth() / 2.0f);
            }
        } else {
            this.stroke = null;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (g instanceof Graphics2D) {
            Rectangle b;
            Rectangle b2;
            Graphics2D g2d;
            boolean save;
            if (this.style != null) {
                save = this.style.isFallbackToDefault();
                this.style.setFallbackToDefault(true);
                g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(this.style.getFillColor());
                b2 = this.getBounds();
                g.fillRect(4, 4, b2.width - 8, b2.height - 8);
                g.setColor(this.style.getLineColor());
                g2d.setStroke(Util.getStroke(this.style.getLinePattern(), this.style.getLineWidth()));
                g.drawRect(4, 4, b2.width - 8, b2.height - 8);
                this.style.setFallbackToDefault(save);
            } else if (this.stroke != null) {
                Graphics2D g2d2 = (Graphics2D)g;
                g2d2.setStroke(this.stroke);
                g2d2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(this.getForeground());
                b = this.getBounds();
                int xo = 4;
                int x1 = b.width - 6;
                int y = b.height / 2;
                g.drawLine(xo, y, x1, y);
            }
            if (this._text != null && this._text.length() > 0) {
                if (this.textStyle != null) {
                    save = this.textStyle.isFallbackToDefault();
                    this.textStyle.setFallbackToDefault(true);
                    Font tf = this.textStyle.getFont();
                    g.setColor(this.textStyle.getFontColor());
                    Font f = new Font(tf.getFamily(), tf.getStyle(), 14);
                    g.setFont(f);
                    Rectangle b3 = this.getBounds();
                    FontMetrics fm = g.getFontMetrics(f);
                    int tw = fm.stringWidth(this._text);
                    int ta = fm.getAscent();
                    int td = fm.getDescent();
                    int xo = (b3.width - tw) / 2;
                    int yo = ta + (b3.height - (ta + td)) / 2;
                    GlyphVector gv = f.createGlyphVector(((Graphics2D)g).getFontRenderContext(), this._text);
                    ((Graphics2D)g).drawGlyphVector(gv, xo, yo);
                    this.textStyle.setFallbackToDefault(save);
                } else {
                    Font f = this.getFont();
                    g.setColor(this.getForeground());
                    g.setFont(f);
                    b = this.getBounds();
                    FontMetrics fm = g.getFontMetrics(f);
                    int tw = fm.stringWidth(this._text);
                    int ta = fm.getAscent();
                    int td = fm.getDescent();
                    int xo = (b.width - tw) / 2;
                    int yo = ta + (b.height - (ta + td)) / 2;
                    g.drawString(this._text, xo, yo);
                }
            }
            if (this.markerStyle != null) {
                boolean save2 = this.markerStyle.isFallbackToDefault();
                this.markerStyle.setFallbackToDefault(true);
                g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                b2 = this.getBounds();
                int size = 13;
                int symbol = this.markerStyle.getMarkerSymbol();
                int edgeWeight = Markers.isBold((int)symbol) ? 2 : 0;
                int edgeSize = MarkerElement.getMarkerEdgeWidth(size, edgeWeight);
                Markers.draw((Graphics)g, (Color)this.markerStyle.getMarkerColor(), null, (int)symbol, (int)size, (int)(b2.width / 2), (int)(b2.height / 2), (boolean)false, (int)edgeWeight, (int)edgeSize);
                this.markerStyle.setFallbackToDefault(save2);
            }
        }
    }
}

