/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.AnnotateElement;
import com.sas.graphics.sganno.AreaElement;
import com.sas.graphics.sganno.BaseAnnotatable;
import com.sas.graphics.sganno.LineElement;
import com.sas.graphics.sganno.RectangleElement;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Element;

class EllipseElement
extends AreaElement {
    EllipseElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent) {
        super(annotate, graph, x, null, parent);
        this.init(node, parent);
    }

    EllipseElement(Annotate annotate, BaseAnnotatable graph, Point x1, Point x2, Element node, String parent) {
        super(annotate, graph, x1, x2, null, parent);
        this.init(node, parent);
    }

    EllipseElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent) {
        super(annotate, graph, x, null, parent);
        this.init(node, parent);
    }

    EllipseElement(Annotate annotate, Annotatable graph, Object[] x1, Object[] x2, Element node, String parent) {
        super(annotate, graph, x1, x2, null, parent);
        this.init(node, parent);
    }

    private void init(Element node, String parent) {
        this.setInternalVariables();
        if (node != null) {
            this.elem = node.getOwnerDocument().createElement("EllipseElement");
            node.appendChild(this.elem);
            if (parent != null) {
                this.elem.setAttribute("Parent", parent);
            }
        }
    }

    @Override
    void setInternalVariables() {
        super.setInternalVariables();
        this.shape = new Ellipse2D.Double(this.x, this.y, this.width, this.height);
    }

    @Override
    public boolean intersects(AnnotateElement ae) {
        if (ae instanceof LineElement) {
            return ae.intersects(this);
        }
        Rectangle2D r1 = ae.outside;
        if (this.shape.intersects(r1) || this.outside.intersects(r1) || ae.shape.intersects(this.outside)) {
            return true;
        }
        if (ae instanceof EllipseElement) {
            return ae.shape.intersects(this.shape.getBounds2D()) && this.shape.intersects(ae.shape.getBounds2D());
        }
        if (ae instanceof RectangleElement) {
            Rectangle2D r2 = ae.shape.getBounds2D();
            return this.shape.intersects(r2);
        }
        return false;
    }

    Ellipse2D getEllipse() {
        return (Ellipse2D)this.shape;
    }
}

