/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.interfaces.TextInterface;
import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.ArrowLineElement;
import com.sas.graphics.sganno.BaseAnnotatable;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Element;

final class ArrowAndTextCompositeElement
extends ArrowLineElement
implements TextInterface {
    int valign;
    Rectangle2D oldOutside = new Rectangle2D.Double();

    ArrowAndTextCompositeElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent, Font font) {
        super(annotate, graph, x, null, parent);
        this.init(node, parent);
        this.caretOn = true;
    }

    ArrowAndTextCompositeElement(Annotate annotate, BaseAnnotatable graph, Point x1, Point x2, Element node, String parent, Font font) {
        super(annotate, graph, x1, x2, null, parent);
        this.init(node, parent);
    }

    private void init(Element node, String parent) {
        this.secondaryParent = parent;
        if (node != null) {
            this.elem = node.getOwnerDocument().createElement("ArrowAndTextCompositeElement");
            node.appendChild(this.elem);
            if (parent != null) {
                this.elem.setAttribute("Parent", parent);
            }
        }
        this.textPosition = 10;
    }

    ArrowAndTextCompositeElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent, Font font) {
        super(annotate, graph, x, null, parent);
        this.init(node, parent);
    }

    ArrowAndTextCompositeElement(Annotate annotate, Annotatable graph, Object[] x1, Object[] x2, Element node, String parent, Font font) {
        super(annotate, graph, x1, x2, null, parent);
        this.init(node, parent);
    }

    @Override
    void createHandles() {
        double ax = this.anchor.screen.getX();
        double ay = this.anchor.screen.getY();
        double sx = this.secondary.screen.getX();
        double sy = this.secondary.screen.getY();
        double xo = (ax + sx) / 2.0;
        double yo = (ay + sy) / 2.0;
        double dist = this.secondary.screen.distance(xo, yo);
        double angle = Math.atan2(sy - yo, sx - xo);
        if (this.handles == null) {
            this.handles = new Shape[2];
            this.handles[0] = new Ellipse2D.Double();
            this.handles[1] = new Ellipse2D.Double();
        }
        double delx = (dist - 4.0) * Math.cos(angle);
        double dely = (dist - 4.0) * Math.sin(angle);
        ((Ellipse2D)this.handles[0]).setFrameFromCenter(xo - delx, yo - dely, xo - delx - 4.0, yo - dely - 4.0);
        delx = (dist - 7.0 - 4.0) * Math.cos(angle);
        dely = (dist - 7.0 - 4.0) * Math.sin(angle);
        ((Ellipse2D)this.handles[1]).setFrameFromCenter(xo + delx, yo + dely, xo + delx + 4.0, yo + dely + 4.0);
    }

    @Override
    int getHandleAt(int x, int y) {
        if (this.handles == null) {
            this.createHandles();
        }
        if (this.handles[0].contains(x, y)) {
            return 0;
        }
        if (this.handles[1].contains(x, y)) {
            return 4;
        }
        if (((Line2D)this.shape).ptLineDist(x, y) < 2.0) {
            return 10;
        }
        Rectangle inside = new Rectangle((int)this.outside.getX() + 2, (int)this.outside.getY() + 2, (int)this.outside.getWidth() - 4, (int)this.outside.getHeight() - 4);
        if (inside.contains(x, y)) {
            return 9;
        }
        return -1;
    }

    @Override
    public boolean isSelected(int x, int y) {
        if (super.isSelected(x, y)) {
            return true;
        }
        Rectangle inside = new Rectangle((int)this.outside.getX() + 2, (int)this.outside.getY() + 2, (int)this.outside.getWidth() - 4, (int)this.outside.getHeight() - 4);
        return inside.contains(x, y);
    }
}

