/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.interfaces.AlignInterface;
import com.sas.graphics.sg.util.SGActionEvent;
import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.BaseAnnotatable;
import com.sas.graphics.sganno.TwoPointElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.w3c.dom.Element;

public abstract class AreaElement
extends TwoPointElement
implements AlignInterface {
    AreaElement(Annotate annotate, BaseAnnotatable graph, Point x, Element node, String parent) {
        super(annotate, graph, x, null, parent);
        this.areaAttrsEnabled = true;
    }

    AreaElement(Annotate annotate, BaseAnnotatable graph, Point x1, Point x2, Element node, String parent) {
        super(annotate, graph, x1, x2, null, parent);
        this.areaAttrsEnabled = true;
    }

    AreaElement(Annotate annotate, Annotatable graph, Object[] x, Element node, String parent) {
        super(annotate, graph, x, null, parent);
        this.areaAttrsEnabled = true;
    }

    AreaElement(Annotate annotate, Annotatable graph, Object[] x1, Object[] x2, Element node, String parent) {
        super(annotate, graph, x1, x2, null, parent);
        this.areaAttrsEnabled = true;
    }

    @Override
    public void setClipOutsideDataOn(boolean flag) {
        int lsize;
        Boolean oldValue;
        Boolean bl = oldValue = this.clipOutside ? Boolean.TRUE : Boolean.FALSE;
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("ClipOutside");
            e.setAttribute("clip", oldValue.toString());
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.clipOutside = flag;
        if (this.elem != null) {
            this.elem.setAttribute("ClipOutside", Boolean.toString(flag));
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "clipOutsideDataOn", oldValue, new Boolean(flag));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
        if (!flag) {
            this.clip = null;
        } else if (this.anchor.type == 1) {
            this.clip = this.anGraph.getDataBoundingBox(this.parentID);
        }
    }

    @Override
    public void setAnchorAttachedToData(boolean flag) {
        Boolean oldValue;
        Boolean bl = oldValue = this.anchorAttachedToData ? Boolean.TRUE : Boolean.FALSE;
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("AttachedToData");
            e.setAttribute("anchor", oldValue.toString());
            e.setAttribute("secondary", oldValue.toString());
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.anchorAttachedToData = flag;
        this.secondaryAttachedToData = flag;
        if (flag) {
            this.anchor.setSpaceType(1);
            this.secondary.setSpaceType(1);
        } else {
            this.anchor.setSpaceType(0);
            this.secondary.setSpaceType(0);
        }
        this.anchor.finish(this.graph, this.parentID);
        this.secondary.finish(this.graph, this.parentID);
        if (this.elem != null) {
            this.elem.setAttribute("AnchorAttachedToData", Boolean.toString(flag));
            this.elem.setAttribute("SecondaryAttachedToData", Boolean.toString(flag));
        }
        this.clip = this.clipOutside && this.anchor.type == 1 ? this.anGraph.getDataBoundingBox(this.parentID) : null;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "setAnchorAttachedToData", oldValue, new Boolean(flag));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public Rectangle getAnchorBounds() {
        Rectangle r;
        if (!this.anchorAttachedToData || this.parentID == null || !(this.graph instanceof Annotatable)) {
            Dimension d = this.graph.getAnnotationSize();
            r = new Rectangle(0, 0, d.width, d.height);
        } else {
            r = ((Annotatable)this.graph).getDataBoundingBox(this.parentID);
        }
        r.x = (int)((double)r.x - this.width / 2.0);
        r.y = (int)((double)r.y - this.height / 2.0);
        r.width = (int)((double)r.width + this.width);
        r.height = (int)((double)r.height + this.height);
        return r;
    }

    @Override
    public Rectangle getSecondaryBounds() {
        return this.getAnchorBounds();
    }

    @Override
    public void setSecondaryAttachedToData(boolean flag) {
        this.setAnchorAttachedToData(flag);
    }

    @Override
    public void setFillColor(Color c) {
        int lsize;
        String oldColor;
        String string = oldColor = this.style.isFillColorCustom() ? Integer.toString(this.style.getFillColor().getRGB()) : " ";
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("FillAttrs");
            e.setAttribute("color", oldColor);
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.style.setFillColor(c);
        if (this.elem != null) {
            if (c != null) {
                if (this.fillAttrs == null) {
                    this.fillAttrs = this.elem.getOwnerDocument().createElement("FillAttrs");
                    this.elem.appendChild(this.fillAttrs);
                }
                this.fillAttrs.setAttribute("color", Integer.toString(c.getRGB()));
            } else if (this.fillAttrs != null && this.fillAttrs.hasAttribute("color")) {
                this.fillAttrs.removeAttribute("color");
            }
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "fillColor", oldColor, c);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public void setFillColor(Color c, int alpha) {
        int lsize;
        if (this.listener != null) {
            String oldColor = this.style.isFillColorCustom() ? Integer.toString(this.style.getFillColor().getRGB()) : " ";
            Element e = this.elem.getOwnerDocument().createElement("FillAttrs");
            e.setAttribute("color", oldColor);
            e.setAttribute("alpha", Integer.toString(alpha));
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.style.setFillColor(c);
        this.style.setFillTrans(alpha);
        if (this.elem != null) {
            if (this.fillAttrs == null) {
                this.fillAttrs = this.elem.getOwnerDocument().createElement("FillAttrs");
                this.elem.appendChild(this.fillAttrs);
            }
            if (alpha > 0 && alpha < 255) {
                this.elem.setAttribute("alpha", Integer.toString(c.getAlpha()));
            } else {
                this.elem.removeAttribute("alpha");
            }
            if (c != null) {
                this.fillAttrs.setAttribute("color", Integer.toString(c.getRGB()));
            } else if (this.fillAttrs != null && this.fillAttrs.hasAttribute("color")) {
                this.fillAttrs.removeAttribute("color");
            }
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "multiple", null, null);
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public void setFillOn(boolean fill) {
        int lsize;
        Boolean oldValue;
        Boolean bl = oldValue = this.style.isFillOn() ? Boolean.TRUE : Boolean.FALSE;
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("Fill");
            e.setAttribute("fill", oldValue.toString());
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.style.setFillOn(fill);
        if (this.elem != null) {
            this.elem.setAttribute("fill", Boolean.toString(fill));
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "fillOn", oldValue, new Boolean(fill));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public final void setLineOn(boolean line) {
        int lsize;
        Boolean oldValue;
        Boolean bl = oldValue = this.style.isLineOn() ? Boolean.TRUE : Boolean.FALSE;
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("Line");
            e.setAttribute("line", oldValue.toString());
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.style.setLineOn(line);
        if (this.elem != null) {
            this.elem.setAttribute("line", Boolean.toString(line));
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "lineOn", oldValue, new Boolean(line));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    @Override
    public void setDisplay(String display) {
        if (display == null || display.equals("")) {
            display = this.style.defaultStyle.getDisplay();
        }
        this.style.setDisplay(display);
    }

    @Override
    void startMove(int moveType) {
        if (this.listener == null) {
            return;
        }
        if (moveType == 8) {
            Element e;
            if (this.caretOn && (this.savedText == null && this.text != null && this.text.length() > 0 || this.savedText != null && !this.savedText.equals(this.text))) {
                e = this.elem.getOwnerDocument().createElement("Text");
                e.setAttribute("text", this.savedText);
                this.listener.actionPerformed(new SGActionEvent(this, e));
                this.savedText = this.text;
            }
            e = this.elem.getOwnerDocument().createElement("Rotation");
            e.setAttribute("rotation", Double.toString(this.rotation));
            this.listener.actionPerformed(new SGActionEvent(this, e));
        } else {
            super.startMove(moveType);
        }
    }

    @Override
    public final void setRotationAngle(double angleInDegrees) {
        int lsize;
        String oldValue = Double.toString(this.rotation);
        if (this.listener != null) {
            Element e = this.elem.getOwnerDocument().createElement("Rotation");
            e.setAttribute("rotation", oldValue.toString());
            this.listener.actionPerformed(new SGActionEvent(this, e));
        }
        this.rotation = angleInDegrees * Math.PI / 180.0;
        this.finish();
        if (this.elem != null) {
            this.elem.setAttribute("Rotation", Double.toString(this.rotation));
        }
        if ((lsize = this.listeners.size()) > 0) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this, "rotationAngle", oldValue, new Double(angleInDegrees));
            for (int i = 0; i < lsize; ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(pce);
            }
        }
    }

    public Point getUpperLeftCorner() {
        return new Point((int)this.x, (int)this.y);
    }

    public Point getLowerRightCorner() {
        return new Point((int)(this.x + this.width), (int)(this.y + this.height));
    }

    @Override
    public int getAlignment() {
        return this.textAlign;
    }

    @Override
    public void setAlignment(int align) {
        this.setTextAlignment(align);
    }

    @Override
    public boolean canAlignment(int align) {
        return this.textAlign != align;
    }
}

