/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sganno.Annotate;
import com.sas.graphics.sganno.AnnotateElement;
import com.sas.graphics.sganno.ArrowAndTextCompositeElement;
import com.sas.graphics.sganno.ArrowLineElement;
import com.sas.graphics.sganno.BaseAnnotatable;
import com.sas.graphics.sganno.EllipseElement;
import com.sas.graphics.sganno.Group;
import com.sas.graphics.sganno.ImageElement;
import com.sas.graphics.sganno.LineElement;
import com.sas.graphics.sganno.MarkerElement;
import com.sas.graphics.sganno.RectangleElement;
import com.sas.graphics.sganno.TextElement;
import java.awt.Point;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AnnotateParser {
    public static final int ArrowAndTextComposite = 0;
    public static final int ArrowLineElement = 1;
    public static final int CenteredEllipseElement = 2;
    public static final int CenteredRectangleElement = 3;
    public static final int CircleElement = 4;
    public static final int EllipseElement = 5;
    public static final int LineElement = 6;
    public static final int RectangleElement = 7;
    public static final int TextElement = 8;
    public static final int ImageElement = 9;
    public static final int MarkerElement = 10;
    public static final int ElementCount = 11;
    public static final String[] ElementNames = new String[]{"ArrowAndTextCompositeElement", "ArrowLineElement", "CenteredEllipseElement", "CenteredRectangleElement", "CircleElement", "EllipseElement", "LineElement", "RectangleElement", "TextElement", "ImageElement", "MarkerElement"};

    AnnotateParser() {
    }

    static void load(Annotate an, BaseAnnotatable graph, Element aElem, boolean loadOnly) {
        for (Node node = aElem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element elem;
            String tag;
            if (!(node instanceof Element) || (tag = (elem = (Element)node).getTagName()).indexOf("Attrs") != -1) continue;
            AnnotateElement ae = AnnotateParser.loadAElement(an, graph, elem, loadOnly);
            if (loadOnly) continue;
            ae.addPropertyChangeListener(an);
            if (an.sgActionListener == null || elem.hasAttribute("group")) continue;
            ae.addActionListener(an.sgActionListener);
        }
    }

    static AnnotateElement loadAElement(Annotate an, BaseAnnotatable graph, Element elem, boolean loadOnly) {
        String elemTag = elem.getTagName();
        int index = -1;
        for (int i = 0; i < 11; ++i) {
            if (!ElementNames[i].equals(elemTag)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return null;
        }
        AnnotateElement ae = null;
        Point x = new Point();
        switch (index) {
            default: {
                break;
            }
            case 0: {
                ae = new ArrowAndTextCompositeElement(an, graph, x, null, null, null);
                break;
            }
            case 1: {
                ae = new ArrowLineElement(an, graph, x, null, null);
                break;
            }
            case 5: {
                ae = new EllipseElement(an, graph, x, null, null);
                break;
            }
            case 6: {
                ae = new LineElement(an, graph, x, null, null);
                break;
            }
            case 7: {
                ae = new RectangleElement(an, graph, x, null, null);
                break;
            }
            case 8: {
                ae = new TextElement(an, graph, x, null, null);
                break;
            }
            case 9: {
                ae = new ImageElement(an, graph, x, null, null, null);
                break;
            }
            case 10: {
                ae = new MarkerElement(an, graph, x, null, null, null);
            }
        }
        ae.load(elem, loadOnly);
        ae.finish();
        if (elem.hasAttribute("group")) {
            Group gr = an.getGroup(elem.getAttribute("group"));
            gr.add(ae);
        }
        an.drawables.add(ae);
        return ae;
    }
}

