/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sganno;

import com.sas.graphics.sg.interfaces.DefaultMarkerInterface;
import com.sas.graphics.sg.interfaces.MarkerInterface;
import com.sas.graphics.sganno.Annotatable;
import com.sas.graphics.sganno.RB;
import com.sas.graphics.styles.MarkerStyleElement;
import com.sas.graphics.styles.Style;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class AMarkerStyle
implements MarkerInterface,
DefaultMarkerInterface {
    final AMarkerStyle defaultStyle;
    private Color color;
    private int symbol;
    private int size;
    private int weight;
    private ArrayList listeners = new ArrayList();
    private boolean fallbackToDefault = true;

    public AMarkerStyle(Annotatable graph) {
        if (graph != null && graph.getStyle() != null) {
            MarkerStyleElement markerElem = graph.getStyle().getMarkerStyleElement("AnnoShape");
            this.symbol = markerElem.getMarkerSymbol();
            this.size = markerElem.getMarkerSize().toPixels((int)(graph.getDPIScaleFactor() * 100.0), graph.getAnnotationSize().height);
            this.color = markerElem.getMarkerColor();
        } else {
            this.symbol = 23;
            this.color = Color.BLACK;
            this.size = 7;
        }
        this.defaultStyle = this;
    }

    public AMarkerStyle(AMarkerStyle aStyle) {
        this.defaultStyle = aStyle;
        this.reset();
    }

    public void setStyle(Annotatable graph, Style style) {
        MarkerStyleElement markerElem = style.getMarkerStyleElement("AnnoShape");
        this.symbol = markerElem.getMarkerSymbol();
        this.size = markerElem.getMarkerSize().toPixels((int)(graph.getDPIScaleFactor() * 100.0), graph.getAnnotationSize().height);
        this.color = markerElem.getMarkerColor();
    }

    void reset() {
        this.symbol = -1;
        this.color = null;
        this.size = -1;
        this.weight = -1;
    }

    @Override
    public void setMarkerSymbol(int symbol) {
        if (symbol == this.symbol) {
            return;
        }
        Integer oldValue = new Integer(this.symbol);
        this.symbol = symbol;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "markerSymbol", oldValue, new Integer(symbol));
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    @Override
    public int getMarkerSymbol() {
        if (this.symbol != -1) {
            return this.symbol;
        }
        if (this.fallbackToDefault) {
            return this.defaultStyle.symbol;
        }
        return -1;
    }

    public boolean isMarkerSymbolCustom() {
        return this.symbol != -1;
    }

    @Override
    public void setMarkerSize(int size) {
        if (size == this.size) {
            return;
        }
        Integer oldValue = new Integer(this.size);
        this.size = size;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "markerSize", oldValue, new Integer(size));
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    @Override
    public int getMarkerSize() {
        if (this.size != -1) {
            return this.size;
        }
        if (this.fallbackToDefault) {
            return this.defaultStyle.size;
        }
        return -1;
    }

    public boolean isMarkerSizeCustom() {
        return this.size != -1;
    }

    @Override
    public Color getMarkerColor() {
        if (this.color != null) {
            return this.color;
        }
        if (this.fallbackToDefault) {
            return this.defaultStyle.color;
        }
        return null;
    }

    @Override
    public void setMarkerColor(Color color) {
        Color oldValue = this.color;
        this.color = color == null || color.getRGB() == this.defaultStyle.getMarkerColor().getRGB() ? null : color;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "markerColor", oldValue, color);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    public boolean isMarkerColorCustom() {
        return this.color != null;
    }

    @Override
    public void setMarkerWeight(int weight) {
        if (weight == this.weight) {
            return;
        }
        Integer oldValue = new Integer(this.weight);
        this.weight = weight;
        int lsize = this.listeners.size();
        if (lsize > 0) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "markerWeight", oldValue, new Integer(weight));
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(e);
            }
        }
    }

    @Override
    public int getMarkerWeight() {
        if (this.weight != -1) {
            return this.weight;
        }
        if (this.fallbackToDefault) {
            return this.defaultStyle.weight;
        }
        return -1;
    }

    public boolean isMarkerWeightCustom() {
        return this.weight != -1;
    }

    public void setMarkerStyle(MarkerInterface style) {
        int value = style.getMarkerSymbol();
        this.symbol = value == this.defaultStyle.symbol ? -1 : value;
        value = style.getMarkerWeight();
        this.weight = value == this.defaultStyle.weight ? -1 : value;
        value = style.getMarkerSize();
        this.size = value == this.defaultStyle.size ? -1 : value;
        Color c = style.getMarkerColor();
        this.color = c.getRGB() == this.defaultStyle.color.getRGB() ? null : c;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    @Override
    public int getDefaultMarkerSymbol() {
        return this.defaultStyle.getMarkerSymbol();
    }

    @Override
    public String getDefaultMarkerSymbolSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public int getDefaultMarkerSize() {
        return this.defaultStyle.getMarkerSize();
    }

    @Override
    public String getDefaultMarkerSizeSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public Color getDefaultMarkerColor() {
        return this.defaultStyle.getMarkerColor();
    }

    @Override
    public String getDefaultMarkerColorSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public int getDefaultMarkerWeight() {
        return this.defaultStyle.getMarkerWeight();
    }

    @Override
    public String getDefaultMarkerWeightSource() {
        return RB.getStringResource("automatic.txt");
    }

    @Override
    public boolean isDefaultMarkerOn() {
        return true;
    }

    public boolean isFallbackToDefault() {
        return this.fallbackToDefault;
    }

    public void setFallbackToDefault(boolean fallbackToDefault) {
        this.fallbackToDefault = fallbackToDefault;
    }
}

