/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.util;

import com.sas.graphics.sg.elements.SGText;
import com.sas.graphics.sg.interfaces.ComputedTextInterface;
import com.sas.graphics.sg.interfaces.LineInterface;
import com.sas.graphics.sg.interfaces.RichTextInterface;
import com.sas.graphics.sg.util.SGDecimalFormat;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Util {
    public static final int MAX_TEXT_SIZE1 = 512;
    public static final int MAX_TEXT_SIZE2 = 256;
    public static final String[] GLMarkerNames = new String[]{"CIRCLE", "PLUS", "TRIANGLE", "SQUARE", "X", "TRIANGLEDOWN", "DIAMOND", "ASTER", "CIRCLEBOLD", "PLUSBOLD", "TRIANGLEBOLD", "SQUAREBOLD", "XBOLD", "TRIANGLEDOWNBOLD", "DIAMONDBOLD", "ASTERBOLD", "CIRCLEFILLED", "CROSSFILLED", "TRIANGLEFILLED", "SQUAREFILLED", "SALTIREFILLED", "TRIANGLEDOWNFILLED", "DIAMONDFILLED", "STARFILLED", "VENUS", "MARS", "EARTH", "VENUSBOLD", "MARSBOLD", "EARTHBOLD", "VENUSFILLED", "MARSFILLED", "EARTHFILLED", "HORIZONTAL", "VERTICAL", "HORIZONTALBOLD", "VERTICALBOLD", "RECTANGLEHORIZONTALFILLED", "RECTANGLEVERTICALFILLED", "PLUSX", "CIRCLEPLUS", "CIRCLEX", "SQUAREPLUS", "SQUAREX", "SQUAREUP", "SQUAREDOWN", "SQUARELEFT", "SQUARERIGHT", "UPDOWN", "LEFTRIGHT", "DIAMONDPLUS", "DIAMONDX", "CROSS", "SALTIRE", "STAR", "CROSSMALTESE", "HASH", "SMASH", "ASTERISK", "TRIANGLELEFT", "TRIANGLERIGHT", "LESSTHAN", "GREATERTHAN", "TILDE", "WREATH", "UNION", "IBEAM", "HEX", "HOME", "HEART", "TACK", "SPIRAL", "WEAVE", "HOMEDOWN", "FIXEDSTAR", "CHAIN", "ARROW", "DIAMONDNARROW", "HOMENARROW", "HOMENARROWDOWN", "DAGGER", "FLAG", "CIRCLETRIANGLE", "CIRCLETRIANGLEDOWN", "CIRCLEODD", "ARROWWIDE", "ARROWWIDEDOWN", "CIRCLEARROWWIDE", "CIRCLEARROWWIDEDOWN", "HOURGLASS", "TRIANGLELEFTBOLD", "TRIANGLERIGHTBOLD", "ASTERISKBOLD", "UNIONBOLD", "IBEAMBOLD", "HEXBOLD", "HOMEBOLD", "HEARTBOLD", "TACKBOLD", "SPIRALBOLD", "WEAVEBOLD", "HOMEDOWNBOLD", "FIXEDSTARBOLD", "CHAINBOLD", "ARROWBOLD", "TRIANGLELEFTFILLED", "TRIANGLERIGHTFILLED", "HOMEFILLED", "HOMEDOWNFILLED", "DIAMONDNARROWFILLED", "HOMENARROWFILLED", "HOMENARROWDOWNFILLED", "FLAGFILLED", "ARROWWIDEFILLED", "ARROWWIDEDOWNFILLED", "CIRCLEARROWWIDEFILLED", "CIRCLEARROWWIDEDOWNFILLED", "CIRCLETRIANGLEFILLED", "CIRCLETRIANGLEDOWNFILLED", "CIRCLEODDFILLED", "HOURGLASSFILLED", "HEARTFILLED", "CLUBFILLED", "SPADEFILLED", "ARROWNARROWFILLED", "ARROWNARROWDOWNFILLED", "ARROWNARROWLEFTFILLED", "ARROWNARROWRIGHTFILLED", "FEMALEFIGUREFILLED", "MALEFIGUREFILLED", "FEMALEFIGURE", "MALEFIGURE", "RECTANGLEHORIZONTAL", "RECTANGLEVERTICAL", "ARROWDOWN", "ARROWLEFT", "ARROWRIGHT", "ARROWDOWNBOLD", "ARROWLEFTBOLD", "ARROWRIGHTBOLD", "ARROWNARROW", "ARROWNARROWDOWN", "ARROWNARROWLEFT", "ARROWNARROWRIGHT", "CLUB", "SPADE", "HEXAGON", "HEXAGONVERTICAL", "HEXAGONFILLED", "HEXAGONVERTICALFILLED", "Y", "Z"};
    public static final String[] MarkerNames = new String[]{"Circle", "Plus", "Triangle", "Square", "X", "Triangle Down", "Diamond", "Aster", "Circle Bold", "Plus Bold", "Triangle Bold", "Square Bold", "X Bold", "Triangle Down Bold", "Diamond Bold", "Aster Bold", "Circle Filled", "Cross Filled", "Triangle Filled", "Square Filled", "Saltire Filled", "Triangle Down Filled", "Diamond Filled", "Star Filled", "Venus", "Mars", "Earth", "Venus Bold", "Mars Bold", "Earth Bold", "Venus Filled", "Mars Filled", "Earth Filled", "Horizontal", "Vertical", "Horizontal Bold", "Vertical Bold", "Rectangle Horizontal Filled", "Rectangle Vertical Filled", "Plus X", "Circle Plus", "Circle X", "Square Plus", "Square X", "Square Up", "Square Down", "Square Left", "Square Right", "Up Down", "Left Right", "Diamond Plus", "Diamond X", "Cross", "Saltire", "Star", "Cross Maltese", "Hash", "Smash", "Asterisk", "Triangle Left", "Triangle Right", "Less Than", "Greater Than", "Tilde", "Wreath", "Union", "Ibeam", "Hex", "Home", "Heart", "Tack", "Spiral", "Weave", "Home Down", "Fixed Star", "Chain", "Arrow", "Diamond N Arrow", "Home N Arrow", "Home N Arrow Down", "Dagger", "Flag", "Circle Triangle", "Circle Triangle Down", "Circle Odd", "Arrow Wide", "Arrow Wide Down", "Circle Arrow Wide", "Circle Arrow Wide Down", "Hour Glass", "Triangle Left Bold", "Triangle Right Bold", "Asterisk Bold", "Union Bold", "Ibeam Bold", "Hex Bold", "Home Bold", "Heart Bold", "Tack Bold", "Spiral Bold", "Weave Bold", "Home Down Bold", "Fixed Star Bold", "Chain Bold", "rrow Bold", "Triangle Left Filled", "Triangle Right Filled", "Home Filled", "Home Down Filled", "Diamond Arrow Filled", "Home N Arrow Filled", "Home N Arrow Down Filled", "Hlag Filled", "Arrow Wide Filled", "Arrow Wide Down Filled", "Circle Arrow Wide Filled", "CircleArrow Wide Down Filled", "Circle Triangle Filled", "Circle Triangle Down Filled", "Circle Odd Filled", "Hour Glass Filled", "Heart Filled", "Club Filled", "Spade Filled", "Arrow N Arrow Filled", "Arrow N Arrow Down Filled", "Arrow N Arrow Left Filled", "Arrow N Arrow Right Filled", "Female Figure Filled", "Male Figure Filled", "Female Figure", "Male Figure", "Rectangle Horizontal", "Rectangle Vertical", "Arrow Down", "Arrow Left", "Arrow Right", "Arrow Down Bold", "Arrow Left Bold", "Arrow Right Bold", "Arrow N Arrow", "Arrow N Arrow Down", "Arrow N Arrow Left", "Arrow N Arrow Right", "Club", "Spade", "Hexagon", "Hexagon Vertical", "Hexagon Filled", "Hexagon Vertical Filled", "Y", "Z"};
    public static final DecimalFormat INT_FORMAT = new SGDecimalFormat(1, 4, 0, 0);
    public static final DecimalFormat DOUBLE_FORMAT = new SGDecimalFormat(1, 3, 2, 2);
    public static final int SKIN_NONE = 0;
    public static final int SKIN_MODERN = 1;
    public static final int SKIN_SATIN = 2;
    public static final int SKIN_PRESSED = 3;
    public static final int SKIN_SHEEN = 4;
    public static final int SKIN_CRISP = 5;
    public static final int SKIN_GLOSS = 6;
    public static final int SKIN_MATTE = 7;
    public static final int SKIN_COUNT = 8;

    public static final String toGL(String name) {
        int index = name.indexOf(32);
        while (index != -1) {
            name = name.substring(0, index) + name.substring(index + 1);
            index = name.indexOf(32);
        }
        return name.toUpperCase();
    }

    public static final int toIndex(String name) {
        for (int i = 0; i < GLMarkerNames.length; ++i) {
            if (!GLMarkerNames[i].equals(name)) continue;
            return i;
        }
        return 0;
    }

    public static int getLineEnum(String name) {
        for (int i = 0; i < LineInterface.stipNames.length; ++i) {
            if (!LineInterface.stipNames[i].equalsIgnoreCase(name)) continue;
            return i;
        }
        return 0;
    }

    public static TransformerFactory getJavaInternalTransformerFactory() {
        TransformerFactory transformerFactory;
        String saveTF = null;
        boolean reset = true;
        try {
            saveTF = System.getProperty("javax.xml.transform.TransformerFactory");
            System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        }
        catch (SecurityException se) {
            reset = false;
        }
        try {
            transformerFactory = TransformerFactory.newInstance();
        }
        catch (TransformerFactoryConfigurationError e) {
            if (reset) {
                System.clearProperty("javax.xml.transform.TransformerFactory");
            } else {
                System.setProperty("javax.xml.transform.TransformerFactory", saveTF);
            }
            transformerFactory = TransformerFactory.newInstance();
            reset = false;
        }
        try {
            transformerFactory.setAttribute("indent-number", new Integer(4));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (reset) {
            if (saveTF == null) {
                System.clearProperty("javax.xml.transform.TransformerFactory");
            } else {
                System.setProperty("javax.xml.transform.TransformerFactory", saveTF);
            }
        }
        return transformerFactory;
    }

    public static final Cursor createCursor(String name, Point point, String file) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        Image im = Util.getImage(null, file);
        return Toolkit.getDefaultToolkit().createCustomCursor(im, point, name);
    }

    public static BasicStroke getStroke(int lineStyle, float lineWidth) {
        BasicStroke bs;
        int mask = SASLinePatterns.getStipplePattern((int)lineStyle);
        int factor = SASLinePatterns.getStippleFactor((int)lineStyle);
        int[] dashes = new int[16];
        int index = 0;
        int scanner = 32768;
        while (scanner > 0) {
            int bitcount = 0;
            while ((scanner & mask) != 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount > 0) {
                dashes[index++] = factor * bitcount;
            }
            bitcount = 0;
            while ((scanner & mask) == 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount <= 0) continue;
            dashes[index++] = -factor * bitcount;
        }
        int[] glPattern = new int[index--];
        int i = 0;
        while (index >= 0) {
            glPattern[i] = dashes[index];
            ++i;
            --index;
        }
        float dashPhase = 0.0f;
        float[] dashArray = null;
        float lw = lineWidth;
        int stippleIndex = 0;
        if (lineWidth < 1.0f) {
            lw = 0.5f;
        }
        if (glPattern.length == 1) {
            bs = glPattern[0] < 0 ? null : new BasicStroke(lw, 0, 0);
        } else {
            if (glPattern[0] < 0 && glPattern[glPattern.length - 1] > 0) {
                ++stippleIndex;
                dashPhase = glPattern[1];
                dashArray = new float[glPattern.length];
                dashArray[glPattern.length - 1] = Math.abs(glPattern[0]);
            } else if (glPattern[0] < 0 && glPattern[glPattern.length - 1] < 0) {
                int n = glPattern.length - 1;
                glPattern[n] = glPattern[n] + glPattern[0];
                int[] newStipplePattern = new int[glPattern.length - 1];
                System.arraycopy(glPattern, 1, newStipplePattern, 0, glPattern.length - 1);
                glPattern = newStipplePattern;
                dashArray = new float[glPattern.length];
            } else {
                dashArray = new float[glPattern.length];
            }
            int dashIndex = 0;
            while (stippleIndex < glPattern.length) {
                dashArray[dashIndex] = Math.abs(glPattern[stippleIndex]);
                ++stippleIndex;
                ++dashIndex;
            }
            bs = new BasicStroke(lw, 0, 0, (int)Math.max(lineWidth, 1.0f), dashArray, dashPhase);
        }
        return bs;
    }

    public static boolean isSame(Element e1, Element e2) {
        Node node;
        NamedNodeMap nnm = e2.getAttributes();
        int len2 = nnm.getLength();
        nnm = e1.getAttributes();
        int len1 = nnm.getLength();
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node node2 = nnm.item(i);
            String v1 = node2.getNodeValue();
            if (!e2.hasAttribute(node2.getNodeName())) {
                return false;
            }
            String v2 = e2.getAttribute(node2.getNodeName());
            if (v1.equalsIgnoreCase(v2)) continue;
            return false;
        }
        NodeList nl1 = e1.getChildNodes();
        NodeList nl2 = e2.getChildNodes();
        int n1len = nl1.getLength();
        int n2len = nl2.getLength();
        for (node = e1.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof Element) continue;
            --n1len;
        }
        for (node = e2.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof Element) continue;
            --n2len;
        }
        if (n1len != n2len) {
            return false;
        }
        for (node = e1.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            NodeList nl = e2.getElementsByTagName(e.getTagName());
            if (nl != null && nl.getLength() > 0) {
                boolean same = false;
                for (int j = 0; j < nl.getLength() && !same; ++j) {
                    if (!Util.isSame(e, (Element)nl.item(j))) continue;
                    same = true;
                }
                if (same) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static Image getImage(Class theClass, String name) {
        Image image;
        if (theClass == null) {
            theClass = Util.class;
        }
        try {
            image = Toolkit.getDefaultToolkit().getImage(theClass.getResource("res/" + name));
        }
        catch (Exception e) {
            image = null;
        }
        return image;
    }

    public static Image getTransparentImage(Class theClass, String name) {
        Image image;
        if (theClass == null) {
            theClass = Util.class;
        }
        if ((image = Util.getImage(theClass, name)) != null) {
            RGBImageFilter filter = new RGBImageFilter(){
                public int transRGB = -1;

                @Override
                public final int filterRGB(int x, int y, int rgb) {
                    if ((rgb | 0xFF000000) == this.transRGB) {
                        return 0xFFFFFF & rgb;
                    }
                    return rgb;
                }
            };
            FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
            return Toolkit.getDefaultToolkit().createImage(ip);
        }
        return image;
    }

    public static RichTextInterface[] getRichText(JTextPane pane, ComputedTextInterface cti, double fontScale) {
        StyledDocument doc = pane.getStyledDocument();
        if (!pane.isVisible()) {
            try {
                String text = doc.getText(0, doc.getLength());
                int index = text.indexOf(13);
                if (index != -1) {
                    doc.remove(index, 1);
                }
            }
            catch (BadLocationException text) {
                // empty catch block
            }
        }
        javax.swing.text.Element elmt = doc.getCharacterElement(0);
        ArrayList curText = new ArrayList();
        while (elmt != null && elmt.getEndOffset() <= doc.getLength()) {
            curText.addAll(Util._getRichTextAt(doc, elmt, cti, fontScale));
            elmt = doc.getCharacterElement(elmt.getEndOffset());
        }
        if (doc.getLength() > 0 && curText.size() == 0) {
            curText.addAll(Util._getRichTextAt(doc, elmt, cti, fontScale));
        }
        if (curText.size() > 0) {
            RichTextInterface[] tlist = new RichTextInterface[curText.size()];
            for (int i = 0; i < tlist.length; ++i) {
                tlist[i] = (RichTextInterface)curText.get(i);
            }
            return tlist;
        }
        return new RichTextInterface[0];
    }

    private static ArrayList _getRichTextAt(StyledDocument doc, javax.swing.text.Element elmt, ComputedTextInterface cti, double fontScale) {
        ArrayList<SGText> list = new ArrayList<SGText>();
        if (elmt.getElementCount() == 0) {
            String text = "";
            try {
                text = doc.getText(elmt.getStartOffset(), Math.min(doc.getLength(), elmt.getEndOffset() - elmt.getStartOffset()));
            }
            catch (BadLocationException ble) {
                return null;
            }
            AttributeSet as = elmt.getAttributes();
            Color c = StyleConstants.getForeground(as);
            String family = StyleConstants.getFontFamily(as);
            boolean italic = StyleConstants.isItalic(as);
            boolean bold = StyleConstants.isBold(as);
            int fsize = StyleConstants.getFontSize(as);
            int csize = fsize = (int)Math.ceil((double)fsize / fontScale);
            if (cti != null) {
                while (cti.getComputedFontSize(csize) > fsize) {
                    --csize;
                }
            }
            int style = italic && bold ? 3 : (italic ? 2 : (bold ? 1 : 0));
            SGText sgt = new SGText(new Font(family, style, csize), c);
            if (StyleConstants.isSubscript(as)) {
                sgt.setSubscript(true);
            } else if (StyleConstants.isSuperscript(as)) {
                sgt.setSuperscript(true);
            }
            sgt.setText(text);
            list.add(sgt);
            return list;
        }
        for (int i = 0; i < elmt.getElementCount(); ++i) {
            ArrayList sublist = Util._getRichTextAt(doc, elmt.getElement(i), cti, fontScale);
            if (sublist == null || sublist.size() <= 0) continue;
            list.addAll(sublist);
        }
        return list;
    }

    public static Border getSelectionBorder(final float thickness) {
        return new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.BLACK);
                g2d.setStroke(new BasicStroke(thickness));
                g2d.drawRect((int)((float)x - thickness / 2.0f), (int)((float)y - thickness / 2.0f), (int)((float)width - thickness), (int)((float)height - thickness));
                g2d.setColor(Color.WHITE);
                float[] DASH = new float[]{4.0f, 4.0f};
                BasicStroke outlineStroke = new BasicStroke(thickness, 0, 0, 4.0f, DASH, 0.0f);
                g2d.setStroke(outlineStroke);
                g2d.drawRect((int)((float)x - thickness / 2.0f), (int)((float)y - thickness / 2.0f), (int)((float)width - thickness), (int)((float)height - thickness));
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets((int)thickness, (int)thickness, (int)thickness, (int)thickness);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        };
    }

    public static void drawSelectionBorder(Graphics2D g2d, float thickness, int width, int height) {
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(thickness));
        g2d.drawRect((int)(thickness / 2.0f), (int)(thickness / 2.0f), width - (int)thickness, height - (int)thickness);
        g2d.setColor(Color.WHITE);
        float[] DASH = new float[]{4.0f * thickness, 4.0f * thickness};
        BasicStroke outlineStroke = new BasicStroke(thickness, 0, 0, 4.0f * thickness, DASH, 0.0f);
        g2d.setStroke(outlineStroke);
        g2d.drawRect((int)(thickness / 2.0f), (int)(thickness / 2.0f), width - (int)thickness, height - (int)thickness);
    }

    public static String skinTypeToString(int type) {
        String rc;
        switch (type) {
            default: {
                rc = "None";
                break;
            }
            case 1: {
                rc = "Modern";
                break;
            }
            case 2: {
                rc = "Satin";
                break;
            }
            case 3: {
                rc = "Pressed";
                break;
            }
            case 4: {
                rc = "Sheen";
                break;
            }
            case 5: {
                rc = "Crisp";
                break;
            }
            case 6: {
                rc = "Gloss";
                break;
            }
            case 7: {
                rc = "Matte";
            }
        }
        return rc;
    }

    public static int stringToSkinType(String str) {
        if ("none".equalsIgnoreCase(str)) {
            return 0;
        }
        if ("crisp".equalsIgnoreCase(str)) {
            return 5;
        }
        if ("matte".equalsIgnoreCase(str)) {
            return 7;
        }
        if ("modern".equalsIgnoreCase(str)) {
            return 1;
        }
        if ("pressed".equalsIgnoreCase(str)) {
            return 3;
        }
        if ("satin".equalsIgnoreCase(str)) {
            return 2;
        }
        if ("sheen".equalsIgnoreCase(str)) {
            return 4;
        }
        if ("gloss".equalsIgnoreCase(str)) {
            return 6;
        }
        return 0;
    }

    public static void addNameListElement(Document dom, Element elem, String listName, String valueName, Vector<String> values) {
        if (elem == null) {
            return;
        }
        Element old = null;
        if (elem.getTagName().equals(listName)) {
            old = elem;
        } else {
            NodeList nodes = elem.getElementsByTagName(listName);
            if (nodes.getLength() > 0) {
                old = (Element)nodes.item(0);
            }
        }
        if (old != null) {
            elem.removeChild(old);
        }
        if (values == null) {
            return;
        }
        Element gn = dom.createElement(listName);
        for (int i = 0; i < values.size(); ++i) {
            Element e = dom.createElement(valueName);
            e.setTextContent(values.get(i));
            gn.appendChild(e);
        }
        elem.appendChild(gn);
    }

    public static Vector<String> getNameListValues(Element elem, String listName, String valueName) {
        if (elem == null) {
            return null;
        }
        Element names = null;
        if (elem.getTagName().equals(listName)) {
            names = elem;
        } else {
            NodeList nodes = elem.getElementsByTagName(listName);
            if (nodes.getLength() == 0) {
                return null;
            }
            names = (Element)nodes.item(0);
        }
        if (names == null) {
            return null;
        }
        NodeList nl = names.getElementsByTagName(valueName);
        if (nl.getLength() < 1) {
            return null;
        }
        Vector<String> values = new Vector<String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element item = (Element)nl.item(i);
            values.add(item.getTextContent());
        }
        return values;
    }
}

