/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.util;

import com.sas.graphics.sg.interfaces.MarkerInterface;
import com.sas.graphics.sganno.MarkerElement;
import com.sas.graphics.util.Markers;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;

public class SGIcon
implements Icon {
    static Color foreground = Color.black;
    static Color disabledColor = Color.gray;
    private MarkerInterface markerStyle;
    int iconWidth = 16;
    int iconHeight = 16;

    public SGIcon(MarkerInterface aMarkerStyle, int width, int height) {
        this.iconWidth = width;
        this.iconHeight = height;
        this.markerStyle = aMarkerStyle;
    }

    public void setMarkerStyle(MarkerInterface aMarkerStyle) {
        this.markerStyle = aMarkerStyle;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int size = Math.min(this.iconWidth, this.iconHeight) / 2 * 2 - 3;
            int symbol = this.markerStyle.getMarkerSymbol();
            int edgeWeight = Markers.isBold((int)symbol) ? 2 : 0;
            int edgeSize = MarkerElement.getMarkerEdgeWidth(size, edgeWeight);
            Color color = c.isEnabled() ? foreground : disabledColor;
            Markers.draw((Graphics)g, (Color)color, null, (int)symbol, (int)size, (int)(x + this.iconWidth / 2), (int)(y + this.iconHeight / 2), (boolean)false, (int)edgeWeight, (int)edgeSize);
        }
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }
}

