/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.sg.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class NameGenerator {
    private HashMap deletedItems = new HashMap();
    private HashMap currentIndices = new HashMap();
    private HashMap inUse = new HashMap();

    public String get(String type) {
        String name = null;
        Object oldItems = this.deletedItems.get(type);
        if (oldItems != null && ((ArrayList)oldItems).size() > 0) {
            ArrayList list = (ArrayList)oldItems;
            name = (String)list.get(0);
            list.remove(0);
        } else {
            Object obj = this.currentIndices.get(type);
            int suffix = 1;
            if (obj != null) {
                suffix = (Integer)obj;
            }
            name = type + suffix;
            Vector list = (Vector)this.inUse.get(type);
            if (list != null) {
                while (list.contains(name)) {
                    list.remove(name);
                    name = type + ++suffix;
                }
            }
            this.currentIndices.put(type, new Integer(suffix + 1));
        }
        return name;
    }

    public void delete(String name) {
        int size;
        char[] array = name.toCharArray();
        for (size = array.length; size > 0 && Character.isDigit(array[size - 1]); --size) {
        }
        if (size == 0) {
            return;
        }
        String type = new String(array, 0, size);
        ArrayList<String> list = (ArrayList<String>)this.deletedItems.get(type);
        if (list == null) {
            list = new ArrayList<String>();
            this.deletedItems.put(type, list);
        }
        list.add(name);
    }

    public void add(String name) {
        try {
            Double.parseDouble(name);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            char[] array = name.toCharArray();
            int size = array.length;
            while (Character.isDigit(array[size - 1])) {
                --size;
            }
            String type = new String(array, 0, size);
            Vector<String> list = (Vector<String>)this.inUse.get(type);
            if (list == null) {
                list = new Vector<String>();
                this.inUse.put(type, list);
            }
            list.add(name);
            return;
        }
    }

    public boolean isInUse(String name) {
        char[] array = name.toCharArray();
        int size = array.length;
        while (Character.isDigit(array[size - 1])) {
            --size;
        }
        String type = new String(array, 0, size);
        Vector list = (Vector)this.inUse.get(type);
        if (list != null) {
            return list.contains(name);
        }
        return false;
    }
}

